<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: xform_valid.php,v 1.22 2006/03/30 13:23:52 sondberg Exp $
*/

// Here are some general regular expressions
$invalid_chars = '/([<|>])/';
$date_regexp_sep = '[-|\.|\/]';
$date_regexp = "/^(\d\d\d\d)$date_regexp_sep(\d\d)$date_regexp_sep(\d\d)$/";
$decimal_regexp = "/\d+(\.\d+|)$/";
$time_regexp = "/^([0-1]\d|2[0-3]):[0-5]\d:[0-5]\d$/";
$entity_map = array(
			' '	=>	" ",
			'@'	=>	"&#064;",
			'<'	=>	"&lt;",
			'>'	=>	"&gt;",
		   );



// Here goes the validating functions

function element_valid ($node, &$namespace, $level, &$path, $type, $min, $max) {
    global $doc_root, $xml_header, $p, $invalid_chars, $entity_map, $debug, $f, $indent, $date_regexp, $decimal_regexp, $time_regexp;
    $value = get_value($f, $path);
    $offset = $path[count($path) - 1];

    if ($type != "xs:anyType") {
	if (preg_match($invalid_chars, $value, $match)) {
	    set_value($p, $path, preg_replace($invalid_chars, "", $value));
	    return "Invalid character: &#034;" . $entity_map[$match[1]] . "&#034;";
	}
    }

    if (!strlen(trim($value)) && !is_array(set_password(get_form_name($path)))) { // Empty fields
	if ((string)$offset == 'attr') {
	    // This is not implemented yet, so far, 
            // atttributes are always optional...
	} elseif ($offset < $min) {
	    return "This field must be specified";
	}
    } elseif ($type == "xs:string") { // Various types
    } elseif ($type == "xs:date") {
	if (preg_match($date_regexp, $value, $match)) {
	    $year = $match[1];
	    $month = $match[2];
	    $day = $match[3];
	    if (($month < 1) || ($month > 12)) {
		return "Month must be in interval 1-12";
	    } elseif (($day < 1) || ($day > 31)) {
		return "Day must be in interval 1-31";
	    }
	} else {
	    return "Date format is YYYY-MM-DD";
	}
    } elseif ($type == "xs:positiveInteger") {
      if (!preg_match('/^[1-9]\d*$/', $value)) {
	return "Must be positive integer";
      }
    } elseif ($type == "xs:integer") {
      if (!preg_match('/^\-?[1-9]\d*$/', $value) && $value !='0' ) {
	// does not work - why ?? (!is_int($value)) 
	    return "Must be integer";
	}
    } elseif ($type == "xs:decimal") {
	if (!preg_match($decimal_regexp, $value)) {
	    return "Must be a floating point number";
	}
    } elseif ($type == "xs:time") {
	if (!preg_match($time_regexp, $value)) {
	    return "Time format is hh:mm:ss in the range from 00:00:00 to 23:59:59";
	}
    } elseif ($type == "xs:anyURI") {
	$fields = parse_url($value);
	if ($scheme = $fields['scheme']) {
            $valid_schemes = array( 'http'      => 1,
                                    'https'     => 1,
                                    'ftp'       => 1,
                                    'gopher'    => 1,
                                    'z3950'     => 1 );

            if ( !isset( $valid_schemes[$scheme] ) ||
                 !$valid_schemes[$scheme] ) {

                return "Valid schemes are: " . join( ', ', array_keys( $valid_schemes ) );
            }
	} else {
	    return "Remember to specifiy scheme i.e., http, ftp, gopher etc.";
	}
	if ($host = $fields['host']) {
	    if (preg_match("/([\s|\@])/", $host, $match)) {
		return "Invalid character &#034;" . $entity_map[$match[1]] . "&#034;";
	    }
	} else {
	    return "Host information must be specified";
	}
	if ($doc_path = $fields['path']) {
	    if (preg_match("/([\s])/", $doc_path, $match)) {
		return "Invalid charater &#034;" . $entity_map[$match[1]] . "&#034;";
	    }
	}
    } elseif ($type == "xs:anyType") {
      //$parser = xml_parser_create();
      //$ok = xml_parse($parser, $xml_header . "<root>$value</root>");
      //xml_parser_free($parser);
      //if (!$ok)
      //    return "Malformed XML";
        $args = array (
	    '/_xml' => $xml_header . "<root>$value</root>",
	    '/_xsl' => 
	        '<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	         <xsl:output method="html" encoding="UTF-8"/>
		     <xsl:template match="/"><html/></xsl:template>
		 </xsl:stylesheet>'
		 );
        $xsl = xslt_create();
	$ok = @xslt_process($xsl, 'arg:/_xml', 'arg:/_xsl', NULL, $args, array());
	xslt_free($xsl);
	if (!$ok)
	    return "Malformed XML";
    } elseif ($type == "tkl:path") {
      // here we have to check if the field contains a value/string, 
      // which - if added to the portal root - gives an absolute path
      // on the file system which exists.
      $path_to_check =  $_SERVER['DOCUMENT_ROOT'] . "/" 
        . $doc_root . "/" . $value;
      if ( !file_exists($path_to_check) || !is_readable($path_to_check)) {
        return "path '$value' does not exist in portal";
      }
      
    }
    return 0;
}


function complextype_valid ($node, &$namespace, $level, &$path) {
    global $debug;

    if ($debug) {
	echo "Validating complexType<br>";
    }
}


function simpletype_valid ($node, &$namespace, $level, &$path) {
    global $debug;

    if ($debug) {
	echo "Validating simpleType<br>";
    }
}


// Check if a password pair has been posted, and return the password array.
function set_password ($path) {
    $passwd_array_name = preg_replace("/[\[\]]/", "_", $path);
    $passwd_array_name = preg_replace("/_{2,}/", "_", $passwd_array_name);
    $passwd_array_name = preg_replace("/_*$/", "", $passwd_array_name);

    return $_REQUEST[$passwd_array_name];
}

    
?>
