<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: xform2.xsl,v 1.71 2006/05/19 11:03:52 sondberg Exp $
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="xhtml" encoding="UTF-8" indent="yes"/>

<xsl:param name="doc_root"/>
<xsl:param name="portal_root"/>
<xsl:param name="admin_lang"/>
<xsl:param name="domain"/>
<xsl:param name="close_win"/>
<xsl:param name="where"/>
<xsl:param name="max_page" select="'1'"/>
<xsl:param name="currentPage" select="'1'"/>
<xsl:variable name="quote">'</xsl:variable>


<xsl:template match="xform">
  <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
      <title><xsl:call-template name="insert-title"/></title>
      <xsl:call-template name="insert-css"/>
      <link rel="author" href="http://www.indexdata.dk" />
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
      <xsl:call-template name="load-javascript"/>
    </head>
    <body onLoad="init_java()">
      <xsl:choose>
        <xsl:when test="not(@url='')">
	  <xsl:attribute name="onLoad">dir_browse('<xsl:value-of select="@cwd"/>')</xsl:attribute>
	</xsl:when>
	<xsl:when test="@saved='1'">
	  <xsl:attribute name="onLoad">close_win()</xsl:attribute>
	</xsl:when>
	<xsl:when test="$close_win='1'">
	  <xsl:attribute name="onLoad">close_win()</xsl:attribute>
	</xsl:when>
	<xsl:when test="string-length(@focus) &gt; 0">
	  <xsl:attribute name="onLoad">set_focus(<xsl:value-of select="concat($quote, @focus, $quote)"/>)</xsl:attribute>
	</xsl:when>
      </xsl:choose>

      <xsl:variable name="enctype">
        <xsl:choose>
	   <xsl:when test="//fieldtype[text()='upload']">
	     <xsl:text>multipart/form-data</xsl:text>
           </xsl:when>
	   <xsl:otherwise>
	     <xsl:text>application/x-www-form-urlencoded</xsl:text>
           </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:choose>
        <xsl:when test="@saved = '1'">
          <p><b>Document is saved, it is now safe to close this window</b></p>
        </xsl:when>
        <xsl:when test="$close_win = '1'">
          <p><b>It is not possible to close this window automatically!<br/>
          Click on the close button in the window frame.</b></p>
        </xsl:when>
      </xsl:choose>

      <form style="display: inline;" name="main" method="post"
            action="{@action}" enctype="{$enctype}">
	<input type="hidden" name="append" value=""/>
	<input type="hidden" name="unlink" value=""/>
	<input type="hidden" name="move_up" value=""/>
	<input type="hidden" name="write_file" value="{@write_file}"/>
	<input type="hidden" name="write" value="{@write}"/>
	<input type="hidden" name="schema" value="{@schema}"/>
	<input type="hidden" name="cwd" value="{@cwd}"/>
	<input type="hidden" name="start" value="{@root}"/>
	<input type="hidden" name="file_spec" value="{@file_spec}"/>
	<input type="hidden" name="dir" value="0"/>
	<input type="hidden" name="valid" value="0"/>
	<input type="hidden" name="save" value="0"/>
	<input type="hidden" name="delete_node" value="0"/>
	<input type="hidden" name="choose_dir" value=""/>
	<input type="hidden" name="choice_path" value=""/>
	<input type="hidden" name="admin_lang" value="{$admin_lang}"/>
	<input type="hidden" name="close_win" value=""/>
	<input type="hidden" name="max_page" value="{$max_page}"/>
	<input type="hidden" name="currentPage" value="{$currentPage}"/>

	<script type="text/javascript">
	  var pageTextList = new Array(
	<xsl:for-each select="/xform/global_info/appinfo/pageText">
	  <xsl:sort select="@pageID"/>
	  '<xsl:value-of select="."/>'<xsl:if test="position() != last()">, </xsl:if>
	</xsl:for-each>
	  );
	</script>

      <table border="0" cellpadding="0" cellspacing="0" width="680">
        <tr>
	  <td width="480" class="void">&#xa0;</td>
	  <td width="200" class="void">&#xa0;</td>
	</tr>
	<tr>
	  <td align="left">
	    <span class="headline">
	    <xsl:choose>
	      <xsl:when test="/xform/struct/info/documentation/fieldname"><xsl:value-of select="/xform/struct/info/documentation/fieldname"/></xsl:when>
	      <xsl:otherwise>[ <xsl:value-of select="/xform/struct/@name"/> ]</xsl:otherwise>
	    </xsl:choose>
	    </span>
	  </td>
	  <td align="right">
	    <a href="#" onClick="set_close()"><img src="grafik/button_return_{$admin_lang}.gif" style="border: 0px;" width="68" height="22" alt="Return" /></a>
	    &#xa0;&#xa0;
	    <xsl:call-template name="insertDelete"/>
	    <xsl:call-template name="insertSave">
	      <xsl:with-param name="save_as">0</xsl:with-param>
	    </xsl:call-template>
	  </td>
	</tr>
        <tr>
	  <td>
            <xsl:call-template name="insert-document-path"/>
	  </td>
	  <td align="right">
	    <xsl:if test="$max_page &gt; 1">
	      <div id="other_pages1"/>
	    </xsl:if>
	  </td>
	</tr>
	<tr>
	  <td colspan="2" class="line" height="10">&#xa0;</td>
	</tr>
        <tr><td colspan="2"><xsl:call-template name="errorMsg"/></td></tr>
      </table>
      <table border="0" cellpadding="0" cellspacing="0" width="705">
        <tr>
	  <td width="225" class="void">&#xa0;</td>
	  <td width="480" class="void">&#xa0;</td>
	</tr>
	<xsl:apply-templates/>
	<tr>
	  <td colspan="2" height="15">&#xa0;</td>
	</tr>
      </table>
      <table border="0" cellpadding="0" cellspacing="0" width="680">
	<tr>
	  <td colspan="2" class="line" height="10">&#xa0;</td>
	</tr>
	<tr>
	  <td colspan="2" height="8">&#xa0;</td>
	</tr>
        <xsl:if test="$max_page &gt; 1">
          <tr>
            <td colspan="2" align="right">
              <div id="other_pages2"/>
            </td>
          </tr>
          <tr>
            <td colspan="2" height="8">&#xa0;</td>
          </tr>
        </xsl:if>
	<tr>
	  <td>&#xa0;</td>
	  <td align="right"><a href="#" onClick="set_close()"><img src="grafik/button_return_{$admin_lang}.gif" style="border: 0px;" width="68" height="22" alt="Return" /></a>&#xa0;&#xa0;
	    <xsl:call-template name="insertDelete"/>
	    <xsl:call-template name="insertSave">
	      <xsl:with-param name="save_as">1</xsl:with-param>
	    </xsl:call-template>
	  </td>
	</tr>
      </table>
      <xsl:call-template name="error-focus"/> 
      </form>
    </body>
  </html>
</xsl:template>

<xsl:template name="insert-title">
  Content editor
</xsl:template>


<xsl:template name="load-javascript">
  <script type="text/javascript" src="admin/xform.js"/>
</xsl:template>

<xsl:template name="insert-document-path">
  <p>
    <b>
      <xsl:for-each select="/xform/doc_path/step">
        <xsl:choose>
          <xsl:when test="@root = '1'">
            <xsl:choose>
              <xsl:when test="string-length(.) &gt; 0"><xsl:value-of
                                                        select="."/></xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="$admin_lang = 'da'">Forside</xsl:when>
                  <xsl:otherwise>Front page</xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
        </xsl:choose>
        <xsl:if test="position() != last()">&#xa0;&gt;&#xa0;</xsl:if>
      </xsl:for-each>
    </b>
  </p>
</xsl:template>


<xsl:template name="insert-css">
  <link href="admin/xform.css"
      rel="stylesheet"
      type="text/css"
      media="screen, all" />
</xsl:template>


<xsl:template name="error-focus">
  <xsl:for-each select="//field">
    <xsl:if test="error">
      <script type="text/javascript">
        var f  = document.forms[0];
	for (var i = 0; i != f.length; i++) {
	   var e = f.elements[i];
           if (e.name == &quot;<xsl:value-of select="@path"/>&quot;) {
	      window.scrollTo(0, e.y);
	      e.focus();
	      window.scrollBy(0, 40);
	   }
	}
      </script>
    </xsl:if>
    <xsl:if test="@valid">
      <script type="text/javascript">
        var f  = document.forms[0];
	for (var i = 0; i != f.length; i++) {
	   var e = f.elements[i];
           if (e.name == &quot;<xsl:value-of select="@path"/>&quot;) {
	      window.scrollTo(0, e.y);
	      e.focus();
	      window.scrollBy(0, 40);
	   }
	}
      </script>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template name="insertChoice">
  <xsl:param name="belongs_to"/>
  
  <xsl:if test="choice">
    <xsl:variable name="unique" select="generate-id()"/>
    <xsl:variable name="cell_id" select="generate-id(choice)"/>
    <xsl:variable name="cell1" select="concat($cell_id, '_1')"/>
    <xsl:variable name="cell2" select="concat($cell_id, '_2')"/>
    
    <tr style="display: none;">
      <td colspan="2" style="display: none;">
        <script type="text/javascript">
	  set_id('<xsl:value-of select="$belongs_to"/>', '<xsl:value-of select="$cell1"/>');
	  set_id('<xsl:value-of select="$belongs_to"/>', '<xsl:value-of select="$cell2"/>');
	</script>
      </td>
    </tr>
  
    <tr id="{$cell1}">
      <td colspan="2" height="15">&#xa0;</td>
    </tr>
    <tr id="{$cell2}">
      <td>&#xa0;</td>
      <td>
        <select class="forminput" name="{$unique}">
	  <xsl:for-each select="choice/select">
	    <option value="{@path}"><xsl:value-of select="info/documentation/fieldname"/></option>
	  </xsl:for-each>
	</select>
	<a href="javascript:set_choice(document.main.{$unique}.value)">
	  <img src="grafik/icon_plus.gif" style="border: 0px; vertical-align: top;" width="13" height="13" alt="expand" />
	</a>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="insertDelete">
  <xsl:variable name="confirm">
    <xsl:choose>
      <xsl:when test="$admin_lang='da'">Er du sikker p at du vil slette denne fil?</xsl:when>
      <xsl:when test="$admin_lang='en'">Are you sure that you want to delete this file?</xsl:when>
      <xsl:when test="$admin_lang='el'">Είστε σίγουρος οτι θέλετε να διαγράψετε αυτό το αρχείο;</xsl:when>
    </xsl:choose>
  </xsl:variable>
  <xsl:if test="@allow_write">
    <a href="#" onClick="set_unlink('{$confirm}')">
      <img src="grafik/button_delete_{$admin_lang}.gif"
           style="border: 0px;" alt="Delete"/>
    </a>
    &#xa0;&#xa0;
  </xsl:if>
</xsl:template>

<xsl:template name="insertSave">
  <xsl:param name="save_as"/>
  <xsl:choose>
    <xsl:when test="@allow_write='1'">
      <xsl:choose>
        <xsl:when test="@file_spec='1'"><a href="#" onClick="return set_save(1)"><img src="grafik/button_save_{$admin_lang}.gif" style="border: 0px;" width="41" height="22" alt="Save as" /></a>
	  <xsl:choose>
	    <xsl:when test="$save_as='1'">
	      <input type="text" name="write" value="{@write}"/>
	    </xsl:when>
	  </xsl:choose>
	</xsl:when>
	<xsl:otherwise><a href="#" onClick="return set_save(1)"><img src="grafik/button_save_{$admin_lang}.gif" style="border: 0px;" width="41" height="22" alt="Save" /></a></xsl:otherwise>
      </xsl:choose>
    </xsl:when>
  </xsl:choose>
</xsl:template>


<xsl:template name="errorMsg">
  <xsl:choose>
    <xsl:when test="@error='1'"><b>Fil eksisterer allerede</b></xsl:when>
    <xsl:when test="@error='2'"><b>Du har ikke skriveadgang i dette katalog</b></xsl:when>
  </xsl:choose>
</xsl:template>


<xsl:template match="struct">
  <xsl:param name="belongs_to_default" select="'1'"/>
  <xsl:variable name="name" select="@name"/>
  <xsl:variable name="belongs_to">
    <xsl:choose>
      <xsl:when test="info/appinfo/page">
        <xsl:value-of select="info/appinfo/page"/>
      </xsl:when>
      <xsl:when test="@adopt = 'former' and position() != 1">
        <xsl:choose>
	  <xsl:when test="preceding-sibling::struct[1]/info/appinfo/page">
	    <xsl:value-of select="preceding-sibling::struct[1]/info/appinfo/page"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="$belongs_to_default"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$belongs_to_default"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="cell_id" select="generate-id()"/>
  <xsl:variable name="cell1" select="concat($cell_id, '_1')"/>
  <xsl:variable name="cell2" select="concat($cell_id, '_2')"/>

  <tr style="display: none;">
    <td colspan="2" style="display: none;">
      <script defer="defer" type="text/javascript">
        set_id('<xsl:value-of select="$belongs_to"/>',
               '<xsl:value-of select="$cell1"/>');
        set_id('<xsl:value-of select="$belongs_to"/>',
               '<xsl:value-of select="$cell2"/>');
      </script>
    </td>
  </tr>
  
  <tr id="{$cell1}">
    <td colspan="2" height="15">&#xa0;</td>
  </tr>
  
  <tr id="{$cell2}">
    <td class="{concat('level', @indent)}">
      <xsl:call-template name="insertDel"/>
      <span class="subhead"><xsl:call-template name="insertFieldName"/></span>
    </td>
    <td>
      <xsl:call-template name="insertHandlerLink"/>
      <xsl:call-template name="insertMore"/>
      <xsl:call-template name="insertMoveUp"/>
    </td>
  </tr>
  
  <xsl:apply-templates>
    <xsl:with-param name="belongs_to_default" select="$belongs_to"/>
  </xsl:apply-templates>
  
  <xsl:call-template name="insertChoice">
    <xsl:with-param name="belongs_to" select="$belongs_to"/>
  </xsl:call-template>
</xsl:template>


<xsl:template match="*"/>

<xsl:template name="inputField">
  <input type="text" tabIndex="{@tabindex}" class="forminput" name="{@path}" value="{default/node()}"/>
  <xsl:choose>
    <xsl:when test="info/appinfo/authoriZURL">
      <a href="#" onClick="launch('{@path}','main','bagel.indexdata.dk:2200/Default','@attr 1=1016');">
        <img SRC="grafik/lup.gif" BORDER="0" WIDTH="14" HEIGHT="14" TITLE="Sl op i registret" ALT="Sl op i registret..."/>
      </a>
    </xsl:when>
  </xsl:choose>
</xsl:template>


<xsl:template name="hiddenField">
  <input type="hidden" name="{@path}" value="{default/node()}"/>
  <div id="hidden_{@path}" class="formtext"><xsl:copy-of select="default/node()"/></div>
</xsl:template>


<xsl:template name="invisibleField">
  <input type="hidden" name="{@path}" value="{default/node()}"/>
</xsl:template>


<xsl:template name="passwdField">
  <input type="hidden" name="{@path}" tabIndex="{@tabindex}" value="{default/node()}"/>
  <input type="password" class="forminput" name="{translate(@path, '[]', '_')}[0]" tabIndex="{@tabindex}" value=""/>
  <p style="line-height: 10px;"/>
  <input type="password" class="forminput" name="{translate(@path, '[]', '_')}[1]" tabIndex="{@tabindex}" value=""/>
</xsl:template>


<xsl:template name="dateField">
  <input type="text" class="forminput" name="{@path}" tabIndex="{@tabindex}" value="{default/node()}"/>
  <a href="javascript:insert_today('{@path}', 'main')">
    <img SRC="grafik/dateconfig.png" BORDER="0" height="20" TITLE="Indst dags dato" ALT="Indst dags dato"/>
  </a>
</xsl:template>


<xsl:template name="urlField">
  <input type="text" class="forminput" tabIndex="{@tabindex}" name="{@path}" value="{default/node()}"/>
  <a href="javascript:launch_checkURL('{@path}', 'main', '{/xform/@cwd}')">
    <img SRC="grafik/tjekurl.gif" BORDER="0" TITLE= "Tjek om linket virker, og om det allereede eksisterer i databasen" ALT="Tjek om linket virker, og om det allerede eksisterer i databasen"/>
  </a>
</xsl:template>


<xsl:template name="zurlField">
  <input type="text" class="forminput" name="{@path}" tabIndex="{@tabindex}" value="{default/node()}"/>
  <a href="javascript:launch_checkZURL('{@path}', 'main', '{/xform/@cwd}')">
    <img src="grafik/tjekurl.gif" border="0"/>
  </a>
</xsl:template>

<!-- Experimental Hierarchy Support -->
<xsl:template name="hierarchyField">
  <xsl:variable name="fieldID" select="generate-id()"/>
  <xsl:variable name="href">
    <xsl:text>scripts/hierarchy.php</xsl:text>
    <xsl:text>?fieldid=</xsl:text><xsl:value-of select="$fieldID"/>
    <xsl:text>&amp;cwd=</xsl:text><xsl:value-of select="/xform/@cwd"/>
    <xsl:for-each select="info/appinfo/*">
      <xsl:text>&amp;</xsl:text>
      <xsl:value-of select="name()"/>
      <xsl:text>=</xsl:text>
      <xsl:value-of select="."/>
    </xsl:for-each>
  </xsl:variable>

  <input type="hidden" class="forminput" name="{@path}" id="{$fieldID}"
         tabIndex="{@tabindex}" value="{default/node()}"/>
  
  <xsl:variable name="index_file">
    <xsl:choose>
      <xsl:when test="string-length(info/appinfo/hierarchy_filetype)
                      &gt; 0"><xsl:value-of
        select="info/appinfo/hierarchy_filetype"/></xsl:when>
      <xsl:otherwise>index.tkl</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="hier_path_display"
       select="document( concat( $doc_root, '/', default,
       '/', $index_file ) )/hierarchy/title"/>

  <div id="text_{$fieldID}" class="formtext">
    <xsl:value-of select="default"/><xsl:text>&#xa0;-&gt;   </xsl:text>
    <xsl:value-of select="$hier_path_display"/>
  </div>

  <xsl:element name="a">
    <xsl:attribute name="href">javascript:pop_up_win('<xsl:value-of select="$href"/>')</xsl:attribute>
    <xsl:text> Browse </xsl:text>
  </xsl:element>
</xsl:template>


<xsl:template name="selectField">
  <select class="forminput" name="{@path}" tabIndex="{@tabindex}">
    <xsl:for-each select="enum">
      <xsl:sort select="@value"/>
      <xsl:if test="not(@value = following-sibling::enum/@value)">
	<option value="{@value}">
	  <xsl:choose>
	    <xsl:when test="../default/node()=@value">
	      <xsl:attribute name="selected">selected</xsl:attribute>
	    </xsl:when>
	    <xsl:when test="@default = 1 and not(string-length(../default/node()))">
	      <xsl:attribute name="selected">selected</xsl:attribute>
	    </xsl:when>
	  </xsl:choose>
	  <xsl:value-of select="@value"/> - <xsl:value-of select="."/>
	</option>
      </xsl:if>
    </xsl:for-each>
  </select>
</xsl:template>

<xsl:template name="checkboxField">
  <input type="checkbox" value="1" name="{@path}" tabIndex="{@tabindex}">
    <xsl:choose>
      <xsl:when test="default/node()='1'">
        <xsl:attribute name="checked">checked</xsl:attribute>
      </xsl:when>
    </xsl:choose>
  </input>
</xsl:template>

<xsl:template name="stringareaField">
  <xsl:variable name="fieldID" select="generate-id()"/>
  <textarea type="text" rows="4" class="forminput" name="{@path}" id="{$fieldID}" tabIndex="{@tabindex}">
    <xsl:copy-of select="default/node()"/>
  </textarea>
  <a href="#" onClick="morerows(document.forms[0], '{@path}');">Resize</a>
</xsl:template>

<xsl:template name="textareaField">
  <xsl:variable name="fieldID" select="generate-id()"/>
  <textarea type="text" rows="4" class="forminput" name="{@path}" id="{$fieldID}" tabIndex="{@tabindex}">
    <xsl:copy-of select="default/node()"/>
  </textarea>
  <a href="javascript:popup_editor('main','{@path}')">
    <img src="grafik/lup.gif" border="0" title="Edit text in separate window" alt="Edit text in separte window"/>
  </a>
  <a href="#" onClick="morerows(document.forms[0], '{@path}');">Resize</a>
</xsl:template>

<xsl:template name="insertFieldName">
  <xsl:variable name="stuff">
    <xsl:choose>
      <xsl:when test="info/documentation/fieldname">
	<xsl:value-of select="info/documentation/fieldname"/>
      </xsl:when>
      <xsl:otherwise>
	[<xsl:value-of select="@name"/>]
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="info/documentation/longhelp">
      <a class="subhead" href="{info/documentation/longhelp}"
                             target="helpop" onClick="window.open('', 'helpop')">
        <xsl:value-of select="$stuff"/>
      </a>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$stuff"/>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
    <xsl:when test="language">
      (<xsl:value-of select="language"/>)
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template name="insertFieldDesc">
  <xsl:choose>
    <xsl:when test="info/documentation/helptext">
      <br/>
      <span class="small"><xsl:value-of select="info/documentation/helptext"/></span>
    </xsl:when>
  </xsl:choose>
</xsl:template>


<xsl:template name="insertMore">
  <xsl:choose>
    <xsl:when test="@more">
      <a href="#">
        <xsl:attribute name="onClick">
	  <xsl:text>return set_append('</xsl:text>
	  <xsl:value-of select="@more"/>
	  <xsl:text>')</xsl:text>
	</xsl:attribute>
	<img src="grafik/icon_plus.gif" style="border: 0px; vertical-align: top;" width="13" height="13" alt="expand" />
      </a>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template name="insertMoveUp">
  <xsl:choose>
    <xsl:when test="@moveUp">
      <a href="#">
        <xsl:attribute name="onClick">
	  <xsl:text>return set_moveup('</xsl:text>
	  <xsl:value-of select="@moveUp"/>
	  <xsl:text>')</xsl:text>
	</xsl:attribute>
	<img src="grafik/prior_op.gif" style="border: 0px; vertical-align: top;" alt="Move up" />
      </a>
    </xsl:when>
  </xsl:choose>
</xsl:template>



<xsl:template name="insertValid">
  <xsl:choose>
    <xsl:when test="@valid">
      <br/>
      <span class="small_red">
        <xsl:value-of select="@valid"/>
      </span>
    </xsl:when>
  </xsl:choose>
</xsl:template>


<xsl:template name="insertErrorMsg">
  <xsl:choose>
    <xsl:when test="error">
      <br/>
      <font class="small_red">
        <xsl:value-of select="error"/>
      </font>
    </xsl:when>
  </xsl:choose>
</xsl:template>


<xsl:template name="insertDel">
  <xsl:choose>
    <xsl:when test="@delete">
      <a href="#">
	<xsl:attribute name="onClick">
	  <xsl:text>return set_delete('</xsl:text>
	  <xsl:value-of select="@delete"/>
	  <xsl:text>')</xsl:text>
	</xsl:attribute>
	<img src="grafik/icon_minus.gif" style="border: 0px; vertical-align: middle;" width="13" height="13" alt="Outdent" />
      </a>&#xa0;
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template name="radiobuttonField">
  <input type="radio" value="yes" name="{@path}" tabIndex="{@tabindex}"> <!-- hvis den sattes -->
    <xsl:choose>
      <xsl:when test="default/node()='yes'">
        <xsl:attribute name="checked">checked</xsl:attribute>
      </xsl:when>
    </xsl:choose>
  </input> Yes
  <input type="radio" value="no" name="{@path}">
    <xsl:choose>
      <xsl:when test="default/node()='no'">
        <xsl:attribute name="checked">checked</xsl:attribute>
      </xsl:when>
    </xsl:choose>
  </input> No
</xsl:template>


<xsl:template name="insertSelectBox">
  <xsl:choose>
    <xsl:when test="info/appinfo/select">
      <xsl:variable name="auth_file" select="concat($doc_root, string(info/appinfo/select))"/>
        <xsl:variable name="values" select="document(concat('file://', $auth_file))"/>
	<select>
	  <xsl:attribute name="onClick">
	    <xsl:text>append_value('</xsl:text>
	    <xsl:value-of select="@path"/>
	    <xsl:text>','main', this.value);</xsl:text>
	  </xsl:attribute>
	  <xsl:for-each select="$values/authority/enum[@xml:lang=string($admin_lang)]">
	    <option value="{@value}">
	      <xsl:value-of select="."/>
	    </option>
	  </xsl:for-each>
	</select>
    </xsl:when>
  </xsl:choose>
</xsl:template>


<xsl:template name="uploadField">
  <xsl:variable name="upload" select="upload_xml/*"/>
  <xsl:variable name="uploaded_url">
    <xsl:text>http://</xsl:text><xsl:value-of select="$domain"/>/<xsl:value-of select="$portal_root"/><xsl:value-of select="$where"/>/<xsl:value-of select="$upload/object"/>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="$upload/object">
      <input type="hidden" name="{@path}" value="{default/node()}"/>
      <a href="javascript:pop_up_win('{$uploaded_url}');">
        <xsl:choose>
	  <xsl:when test="$upload/*/@scale = 'thumb'">
            <xsl:variable name="preview_url">
              <xsl:text>http://</xsl:text><xsl:value-of select="$domain"/>/<xsl:value-of select="$portal_root"/><xsl:value-of select="$where"/>/<xsl:value-of select="$upload/*[@scale = 'thumb']"/>
            </xsl:variable>
            <img src="{$preview_url}" alt="{$preview_url}"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <b><xsl:value-of select="$upload/object"/></b>
	  </xsl:otherwise>
	</xsl:choose>
      </a>
    </xsl:when>
    <xsl:otherwise>
      <input type="hidden" name="{@path}" value="unset"/>
      <input class="forminput" name="{translate(@path, '[]', ':')}" type="file" tabIndex="{@tabindex}"/>
      <xsl:if test="$upload/error">
        <br/><b><xsl:value-of select="$upload/error"/></b>
      </xsl:if>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template match="field">
  <xsl:param name="belongs_to_default"/>
  <xsl:variable name="belongs_to">
    <xsl:choose>
      <xsl:when test="info/appinfo/page">
        <xsl:value-of select="info/appinfo/page"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$belongs_to_default"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="cell_id" select="generate-id()"/>
  <xsl:variable name="cell1" select="concat($cell_id, '_1')"/>
  <xsl:variable name="cell2" select="concat($cell_id, '_2')"/>

  <tr style="display: none;">
    <td colspan="2" style="display: none;">
      <script defer="defer" type="text/javascript">
	set_id('<xsl:value-of select="$belongs_to"/>', '<xsl:value-of select="$cell1"/>');
	set_id('<xsl:value-of select="$belongs_to"/>', '<xsl:value-of select="$cell2"/>');
      </script>
    </td>
  </tr>
  
  <xsl:choose>
    <xsl:when test="info/appinfo/fieldtype='invisible'">
      <xsl:call-template name="invisibleField"/>
    </xsl:when>
    <xsl:otherwise>
      <tr id="{$cell1}">
        <td colspan="2" height="15">&#xa0;</td>
      </tr>
      <tr id="{$cell2}">
        <td class="{concat('level', @indent)}">
	  <xsl:call-template name="insertDel"/>
	  <span class="subhead"><xsl:call-template name="insertFieldName"/></span>
	</td>
	<td>
	  <xsl:choose>
	    <xsl:when test="info/appinfo/fieldtype='text'">
	      <xsl:call-template name="inputField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='dropdown'">
	      <xsl:call-template name="selectField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='checkbox'">
	      <xsl:call-template name="checkboxField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='stringarea'">
	      <xsl:call-template name="stringareaField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='textarea'">
	      <xsl:call-template name="textareaField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='url'">
	      <xsl:call-template name="urlField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='zurl'">
	      <xsl:call-template name="zurlField"/>
	    </xsl:when>
            <!-- Experimental Hierarchy Support -->
	    <xsl:when test="info/appinfo/fieldtype='hierarchy'">
	      <xsl:call-template name="hierarchyField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='hidden' 
                            or info/appinfo/fieldtype='readonly'">
	      <xsl:call-template name="hiddenField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='password'">
	      <xsl:call-template name="passwdField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='date'">
	      <xsl:call-template name="dateField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='radiobutton'">
	      <xsl:call-template name="radiobuttonField"/>
	    </xsl:when>
	    <xsl:when test="info/appinfo/fieldtype='upload'">
	      <xsl:call-template name="uploadField"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:call-template name="inputField"/>
	    </xsl:otherwise>
	  </xsl:choose>
	  <xsl:choose>
	    <xsl:when test="not(info/appinfo/fieldtype='hidden')">
              <xsl:call-template name="insertHandlerLink"/>
	      <xsl:call-template name="insertSelectBox"/>
	      <xsl:call-template name="insertMore"/>
	      <xsl:call-template name="insertMoveUp"/>
	      <xsl:call-template name="insertFieldDesc"/>

	    </xsl:when>
	  </xsl:choose>
          <!-- call error messages - also for hidden fields! -->
	  <xsl:call-template name="insertErrorMsg"/>
	  <xsl:call-template name="insertValid"/>
	</td>
      </tr>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="insertHandlerLink">
  <xsl:if test="info/appinfo/popup/@link">
    <a href="javascript:pop_up_win('/{$portal_root}{info/appinfo/popup/text()}?field_id={@path}')">
      <xsl:value-of select="info/appinfo/popup/@link"/>
    </a>
  </xsl:if>
</xsl:template>

<xsl:template match="hidden">
  <input type="hidden">
    <xsl:attribute name="name">
      <xsl:value-of select="@path"/>
    </xsl:attribute>
    <xsl:attribute name="value">
      <xsl:value-of select="@default"/>
    </xsl:attribute>
  </input>
</xsl:template>

</xsl:stylesheet>
