<?php
/*
   Copyright (C) 2002-2006 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: xform2.php,v 1.70 2006/05/16 13:07:08 sondberg Exp $
*/

require "config.php";
require "standards.php";
require "domtools.php";
require "search.php";
require "xform_valid.php";
require "xform_tools.phpi";

header("Content-Type: text/html; charset=utf-8");

if (!$cwd && $xml_file) { // Infer cwd from file path
    $cwd = extract_cwd($xml_file);
}

if (strlen($xml_file)) {
    $where = extract_cwd($xml_file);
} else {
    $where = $cwd;
}

if (!$currentPage) {
    $currentPage = 1;
}



session_start();

find_portal_root();
$where_path = get_path($where);

require "read_local_config.php";

// Check if there is a portal specific list of languages:
if (is_array($tkl_config_languages = get_tkl_config('languages'))) {
    $languages = tklconfiglang2configlang( $tkl_config_languages );
}

$this_user = check_auth_user();
$style_indent = 0;
$tab_index = 0;
$max_indent = 0;
//$debug = 1;
if (strlen($url)) {
    $xml_raw = get_metadata($url);
}

if (strlen($choose_dir)) { //If $choose_dir is set, change cwd to the new place
    $cwd = "$doc_root/$choose_dir";
    find_portal_root();
    $this_user = check_auth_user();
    $choose_dir = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$choose_dir";
}

$unlink = $_REQUEST['unlink'];

if (is_granted($cwd, "write") 
    && (($xml_file && is_granted($xml_file, "write")) 
        || ($write_file && is_granted($write_file, "write")) 
        || ($write && $choose_dir && is_granted("$choose_dir$write", "write"))
        )) {
    $allow_write = 1;
    if (strlen($choose_dir) && !strlen($write_file)) {
	$write_file = $choose_dir;
    }
} elseif ($url) {
    $allow_write = 1;
    $file_spec = 1; // So far, we always allow user to specify file name
    if (preg_match("/http:\/\/([^\/]*)/", $url, $match)) {
	$url_domain = preg_replace("/\./", "-", $match[1]);
	$write = "link-" . $url_domain . ".tkl";
    } else {
	$write = "link-dc-tkl.tkl";
    }
} else {
    echo "<b>Note: You are not allowed to overwrite this document</b><br>";
    $save = 0; // Never save anything, if we're not allowed to
    $unlink = 0;
}

if ($xml_file) {
    if (!is_granted($xml_file, "read")) {
	exception("You're not allowed to open this file: '$xml_file'");
	die;
    }
}

$typemap = array( // These objects constitutes our basic building blocks
                 'xs:string'     	=>      'text',
                 'xs:date'       	=>      'text',
                 'xs:integer'    	=>      'text',
                 'xs:decimal'		=>	'text',
                 'xs:positiveInteger'	=>	'text',
                 'xs:boolean'		=>	'text',
                 'xs:anyURI'		=>	'text',
                 'xs:anyType'		=>	'text',
                 'xs:time'		=>	'text',
                 'xs:language'		=>	'text',
                 'tkl:path'		=>	'text',
                 );

if ($xml_file || $xml_raw) {	// If xml-file, load and parse it
    if ($xml_raw) {
	if (!($dom_xml = domxml_open_mem($xml_raw))) {
	    echo "Can't open/parse raw xml<br><pre>", htmlentities($xml_raw), "</pre>\n";
	    die;
	}
    } else {
	$raw_tkl = open_tkl_file($xml_file);
	if (!($dom_xml = domxml_open_mem($raw_tkl))) {
	    echo "Can't parse xml file '$xml_file'";
	    die;
	}
    }
    $doc = $dom_xml->document_element();
    $doc_elem = $doc->tagname();
    $schemaname = "$doc_elem.xsd";
    if (file_exists($xsd_cand = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$xsd_path/$schemaname")) {
	$schema = $xsd_cand;
    } else {
	$schema = "$xsd_path/$schemaname";
    }

    if (!@file_exists($schema)) {
	echo "<b>You can not edit this record ($schema).</b>";
	die;
    }
    
    create_struct($f = array(), $dom_xml->document_element());
}


if (!strlen($write_file)) {
    $write_file = $xml_file;
}

xform_check_xml_structure( $f, $fct_args = array(
                'start'         => $start,
                'debug'         => $debug,
                'save'          => $save,
                'this_user'     => $this_user ) );

$schema_candidate = $fct_args['schema_candidate'];
$creator = $fct_args['creator'];

if ($debug) {
    echo "<pre>";
    print_r($f);
    echo "</pre><hr>";
}
if (!$schema) {
    if (!$schema_candidate) {
	echo "No schema information available";
	die;
    } else {
	$schema = $schema_candidate;
	if (file_exists($xsd_cand = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$xsd_path/$schema")) {
	    $schema = $xsd_cand;
	} else {
	    $schema = "$xsd_path/$schema";
	}
    }
}
if (!strlen($creator)) {
    $creator = $this_user['login'];
}
if (!@file_exists($schema)) {
    echo "<b>Du kan ikke editere i denne post.</b>";
    die;
}

$schema_raw_xml = join( '', file( $schema ) );
if (!($dom_schema = domxml_open_mem($schema_raw_xml))) {
    echo "Unable to construct DOM object";
    die;
}

$schema_root = $dom_schema->root();

if (!is_array($f)) {			// We're dealing with an empty document...
    if (strlen($default_file)) {
	$abs_def_file = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$default_file";
	if (!($dom_xml = domxml_open_file($abs_def_file))) {
	    echo "Can't open/parse default xml file '$abs_def_file'";
	    die;
	}
	create_struct($f = array(), $dom_xml->document_element());
    }
}

$schema_annotation = annotation($schema_root); // Parse optional schema annotations...

$root_elements = dom_select_ext($schema_root, array("element"));
$no_of_elm = count($root_elements);
if ($no_of_elm != 1) {
    die("Number of root elements must be 1, the number found is $no_of_elm");
} else {
    $schema_element_root = $root_elements[0];
}


function create_namespace ($node, &$ns) {
    // We adopt the Perl namespace model, where a specific identifier can co-exist in
    // various contexts simultaneously

    if ($tag = $node->tagname) {
	if ($name = $node->get_attribute('name')) {
	    $ns[$name][$tag] = $node;
	}
    }
    if ($kids = $node->child_nodes()) {
	foreach ($kids as $kid) {
	    create_namespace($kid, $ns);
	}
    }
}


function get_value (&$f, &$path, $type="") {
    $value = get_node($f, $path);
    // echo "get_value type=$type<br>\n";
    if ($type == "xs:anyType") {
	if ($node = $value['parent']) {
	    return dump_xml($node);
	} else {
	    return escape_amp(stripslashes($value['value']));
	}
    } else {
	return escape_amp(stripslashes($value['value']));
    }
}


function get_node (&$f, &$path) {
    $value = $f;
    foreach ($path as $key) {
	$value = $value[$key];
    }
    return $value;
}


function swap_elements ($path1, $path2) {
    global $f;

    if (!is_array($path1)) {
	$path1 = make_array($path1);
    }
    if (!is_array($path2)) {
	$path2 = make_array($path2);
    }
    $node1 = get_node($f, $path1);
    $node2 = get_node($f, $path2);
    set_node($path1, $node2);
    set_node($path2, $node1);
}


function make_array ($path_str) {
    $path_str = preg_replace("/^\[/", "", $path_str);
    $path_str = preg_replace("/\]$/", "", $path_str);
    return preg_split("/\]\[/", $path_str);
}


function get_last(&$f, &$path, $field) {
    // Checks the sub-structure for non-empty nodes and returns the offset of last non-empty node

    $extended_path = array_merge($path, $field);
    $nodeset = get_node($f, $extended_path);

    if (is_array($nodeset)) {
	for ($count = count($nodeset); $count >= 0; $count--) {
	    $node = $nodeset[$count];
	    if (strlen(trim($node['value']))) {		// If the value is non-empty this qualify as last node
		return $count;
	    }
	    if (is_array($attributes = $node['attr'])) {	// Check for attributes
		foreach ($attributes as $key => $value) {
		    if (trim($key)) {
			return $count;
		    }
		}
	    }
	    if (is_array($subtree = $node['subtree'])) {	// Otherwise, check for non-empty sub-fields
		foreach ($subtree as $sub_field => $dummy) {
		    if (get_last($f, array_merge($extended_path, $count, 'subtree'), $sub_field) != -1) {
			return $count;
		    }
		}
	    }
	}
    }
    return -1;
}


function get_form_name (&$path) {
    // Generates a generic path name for the specific xml node

    return "f" . get_path_str($path) . "[value]";
}


function get_path_str (&$path) {
    // Generates a generic path string for the specific xml node

    return "[" . join("][", $path) . "]";
}

function make_attr ($attr) {
    $ret = "";
    if (is_array($attr)) {
	foreach ($attr as $key => $value) {
	    while (is_array($value)) {
		$value = stripslashes($value['value']);
	    }
	    $ret .= " $key=\"" . escape_amp($value) . "\"";
	}
    }
    return $ret;
}


function make_info (&$info, $level) {
    // Based on the $info structure this function returns an info tag to include in the meta xml-document

    global $indent;
    if (!is_array($info)) {
	return;
    }
    $ret = str_repeat($indent, $level) . "<info>\n";
    foreach ($info as $tag => $entry) {
	$ret .= str_repeat($indent, $level + 1) . "<$tag";
	if (is_array($attributes = $entry['attr'])) {
	    $ret .= make_attr($attributes);
	}
	$ret .= ">";
	if (is_array($content = $entry['subtree'])) {
	    $ret .= "\n";
            $sorted_attributes = array( );
            $elements = array( );

            foreach ( $content as $key => $value ) {
                if ( preg_match( "/([^\/]*)\/@attr$/", $key, $match ) ) {
                    $sorted_attributes[$match[1]] = $value;
                } else {
                    $elements[$key] = $value;
                }
            }

	    foreach ($elements as $key => $value) {
                $attributes = make_attr( $sorted_attributes[$key] );
		$ret .= str_repeat($indent, $level + 2) . "<$key$attributes>$value</$key>\n";
	    }
	    $ret .= str_repeat($indent, $level + 1);
	} else {
	    $content = $entry['content'];
	    $ret .= "$content";
	}
	$ret .= "</$tag>\n";
    }
    $ret .= str_repeat($indent, $level) . "</info>\n";

    return $ret;
}


function lang_offset ($lang) {
    global $languages, $debug;

    if ($debug) {
	echo "Looking for langauge '$lang'<br>";
    }
    foreach ($languages as $offset => $lang_info) {
	if ($lang_info['abbr'] == $lang) {
	    if ($debug) {
		echo "Found offset for language '$lang': $offset<br>";
	    }
	    return $offset;
	}
    }
    exception("Unknown language '$lang'");
}

function call_handler ($annot, $args) {
    global $doc_root;

    if ($handler = $annot['appinfo']['subtree']['handler']) {
	$abs_handler = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$handler";
	if (is_file($abs_handler)) {
	    $php_code = join("", file($abs_handler));
	    if ($anon_func = create_function('$args', $php_code)) {
		if (!isset($args['sid'])) {
		    $args['sid'] = session_id();
		}

                if ( !isset( $args['attr'] ) ) {
                    if ( is_array( $attr = $annot['appinfo']['subtree']['handler/@attr'] ) ) {
                        $args['attr'] = $attr;
                    }
                }
                    
		$ret_xml = $anon_func($args);
		// So far, we through away the returned XML, maybe we want to do something with it in the future...
	    } else {
		die("<b>Fatal:</b> Unable to parse handler '$abs_handler':");
	    }
	} else {
	    die("<b>Fatal:</b> Can't find handler '$abs_handler'");
	}
    }
}


function make_handler_args ($args = array()) {
    global $doc_root, $cwd;
    $patterns = array("/\//", "/\./");	// Stuff we want to escape in doc root regexp should be added here
    $replacements = array("\/", "\.");	// ... and of course the escaping here...

    $doc_root_tmp = preg_replace("/^\/+/", "", $doc_root);
    $doc_root_tmp = preg_replace("/\/+$/", "", $doc_root_tmp);
    $doc_root_regexp = preg_replace($patterns, $replacements, $doc_root_tmp);
    $norm_cwd = normalize_path($cwd);
    $args['portal_abs_dir'] = preg_replace("/^\/*$doc_root_regexp/", "", $norm_cwd, 1);
    $args['portal_root'] = $doc_root_tmp;
    return $args;
}


function process_type ($name, $type, &$info, &$namespace, $level, &$path, $attr=array(), $node, $min, $max, $offset=-1) {
    global $write_file, $delete_node, $style_indent, $tab_index, $is_invalid, $valid, $typemap, $indent, $f, $languages, $debug, $doc_root, $admin_lang, $cwd;
    $ret = "";
    $hidden = "";

    if ($formtype = $typemap[$type]) { // Is this thing predeclared?
	if ($valid 
            && ($valid_msg = element_valid ($node, $namespace, 
                                            $level, $path, $type, 
                                            $min, $max))) {
	    $is_invalid = 1;
	    $attr['valid'] = $valid_msg;
	}
	$this_path = get_form_name($path);
	$tab_index ++;
	$ret .= str_repeat($indent, $level) . "<field name=\"$name\" tabindex=\"$tab_index\" path=\"$this_path\" type=\"$formtype\"" . make_attr($attr). " indent=\"$style_indent\">\n";
	check_focus($path);
	if ($authoriZURL = $info['appinfo']['subtree']['authoriZURL']) {
	    if (preg_match("/.*\.tkl$/", $authoriZURL)) {
		if (!file_exists($zfn = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root$authoriZURL"))
		    die("Could not locate authority file $zfn");
		else {
		    if (!($auth_dom = domxml_open_file($zfn))) {
			die("<b>Fatal:</b> Unable to open/parse authority file '$zfn'");
		    }
		    $auth_root = $auth_dom->document_element();
		    if (is_array($enums = $auth_root->child_nodes())) {
			foreach ($enums as $enum) {
			    if ($enum->node_type() != XML_ELEMENT_NODE) {
				continue;
			    }
			    $enum_value = $enum->get_attribute('value');
			    $enum_default = $enum->get_attribute('default');
			    if (is_array($enum_string_nodes = $enum->child_nodes())) {
				foreach ($enum_string_nodes as $enum_string_node) {
				    if ($enum_string_node->node_type() != XML_ELEMENT_NODE) {
					continue;
				    }
				    $enum_lang = $enum_string_node->get_attribute("lang");
				    if ($enum_lang != $admin_lang) {
					continue;
				    }
				    $enum_string = get_content($enum_string_node);
				    $ret .= str_repeat($indent, $level + 1) . "<enum value=\"$enum_value\" default=\"$enum_default\">$enum_string</enum>\n";
				}
			    }
			}
		    }
		}
	    } else
		die("Fatal: Don't know how to deal with authoriZURL: $authoriZURL");
	} elseif ($file_select = $info['appinfo']['subtree']['file_select']) {
	    $abs_path = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$file_select";
	    if (is_dir($abs_path)) {
		if ($file_dir = @opendir($abs_path)) {
		    $enums = "";
		    while ($entry = readdir($file_dir)) {
			if ($entry == "." or $entry == ".." or $entry == "CVS") {
			    continue;
			}
			$enums .= str_repeat($indent, $level + 2) . "<enum value=\"$entry\"/>\n";
		    }
		    $ret .= str_repeat($indent, $level + 1) . "$enums\n";
		    closedir($file_dir);
		} else {
		    die("<b>Fatal:</b> Unable to open directory '$abs_path'");
		}
	    } else{
		die("<b>Fatal: No such directory '$abs_path'");
	    }
	}

	if ($info['appinfo']['subtree']['fieldtype'] == 'password') {
	    if (is_array($pwd_array = set_password($this_path))) {
		if (strlen($pwd_array[0])) {
		    if ($pwd_array[0] == $pwd_array[1]) {
			set_node(array_merge($path, 'value'), md5($pwd_array[0]));
			set_node(array_merge($path, 'attr'), array('type' => array('value' => 'md5')));
		    } else {
			$ret .= "<error>Passwords mis-match</error>";
			$is_invalid = 1;
		    }
		}
	    }
	}
	
	if (is_array($info)) {
	    $ret .= make_info($info, $level + 1);
	}

	if (!strlen($def_value = get_value($f, $path, $type))) {
	    $def_value = $node->get_attribute('default');
	} 

        if ($field_handler = $info['appinfo']['subtree']['handler']) {
	    $upload_action = "upload";
	    if (strlen($delete_node)) {		// Check if we're going to delete this node...
		$path_regexp = preg_replace(array("/\[/", "/\]/"), array("\[", "\]"), $delete_node);
		if (preg_match("/^$path_regexp/", get_path_str($path))) {
		    $upload_action = "delete";
		}
	    }
	    if ($type != "xs:anyType") {	// We assume type is xs:anyType so we store the returned xml from handler
		die("<b>Fatal:</b> Element type must be <b>xs:anyType</b> when xs:appinfo/handler is specified");
	    }
	    $which_path = "f:" . join(":", $path) . ":value";
	    $upload_info = $_FILES[$which_path];
	    if ($upload_info['tmp_name'] =='none' || $def_value == 'unset') {
		set_node($path, array());
	    }
	    $abs_handler = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$field_handler";
	    if (is_file($abs_handler)) {
		$php_code = join("", file($abs_handler));
		if ($anon_func = create_function('$args', $php_code)) {
		    $upload_content = get_node($f, $path);
		    $args = array('mimetype'	=>	$upload_info['type'],
		    		  'filename'	=>	$upload_info['name'],
				  'tmp'		=>	$upload_info['tmp_name'],
				  'size'	=>	$upload_info['size'],
		    		  'domain'	=>	$_SERVER['HTTP_HOST'],
				  'content'	=>	stripslashes($upload_content['value']),
				  'sid'		=>	session_id(),
		    		  'action'	=>	$upload_action);
		    if (strlen($write_file)) {
			if (!$file_spec) {
			    if (preg_match("/([^\/]*)$/", $write_file, $match)) {
				$args['tkl_doc'] = $match[1];
			    } else {
				die("<b>Fatal:</b> Unknown write file format: '$write_file'");
			    }
			}
		    }
		    $args = make_handler_args($args);
		    if ($upload_xml = $anon_func($args)) {
			$upload_xml = preg_replace("/<\?.*\?>/", "", $upload_xml);
			if (preg_match("/<error>(.*?)<\/error>/", $upload_xml, $match)) {
			    $is_invalid = 1;
			}
			$def_value = $upload_xml;
			set_node(array_merge($path, 'value'), $def_value);
		    }
		} else {
		    die("<b>Fatal:</b> Unable to parse handler '$abs_handler'");
		}
	    } else {
		die("<b>Fatal:</b>Call to undefinded field handle '$abs_handle'");
	    }

            $ret .= str_repeat($indent, $level + 1) . '<upload_xml>' .
                    $def_value . "</upload_xml>\n";
	}
        
        $def_value = tkl_string_to_xml($def_value);
	$ret .= str_repeat($indent, $level+ 1) . "<default>" . $def_value . "</default>\n";
	if ($info['appinfo']['subtree']['langdep'] && $offset != -1) {
	    $lang_path = array_merge($path, array("attr", "xml:lang"));
	    if ($lang_code = get_node($f, array_merge($lang_path, "value"))) {
		$lang_offset = lang_offset($lang_code);
		$lang_value = get_value($f, $lang_path);
	    } else {
		$lang_offset = $offset % count($languages);
		$lang_value = $languages[$lang_offset]['abbr'];
	    }
	    $ret .= str_repeat($indent, $level + 1) . "<language>" . $languages[$lang_offset]['desc'] . "</language>\n";
	    $hidden_fields .= str_repeat($indent, $level) . "<hidden path=\"" . get_form_name($lang_path) . "\" default=\"$lang_value\"/>\n";
	}
	$ret .= str_repeat($indent, $level) . "</field>\n";
	$ret .= $hidden_fields;
    } else {
	if ($ref_node = $namespace[$type]['complexType']) {  // Otherwise, it better be in the namespace...
	    if (is_choice($ref_node)) {
		if ($attr['more']) {
		    unset($attr['more']);
		}
	    }
	    $ret .= str_repeat($indent, $level) . "<struct name=\"$name\"" . make_attr($attr) . " indent=\"$style_indent\" path=\"" . get_path_str($path) . "\">\n";
	    $ret .= make_info($info, $level + 1);
	    $ret .= process($ref_node, $namespace, $level + 1, $path);
	    $ret .= str_repeat($indent, $level) . "</struct> " .
                    "<!-- NAME: $name -->\n";
	} elseif ($ref_node = $namespace[$type]['simpleType']) {
	    $ret .= process($ref_node, $namespace, $level, $path, array('name'=>$name, 'type'=>$type, 'info'=>$info, 'attr'=>$attr));
	} else {
	    exception("Unknown type '$type' for symbol name '$name'");
	}
    }
    return $ret;
}


function ref_node ($node) {	// Keeps following referenced nodes until the base node is found...
    while ($ref = $node->get_attribute('ref')) {	// is this a reference?
	$tag = $node->tagname;
	if ($ref_node = $namespace[$ref][$tag]) {
	    if ($ref_node == $node) {
		exception("self referenced declaration '$ref' in '$tag'");
	    }
	    $node = $ref_node;
	} else {
	    exception("reference to unknown symbol '$ref' in '$tag'");
	}
    }
    return $node;
}


function element ($node, &$namespace, $level=0, &$path, $context = 0) {
    global $move_up, $debug, $languages, $delete_node, $indent, $f, $append, $local_focus_name, $local_focus, $focus, $schema_ctx, $style_indent;
    $ret = "";
    $name = $node->get_attribute('name');	// Get as much info as possible from current node...
    $type = $node->get_attribute('type');
    $min = $node->get_attribute('minOccurs');
    $max = $node->get_attribute('maxOccurs');
    $org_node = $node;

    if (is_array($context)) {
	if (!strlen($min)) {
	    $min = $context['minOccurs'];
	}
	if (!strlen($max)) {
	    $max = $context['maxOccurs'];
	}
    }
    $node = ref_node($node);
    if (!$name) {					// Locally unset variables are set via the referenced object
	$name = $node->get_attribute('name');
    }
    if (!$type) {
	$type = $node->get_attribute('type');
    }
    if (!is_array($info = annotation($org_node))) {	// And likewise for annotations...
	$info = annotation($node);
    }
    if (!strlen($min)) {				// Default values for minOccurs and maxOccurs
	$min = 1;
    }
    if (!strlen($max)) {
	$max = "1";
    }
    if ($max == "unbounded") {				// Physical boundary
	$max = 9999999;
    }
    $max_offset = get_last($f, $path, $name);	// How many nodes do we already have?
    if ($info['appinfo']['subtree']['langdep']) {
	$lowest_offset = count($languages) - 1;
	if ($max_offset < $lowest_offset) {
	    $max_offset = $lowest_offset;
	}
    }
    if ($max_offset == -1) {
	$max_offset = 0;
    }
    if (isset($append) && $append == get_path_str(array_merge($path, $name))) {	// Are we going to append another element?
	$local_focus = $max_offset + 1;
	$local_focus_name = $name;
	if ($info['appinfo']['subtree']['langdep']) {
	    $max_offset = $max_offset + count($languages);
	} else {
	    $max_offset ++;
	}
    }
    $this_path_str = get_path_str(array_merge($path, $name));
    if (strlen($move_up)) {
	if (preg_match("/\[(\d+)\]$/", $move_up, $match)) {
	    $move_offset = $match[1];
	    $stripped = preg_replace("/\[$move_offset\]$/", "", $move_up);
	    if ($stripped == $this_path_str) {
		$new_offset = $move_offset - 1;
		$local_focus = $move_offset;
		$local_focus_name = $name;
		$new_path = $this_path_str . "[$new_offset]";
		//echo "Exchanging: '$move_up' with '$new_path'<br>";
		swap_elements($move_up, $new_path);
	    } else {
		unset($move_offset);
		unset($new_offset);
	    }
	} else {
	    echo "<b>Warning:</b> Unable to move element<br/>";
	}
    }

    if ($max_offset < ($min - 1)) {		// Always show at least minOccurs number of fields
	$max_offset = $min - 1;
    }
    if ($max_offset >= $max) {
	$max_offset = $max - 1;
    }

    $info_xml = make_info($info, $level + 1);
    if ($sub_node = dom_select($node, array("complexType", "simpleContent", "extension"))) {
	return $ret . extension($sub_node, $namespace, $level, $path, $info);
    }
    for ($offset = 0; $offset <= $max_offset; $offset ++) {	// Loop through node-set
	$ext_path = array_merge($path, array($name, $offset));
	if (($offset == $max_offset) && ($max_offset < ($max - 1))) {	// There are room for more elements, inform XSLT...
	    $more = array('more'=>get_path_str(array_merge($path, $name)));
	} else {
	    $more = array();
	}
	if ($offset > 0) {
	    $more['moveUp'] = get_path_str($ext_path);
	}
	if ($max_offset >= $min) {	// If we have more nodes than required, insert a delete button in XSLT...
	    $more['delete'] = get_path_str($ext_path);
	}
	if ($type) {						// Do we have a type?
	    $processed = process_type($name, $type, $info, $namespace, $level, $ext_path, $more, $node, $min, $max, $offset);
	} else {						// Otherwise, the structure is a subtree...
	    if (list($sub_node) = get_elements_by_tagname($node,"simpleType")) { // SimpleType and ComplexTypes are handled differently...
		$processed = process($sub_node, $namespace, $level, $ext_path, array('name'=>$name, 'type'=>$type, 'info'=>$info_xml, 'attr'=>$more));
	    } else {
		if (is_array($complex_subtree = dom_select_ext($node, array("complexType")))) {
		    $complex_node = array_shift($complex_subtree);
		} else {
		    die("<b>Fatal:</b> Schema error: Element '$name' must have either type attribute or a simpleType or complexType substructure");
		}
		if (is_choice($complex_node)) {
		    if ($more['more']) {
			unset($more['more']);
		    }
		}
		$processed = str_repeat($indent, $level) . "<struct name=\"$name\"" . make_attr($more) . " indent=\"$style_indent\" path=\"" . get_path_str($ext_path) . "\">\n" .
	            $info_xml .
	            process_subtree($node, $namespace, $level + 1, $ext_path) .
		    str_repeat($indent, $level) . "</struct> " .
                    "<!-- NAME: $name -->\n";
	    }
	}
	if (strlen($delete_node) && $delete_node == get_path_str($ext_path)) {
	    delete_node($f, $delete_node);
	    $delete_node = "";
            return element( $node, &$namespace, $level, &$path, $context );
	}
	$ret .= $processed;
    }
    return $ret;
}


// Delete a node deep down a nested hash by reference...
function delete_node (&$f, $path_str) {
    $path = make_array($path_str);
    $offset = array_pop($path);
    
    if (is_array($nodeset = get_node($f, $path))) {
	array_splice($nodeset, $offset, count($nodeset), array_slice($nodeset, $offset + 1, count($nodeset)));
	set_node($path, $nodeset);
    }
}


function is_choice ($node) {
    $children = dom_select_ext($node, array('choice'));
    if (is_array($children)) {
	return count($children);
    } else {
	return 0;
    }
}



function complextype ($node, &$namespace, $level, &$path) {
    global $style_indent, $max_indent;

    $style_indent ++;
    if ($style_indent > $max_indent) {
	$max_indent = $style_indent;
    }
    $ext_path = array_merge($path, array("subtree"));
    $subtree_xml = process_subtree($node, $namespace, $level, $ext_path);
    $style_indent --;
    return $subtree_xml;
}


function simplecontent ($node, &$namespace, $level, &$path) {
    $reduced_path = reduce_path($path);
    return process_subtree($node, $namespace, $level, $reduced_path);
}


function choice ($node, &$namespace, $level, &$path) {
    global $indent, $choice_path, $f, $local_focus, $local_focus_name;
    $min = $node->get_attribute("minOccurs");
    $max = $node->get_attribute("maxOccurs");
    $reduced_path = reduce_path($path);
    $offset = array_pop($reduced_path);
    $base_path = $reduced_path;
    $name = array_pop($reduced_path);
    $max_offset = get_last($f, $reduced_path, $name);

    if (is_array($kids = $node->child_nodes())) { // Which children does the choice construction have?
	foreach ($kids as $kid) {
	    if (strlen($elem = $kid->tagname)) {
		if ($elem = "element") { // Store true elements
		    $sub_elements[$kid->get_attribute('name')] = $kid;
		} else {
		    exception("Only xs:element tags are allowed as children of xs:choice");
		}
	    }
	}

	if (!is_array($sub_elements)) {	// We only support elements in a choice construction!
	    exception("Found no xs:element subtags under xs:choice");
	}

	foreach ($sub_elements as $sub_name => $element) {
	    if (get_last($f, $path, $sub_name) != -1) {	// Any elements of this type?
		$ret .= process($element, $namespace, $level, $path); // If yes, then process them...

		if ($offset == $max_offset || $max_offset == -1) {
		    $ret .= str_repeat($indent, $level - 1) . "</struct> " .
                            "<!-- NAME: $name -->\n";
		    $ret .= str_repeat($indent, $level - 1) . "<struct name=\"$name\" adopt=\"former\" path=\"" . get_path_str($path) . "\">\n";
		}

		break;
	    }
	}

	if ($offset == $max_offset || $max_offset == -1) { // If we're looking @ last element, inform XSLT
	    if ($max_offset == -1) {
		$append_offset = 0;
	    } else {
		$append_offset = $offset + 1;
	    }

	    $append_choice_path = array_merge($reduced_path, $name, $append_offset, "subtree");

	    if (isset($choice_path)) {
		$choice_path_mod = preg_replace("/^\[/", "", $choice_path);
		$choice_path_mod = preg_replace("/\]$/", "", $choice_path_mod);
		$choice_path_array = preg_split("/\]\[/", $choice_path_mod);
		$choice_field = array_pop($choice_path_array);

		if ($choice_path == get_path_str(array_merge($append_choice_path, $choice_field))) {
		    $local_focus = $append_offset;
		    $local_focus_name = $name;
                    
		    $ret .= process($sub_elements[$choice_field], $namespace, $level, $append_choice_path);

		    $max_offset ++;
		}
	    }

	    $ret .= str_repeat($indent, $level) . "<choice>\n";	// to insert a more button...

	    foreach ($sub_elements as $element) {
		if (!is_array($info = annotation($element))) {
		    $element = ref_node($element);
		    $info = annotation($element);
		}
                
		$sub_name = $element->get_attribute('name');

		$ret .= str_repeat($indent, $level + 1) . "<select path=\"" .
		        get_path_str(array_merge($base_path, $max_offset + 1, "subtree", $sub_name)) . "\">\n" .
		        make_info($info, $level + 2) .
		        str_repeat($indent, $level + 1) . "</select>\n";
	    }

	    $ret .= str_repeat($indent, $level) . "</choice>\n";
	}

	return $ret;
    } else {
	exception("xs:choice must have xs:element children");
    }
}


function reduce_path (&$path) {		// Consume path back to last subtree occurrence
    $reduced_path = array();
    $append = 0;
    for ($i = count($path) - 1; $i >= 0; $i--) {
	if (!$append && ($path[$i] == "subtree")) {
	    $append = 1;
	    continue;
	}
	if ($append) {
	    array_unshift($reduced_path, $path[$i]);
	}
    }

    return $reduced_path;
}


function extension ($node, &$namespace, $level, &$path, $info=0) {	// This code is tuned for the insertion of the lang attribute. It is not tested and intended for other purposes!
    global $f, $append, $called, $delete_node;
    $ret = "";

    if ($type = $node->get_attribute('base')) {
	$tag = "";
	$parent = $node;
	while ($tag != "element") {			// Navigate up in the hierarchy to find the named element
	    $parent = $parent->parent_node();
	    $tag = $parent->tagname;
	}
	if (!($name = $parent->get_attribute('name'))) {
	    exception("Extension tag must be embedded in a named element");
	}
	$max = $parent->get_attribute('maxOccurs');
	$min = $parent->get_attribute('minOccurs');
	if (!$info) {
	    if (!is_array($info = annotation($parent))) {     // And likewise for annotations...
		$info = annotation($node);
	    }
	}
	if (!strlen($min)) {                                // Default values for minOccurs and maxOccurs
	    $min = 1;
	}
	if (!strlen($max)) {
	    $max = "1";
	}
	if ($max == "unbounded") {                          // Physical boundary
	    $max = 9999999;
	}
	$max_offset = get_last($f, $path, $name);   // How many nodes do we already have?
	if ($max_offset == -1) {
	    $max_offset = 0;
	}
	if (isset($append) && $append == get_path_str(array_merge($path, $name))) { // Are we going to append another field?
	    $max_offset ++;
	}
	if ($max_offset < ($min - 1)) {             // Always show at least minOccurs number of fields
	    $max_offset = $min - 1;
	}
	if ($max_offset >= $max) {
	    $max_offset = $max - 1;
	}
	$info_xml = make_info($info, $level + 1);
	for ($offset = 0; $offset <= $max_offset; $offset ++) {     // Loop through node-set
	    $ext_path = array_merge($path, array($name, $offset));
	    if (($offset == $max_offset) && ($max_offset < ($max - 1))) {   // There are room for more elements, inform XSLT...
		$more = array('more'=>get_path_str(array_merge($path, $name)));
	    } else {
		$more = array();
	    }
	    if ($max_offset >= $min) {	// If we have more nodes than required, insert a delete button in XSLT...
		$more['delete'] = get_path_str($ext_path);
	    }
	    $ret_type = process_type($name, $type, $info, $namespace, $level, $ext_path, $more, $node, $min, $max, $offset);
	    $ret_subtree = process_subtree($node, $namespace, $level, $ext_path);
	    
	    if (strlen($delete_node) && $delete_node == get_path_str($ext_path)) {
		delete_node($f, $delete_node);
		$offset --;		// Process same offset once again
		$max_offset --;	// Number of nodes is reduced by 1
		$delete_node = "";
		continue;
	    }
	    $ret .= $ret_type;
	    $ret .= $ret_subtree;
	}
	return $ret;
    } else {
	exception("There is no base attribute in extension tag");
    }
}


function check_focus ($path) {
    global $local_focus, $focus, $local_focus_name;
    $my_path = $path;

    if (strlen($local_focus)) {
	do {
	    list($field, $offset, $type) = array(array_shift($my_path), array_shift($my_path), array_shift($my_path));
	    if (strlen($field) && strlen($offset) && $local_focus_name == $field && $local_focus == $offset) {
		$focus = get_form_name($path);
		$local_focus = "";
		break;
	    }
	} while ($field);
    }
}


function simpletype ($node, &$namespace, $level, &$path, &$context) {
    global $f, $indent, $typemap, $tab_index, $style_indent;
    $name = $context['name'];
    $attr = $context['attr'];
    $info = $context['info'];

    if (list($sub_node) = get_elements_by_tagname($node,'restriction')) {
	$sub_info = restriction($sub_node, $namespace, $level, $path, $context);
    } else {
	exception("simpleType without any restriction sub tag");
    }
    $type = $typemap[$sub_info['base']];
    $enum = $sub_info['enum'];

    $this_path = get_form_name($path);
    $tab_index ++;
    $ret .= str_repeat($indent, $level) . "<field name=\"$name\" tabindex=\"$tab_index\" path=\"$this_path\" type=\"$type\"" . make_attr($attr). " indent=\"$style_indent\">\n";
    check_focus($path);
    $ret .= $info . $enum . str_repeat($indent, $level);
    $ret .= str_repeat($indent, $level + 1) . "<default>" . tkl_string_to_xml(get_value($f, $path)) . "</default>\n";
    $ret .= str_repeat($indent, $level) . "</field>\n";
    return $ret;
}


function sequence ($node, &$namespace, $level, &$path) {
    return process_subtree($node, $namespace, $level, $path);
}


function maxlength ($node, &$namespace, $level, &$path) {
    return process_subtree($node, $namespace, $level, $path);
}


function pattern ($node, &$namespace, $level, &$path) {
    return process_subtree($node, $namespace, $level, $path);
}


function attribute ($node, &$namespace, $level, $path) { // So far, we treat attributes as elements...
    $tag = 'attribute';
    if ($ref = $node->get_attribute('ref')) {		// Is this a reference?
	if ($ref_node = $namespace[$ref][$tag]) {
	    if ($ref_node == $node) {
		exception("Self referenced declaration '$ref' in '$tag'");
	    }
	    return process($ref_node, $namespace, $level, $path);
	} else {
	    exception("Reference to unknown symbol '$ref' in '$tag'");
	}
    }
    $info = annotation($node);
    $name = $node->get_attribute('name');
    $type = $node->get_attribute('type');
    if ((string) $path[count($path) - 1] == 'subtree') {
	array_pop($path);
    }
    $ext_path = array_merge($path, array("attr", $name));
    if ($type) {                                    // Do we have a type?
	return process_type($name, $type, $info, $namespace, $level, $ext_path, array(), $node, $min, $max);	// Remember to implement $info here!!!!
    } else {
	exception("Attribute '$name' with no type");
    }
}


function restriction ($node, &$namespace, $level, &$path, $context=0) {
    $ret = array();
    if ($base = $node->get_attribute('base')) {
	$ret['base'] = $base;
    } else {
	exception("No base attribute present");
    }
    $ret['enum'] = process_subtree($node, $namespace, $level + 1, $path, $context);
    return $ret;
}


function enumeration ($node, &$namespace, $level, &$path, $context=0) {
    global $indent;

    if ($value = $node->get_attribute('value')) {
	return str_repeat($indent, $level) . "<enum value=\"$value\"/>\n";
    } else {
	exception("Enumeration tag without value attribute");
    }
}


function process ($node, &$namespace, $level=0, &$path, $context=0) {
    global $valid;

    if ($tag = $node->tagname) {
	if ($tag == "annotation" || $tag == "extension") {	// Annotations/extensions are handled elsewhere, neglect them here...
	    return;
	}
	if (function_exists($tag)) {
	    if (is_array($context)) {
		$result = $tag($node, $namespace, $level, $path, $context);
	    } else {
		$result = $tag($node, $namespace, $level, $path);
	    }
	    return $result;
	} else {
	    exception("Unsupported tag: '$tag'");
	}
    }
}

function annotation ($node, $found=0) {
    // Extracts the content of an annotation tag, and returns a nested associative array.
    // If there is no annotation sub-node, false is returned.

    global $max_page;

    if (is_array($entries = $node->child_nodes())) {
	foreach ($entries as $entry) {
	    if ($tag = $entry->tagname) {
		if ($tag != "annotation") {
		    if (!$found) {
			continue;
		    } else {
			if (is_array($sub_entries = $entry->child_nodes())) {
			    foreach ($sub_entries as $sub_entry) {
				if (($content = trim(get_content($sub_entry))) && $sub_entry->tagname) {
				    $info[$tag]['subtree'][$sub_entry->tagname] = $content;
                                    $attributes = array( );

                                    if ( is_array( $attr_list = $sub_entry->attributes( ) ) && count( $attr_list ) ) {
                                        foreach ( $attr_list as $attr ) {
                                            $attributes[ $attr->name( ) ] = $attr->value( );
                                        }
                                    }
                                    
                                    $info[$tag]['subtree'][ $sub_entry->tagname . '/@attr' ] = $attributes;
				} elseif (trim($content)) {
				    $info[$tag]['content'] = $content;
                                }
			    }
			}
		    }
		} else {
		    $ret = annotation($entry, 1);
		    if ($ret['appinfo']['subtree']['page'] > $max_page) {
			$max_page = $ret['appinfo']['subtree']['page'];
		    }
		    return $ret;
		}
	    }
	}
	return $info;
    } else {
	return 0;
    }
}


function process_subtree ($node, &$namespace, $level, &$path, $context=0) {
    $ret = "";
    if ($kids = $node->child_nodes()) {
	foreach ($kids as $kid) {
	    $ret .= process($kid, $namespace, $level, $path, $context);
	}
    }
    return $ret;
}


function schema ($node, &$namespace, $level=0, &$path) {
    return process_subtree($node, $namespace, $level, $path);
}


function trap_xslt_error ($parser, $errorno, $level, $fields) {
    global $output_xml;
    echo "<h1>Error parsing xform XML:</h1><br/>";
    if(is_array($fields)) {
	foreach ($fields as $key => $value) {
	    echo "<b>$key</b>: $value<br/>";
	}
    } else {
	echo "<b>$fields</b><br/>";
    }
    $lines = preg_split("/\n/", $output_xml);
    for ($i = 0; $i <= count($lines); $i++) {
	echo $i + 1, ": ", htmlentities($lines[$i]), "<br/>\n";
    }
}

$path = array();
create_namespace($schema_root, $namespace = array());

if (strlen($start)) {
    $output_xml = process($namespace[$start]['element'], $namespace, 1, $path);
} else {
    $output_xml = process($schema_element_root, $namespace, 1, $path);
}

$write_error = 0;
if ($save && is_array($f) && (!$is_invalid || $url)) {
    $xml_data = $xml_header. create_xml($f);
    if ($debug) {
	echo "<hr/>Writing:<pre>", htmlentities($xml_data), "</pre><hr/>";
    }
    if (isset($write_file)) {
	$filename = $write_file;
	if ($file_spec && strlen($write)) {
	    $write = check_suffix($write);
	    $filename = "$filename/$write";
	}
	if (!is_granted($filename, "write")) {
	    echo "<h1>Write access error</h1>\n";
	    die;
	    $write_error = 2;
	} elseif ($file_spec && file_exists($filename)) {
	    $write_error = 1;
	} else {
	    if (!($fh = fopen($filename, "w"))) {
		exception("Unable to open file '$filename' for writing");
	    }
	    if (!(fputs($fh, $xml_data))) {
		exception("Unable to write xml data to file '$filename'");
	    }
	    fclose($fh);
	    if ($debug) {
		echo "Wrote xml data to file '$filename'<br>";
	    }
	    $saved = 1;
	    //search_index($filename);
            
            if ( preg_match("/([^\/]*)$/", $filename, $match) ) {
                $tkl_doc = $match[1];
            } else {
                exception( 'save: Unable to find tkl file name: ' . $filename );
            }
            
	    if (is_array($schema_annotation)) {
		$hndl_args = array( 'action'    => 'commit',
                                    'tkl_doc'   => $tkl_doc,
                                    'xml_data'   => $xml_data );
                
		$hndl_args = make_handler_args($hndl_args);
		call_handler($schema_annotation, $hndl_args);
	    }
            
	    search_index( $cwd . '/' . $tkl_doc );
	}
    }
} elseif ( $unlink ) {
    if ( isset( $write_file ) ) {
	$filename = $write_file;
        
        if ( preg_match( '/([^\/]*)$/', $filename, $match ) ) {
            $tkl_doc = $match[1];
        } else {
            exception( 'Unlink: Unable to find tkl file name: ' . $filename );
        }
	
        if ( is_granted( $filename, 'write' ) ) {
            if ( is_array( $schema_annotation ) ) {
                $hndl_args = array( 'action'    => 'unlink',
                                    'tkl_doc'   => $tkl_doc,
                                    'xml_data'  => $xml_data );
                
                if ( preg_match( '/([^\/]*)$/', $filename, $match ) ) {
                    $hndl_args['tkl_doc'] = $match[1];
                }
                
                $hndl_args = make_handler_args( $hndl_args );
                call_handler( $schema_annotation, $hndl_args );
            } else {
                if ( !unlink( $filename ) ) {
                    exception( 'Unable to unlink file ' . $filename );
                }

                search_index( $cwd );
            }
        } else {
            echo "<h3>Write access denied</h3>";
            die;
        }

        $close_win = 1;
    }
} elseif ($close_win) {
    if (is_array($schema_annotation)) {
	$hndl_args = array('action' => 'cleanup');
	if (!$file_spec) {
	    if (preg_match("/([^\/]*)$/", $write_file, $match)) {
		$hndl_args['tkl_doc'] = $match[1];
	    } else {
		die("<b>Fatal:</b> Unknown write file format: '$write_file'");
	    }
	}
	$hndl_args = make_handler_args($hndl_args);
	call_handler($schema_annotation, $hndl_args);
    }
}
$creator_info = get_user_info($creator);
$creator_name = $creator_info['name'];
$output_xml = $xml_header . "<xform focus=\"$focus\" 
                                    invalid=\"$is_invalid\"
                                    saved=\"$saved\"
                                    url=\"$url\"
                                    creator_name=\"$creator_name\"
                                    creator=\"$creator\"
                                    allow_write=\"$allow_write\"
                                    cwd=\"$cwd\"
                                    write=\"$write\"
                                    write_file=\"$write_file\"
                                    schema=\"$schema\"
                                    action=\"$xml_editor\"
                                    root=\"$start\"
                                    error=\"$write_error\"
                                    file_spec=\"$file_spec\"
                                    max_indent=\"$max_indent\">\n". $output_xml;

// Insert a noteset describing where the hell this document originates...
$output_xml .= str_repeat($indent, 1) . "<doc_path>\n";
$index_dir = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/";
$index_file = "$index_dir/index.tkl";
if (file_exists($index_file) && strlen($index_title = get_title($index_file))) {
    $index_title = tkl_string_to_xml($index_title);
    $output_xml .= str_repeat($indent, 2) .
                   "<step root=\"1\">$index_title</step>\n";
} else {
    $output_xml .= str_repeat($indent, 2) . "<step root=\"1\"/>\n";
}

foreach ($where_path as $step) {
    $index_dir .= "/$step";
    $index_file = "$index_dir/index.tkl";
    if (file_exists($index_file)) {
	if (!strlen($index_title = get_title($index_file))) {
	    $index_title = $step;
	}
	else 
	{
	    $index_title = tkl_string_to_xml($index_title);
	}
    } else {
	$index_title = $step;
    }
    $output_xml .= str_repeat($indent, 2) . "<step>$index_title</step>\n";
}
$output_xml .= str_repeat($indent, 1) . "</doc_path>\n";

// Insert some global schema information
list($anno_node) = dom_select_ext($schema_root, array('annotation'));
if ($anno_node) {
    $output_xml .= str_repeat($indent, 1) . "<global_info>";
    $output_xml .= dump_xml($anno_node);
    $output_xml .= str_repeat($indent, 1) . "</global_info>\n";
}

$output_xml .= "</xform>\n";


if ($debug) {
    echo "<pre>\n", htmlentities($output_xml), "\n</pre>\n";
}

$portal_root = strlen( preg_replace( "/^\/+/", "", $doc_root ) ) ? normalize_path( "$doc_root/" ) : "";

$xslt = xslt_create();
xslt_set_error_handler($xslt, "trap_xslt_error");
xslt_set_scheme_handlers( $xslt, array( 'get_all' => 'xform_scheme_handler' ) );
$xslt_parameters = array( 'currentPage' => $currentPage,
                          'max_page'    => $max_page,
                          'where'       => join("/", $where_path),
                          'doc_root'    => $_SERVER['DOCUMENT_ROOT'] .
                                           "/$doc_root",
                          'admin_lang'  => $admin_lang,
                          'domain'      => $_SERVER['HTTP_HOST'],
                          'portal_root' => $portal_root,
                          'close_win'   => $close_win );

$xform_stylesheet = xform_get_stylesheet( $portal_root );


if ($result = @xslt_process($xslt, "arg:/_xml", $xform_stylesheet, NULL,
                            array('/_xml' => $output_xml),
                            $xslt_parameters ) ) {
    echo $result;
} else {
    if (!$debug) {
	echo "<html><body onLoad=\"close()\"/></html>\n";
    }
}

xslt_free($xslt);

?>
