<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: util.php,v 1.2 2003/09/09 13:56:03 adam Exp $
*/


$port_context = array();

function port_context($array) {
}

function port_makeparms($array, $override = array()) {
   $res='';
    foreach ($array as $varname) {
	$var = &$GLOBALS[$varname];
	if (!empty($var)) {
	    if (!$override[$varname]) {
		if (is_array($GLOBALS[$varname])) {
		    foreach ($var as $key => $member) {
			if ($res)
			    $res .= '&';
			$res .= "{$varname}[$key]=" . urlencode($member);
		    }
		}
		else {
		    if ($res)
			$res .= '&';
		    $res .= "$varname=" . urlencode($GLOBALS[$varname]);
		}
	    }
	}
    }
    foreach ($override as $varname => $value) {
	if ($res)
	    $res .= '&';
	$res .= "$varname=" . urlencode($value);
    }
    return $res;
}

function port_makeparms_context() {
    global $port_context;
}


function min_dump ($array, $level) {
	while (list($key, $varname) = each($array)) {
		$var = &$GLOBALS[$varname];
                for ($i = 1; $i < $level; $i++) {
                        echo "--";
                }
		echo " $varname = ";
		if (is_array($var)) {
			echo "Array<BR>";
			if ($varname != 'context') {
				min_dump($var, ++$level);
			}
		} else {
			echo "$var<BR>";
		}
	}
}


function exist ($string, $array, $yes, $no = '') {
	while (list($key, $entry) = each($array)) {
		if ($entry == $string) {
			return $yes;
		}
	}
	return $no;
}


function get_nonempty($list) {
	$nonempty = array();
	if (!is_array($list)) {
		return array();
	}
	foreach ($list as $key => $entry) {
		if (!empty($entry)) {
			$nonempty[] = $key;
		}
	}

	return $nonempty;
}


function is_query($query_list) {
	global $required_fields;

	return $number = sizeof(array_intersect(get_nonempty($query_list), $required_fields));
}


function hash2Inputlist ($lol, $array_id) {
	$tagset .= '<tr>';
	$tagset .= '<td colspan="2" bgcolor="#999999" height="1" width="190"><img border="0" src="point_gray1.gif" width="1" height="1"></td>';
	$tagset .= '<td rowspan="8" bgcolor="#999999" width="1"><img border="0" src="point_gray1.gif" width="1" height="1"><br>';
	$tagset .= '<br></td></tr>' . "\n";

	foreach ($lol as $list) {
		foreach ($list as $field => $name) {
			if (!preg_match("/^__\d+__/", $field)) {
				$tagset .=	"<TR>\n" .
						'<td width="78"><br>' .
						'<img border="0" src="point_gray1.gif" hspace="3" width="1" height="1"><b><font face="Verdana, Arial, Helvetica, sans-serif" size="1" color="#333333">' .
						m($field) .
						'</font></b></td>' .
						'<td width="112"><br>' .
						HTML_input('text', $array_id . '[' . $name . ']', '', 'size=11') .
						'</td>' .
						"</TR>\n";
			}
		}
	}
	$tagset .= "<TR>\n";
	$tagset .= '<TD width="78">&nbsp;</TD>' . "\n";
	$tagset .= '<TD width="112"><img border="0" src="point_gray1.gif" width="1" height="1" vspace="2"><br>' . "\n";
	$tagset .= HTML_input('submit', '', m('Send'), 'style="font-size: 8pt; font-family: Arial; font-weight: bold"');
	$tagset .= HTML_input('reset', '', m('Slet'), 'style="font-family: Arial; font-size: 8pt; font-weight: bold"');
	$tagset .= "</TD></TR>\n";

	return $tagset;
}


function print_marc_record($ar) {
    reset($ar);
    $nl = "";
    $ret = '';
    while(list($key,list($tagpath,$data))=each($ar)) {
        if (ereg("^\(3,([^)]*)\)\(3,@\)$",$tagpath,$res)) {
	    // Line below inserted to ensure good diaplay of DANMARC2 records in release-version of PHP (may be deleted later)
	    $data = preg_replace("/\037(.)/", ' <B>$1</B> ', $data);
            $ret .= $res[1] . '&nbsp;' . $data . "<br>\n";
        } elseif (ereg("^\(3,([^)]*)\)\(3,([^)]*)\)$",$tagpath,$res)) {
            $ret .= $nl;
            $nl = "";
            $ret .= $res[1] . ' ' . ereg_replace(" ", "_", $res[2]);
        } elseif (ereg("^\(3,([^)]*)\)\(3,([^)]*)\)\(3,([^)]*)\)$",$tagpath,$res)) {
            $ret .=  ' <b>' . $res[3] . '</b> ' . $data . "\n";
            $nl="<br>";
        }
    }
    $ret .= $nl;

    return $ret;
}

function get_target_name($target) {
	global $targets, $lang;

	$info = $targets[$target];
	if (is_array($info['name'])) {
		$dbname = $info['name'][$lang];
	} else {
		$dbname = $info['name'];
	}

	return $dbname;
}


function convert_locale($string, &$info) {
	$mapping = $info['locale'];
	if (is_array($mapping)) {
		foreach ($mapping as $before => $after) {
			$string = preg_replace($before, $after, $string);
		}
	}
	return $string;
}


function restore_query() {
	global $base_q;
	$new = array();

	foreach ($base_q as $field => $value) {
		$key = 'query[' . $field . ']';
		$new[$key] = $value;
	}

	return $new;
}


function check_isbn(&$q) {
        $value = $q['isbn_issn'];
        if (!empty($value)) {
                if (preg_match('/^\d{4}-\d{3}\w$/', $value)) {            // xxxx-xxx*
                        $q['issn'] = $value;
                } elseif (preg_match('/^\d{8}$/', $value)) {              // xxxxxxx*
                        $q['issn'] = $value;
                } else {
                        $q['isbn'] = $value;
                }
                $q['isbn_issn'] = '';
        }
}



function narrow_anchor($term, $termid) {
	global $context;
	return "<A HREF=\".?" . port_makeparms($context, array('p' => 'narrow', 'zbrowse' => $termid, 'start'=>1)) . "\">" . $term . "</A>";
}


function get_thes_path($current) {
	global $zthes_zurl;
	$path = array();
	$thes = new Zthesaurus($zthes_zurl);
	list($node) = $thes->find_id($current);
	//echo "ERROR = ", $thes->error, "<BR>";
	while ($node) {
		//echo "TERM = '", $node->term, "', ID = '", $node->id, "'<br>\n";
		array_unshift($path, array('term' => $node->term, 'id' => $node->id));
		list($node) = $node->broader();
	}
	$thes->close();
	//echo "Path = ", join(" -> ", $path), "<BR>";

	return $path;
}


function get_term_name($id) {
    global $zthes_zurl, $arrow;
    
    $ret = "";
    $thes = new Zthesaurus($zthes_zurl);
    list($node) = $thes->find_id($id);
    if ($node) {
	$path = get_path_plain($node);
	foreach ($path as $entry) {
	    if (!$entry) {
		continue;
	    }
	    if ($ret) {
		$ret .= $arrow;
	    }
	    $ret .= "<a href=\"?p=narrow&zbrowse=" . $entry->id . "\">" . $entry->term . "</a>";
	}
    } else {
	$ret = "Uafklaret";
    }
    $thes->destroy();
    
    return $ret;
}


function get_path_plain($node) {
    $path = array();
    while ($node) {
	array_unshift($path, $node);
	list($node) = $node->broader();
    }

    return $path;
}



function check_term($term) {
	$reserved = array('og', 'eller', 'ikke');
	$chunks = preg_split("/\s+/", strtolower($term));
	$escaped = array();

	foreach ($chunks as $chunk) {
		if (in_array($chunk, $reserved)) {
			$chunk = "'$chunk'";
		}
		$escaped[] = $chunk;
	}
	return join(" ", $escaped);
}


function tuned_record_interval ($hits, $query, $showdate) {
    echo "<div style=\"font-family:arial,sans-serif; font-size: 12px;\">";
    if (!$showdate) {
	echo show_record_interval($hits);
	echo " - Sgeord: ", prettyQuery($query);
	$navig = HTML_changePage($hits);
	if ($navig) {
	    echo " - $navig";
	}
    } else {
	echo "<b>Nye links i fng.dk fra perioden ", date("d-m-Y", time() - 604800), " til ";
	echo date("d-m-Y", time()), "</b>\n";
    }
    echo "</div>\n";
}


//$Log: util.php,v $
//Revision 1.2  2003/09/09 13:56:03  adam
//GPL message in all XSL and PHP files
//
//Revision 1.1  2002/07/02 15:37:18  perhans
//Added a browse pop up window (browse.php) to xform.xsl. Browse.php uses the catutil.phpi, standards,php, util.php files.
//
//Revision 1.15  2002/01/11 11:29:26  sondberg
//Added function to generate a thesaurus path from the id.
//
//Revision 1.14  2002/01/03 14:34:02  sondberg
//"Nye-links" link now works again.
//
//Revision 1.13  2002/01/03 14:28:17  sondberg
//Added more functionality to function tuned_record_interval.
//
//Revision 1.12  2002/01/03 14:15:47  sondberg
//Added function tuned_record_interval.
//
//Revision 1.11  2001/11/20 15:09:56  sondberg
//Closed a yaz-handle properly.
//
//Revision 1.10  2001/11/20 14:37:06  sondberg
//Made a cleaner version of get_thes_path: get_path_plain.
//
//Revision 1.9  2001/11/20 11:18:02  sondberg
//Added simpler version of get_thes_path: get_path_plain.
//
//Revision 1.8  2001/11/15 14:54:44  quinn
//Smallish
//
//Revision 1.7  2001/11/01 14:53:57  perhans
//Scan on keywords now works.
//
//Revision 1.6  2001/11/01 11:15:28  sondberg
//Reintroduced 'og', 'eller' and 'ikke' into $reserved words in check_term.
//
//Revision 1.5  2001/11/01 09:07:38  perhans
//Changes so that the og, elle, ikke dosn't get "'" around it in the search query.
//
//Revision 1.4  2001/10/12 09:37:32  perhans
//More changes to make editing work and support for date fields were added
//
//Revision 1.3  2001/10/05 12:39:55  perhans
//Adde a function to format DK5 keywords and a new version of the function
//to show scan results that does not depend so much on formatting
//
//Revision 1.2  2001/09/27 12:03:52  sondberg
//Added narrow_anchor.
//
//Revision 1.1  2001/09/25 12:48:00  sondberg
//Added a few files and started on the index-page.phpi
//
//Revision 1.10  2001/08/03 13:39:39  quinn
//DANMARC2 fix
//
//Revision 1.9  2001/07/24 08:49:53  sondberg
//Export is now taken care of by export.php
//
//Revision 1.8  2001/07/24 07:59:34  sondberg
//Added function check_isbn which checks for the format of entry 'isbn_issn' and decided whether to perform isbn search og issn search.
//
//Revision 1.7  2001/07/20 06:15:51  sondberg
//Added $base_q, and implemented extra navigation facilities between
//searching and scanning results.
//
//Revision 1.6  2001/07/17 13:13:36  sondberg
//Added convert_locale.
//
//Revision 1.5  2001/07/06 12:49:07  sondberg
//Included new html mugup in source.
//
//Revision 1.4  2001/07/05 12:55:09  sondberg
//hash2Inputlist now makes entries with '__digit__' invisible.
//
//Revision 1.3  2001/07/03 14:03:03  sondberg
//Added function returning dbname in a given language.
//
//Revision 1.2  2001/07/03 13:45:28  sondberg
//Added Adams function for rendering marc records.
//

?>
