<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: dtv2tkl.xsl,v 1.2 2003/09/09 13:56:03 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0">

    <xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>


<xsl:template match="/record">
   <link>
       <xsl:apply-templates select="DC.Date.X-MetadataLastModified"/>
       <xsl:apply-templates select="DC.Title"/>
       <xsl:apply-templates select="DC.Identifier"/>
       <xsl:apply-templates select="DC.Description"/>
       <xsl:apply-templates select="DC.Format"/>
       <xsl:apply-templates select="DC.Language"/>
       <xsl:apply-templates select="DC.Type"/>
       <xsl:apply-templates select="DEF.Library"/>
       <xsl:apply-templates select="DEF.Status"/>
       <xsl:apply-templates select="DEF.HarvestOption"/>
   </link>
</xsl:template>

<xsl:template match="DC.Date.X-MetadataLastModified">
    <xsl:attribute name="created"><xsl:value-of select="."/></xsl:attribute>
</xsl:template>

<xsl:template match="DEF.Library">
    <library><xsl:value-of select="."/></library>
</xsl:template>

<xsl:template match="DEF.Status">
    <def-status><xsl:value-of select="."/></def-status>
</xsl:template>

<xsl:template match="DC.Format">
    <format><xsl:value-of select="."/></format>
</xsl:template>

<xsl:template match="DC.Title">
    <title xml:lang="da"><xsl:value-of select="."/></title>
    <title xml:lang="en"><xsl:value-of select="."/></title>
</xsl:template>

<xsl:template match="DC.Description">
    <description><xsl:call-template name="text"/></description>
</xsl:template>

<xsl:template match="DC.Identifier[@scheme='URL']">
    <identifier><xsl:value-of select="."/></identifier>
</xsl:template>

<xsl:template match="DC.Type[@scheme='DEFType']">
    <type>
      <xsl:choose>
        <xsl:when test=". = 'DEFB'">DEFO</xsl:when>
	<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
      </xsl:choose>
    </type>
</xsl:template>

<xsl:template match="DEF.HarvestOption">
  <harvest>
    <xsl:attribute name="strategy">star</xsl:attribute>
    <xsl:attribute name="steps">3</xsl:attribute>
    <xsl:if test=". = 'Nej'">no</xsl:if>
    <xsl:if test=". = 'Ja'">
      <xsl:text>yes</xsl:text>
    </xsl:if>
  </harvest>
</xsl:template>

<xsl:template match="DC.Language">
  <language>
    <xsl:choose>
      <xsl:when test=". = 'dan'">da</xsl:when>
      <xsl:when test=". = 'eng'">en</xsl:when>
      <xsl:when test=". = 'swe'">sv</xsl:when>
      <xsl:when test=". = 'nno'">no</xsl:when>
      <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
    </xsl:choose>
  </language>
</xsl:template>

<xsl:template match="node()"/>

<xsl:template name="text">
    <xsl:attribute name="xml:lang">
	<xsl:if test="@lang='dan'">da</xsl:if>
	<xsl:if test="@lang='eng'">en</xsl:if>
    </xsl:attribute>
    <xsl:value-of select="."/>
</xsl:template>

</xsl:stylesheet>

