<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: classic2tklite.php,v 1.3 2003/09/09 13:56:03 adam Exp $
*/
?><html><head><title>classic2tklite</title></head>
<body>
<form method="get" action="">
<b>Record conversion -- TK Classic => TKLite</b>
</p>
<table border="1">
<tr>
<td><b>XSLT Stylesheet - bizigate2tkl.xsl  or dtv2tkl.xsl </b></td>
<td><input type="text" name="stylesheet" size="50" value="<?php echo $stylesheet?>"/></td>
</tr>
<tr>
<td><b>Input directory</b></td>
<td><input type="text" name="input" size="50" value="<?php echo $input?>"/></td>
</tr>
<tr>
<td><b>Output directory</b></td>
<td><input type="text" name="output" size="50" value="<?php echo $output?>"/></td>
</tr>
<tr><td colspan="2" align="center"><input type="submit"/></td></tr>
</table>
</form>

<?php

$XMLHEAD = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";

$xsl = xslt_create();

if (!$stylesheet ||!$input || !$output) {
    print "Please enter XSLT stylesheet and input/output directory paths <br>";
    print "Remember that input data must not be moved from the original path,";
    print " otherwise link conversion will fail.<br>";
}
else {
    $input = preg_replace("'/$'", "", $input);
    $output = preg_replace("'/$'", "", $output);

    //print "stylesheet file is : $stylesheet <br>";
    //print "input dir is : $input <br>";
    //print "output dir is : $output <br>";


    convert($stylesheet, $input, $output);
}

function xml_getelement($xml, $element) {
    preg_match_all("/<$element\s*.*?>\s*(.*?)\s*<\/$element>/s", $xml, $res,
   	 PREG_PATTERN_ORDER);
    return $res[1];
}

function convert($stylesheet, $input, $output, $iroot='', $oroot='') {
    if (!$iroot) $iroot = $input;
    if (!$oroot) $oroot = $output;
    global $xsl;
    global $XMLHEAD;
    $d = opendir($input);
    if (!is_dir($output)) {
	mkdir("$output", 0777);
    }
    while (false != ($f = readdir($d))) {
	if (preg_match("/^[0-9]+$/", $f))
	    convert($stylesheet, "$input/$f", "$output/$f", $iroot, $oroot);
	elseif ($f == 'cat.dat') {
	    print "$input/$f --> $output/index.tkl<br>";
	    $cat_dat = join('', file("$input/$f"));

	    list($dan) = xml_getelement($cat_dat, 'm_ti_dan');
	    list($eng) = xml_getelement($cat_dat, 'm_ti_eng');

	    $index = "$XMLHEAD" .
	    	"<subject>\n" .
	        "  <title xml:lang=\"en\">$eng</title>\n" .
	        "  <title xml:lang=\"da\">$dan</title>\n" .
		"</subject>\n";
	    $of = fopen("$output/index.tkl", "w");
	    fputs($of, $index);
	    fclose($of);
	}
	elseif (preg_match("/^ent.([0-9]+).dat$/", $f, $match)) {
	    $fileno = $match[1];
	    print "$input/$f --> $output/link$fileno.tkl<br>";

	    if (is_link("$input/$f")) {
		// Get rel part
		$r = readlink("$input/$f");
		$iroot_name = preg_replace("'^.*/'", "", $iroot);
		$r2 = preg_replace("'^.*/$iroot_name'", "", $r);
		$r2 = preg_replace("'/[^/]*$'", "", $r2);
		$delta = preg_replace("'^$iroot/'", "", $input);
		$delta = preg_replace("'[^\/]+'", "..", $delta);
	        print "SYMLINK $input/$f -> $r --> $delta$r2<br>";
		symlink("$delta$r2" . "/link$fileno.tkl", "$output/link$fileno.tkl");
		continue;
	    }


	    $if = $XMLHEAD . join('', file("$input/$f"));
	    $if = preg_replace("/&/", "&amp;", $if);

	    $args = array('_xml' => $if);
	    xslt_process($xsl, 'arg:/_xml', $stylesheet,
	        "$output/link$fileno.tkl", $args);

	    //print "stylesheet file is : $stylesheet <br>";
	    //print "output file is : $output/link$fileno.tkl <br>";
	    //print "args are : $args <br>";
	}
    }
    closedir($d);
}

?>
</body>
</html>
