<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: checkurl.php,v 1.7 2003/11/17 13:08:12 adam Exp $
*/

function check_url($url,$flags)
{
        $redirect = "";
	$retries = $flags["retries"];
	$permanent_url = "";
	$debug = $flags["debug"];
	if (strlen($retries) < 1) {
		$retries = 4;
	}
	for ($i = 0; $i < $retries; $i++) {
		if ($debug) {
			echo "\npass $i : $url <br>\n";
		}
		$res = check_url_one($url,$flags);
		if($res["error"]) {
			return $res;
		}
		if ($res["HTTP-code"] == 200) {
			break;
		} else if ($res["HTTP-code"] == 301 ||
		           $res["HTTP-code"] == 302) {
        		$redirect = $res["HTTP-code"];
			$url = $res["HTTP-response"]["Location"];
			if (strncmp($url, "http:", 5) != 0)  {
				if (strncmp($url, "/", 1) != 0) {
					$url = '/' . $url;
				}
				$url = "http://" . $res["host"] . $url;
			}
			if ($res["HTTP-code"] == 301) {
				$permanent_url = $url;
			}
			if ($debug) {
				print_r($res);
			}
		} else {
			$res["error"] = "HTTP";
			break;
		}
	}
	if ($i == $retries) {
		$res["error"] = "Too many redirects";
	}
	$res["HTTP-code-redirect"] = $redirect;
	$res["permanent-url"] = $permanent_url;
	return $res;
}

function check_url_one($url,$flags)
{
	$debug = $flags["debug"];
	$res = array();
	$urlinfo = parse_url($url);

	if (!is_array($urlinfo)) {
		$res["error"] = "Bad URL";
		return $res;
	}
	if (!strlen($urlinfo["path"])) {
		$urlinfo["path"] = "/";
	}
	reset($urlinfo);
	while (list($name,$value) = each($urlinfo)) {
		$res[$name] = $value;
		if ($debug) {
			echo "$name $value<br>\n";
		}

	}
	$socket = @socket_create(AF_INET, SOCK_STREAM, 0);

	if ($socket < 0) {
		$res["error"] = "socket_create failed: " .
		    socket_strerror(socket_last_error());
		return $res;
	}
	socket_set_nonblock($socket);
	if (!$urlinfo["port"]) {
		$urlinfo["port"] = 80;
 	}
	$result = @socket_connect($socket, $urlinfo["host"], $urlinfo["port"]);
	if (PHP_VERSION == "4.1.2") {
		$read = socket_fd_alloc();
		$write = socket_fd_alloc();
		socket_fd_set($read,$socket);
		socket_fd_set($write,$socket);
	} else {
		$read = array();
		$write = array();
		array_push($read,$socket);
		array_push($write,$socket);
	}
	if ($debug) {
		echo "socket_select . timeout=" . $flags["timeout"] . "\n";
	}
	$result = socket_select($read,$write,$except=NULL, $flags["timeout"]);

	if ($result <= 0) {
		$res["error"] = "connect timeout";
		return $res;
	}
	$headers["Accept"] = "*/*";
	$headers["Accept-Language"] = "da, en-us, en";
	$headers["Accept-Charset"] = "ISO-8859-1, utf-8";
	$headers["User-Agent"] = "URLcheck/0.1";
	$headers["Host"] = $urlinfo["host"];
	if (is_array($flags["headers"])) {
		while (list($name,$value) = each($flags["headers"])) {
			$headers[$name] = $value;
		}
	}
	$http_req = "GET " . $urlinfo["path"];
	if (strlen($urlinfo["query"])) {
		$http_req .= '?' . $urlinfo["query"];
	}
	$http_req .= " HTTP/1.0\r\n";
	while (list($name,$value) = each($headers)) {
		$http_req .= $name . ": " . $value . "\r\n";
	}
	$http_req .= "\r\n";
	if ($debug) {
		echo "HTTP_request:\n";
		echo $http_req;
	}
	while (strlen($http_req) > 0) {
		if (PHP_VERSION == "4.1.2") {
			$write = socket_fd_alloc();
			socket_fd_set($write,$socket);
		} else {
			$write = array();
			array_push($write,$socket);
		}
		$result = socket_select($read=NULL,$write,
			$except=NULL, $flags["timeout"]);
		if ($result <= 0) {
			$res["error"] = "timeout while sending headers";
			return $res;
		}
		$inbytes = @socket_write ($socket,$http_req, strlen($http_req));
		if ($inbytes < 1 ) {
			$res["error"] = "error while sending headers";
			return $res;
		}
		$http_req = substr($http_req, $inbytes);
	}
	if ($debug) {
		echo "Sent response.. waiting for reply\n";
	}
	$out = "";
	while (strlen($out) < 2048) {
		if (PHP_VERSION == "4.1.2") {
			$read = socket_fd_alloc();
			socket_fd_set($read,$socket);
		} else {
			$read = array();
			array_push($read,$socket);
		}
		$result = socket_select($read,$write=NULL,$except=NULL,
				$flags["timeout"]);
		if ($result < 0) {
			$res["error"] = "socket_select failed";
			return $res;
		}
		if ($result  == 0) {
			$res["error"] = "timeout while receiving headers";
			return $res;
		}
		$outbytes = @socket_read($socket,2048);
		if (strlen($outbytes) == 0) break;
		$out .= $outbytes;
	}
	$outarray = explode("\n", $out);
	$response = $outarray[0];
	$items = explode(" ", $response);
	if (strncmp($items[0], "HTTP/", 5)) {
		$res["error"] = "bad response from server";
		return $res;
	}
	$res["HTTP-code"] = $items[1];
	$res["HTTP-message"] = $items[2];
	$res["HTTP-response"] = array();
	for ($i = 1; $i < sizeof($outarray); $i++)
	{
		if (strlen($outarray[$i]) < 2) {
			break;
		}
		$items = explode(": ", $outarray[$i]);
		$name = trim($items[0]);
		$value = trim($items[1]);
		$res["HTTP-response"][$name] = $value;
		if ($debug) {
			echo $name . " = " . $value . "\n";
		}
	}
	socket_close($socket);
	return $res;
}

function test_proc() {
	$flags["debug"] = 1;
	$flags["timeout"] = 5;
	// // custom header $flags["headers"]["Connection"] = "close";
	$res = check_url("http://indexdata.dk/yaz.html", $flags);
	//$res = check_url("http://www.amazon.com/", $flags);
	//$res = check_url("http://www.abcnews.com", $flags);
	//$res = check_url("http://dickmeiss.net:9121", $flags);
	//$res = check_url("http://z3950.loc.gov:7090/", $flags);
	//$res = check_url("http://indexdata.dk/projectman", $flags);
	//$res = check_url("http://www.vitusbering.dk/bibliotek/biblio.asp?pid=12", $flags);
	if($res["error"]) {
		echo "Error: " . $res["error"] . "<br>\n";
		if ($res["error"] == "HTTP") {
		     echo $res["HTTP-code"] . "\n";
		}
	} else {
		echo "Permanent URL: " . $res["permanent-url"] . "<br>\n"; 
		echo "OK<br>\n";
	}
}
//test_proc();
?>
