<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: bizigate2tkl.xsl,v 1.5 2003/09/09 13:56:03 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0">

    <xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>

<!--
BiziGate Konvertering af data:
1.
Title   OK  -> title
Identifier OK -> identifier
Description lang=eng OK -> description xml:lang="en"
Description lang=dan OK -> description xml:lang="da"
Language scheme=" ISO/DIS 639-2 OK  -> language
Publisher OK -> publisher
Creator ??? OK DEF.RecordCreatorUID -> creator
Alternative title ??? DC.Title.Alternative ->title-alternative
Subject  scheme="CBS thesaurus" lang="eng" OK -> subject-cbs xml:lang="en"
Subject  scheme="CBSthesaurus" lang="dan" OK -> subject-cbs xml:lang="da"
Subject scheme="DEFsubject" OK -> subject-def
Type scheme="DEFType" OK  -> type
ISSN ??? DC.Identifier scheme="ISSN" -> issn
ISBN ??? DC.Identifier scheme="ISBN" -> isbn
Date ???  DC.Date.X-MetadataCreated -> link created=""
Date ???  DC.Date.X-MetadataLastModified -> link modified=""

2.
Subject scheme="erhvervsklass" OK -> subject-erhverv

3.
RecordcreatorEmail OK DEF.RecordCreatorEmail -> creator-email
Record creation date ???  DC.Date.X-MetadataCreated -> link created=""
Record created by user ??? DEF.RecordCreatorUID -> creator

4.
Record identifier (PID) OK PID -> pid

-->


<xsl:template match="/record">
   <link>
       <xsl:apply-templates select="DC.Date.X-MetadataCreated"/>
       <xsl:apply-templates select="DC.Date.X-MetadataLastModified"/>

       <xsl:apply-templates select="DC.Title"/>
       <xsl:apply-templates select="DC.Title.Alternative"/>
       <xsl:apply-templates select="DC.Identifier"/>
       <xsl:apply-templates select="DC.Description"/>
       <xsl:apply-templates select="DC.Creator"/>
       <xsl:apply-templates select="DC.Format"/>
       <xsl:apply-templates select="DC.Language"/>
       <xsl:apply-templates select="DC.Type"/>
       <xsl:apply-templates select="DC.Publisher"/>
       <xsl:apply-templates select="DC.Subject"/>

       <xsl:apply-templates select="DEF.Library"/>
       <xsl:apply-templates select="DEF.Status"/>
       <xsl:apply-templates select="DEF.HarvestOption"/>
       <xsl:apply-templates select="DEF.RecordCreatorEmail"/>
       <xsl:apply-templates select="DEF.RecordCreatorUID"/>
       <xsl:apply-templates select="DEF.RecordCreator.Comments"/>
       <xsl:apply-templates select="DEF.RecordModifierUID"/>

       <xsl:apply-templates select="PID"/>
   </link>
</xsl:template>

<xsl:template match="DC.Date.X-MetadataCreated">
    <xsl:attribute name="created"><xsl:value-of select="."/></xsl:attribute>
</xsl:template>

<xsl:template match="DC.Date.X-MetadataLastModified">
    <xsl:attribute name="modified"><xsl:value-of select="."/></xsl:attribute>
</xsl:template>

<xsl:template match="DEF.Library">
    <library><xsl:value-of select="."/></library>
</xsl:template>

<xsl:template match="DEF.Status">
    <status><xsl:value-of select="."/></status>
</xsl:template>

<xsl:template match="PID">
    <pid><xsl:value-of select="."/></pid>
</xsl:template>

<xsl:template match="DEF.RecordCreatorEmail">
    <creator-email><xsl:value-of select="."/></creator-email>
</xsl:template>

<xsl:template match="DEF.RecordCreator.Comments">
    <creator-comments><xsl:value-of select="."/></creator-comments>
</xsl:template>

<xsl:template match="DEF.RecordCreatorUID">
    <creator-uid><xsl:value-of select="."/></creator-uid>
</xsl:template>

<xsl:template match="DEF.RecordModifierUID">
    <modifier-uid><xsl:value-of select="."/></modifier-uid>
</xsl:template>

<xsl:template match="DC.Format">
    <format><xsl:value-of select="."/></format>
</xsl:template>

<xsl:template match="DC.Publisher">
    <publisher><xsl:value-of select="."/></publisher>
</xsl:template>

<xsl:template match="DC.Creator">
    <creator><xsl:value-of select="."/></creator>
</xsl:template>

<xsl:template match="DC.Title">
    <title><xsl:value-of select="."/></title>
<!--    <title xml:lang="da"><xsl:value-of select="."/></title>
    <title xml:lang="en"><xsl:value-of select="."/></title>
-->
</xsl:template>

<xsl:template match="DC.Title.Alternative">
    <title-alternative><xsl:value-of select="."/></title-alternative>
</xsl:template>

<xsl:template match="DC.Description">
    <description><xsl:call-template name="text"/></description>
</xsl:template>

<!--
<xsl:template match="DC.Subject">
    <subject><xsl:call-template name="text"/></subject>
</xsl:template>
-->

<xsl:template match="DC.Subject[@scheme='CBS thesaurus']">
    <subject-cbs><xsl:call-template name="text"/></subject-cbs>
</xsl:template>

<xsl:template match="DC.Subject[@scheme='CBSthesaurus']">
    <subject-cbs><xsl:call-template name="text"/></subject-cbs>
</xsl:template>

<xsl:template match="DC.Subject[@scheme='DEFsubject']">
    <subject-def><xsl:call-template name="text"/></subject-def>
</xsl:template>

<xsl:template match="DC.Subject[@scheme='Erhvervklass']">
    <subject-erhverv><xsl:call-template name="text"/></subject-erhverv>
</xsl:template>

<xsl:template match="DC.Identifier[@scheme='URL']">
    <identifier><xsl:value-of select="."/></identifier>
</xsl:template>

<xsl:template match="DC.Identifier[@scheme='ISSN']">
    <issn>
	<xsl:value-of select="."/>
    </issn>
</xsl:template>

<xsl:template match="DC.Identifier[@scheme='ISBN']">
    <isbn>
	<xsl:value-of select="."/>
    </isbn>
</xsl:template>

<xsl:template match="DC.Type[@scheme='DEFType']">
    <type>
      <xsl:choose>
        <xsl:when test=". = 'DEFB'">DEFO</xsl:when>
	<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
      </xsl:choose>
    </type>
</xsl:template>

<xsl:template match="DEF.HarvestOption">
  <harvest>
    <xsl:attribute name="strategy">star</xsl:attribute>
    <xsl:attribute name="steps">3</xsl:attribute>
    <xsl:if test=". = 'Nej'">no</xsl:if>
    <xsl:if test=". = 'Ja'">
      <xsl:text>yes</xsl:text>
    </xsl:if>
  </harvest>
</xsl:template>

<xsl:template match="DC.Language">
  <language>
    <xsl:choose>
      <xsl:when test=". = 'dan'">da</xsl:when>
      <xsl:when test=". = 'eng'">en</xsl:when>
      <xsl:when test=". = 'swe'">sv</xsl:when>
      <xsl:when test=". = 'nno'">no</xsl:when>
      <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
    </xsl:choose>
  </language>
</xsl:template>

<xsl:template match="node()"/>

<xsl:template name="text">
    <!--
    <xsl:if test="@scheme">
        <xsl:attribute name="scheme">
            <xsl:value-of select="@scheme"/>
        </xsl:attribute>
    </xsl:if>
    -->
    <xsl:if test="@lang">
        <xsl:attribute name="xml:lang">
            <xsl:choose>
                <xsl:when test="@lang = 'dan'">da</xsl:when>
                <xsl:when test="@lang = 'eng'">en</xsl:when>
                <xsl:when test="@lang = 'swe'">sv</xsl:when>
                <xsl:when test="@lang = 'nno'">no</xsl:when>
                <xsl:otherwise><xsl:value-of select="@lang"/></xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:if>
    <xsl:value-of select="."/>
</xsl:template>

</xsl:stylesheet>

