<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: standards.php,v 1.120 2006/05/18 09:15:43 sondberg Exp $
*/

require 'xmlstream.phpi';

if (!function_exists('domxml_open_file')) {
	function domxml_open_file($filename) {
		return xmldocfile($filename);
	}
}

if (!function_exists('domxml_open_mem')) {
    function domxml_open_mem($raw) {
	return xmldoc($raw);
    }
}


function check_suffix ($filename) {
    if (!preg_match("/\.tkl$/", $filename)) {
	$filename .= ".tkl";
    }

    return $filename;
}


function get_content($node)
{
    $data = "";
    if (is_array($text_nodes = $node->child_nodes())) {
        foreach ($text_nodes as $text_node) {
            $data .= $text_node->content;
        }
    }
    return $data;
}


function tkl_path () {
    global $root, $tkl_cwd;

    $trimmed_root = preg_replace("/^\/+/", "", $root);
    $trimmed_root = preg_replace("/\/+$/", "", $trimmed_root);
    $trimmed_cwd = preg_replace("/^\/+/", "", $tkl_cwd);
    $trimmed_cwd = preg_replace("/\/+$/", "", $trimmed_cwd);

    $cwd_path = preg_split("/\/+/", $trimmed_cwd);

    if (strlen($trimmed_root)) {
	$root_path = preg_split("/\/+/", $trimmed_root);
	foreach ($root_path as $root_step) {
	    $cwd_step = array_shift($cwd_path);
	    if ($cwd_step != $root_step) {
		echo "<b>Warning:</b> tkl_path: tkl_cwd=('$tkl_cwd') outside root=('$root')<br/>";
	    }
	}
    }

    return "/" . join("/", $cwd_path);
}


function open_tkl_file ($file) {
    if (is_array($content = @file($file))) {
	$raw_xml = join("", $content);
	//$raw_xml = preg_replace("/&#(\d+);/", "&amp;#\\1;", $raw_xml);
	if(preg_match('/(<?xml version[^>]*encoding=)("iso-8859-1")/i', $raw_xml)){
	   $raw_xml = preg_replace('/(<?xml version[^>]*encoding=)("iso-8859-1")/i', '$1"UTF-8"', $raw_xml);
	   $raw_xml = utf8_encode($raw_xml);
	}
        return $raw_xml;
    } else {
	die("<b>Fatal:</b> Unable to open file '$file'");
    }
}

function fix_entities ($xml) {
    return preg_replace("/&amp;#(\d+);/", "&#\\1;", $xml);
}


function remove_special_chars ($str) {
    return preg_replace("/[^A-ZA-z0-9\/]/", "_", $str);
}




function get_elements_by_tagname($node,$name)
{
    $r = array();
    if (is_array($child_nodes = $node->child_nodes())) {
        foreach($child_nodes  as $child_node) {
	    if ($child_node->node_type() == XML_ELEMENT_NODE && $child_node->tagname == $name) {
	        array_push($r,$child_node);
	    }
	}
    }
    return $r;
}

foreach (array_merge($_GET, $_POST) as $key => $value) {  // To cope with "register_globals=off" in PHP-4.2.x
    $$key = $value;
}


function dublet_check ($value, $xpath) {
    global $doc_root;
    $socket = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/db/socket";

    if (file_exists($socket)) {
	$yaz = yaz_connect("unix:$socket");
	if (yaz_errno($yaz)) {
	    echo "Could not connect to search engine at $socket: ", yaz_error($yaz), "<br>";
	    die;
	}
	yaz_search($yaz, 'rpn', "@attr 1=$xpath $value");
	yaz_wait();
	if (yaz_errno($yaz)) {
	    echo "Could not search for duplicates: ", yaz_error($yaz), "<br>";
	    die;
	}
	if (yaz_hits($yaz)) {
	    return 2;
	} else {
	    return 1;
	}
    } else {
	return 0;
    }
}



function trim_filename ($file) {
    return preg_replace("/\/+/", "/", $file);
}


function makeparms($array, $override = array()) {
    $res='';

    foreach ($array as $varname) {
	$var = &$GLOBALS[$varname];
	if (!empty($var)) {
	    if (!$override[$varname]) {
		if (is_array($GLOBALS[$varname])) {
		    foreach ($var as $key => $member) {
			if ($res)
			    $res .= '&';
			    $res .= "{$varname}[$key]=" . urlencode($member);
		    }
		} else {
		    if ($res)
			$res .= '&';
		    $res .= "$varname=" . urlencode($GLOBALS[$varname]);
		}
	    }
	}
    }
    foreach ($override as $varname => $value) {
	if ($res)
	    $res .= '&';
	$res .= "$varname=" . urlencode($value);
    }
    return $res;
}


function set_value (&$f, $path, $val) {
    $content = $f[array_shift($path)];
    foreach ($path as $entry) {
	$content = $content[$entry];
    }
    $content['value'] = $val;
}


function set_node ($path, $node) {
    global $f;
    $leaf = array_pop($path);
    $content = &$f[array_shift($path)];
    foreach ($path as $entry) {
	$content = &$content[$entry];
    }
    $content[$leaf] = $node;
}

// Extracts content of root element attributes of $file
// If $which is specified, this particular attribute's value is returned,
// otherwise, a hash representation of all the attributes is returned.
function get_file_info ($file, $which="") {
    if (!$dom = domxml_open_file($file)) {
	die("get_file_info: Unable to open/parse file '$file'");
    }

    $node = $dom->document_element();
    if (strlen($which)) {
	if (strlen($value = $node->get_attribute($which))) {
	    return $value;
	} else {
	    return "N/A";
	}
    } else {
	$attr = array();
	$attr_list = $node->attributes();
	foreach ($attr_list as $a) {
	    $attr[$a->name()] = $a->value();
	}
	return $attr;
    }
}


// Finds the closest occurance of dirhide.tkl and updates
// a list of dir-names to neglect in find_files.
function make_dir_hide () {
    $hide = array();
    if ($hidelist = default_file("dirhide.tkl")) {
	if (!($dom = domxml_open_file($hidelist))) {
	    die("<b>Fatal:</b> Unable to open/parse file '$hidelist'");
	}
	$root = $dom->document_element();
	if ($root->tagname == "dirhide") {
	    if (is_array($nodes = $root->child_nodes())) {
		foreach ($nodes as $node) {
		    if ($node->node_type() == XML_ELEMENT_NODE) {
			$hide[get_content($node)] = 1;
		    }
		}
	    }
	}
    }
    return $hide;
}

function my_symlink ($target, $link) {
    global $doc_root;
    $root = preg_replace("/\/+$/", "", $_SERVER['DOCUMENT_ROOT'] . "/$doc_root");
    $root_path = preg_split("/\/+/", $root);
    $target_path = preg_split("/\/+/", $target);
    $link_path = preg_split("/\/+/", $link);

    foreach ($root_path as $entry) {
	$target_entry = array_shift($target_path);
	$link_entry = array_shift($link_path);
	if ($entry != $target_entry || $entry != $link_entry) {
	    exception("Path mismatch in entry TARGET='$target_entry', LINK='$link_entry', ROOT='$entry'");
	    die;
	}
    }
    array_pop($link_path);
    foreach ($link_path as $dummy) {
	$rel_target .= "../";
    }
    $rel_target .= join("/", $target_path);
    //echo "<B>REL_TARGET='$rel_target', LINK='$link'</b>";
    return symlink($rel_target, $link);
}




function update_links ($orig_file, $abs_file, $all_links = 0) {
    global $doc_root;

    if (!is_array($all_links)) {
	get_links($_SERVER['DOCUMENT_ROOT'] . "/$doc_root", $all_links = array());
    }
    if (is_array($links = $all_links[$orig_file])) {
	foreach ($links as $link) {
	    system("rm -f $link");
	    if (!my_symlink($abs_file, $link)) {
		exception("Could not change link <em>$link</em> to point to <em>$abs_file</em>");
		die;
	    }
	}
    }
}


function unhtmlentities ($string)
{
	$trans_tbl = get_html_translation_table (HTML_ENTITIES);
	$trans_tbl = array_flip ($trans_tbl);
	$trans_tbl[chr(38)] = '&amp;';
	return strtr ($string, $trans_tbl);
}

function get_metadata($url) {
    $fileid = fopen($url, "r");
    $html = fread($fileid, 2048);
    fclose($fileid);
    preg_match_all("/<title>\s*(.*?)</is", $html, $title, PREG_PATTERN_ORDER);
    $meta_tags = get_meta_tags($url);
    $XMLstring .= "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    $XMLstring .= "<link>\n";
    $XMLstring .= "  <title xml:lang=\"da\">".unhtmlentities($title[1][0])."</title>\n";
    foreach ($meta_tags as $name => $content) {
        preg_match_all("/(dc_)?(.+)/is", $name, $nameArray, PREG_PATTERN_ORDER);
        if ($nameArray[2][0] != "identifier") {
            $XMLstring .= "  <".$nameArray[2][0]." xml:lang=\"da\">".unhtmlentities($content)."</".$nameArray[2][0].">\n";
        }
    }
    $XMLstring .= "  <identifier xml:lang=\"da\">$url</identifier>";
    $XMLstring .= "</link>\n";
    return $XMLstring;
}

function get_hidden($xml_file) {
    if (preg_match("/<[^?!][^>]*hidden=.1./", join('', file($xml_file))))
	return 1;
    else
	return 0;
}


// Used by the get_title function below!
class get_title_class extends XMLstream {
    var $title;
    
    function title_handler ($tag, $attr) {
	if (!strlen($lang = $attr['xml:lang'])) {
	    $lang = "unspecified";
	}
	
	$this->title[$lang] = $this->cdata;
    }

    function get_result () {
	$options = $this->options;
	if (is_array($this->title) && count($this->title) >= 1) {
	    if (is_array($options['preferred_lang'])) {       // We ask for a specific language...
		foreach ($options['preferred_lang'] as $cand) {
		    if (isset($this->title[$cand])) {	// See if we have this version of title
			return $this->title[$cand];
		    }
		}
	    }
	    
	    // Otherwise, look for an unspecified version of title...
	    if (isset($this->title['unspecified'])) {
		return $this->title['unspecified'];
	    }
	    
	    // An finally, look for any instance of the title...
	    list($available_lang, $title) = each($this->title);
	    return $title;
	}

	return "";
    }
}


function get_title_or_dirname ($xml_file) {
    if ( file_exists( $xml_file ) ) {
        return get_title( $xml_file );
    } else {
        $dir = dirname( $xml_file );
	
	if ( preg_match( '/([^\/]*)$/', $dir, $match ) ) {
	    return $match[1];
	} else {
	    exception( __FILE__ . ': get_title_or_filename: Weird path: '
	              . $dir );
	}
    }
}


function get_title ($xml_file) {
    global $admin_lang;
    
    $parser = new get_title_class(array('xmlfile' => $xml_file));
    $callbacks = array('/*/title' => 'title_handler');
    $parser->set_option('callbacks', $callbacks);
    $parser->set_option('preferred_lang', array($admin_lang));
    $parser->parse();
    $res = $parser->get_result();
    $parser->close;
    
    return $res;
}

function get_creator ($xml_file) {
    if ($dom = @domxml_open_file($xml_file)) {
	$root = $dom->document_element();
	return $root->get_attribute("creator");
    } else {
	echo "Could not parse <b>$xml_file</b>";
    }
}


// Browses through a struct by ref, and adds references to dom nodes
function qual_struct (&$p) {
    global $xml_header, $xml_file;

    if (strlen($xml_file)) {
	return;
    }
    $xmlbuf = "$xml_header\n" . create_xml($p);
    if (!($d = domxml_open_mem($xmlbuf))) {
	echo "qual_struct: Can't open/parse raw xml<br><pre>", htmlentities($xmlbuf), "</pre>\n";
	die;
    }
    qual_struct_process ($p, $d->document_element());
}


function qual_struct_process (&$p, $node, $offset=0) {
    $tag = $node->tagname;
    if ($prefix = $node->prefix()) {
	$tag = "$prefix:$tag";
    }

    $p[$tag][$offset]['parent'] = $node;
    if (is_array($kids = $node->child_nodes())) {
	$sub_off = array();
	foreach ($kids as $kid) {
	    if (strlen($subtag = $kid->tagname)) {
		if (!strlen($sub_off[$subtag])) {
		    $sub_off[$subtag] = 0;
		}
		qual_struct_process($p[$tag][$offset]['subtree'], $kid, $sub_off[$subtag] ++);
	    }
	}
    }
}


// Looks for the existence of $file in cwd and up, returns the first occurrence of the file.
function default_file ($file) {
    global $tkl_cwd, $cwd, $debug;
    $apache = $_SERVER['DOCUMENT_ROOT'];
    $current = $cwd;

    if (!strlen($current)) {
	$current = $tkl_cwd;
    }

    while (!file_exists("$apache/$current/$file")) {
	if (file_exists("$apache/$current/tkl.config")) {
	    return 0;
	}
	if (!($current = preg_replace("/\/[^\/]*$/", "", $current))) {
	    return 0;
	}
	if ($debug) {
	    echo "Looking for '$file' in '$apache/$current/$file'<br>";
	}
    }
    if ($debug) {
	echo "Identified $file in '$apache/$current/$file'<br>";
    }
    return "$apache/$current/$file";
}


function get_auto_index () {
    global $dir_config;
    $dir_conf = default_file($dir_config);

    if ($config = file($dir_conf)) {
	foreach ($config as $line) {
	    if (preg_match("/<autoIndex>(.*?)<\/autoIndex>/", $line, $match)) {
		$schema = $match[1];
		if (strlen($schema)) {
		    return $schema;
		}
	    }
	}
    }
    return 0;
}


function make_abs ($file) {
    $target = readlink($file);
    $rel_target_path = preg_split("/\/+/", dirname($target));
    $rel_src_path = preg_split("/\/+/", dirname($file));

    foreach ($rel_target_path as $entry) {
	if (!strlen($entry)) {
	    continue;
	}
	if ($entry == "..") {
	    $pop = array_pop($rel_src_path);
	} else {
	    $rel_src_path[] = $entry;
	}
    }
    $contracted = join("/", $rel_src_path) . "/" . basename($target);
    return normalize_path($contracted);
}


function get_links ($dir, &$links) {
    if ($dh = @opendir($dir)) {
	while ($entry = readdir($dh)) {
	    if (neglect_file($entry)) {
		continue;
	    }
	    $file = "$dir/$entry";
	    if (is_dir($file)) {
		get_links($file, $links);
	    } else {
		if (is_link($file)) {
		    $links[make_abs($file)][] = normalize_path($file);
		}
	    }
	}
	closedir($dh);
    } else {
	exception("Could not open directory '$dir'");
	die;
    }
}


function file_filter ($dir, $filter, &$files, $parms = array(), $recursive = 1) {
    global $suffix_regexp;

    if ($filter && !function_exists($filter)) {
	exception("Filter '$filter' does not exist");
    }
    if ($dh = @opendir($dir)) {
	while ($entry = readdir($dh)) {
	    $file = "$dir/$entry";
	    if (neglect_file($entry)) {
		continue;
	    }
	    if (is_dir($file)) {
		if ($recursive) {
		    file_filter($file, $filter, $files, $parms, $recursive);
		} else {
		    continue;
		}
	    } elseif (!preg_match("/$suffix_regexp$/", $entry)) {
		continue;
	    } elseif (is_link($file)) {
		continue;
	    } else {
		if ($filter) {
		    if ($filter($file, $parms)) {
			$files['passed'][] = $file;
		    } else {
			$files['excluded'][] = $file;
		    }
		} else {
		    $files['passed'][] = $file;
		}
	    }
	}
	closedir($dh);
    } else {
	exception("Could not open directory '$dir'");
    }
}


function is_created_by ($file, $parms) {
    if (strlen($creator = get_creator($file))) {
	if ($creator == $parms['login']) {
	    return 1;
	} else {
	    return 0;
	}
    } else {
	return 0;
    }
}


function get_user_files ($dir, $user) {
    $files = array("passed"=>array(), "excluded"=>array());
    file_filter($dir, "is_created_by", $files, array("login"=>$user));
    return $files;
}


function get_files ($dir, $recursive = 0) {
    $files = array("passed"=>array(), "excluded"=>array());
    file_filter($dir, "is_tkl", $files, array(), $recursive);
    return $files;
}


function is_tkl ($file) {
    return preg_match("/\.tkl$/", $file);
}


function is_empty ($probe_dir) {
    if ($dir = @opendir($probe_dir)) {
	$empty = 1;
	while ($entry = readdir($dir)) {
	    if ($entry == ".." or $entry == ".") {
		continue;
	    }
	    $empty = 0;
	    break;
	}
	closedir($dir);
	return $empty;
    } else {
	exception("Directory '$probe_dir' could not be read");
    }
}

function tkl_string_to_xml($str)
{
    $patterns[0] = "/&/";
    $patterns[1] = "/'/";
    $patterns[2] = "/>/";
    $patterns[3] = "/</";
    $patterns[4] = "/\"/";
 
    $replacements[0] = "&amp;";
    $replacements[1] = "&apos;";
    $replacements[2] = "&gt;";
    $replacements[3] = "&lt;";
    $replacements[4] = "&quot;";
 
    return preg_replace($patterns, $replacements, $str);
}

function escape_amp ($str) {
    if (!preg_match("/&/", $str)) {
	return $str;
    }

    $fields = preg_split("/&/", $str);
    $ret = array_shift($fields);
    foreach ($fields as $f) {
	if (preg_match("/^#[a-zA-Z0-9]{1,7};/", $f)) {	// Identify entity
	    $ret .= "&$f";
	} elseif (preg_match("/^amp;/i", $f)) {
	    $ret .= "&$f";
	} elseif (preg_match("/^lt;/i", $f)) {
	    $ret .= "&$f";
	} elseif (preg_match("/^gt;/i", $f)) {
	    $ret .= "&$f";
	} elseif (preg_match("/^quot;/i", $f)) {
	    $ret .= "&$f";
	} else {
	    $ret .= "&amp;$f";				// Otherwise escape ampersand...
	}
    }
    return $ret;
}


// Creates well-formed xml-code based on the data structure passed from the form
function create_xml (&$p, $level=0) {
    global $indent;

    $ret = "";
    foreach ($p as $tag => $content) {
    	foreach ($content as $value) {
    	    if (!is_array($value['attr']) && !is_array($value['subtree']) && !strlen($value['value'])) {
    		    continue;
    	    }
    	    $ret .= str_repeat($indent, $level) . "<$tag";
    	    if (is_array($attributes = $value['attr'])) {		// Process attributes if any...
    		    $ret .= make_attr($attributes);
    	    }
    	    $ret .= ">";
    	    if (strlen($value['value'])) {					// Process CDATA
    		    $ret .= escape_amp(stripslashes($value['value']));
    	    } elseif (is_array($subtree = $value['subtree'])) {		// Process subtree if any...
    		    $ret .= "\n" . create_xml($subtree, $level + 1) . str_repeat($indent, $level);
    	    }
    	    $ret .= "</$tag>\n";
    	}
    }
    return $ret;
}


function get_symb_links ($file) {
}


function set_symb_link ($file, $link) {
}


function create_struct (&$p, $node) {
    // Creates a data structure by reference based upon the content of a dom xml tree

    $tag = $node->tagname;
    if ($prefix = $node->prefix()) {
	    $tag = "$prefix:$tag";
    }
    if (is_array($p[$tag])) {
	    $offset = count($p[$tag]);
    } else {
    	$p[$tag] = array();
    	$offset = 0;
    }
    $p[$tag][$offset]['parent'] = $node;
    if ($attributes = $node->attributes()) {
    	foreach ($attributes as $attr) {
    	    $key = $attr->name();
    	    if ($prefix = $attr->prefix()) {
    		    $key = "$prefix:$key";
    	    }
    	    $p[$tag][$offset]['attr'][$key]['value'] = $attr->value();
    	}
    }
    if (is_array($kids = $node->child_nodes())) {
    	$cdata = "";
    	foreach ($kids as $kid) {
    	    $content = $kid->content;
    	    if (strlen($content)) {
		$cdata .= tkl_string_to_xml($content);
	    } else {
		create_struct($p[$tag][$offset]['subtree'], $kid);
    	    }
    	}
    	$p[$tag][$offset]['value'] = trim($cdata);
    }
}

function get_user_info ($user, $cwd="" ) {
    global $doc_root, $user_list;
    $apache = $_SERVER['DOCUMENT_ROOT'];
    if ($apache == "") {
	$apache = $cwd;
	$doc_root = "";
    }
    $user_file = "$apache/$doc_root/$user_list";

    if (!file_exists($user_file)) {
    	exception("Could not open user information '$user_file'");
    	die;
    }
    $mode = fileperms($user_file);
    if ($mode & 00022) {		// World/group readable?
        system("chmod 600 $user_file");
	clearstatcache();
        $mode = fileperms($user_file);
    }

    if ($mode & 00022) {		// World/group readable?
    	exception("Bad permissions for '$user_file'<br>Use chmod 600 $user_file");
    	die;
    }
    // Possibly, we want to check for the owner of the user file....
    if (!($dom = domxml_open_file($user_file))) {
    	exception("Could not open user file '$user_file' or XML parsing failed");
    	die;
    }
    $root = $dom->document_element();
    if ($root->tagname != "users") {
    	exception("Unknown format in user information file (expecting users as root element)");
    	die;
    }
    if (is_array($user_nodes = $root->child_nodes())) {
    	foreach ($user_nodes as $user_node) {
    	    $user_info = array();
	    $pass_type = "clear";
    	    if (is_array($user_info_node = $user_node->child_nodes())) {
        		foreach ($user_info_node as $node) {
			    if ($node->tagname) {
				    if ($user_info[$node->tagname]) {
					if (!is_array($user_info[$node->tagname])) {
					    $tmp = $user_info[$node->tagname];
					    unset($user_info[$node->tagname]);
					    $user_info[$node->tagname][0] = $tmp;
					}
					$user_info[$node->tagname][] = get_content($node);
				    } else {
					$user_info[$node->tagname] = get_content($node);
				    }
				    if ($node->tagname == 'password') {
					if (strlen($pwd_type = $node->get_attribute('type'))) {
					    $pass_type = $pwd_type;
					}
				    }
			     }
        		}
    	    }
    	    if ($user_info['login'] == $user) {
		$user_info['pass_type'] = $pass_type;
		return $user_info;
    	    }
    	}
    }
    return 0;
}

function tainted_path ($path) {
    if (preg_match("/\./", $path)) {
	return "Stien m ikke indholde .";
    }
}

function find_portal_root () {
    global $tkl_cwd, $cwd, $abs_cwd, $doc_root;

    if (isset($tkl_cwd) && !isset($cwd)) {
	$cwd = $tkl_cwd;
    }

    if (isset($cwd)) {
    	if (!($doc_root = check_path($cwd))) {
    	    exception("Outside document area. cwd='$cwd'");
    	    die;
    	}
    	$abs_cwd = preg_replace("/\/+/", "/", $_SERVER['DOCUMENT_ROOT'] . "/$cwd");
    } else {
    	exception("cwd was not given");
    	die;
    }
}


function neglect_file ($entry) {
    global $xsd_path;
    if ($entry == "." or $entry == ".." or $entry == "CVS" or $entry == "gfx" or $entry == "grafik" or $entry == "db" or $entry == $xsd_path) {
	    return 1;
    } else {
	    return 0;
    }
}


function check_chrs ($str) {
    return preg_replace("/\s/", "\ ", $str);
}


function is_granted ($object, $op) {
    global $doc_root, $debug, $cwd, $this_user, $privileges;
    $loc_cwd = normalize_path(annihilate_path($cwd));
    $loc_cwd = preg_replace("/^\//", "", $loc_cwd);
    $loc_cwd = preg_replace("/\/$/", "", $loc_cwd);

    if ($debug) {
	echo "VALIDATING '$object' FOR ACTION '$op'<br>";
    }

    if (preg_match("/.*\/(.*)$/", $object, $match)) {
	$file = $match[1];
    } else {
	$file = $object;
    }
    if (preg_match("/(\.*)$/", $file, $match)) {
	$suffix = $match[1];
    } else {
	unset ($suffix);
    }
    if (!is_array($priv = $privileges[$this_user['usertype']])) {
	exception("Unknown usertype '" . $this_user['usertype'] . "'");
	die;
    }
    if ($op == "index") {
	if ($priv['allow'][$op]) {
	    return 1;
	}
    }
    if (is_array($deny_list = $priv['deny'][$op])) {
	if ($deny_list[$file]) {    // The file is rejected
	    if ($debug) {
		echo "The '$file' was explicitly rejected in file deny list";
	    }
	    return 0;
	}
	if (isset($suffix)) {				// Suffix is rejected
	    if ($deny_list["*$suffix"]) {
		if ($debug) {
		    echo "Suffix '$suffix' of the file '$file' was rejected";
		}
		return 0;
	    }
	}
    }
    if ($priv['allow'][$op] == "@portal") {
	return 1;
    }
    if ($priv['allow'][$op] == "@home") {
	if (!($a = $this_user['area'])) {
	    exception("Unset user area for user '" . $this_user['login'] . "'");
	    die;
	}
	if (is_array($a)) {  // Make sure we have an array
	    $arealist = $a;
	} else {
	    $arealist = array($a);
	}

	foreach ($arealist as $ai) {
	    $area = normalize_path("/$doc_root/$ai");
	    $area = preg_replace("/^\//", "", $area);
	    $area = preg_replace("/\/$/", "", $area);
	    $area_regexp = make_regexp($area);
	    if (preg_match("/^$area_regexp/", $loc_cwd)) {
		return 1;
	    }
	}
	if ($debug) {
	    echo "The file '$file' is outside user area '$area'";
	}
	return 0;
    }
    return 0;		// We're paranoid, default grant is reject.
}


function check_auth_user ($no_header=0) {
    $user = $_SERVER['PHP_AUTH_USER'];
    $pwd = $_SERVER['PHP_AUTH_PW'];

    if (isset($user)) {
	if ($user_info = get_user_info($user)) {
	    if ($user_info['pass_type'] == 'md5') {
		$pwd = md5($pwd);
	    }
	    if ($user_info['password'] != $pwd) {
		insert_auth_header();
	    }
	    setcookie ("tkl_admin", 1, 0, "/");
	    return $user_info;
	} else {
	    if ($no_header) {
		return 0;
	    } else {
		insert_auth_header();
	    }
	}
    } else {
	if ($no_header) {
	    return 0;
	} else {
	    insert_auth_header();
	}
    }
}


function insert_auth_header() {
    header("WWW-Authenticate: Basic realm=\"Toolkit Light - restricted areas\"");
    header("HTTP/1.0 401 Unauthorized");
    echo "HTTP/1.0 401 Unauthorized<br>";
    echo "You are attempting to enter a restricted area. Use proper login";
    exit;
}

function mkdir_ext ($dir) {
    $missing = array();
    while ($dir && !is_dir($dir)) {
	if (preg_match("/\/([^\/]*)$/", $dir, $match)) {
	    array_unshift($missing, $match[1]);
	    $dir = preg_replace("/\/[^\/]*$/", "", $dir);
	}

    }
    if ($dir) {
	foreach ($missing as $new_dir) {
	    $new = "$dir/$new_dir";
	    if (!mkdir($new, 0755)) {
		exception("Could not create directory '$new'");
		die;
	    }
	    $dir = $new;
	}
    } else {
	exception("No path left");
	die;
    }
    return 1;
}


function recursive_copy ($src, $dest, $all_links = 0, $moved_links = 0) {
    global $debug, $doc_root;

    //if (!is_array($all_links)) {
	//get_links($_SERVER['DOCUMENT_ROOT'] . "/$doc_root", $all_links = array());
    //}
    //$src = preg_replace("/\/+$/", "", $src);

    if (!is_dir($dest)) {
	if (!mkdir_ext($dest)) {
	    return "Oprettelse af <b>$dest</b> mislykkedes";
	}
    }
    if ($dh = @opendir($src)) {
	while ($entry = readdir($dh)) {
	    if (neglect_file($entry)) {
		continue;
	    }
	    if (is_dir("$src/$entry")) {
		if ($msg = recursive_copy("$src/$entry", "$dest/$entry", $all_links, $moved_links)) {
		    return $msg;
		}
	    } elseif (is_link("$src/$entry")) {
	//	$moved_links["$src/$entry"] = "$dest/$entry";
	//	system("mv $src/$entry $dest/$entry");
	        return "Du skal fjerne links, inden du kan flytte hele kataloger...";
	    } else {
		if ($fh = fopen("$src/$entry", "a+")) {
		    if (flock($fh, LOCK_EX)) {
			$sys_src = check_chrs("$src/$entry");
			$sys_dest = check_chrs("$dest/$entry");
			system("cp $sys_src $sys_dest");
			//if (is_array($links = $all_links["$src/$entry"])) {
			//    foreach ($links as $link) {
			//	if (strlen($moved = $moved_links[$link])) {
			//	    $link = $moved;
			//	}
			//	system("rm -f $link");
			//	if (!symlink($sys_src, $link)) {
			//	    exception("Kunne ikke flyttet linket <em>$link</em>");
			//	    die;
			//	}
			//    }
			//}
			if ($debug) {
			    echo "Copying '$sys_src' to '$sys_dest'<br>";
			}
			fclose($fh);
		    } else {
			fclose($fh);
			return "Filen '$src/$entry' er i brug, prv igen lidt senere...";
		    }
		} else {
		    return "Kunne ikke f adgang til filen <b>$src/$entry</b>";
		}
	    }
	}
	closedir($dh);
    } else {
	return "Kataloget '$src' kunne ikke bnes, kontakt systemadminstrator...";
    }
}


function annihilate_path ($path) {
    $path = preg_replace("/^\//", "", $path);
    $path = preg_replace("/\/$/", "", $path);
    while (preg_match("/\/?[^\/]*\/\.\./", $path, $match)) {
	$path = preg_replace("/\/?[^\/]*\/\.\./", "", $path, 1);
    }
    return $path;
}


function normalize_path ($path) {
    return preg_replace("/\/{2,}/", "/", $path);
}


function check_path ($path) {
    $check_file = "tkl.config";
    $path = annihilate_path($path);
    $current_cwd = getcwd();
    if (chdir($_SERVER['DOCUMENT_ROOT'] . "/$path")) {
	while (!file_exists($check_file)) {
	    if (!$path)
		return 0;
	    //echo "BEFORE='$path'<br/>";
	    $path = preg_replace("/\/?[^\/]*$/", "", $path);
	    //echo "AFTER='$path'<br/>";
	    $check_file = "../$check_file";
	}
    } else {
	dir("<b>Fatal:</b> Unable to access directory '" . $_SERVER['DOCUMENT_ROOT'] . "/$path'");
    }
    chdir($current_cwd);
    //$path = preg_replace("/[^\/]*$/", "", $path);
    if (!strlen($path)) {
	$path = "/";
    }
    return $path;
}


function make_regexp ($str) {
    $tmp = preg_replace("'/*$'", "", $str); // normalize trailing / away
    return preg_replace("/\//", "\/", $tmp);
}


function get_last_updated ($file) {
    if (file_exists($file)) {
	return date("Y-m-d, H:i:s", filemtime($file));
    }
}


function get_path ($here) {
    global $doc_root;

    $reg_doc_root = make_regexp($doc_root);
    $truncated = preg_replace("/^\/*$reg_doc_root\/?/", "", $here);
    if (!strlen($truncated)) {
	return array();
    } else {
	return preg_split("/\//", $truncated);
    }
}



function insert_path ($script, $more="") {
    global $cwd, $doc_root, $context;
    $norm_cwd = preg_replace("/^\//", "", normalize_path($cwd));
    $ret = "";

    $path = get_path($norm_cwd);
    $acc_path = $doc_root;
    $sep = "&nbsp;&gt;&nbsp;";
    if ($cwd != $doc_root) {
	    $ret .= "<a href=\"$script?" . makeparms($context, array("cwd"=>$doc_root)) . "$more\">Oversigt</a>";
    } else {
	    $ret .=  "Oversigt";
    }
    foreach ($path as $dir) {
    	$indexer = $_SERVER['DOCUMENT_ROOT'] . "/$acc_path/$dir/index.tkl";
    	if (file_exists($indexer)) {
    	    $show_dir = get_title($indexer);
    	    if (!strlen(trim($show_dir))) {
    		$show_dir = $dir;
    	    }
    	} else {
    	    $show_dir = $dir;
    	}
    	$acc_path .= "/$dir";
	$acc_path = preg_replace("/^\//", "", normalize_path($acc_path));
    	if ($acc_path != $norm_cwd) {
    	    $ret .= "$sep<a href=\"$script?" . makeparms($context, array("cwd"=>$acc_path)) . "$more\">$show_dir</a>";
    	} else {
    	    $ret .=  $sep . $show_dir;
    	}
    }
    return $ret;
}


function extract_cwd ($file) {
    $docroot = $_SERVER['DOCUMENT_ROOT'];
    $dir = dirname(normalize_path($file));
    $cwd = substr( $dir, strlen( $docroot ) );

    return $cwd;
}



function extract_schema_old ($xml_file) {
    global $debug;
    $xml_schema = "";

    if ($debug) {
	    echo "Attempting to extract schema information from xml file '$xml_file'<br>";
    }
    if (!is_array($lines = file($xml_file))) {
    	echo "<b>Unable to open file '$xml_file'</b>";
    	die;
    }
    while ($line = array_shift($lines)) {		// Navigate to xml header
    	$line = trim($line);
    	if (preg_match("/<\?.*\?>/", $line)) {
    	    break;
    	}
    }
    while ($line = array_shift($lines)) {		// Find root tag
	$line = trim($line);
	if (!strlen($line)) {
	    continue;
	}
	//if (preg_match("/<(\S+)\s+(.*?)>/", $line, $match)) {
	if (preg_match("/<(\S+).*>/", $line, $match)) {
	    $root_tag = $match[1];
	    if ($debug) {
		echo "Identified root tag '$root_tag'<br>";
	    }
	    return "$root_tag.xsd";
	}
    }
    echo "<b>Identifikation af XML-schema for XML filen '$xml_file' mislykkedes</b>";
    return 0;
}


function extract_schema ($xml_file) {
    global $debug;
    $xml_schema = "";

    if ($debug) {
	    echo "Attempting to extract schema information from xml file '$xml_file'<br>";
    }
    if (!($dom = domxml_open_file($xml_file))) {
	echo "Can't open/parse xml file '$xml_file'";
	return "Unknown";
    }
    $doc = $dom->document_element();
    if (strlen($root_tag = $doc->tagname())) {
	if ($debug) {
	    echo "Identified root tag '$root_tag'<br>";
	}
	return "$root_tag.xsd";
    } else {
	echo "<b>Identifikation af XML-schema for XML filen '$xml_file' mislykkedes</b>";
	return "Unknown";
    }
}


function dir_content ($dir) {
    global $xml_suffix;
    $suffix_regexp = preg_replace("/\./", "\.", $xml_suffix);
    $content = array();

    if ($dh = @opendir($dir)) {
	while (strlen($entry = readdir($dh))) {
	    if (neglect_file($entry)) {
		continue;
	    }
	    if (is_dir("$dir/$entry")) {
		$content['dir'][] = $entry;
	    } else {
		if (preg_match("/$suffix_regexp$/", $entry)) {
		    $content['file'][] = $entry;
		}
	    }
	}
	closedir($dh);
	return $content;
    } else {
	exception("Could not open directory '$dir'");
    }
}


function is_xml ($file) {
    $valid = array(
    			'tkl' => 1,
			'xsd' => 1,
			'xml' => 1,
		//	'xsl' => 1,
		  );
    if (preg_match("/\.([^\.]*)$/", $file, $match)) {
	if (strlen($match[1])) {
	    return $valid[$match[1]];
	}
    }
    return 0;
}


function exception ($msg) {
    echo "<b>Error:</b> $msg";
    die;
}

function show_browse_results($id, $info, $type="") {
	global $context, $query, $selected_targets, $scan_map, $form_name, $field_name;

    $errno = yaz_errno($id);
    preg_match("/(\w+)=/", $query, $matches);
	$register = $matches[1];
	if ($errno == 0) {
        $ar = yaz_scan_result($id, &$options);
        while (list($key, list($k, $term, $tcount)) = each($ar)) {
            if (empty($k)) continue;
    			$use_term = check_term($term);
    			$register = preg_replace("/^l/", "", $register);
			if ($type == "getit") {
			    echo getitformat($term);
			} else {
                	    echo DK5format($term);
			}
    			echo "<BR>\n";
            }
        } else {
            echo "Scan failed. Error: " . yaz_error($id) . "<br>";
        }
}

//This function is used to format DK5 keyword strings.
function DK5format($term) {
	global $form_name, $field_name, $target, $field1;
	$string1 = " brug "; // Den rigtige tekst kommer EFTER string1
	$string2 = " brugt for "; // Den rigtige tekst kommer FR string2
	$string3 = " se ogs "; // Den rigtige tekst kommer FR string3 men der sges p ord efter. Kan repeteres.
	if (strpos($term,$string1)) {
		$start = strpos($term,$string1) + strlen($string1);
		$newterm = substr($term, $start);
		$newtermSub = ereg_replace("'","\\'",$newterm);
		echo substr($term, 0, $start - strlen($string1)). "<b>". substr($term, $start - strlen($string1), strlen($string1)). "</b><a href=\"getit.php?term1=$newtermSub&field1=$field1&field_name=$field_name&form_name=$form_name&server_name=$target\">$newterm</a>";
	} elseif (strpos($term,$string2)) {
		$end = strpos($term,$string2);
		$newterm = substr($term, 0, $end);
		$newtermSub = ereg_replace("'","\\'",$newterm);
		$reststreng = ereg_replace($string2," <B>brugt for</B> ",substr($term, $end + strlen($string2)));
		echo "<a href=\"getit.php?term1=$newtermSub&field1=$field1&field_name=$field_name&form_name=$form_name&target=$target\">$newterm</a> <b>" .substr($term, $end, strlen($string2)). "</b>$reststreng";
	} elseif (strpos($term,$string3)) {
		$begynd = 1;
		while (strpos($term,$string3) !== false) {
			if ($begynd) {
				$end = strpos($term, $string3);
				$newterm = substr($term, 0, $end);
				$newtermSub = ereg_replace("'","\\'",$newterm);
			 	$output = $output. "<a href=\"javascript: InsertTerm('$newtermSub','$form_name','$field_name','A')\">$newterm</a>";
//				$output = $output. "<a href=\"getit.php?term1=$newtermSub&field1=$field1&field_name=$field_name&form_name=$form_name&target=$target\">$newterm</a>";
			 	$begynd = 0;
			 	$term = substr($term, $end);
			 } else {
			 	$output = $output. "<b>". substr($term, 0, strlen($string3)). "</b>";
			 	$term = substr($term, strlen($string3));
			 	$end = strpos($term,$string3) - 3;
			 	$end2 = $end;
			 	if ($end <= -1) {
			 		$end = "end";
			 	} elseif ($end != "end") {
			 		$end = $end + 2;
			 		$end2 = $end++;
			 	}
			 	$altterm = substr($term, 0);
			 	$output = $output. " <a href=\"$PHP_SELF?target=$target&form_name=$form_name&field_name=$field_name&action=scan&scannumber=10&term1=$altterm\">$altterm</a>";
			 	$term = substr($term, $end);
			 }
		}
		echo $output;
	} else {
	    //regsub -all {([']+)} $term "\\'" termSub
	    $termSub = ereg_replace("'","\\'",$term);
		echo "<a href=\"javascript: InsertTerm('$termSub','$form_name','$field_name','A')\">$term</a>";
//		echo "<a href=\"getit.php?term1=$termSub&field1=$field1&field_name=$field_name&form_name=$form_name&target=$target\">$term</a>";
	}
	echo "";
}

#These functions pull out text strings from the $trans_lang array.
function trans_text ($id) {
    global $trans_lang, $lang, $debug;

    if (!isset($lang)) {
	    $lang = "da";
    }
    if (!is_array($trans_lang)) {
	    die("Remember to include 'lang/lang.php'");
    }
    if (!is_array($trans = $trans_lang[$id])) {
	    die("Unknown trans id '$id'");
    }
    $outstring = $trans_lang[$id][$lang];
    if ($debug) {
        $outstring .= " <font color=\"red\">(id = $id)</font>";
    }
    return $outstring;
}


function get_portal_cwd ($path) {
    global $root;
    $local_root = normalize_path( "/$root" );
    $path = normalize_path( "/$path" );
    $local_root = preg_replace( "/\//", "\/", $local_root );
    $local_root = preg_replace( "/\./", "\.", $local_root );
    $tkl_portal_cwd = preg_replace( "/^$local_root/", "/", $path );
    $tkl_portal_cwd = normalize_path( $tkl_portal_cwd );
    $tkl_portal_cwd = preg_replace( "/\/$/", "", $tkl_portal_cwd );
    
    return normalize_path( $tkl_portal_cwd );
}


// Convert tkl.config.phpi version of languages array into config.php version:
function tklconfiglang2configlang ($hash) {
    $ret = array( );

    foreach ( $hash as $key => $value ) {
        $ret[] = array( 'abbr' => $key, 'desc' => $value );
    }

    return $ret;
}


if ( !function_exists( 'glob' ) ) {
    
    function glob ($pattern, $flags = '') {
        $bin_ls = "/bin/ls";
        $switches = "-1dA";
        $ret = array( );

        if ( strlen( $flags ) ) {
            echo "<b>Warning:</b> 2nd parameter of glob function is not implemeneted<br/>";
        }

        if ( !is_executable( $bin_ls ) ) {
            die( "<b>Fatal:</b> Missing executable file '$bin_ls'" );
        }

        $cmd = $bin_ls . " " . $switches . " " . $pattern;

        if ( !$pipe = popen( $cmd, "r" ) ) {
            die( "<b>Fatal:</b> Unable to fork '$bin_ls'" );
        }

        while ( !feof( $pipe ) ) {
            $buffer = fgets( $pipe, 4096 );
            $buffer = trim( $buffer );

            if ( strlen( $buffer ) ) {
                $ret[] = $buffer;
            }
        }

        pclose( $pipe );

        return $ret;
    }
}


function string2xmlstring( $str ) {
    $str = preg_replace( "/&/", "&amp;", $str );
    $str = preg_replace( "/</", "&lt;", $str );
    $str = preg_replace( "/>/", "&gt;", $str );

    return $str;
}



function tkl_count_subdir ($path) {
    $counter = 0;

    if ( !$dh = opendir( $path ) ) {
        exception( __FILE__ . ': Unable to open directory: ' . $path );
    }

    while ( false !== ($file = readdir($dh) ) ) {
        if ( $file == '.' || $file == '..' ) {
            continue;
        }

        $counter ++;
    }

    closedir( $dh );

    return $counter;
}




?>
