<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: simple_editor.php,v 1.11 2004/11/18 09:26:01 adam Exp $
*/
?><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<?php

require "config.php";
require "standards.php";

?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Editor</title>

<style>
       
    span.btnImage {border: 2px outset white; padding-left: 5px; padding-right: 5px; cursor: default}
    span.btnImage:active {border-style: inset}
    
    .btnImage {cursor: pointer; cursor: hand; padding:2px;}
    
    iframe {border: 1px solid black;}
    
  </style>  

  <script src="js/xbDesignMode.js"></script>  
   
 	<script  language="JavaScript">

	var fieldid = '<?php echo $fieldid?>';

    var myDesignMode=null;

    function load(){
      var myIFrame = document.getElementById("editorWindow");
      myDesignMode = new xbDesignMode(myIFrame);

      if (!document.all) myDesignMode.setCSSCreation("true");
      
      // this is the only way I can get IE to load data into the iframe 
	  setTimeout("insert_content()",500);
    }       
    function getSource(){
    	var html_tmp = make_wellformed_xhtml(myDesignMode.mEditorDocument.body.innerHTML);		
		html_tmp = replace(myDesignMode.mEditorDocument.body.innerHTML,"<","&lt;");
		//alert(html_tmp);
      document.getElementById("sourceView").innerHTML = "<pre>" + html_tmp + "</pre>";      
    }
    function wysiwyg(){
    	document.getElementById("sourceView").innerHTML =  myDesignMode.mEditorDocument.body.innerHTML;      
    }
    function addLink(){
      var myUrl = prompt("Please enter a URL:", "");
      myDesignMode.execCommand("createLink", myUrl);
     }
	function addSymbol(symbol) {
			//alert(symbol);
			myDesignMode.mEditorDocument.body.innerHTML += symbol;  
	}
	function openWin(theURL,winName,features) {
  		window.open(theURL,winName,features);
	}
    function doRichEditCommand(aCommandName, aArg){
      myDesignMode.execCommand(aCommandName, aArg);
      document.getElementById("editorWindow").contentWindow.focus();
    }

	function select(selectname){
    	var cursel = document.getElementById(selectname).selectedIndex;
		// First one is always a label
		if (cursel != 0) {
			var selected = document.getElementById(selectname).options[cursel].value;
			doRichEditCommand(selectname, selected);
			document.getElementById(selectname).selectedIndex = 0;
		}
    } 
  function replace(string,text,by) {
     // Replaces text with by in string
      var strLength = string.length, txtLength = text.length;
      if ((strLength == 0) || (txtLength == 0)) return string;

      var i = string.indexOf(text);
      if ((!i) && (text != string.substring(0,txtLength))) return string;
      if (i == -1) return string;

      var newstr = string.substring(0,i) + by;

      if (i+txtLength < strLength)
        newstr += replace(string.substring(i+txtLength,strLength),text,by);
      return newstr;
    }
    function make_wellformed_xhtml(text){
    	// Fix, broken XHTML, made by browsers!
        // MOZ 1.3
        var xhtml = replace(text,"<br>","<br />");
        // IE 5.5,6
        xhtml = replace(xhtml,"color=red>","color=\"red\">");
        xhtml = replace(xhtml,"color=black>","color=\"black\">");
        xhtml = replace(xhtml,"color=blue>","color=\"blue\">");
        
        xhtml = replace(xhtml,"align=right>","align=\"right\">");
        xhtml = replace(xhtml,"align=left>","align=\"left\">");
        xhtml = replace(xhtml,"align=center>","align=\"center\">");
 
        xhtml = replace(xhtml,"&nbsp;"," ");
    	
        // lowercase tags.
        xhtml = tagToLowerCase(xhtml);    	
    	
        return xhtml;
    }

  function tagToLowerCase(string) {
      var strLength = string.length;
      if (strLength == 0) return string;

      var tag1 = string.indexOf("<");
      var tag2 = string.indexOf(">");
      
      var newstr = string.substring(0,tag1);
      newstr += "<" + string.substring(tag1+1,tag2).toLowerCase() + ">";
      //alert(string.substring(tag1+1,tag2));
      if (tag2 < strLength) {
         newstr += string.substring(tag2+1,strLength);
      }
      return newstr;
  }

    function get_content () {
		for (var i = 0; i<this.opener.document.main.elements.length; i++) {
			if (this.opener.document.main.elements[i].name == '<?php echo $fieldid?>') {
				return this.opener.document.main.elements[i].value;
			}
		}
    }
    function insert_content () {
		myDesignMode.mEditorDocument.body.innerHTML = get_content();
    }
        
    function update_content () {
        for (var i = 0; i<this.opener.document.main.elements.length; i++) {
            if (this.opener.document.main.elements[i].name == '<?php echo $fieldid?>') {
                this.opener.document.main.elements[i].value = make_wellformed_xhtml(myDesignMode.mEditorDocument.body.innerHTML);
            }
        }
    }

    function close_n_exit () {
        update_content();
        close();
    }

	
  </script>  

  
</head>
<body onLoad="load()">

  <div id="editor" class="tabPanel">

  <p>
  
  
	<select id="formatblock" onchange="select(this.id);">
		<option value="<p>">Normal</option>
		<option value="<p>">Paragraph</option>
		<option value="<h1>">Heading 1 <h1></option>
		<option value="<h2>">Heading 2 <h2></option>
		<option value="<h3>">Heading 3 <h3></option>
		<option value="<h4>">Heading 4 <h4></option>
		<option value="<h5>">Heading 5 <h5></option>
		<option value="<h6>">Heading 6 <h6></option>
		<option value="<address>">Address <ADDR></option>
		<option value="<pre>">Formatted <pre></option>
	</select>
	<select id="fontname" name="selectFont" onchange="select(this.id)">
		<option value="Font" selected>Font</option>
		<option value="Arial, Helvetica, sans-serif">Arial</option>
		<option value="Courier New, Courier, mono">Courier New</option>
		<option value="Times New Roman, Times, serif">Times New Roman</option>
		<option value="Verdana, Arial, Helvetica, sans-serif">Verdana</option>
	</select>

	<img class="btnImage" src="grafik/icon/post_button_bold.gif" width="25" height="24" alt="Bold" title="Bold" onClick="doRichEditCommand('bold');">
	<img class="btnImage" src="grafik/icon/post_button_italic.gif" width="25" height="24" alt="Italic" title="Italic" onClick="doRichEditCommand('italic')">
	<img class="btnImage" src="grafik/icon/post_button_underline.gif" width="25" height="24" alt="Underline" title="Underline" onClick="doRichEditCommand('underline')">
	&nbsp;&nbsp;
	<img class="btnImage" src="grafik/icon/post_button_left_just.gif" width="25" height="24" alt="Align Left" title="Align Left" onClick="doRichEditCommand('justifyleft')">
    <img class="btnImage" src="grafik/icon/post_button_centre.gif" width="25" height="24" alt="Center" title="Center" onClick="doRichEditCommand('justifycenter')">
    <img class="btnImage" src="grafik/icon/post_button_right_just.gif" width="25" height="24" alt="Align Right" title="Align Right" onClick="doRichEditCommand('justifyright')">
    &nbsp;&nbsp;
	<img class="btnImage" src="grafik/icon/post_button_numbered_list.gif" width="25" height="24" alt="Ordered List" title="Ordered List" onClick="doRichEditCommand('insertorderedlist')">
	<img class="btnImage" src="grafik/icon/post_button_list.gif" width="25" height="24" alt="Unordered List" title="Unordered List" onClick="doRichEditCommand('insertunorderedlist')">
	&nbsp;&nbsp;
	<img class="btnImage" src="grafik/icon/post_button_outdent.gif" width="25" height="24" alt="Outdent" title="Outdent" onClick="doRichEditCommand('outdent')">
	<img class="btnImage" src="grafik/icon/post_button_indent.gif" width="25" height="24" alt="Indent" title="Indent" onClick="doRichEditCommand('indent')">
 	&nbsp;&nbsp;           
	<img class="btnImage" src="grafik/icon/post_button_hyperlink.gif" width="25" height="24" alt="Insert Link" title="Insert Link" onClick="addLink();">
	<input type="button" value="UTF-8 symbols" onclick="openWin('utf8.php','utf8','toolbar=0,location=0,status=0,menubar=0,scrollbars=0,resizable=1,width=400,height=420')">
	&nbsp;&nbsp;  
    <select onchange="doRichEditCommand('forecolor',this.options[this.selectedIndex].value)">
      <option>Choose Color</option>
      <option value="black">Black</option>
      <option value="red">Red</option>
      <option value="blue">Blue</option>
    </select>
    <input type="button" value="Delete all" onclick="myDesignMode.mEditorDocument.body.innerHTML = '';">
  
    <iframe src="editor.html" id="editorWindow" width="90%" height="350" style="margin:5px;"></iframe>   
	
  </p>
  <input type="submit" value="Done" onclick="close_n_exit()">
  <input type="button" value="Cancel" onClick="window.close()">
  <input type="button" value="Show code" onclick="getSource()">
  <!-- 
  	<input type="checkbox" name="CSSTogle" onclick="myDesignMode.setCSSCreation(!this.checked);">Use CSS (only supported by Mozilla 1.3+ and Netscape 7.1)
  -->
</div>
	<br />
  <div id="sourceView"></div>
  <br />
   <H6><center>This page only support, Mozilla 1.3+ , Netscape 7.1 and IE 5.5+</center></H6>
</body>
</html>
