<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: shell.php,v 1.87 2005/10/11 01:54:44 quinn Exp $
*/


require 'config.php';
require 'standards.php';
require( 'scheme_tools.phpi' );

header("Content-Type: text/html; charset=utf-8");
require 'domtools.php';

if ($_COOKIE['tkl_admin'] == 1)
    $tkl_authenticated = 1;
else
    $tkl_authenticated = "";

if ($_REQUEST['cwd']) {				// Is the cwd set explicitly?
    $path = $_SERVER['DOCUMENT_ROOT'] . "/" . $_REQUEST['cwd'];
    $cwd_raw = $_REQUEST['cwd'];
    $cwd_raw = annihilate_path($cwd_raw);
    $tkl_cwd = "/$cwd_raw";
    $root = $tkl_cwd;
    $workingdir = $_SERVER['DOCUMENT_ROOT'] . "/" . $tkl_cwd;
} else {
    $root = preg_replace('/\/[^\/]*$/', "", $_SERVER['PATH_INFO']);
    $path = $_SERVER['PATH_TRANSLATED'];
    $workingdir = preg_replace('/\/[^\/]*$/', "", $_SERVER['PATH_TRANSLATED']);
    $tkl_cwd = preg_replace("/\/?[^\/]*$/", '', $_SERVER['PATH_INFO']);
    if (!strlen($tkl_cwd)) {
	$tkl_cwd = "/";
    }
}

if (!check_path($tkl_cwd)) {
    echo "<b>Fatal:</b> Out of portal scope";
    die;
}

$tkl_bin = preg_replace("'/[^/]*$'", "", $_SERVER['SCRIPT_NAME']);

$tkl_execute_footer = '';

$blacklist = array('directory.tkl' => 1, 'users.tkl' => 1);
$fn = preg_replace("'^.*/'", "", $path);
if ($blacklist[$fn]) {
    header("HTTP/1.1 403 Forbidden");
    print "Access denied.";
    die;
}

include 'shell-util.php';

if ($_REQUEST['verb'])
    include 'oai.php';

$soappath='nusoap.php';
if (file_exists($soappath))
    require $soappath;

$debug = $_REQUEST['debug'];

chdir($workingdir);

if ($_REQUEST['admin']) {
    $document = make_admin_index();
} else {
    if (!($fl = @file($path))) {
	header("HTTP/1.1 404 Not Found");
	print "File not found";
	die;
    }
    $document = join('', file($path));
}

//chdir($workingdir);

// Hidden attribute set
// who the heck did program a regular expression which hit's any attribute 
// of name 'hidden' in the entire doc ?? Shame on you!!
if (preg_match("/<[^?!][^>]*hidden=.1./", $document)
    && !(isset($_REQUEST['edit']))) {
    header("HTTP/1.1 403 Forbidden");
    print "Access denied.";
    die;
}

if ($_REQUEST['verb']) {
    do_oai_verb($_REQUEST['verb'], $_SERVER['PATH_INFO']);
    return;
}

session_start();

$t = new XML_getschema($document);
if ($debug) print "Schema is " . $t->schema() . "<p>\n";
$schema = $t->schema();
if (!$schema)
    $schema = "dummy";

if ($debug) {
    print "DOCUMENT:";
    print "<pre>"; print preg_replace("/</", "&lt;", $document); print "</pre>";
    print "<hr>";
    print "STYLESHEET";
    print "<pre>"; print preg_replace("/</", "&lt;", $stylesheet); print "</pre>";
}


// Use trailing part of schema to select stylesheet.
$spart = preg_replace("/^.*[:\/]/", "", $schema);
//$root = preg_replace('/\/[^\/]*$/', "", $_SERVER['PATH_INFO']);

// Look for stylesheet from here back to the root
// Is there a prettier way to do this, please????
$dir = $workingdir;
$stylesheet = '';
$prefix = '';      // This allows prefix override using tkl.prefix file

do {
    if (file_exists("$dir/tkl.prefix")) {
	$ln = file("$dir/tkl.prefix");
	$prefix = preg_replace('/\s/', '', $ln[0]);
    }
    if (!$stylesheet && file_exists("$dir/$prefix$spart.xsl")) {
        $stylesheetpath = "$dir/$prefix$spart.xsl";
	$stylesheet = join('', file($stylesheetpath));
    }
    if (file_exists("$dir/tkl.config"))
        break;
    $dir = preg_replace("/\/[^\/]*$/", "", $dir); // up one dir
    $root = preg_replace("/\/[^\/]*$/", "", $root); // up one dir
} while ($dir);

// Get a list of directories to ignore...
$dirhide = make_dir_hide();

if (!file_exists("$dir/tkl.config")) {
    die("<b>Out of portal scope</b>");
}

require "read_local_config.php";

// In principle, $default_user_lang can be initialized in local_config.phpi
// but in the future, this should be out-phased in favour of the more
// generic configuration file tkl.config
if (strlen($tkl_config_user_lang = get_tkl_config('userlang'))) {
    $default_user_lang = $tkl_config_user_lang;
}

// Check if there is a portal specific list of languages:
if (is_array($tkl_config_languages = get_tkl_config('languages'))) {
    $languages = tklconfiglang2configlang( $tkl_config_languages );
}

if ($_REQUEST['lang']) {
    $lang = $_REQUEST['lang'];
    $_SESSION['lang'] = $lang;
} elseif ($_SESSION['lang'])
    $lang = $_SESSION['lang'];
else {
    $lang = $default_user_lang;
    $_SESSION['lang'] = $lang;
}

$t = new XML_process_stylesheet($document);
$document = $t->buf();

if ($_REQUEST['admin']) {
    scheme_handler(0, 'tkl-admin-header', '');
} else {
    scheme_handler(0, 'tkl-header', '');
}

if (!$_REQUEST['admin'] && $_REQUEST['edit'] && strlen($path)) {
    header("Location: $tkl_bin/xform2.php?xml_file=$path");
    exit(0);
}


if (!$stylesheet && $admin) {
    $abs_tkl_bin = $_SERVER['DOCUMENT_ROOT'] . $tkl_bin;
    $candidate = "$abs_tkl_bin/admin/$spart.xsl";

    if (file_exists($candidate)) {
	$stylesheetpath = $candidate;
	$stylesheet = join('', file($stylesheetpath));
    }
}

//
// ============= Pre-process the stylesheet
// == NOTE: THe PORTCOM substitution commands are being phased out in favor of accessing
// == extra functionality through custom URI schemes. However, we still need the preproc
// == stage to filter out language-specific elements.
//

if (!$stylesheet) {
    echo "Found no stylesheet:<br/>\n";
    print "<pre>"; print preg_replace("/</", "&lt;", $document); print "</pre>";
    exit;
}



// Execute &lt;? PHP-code ?&gt; expressions.
function execute_script($matches) {
    return eval ("$matches[1];");
}

$stylesheet = preg_replace_callback('/<\?[pP][Hh][Pp]\s*(.*?)\s*\?>/s', 'execute_script',
    $stylesheet);

function lookup_var($matches) {
    return $_REQUEST[$matches[1]];
}

$stylesheet = preg_replace_callback('/\$WEB\[\'(.*?)\'\]/', 'lookup_var',
    $stylesheet);

function lookup_global($matches) {
   return $GLOBALS[$matches[1]];
}

$stylesheet = preg_replace_callback('/\$GLOBALS\[\'(.*?)\'\]/', 'lookup_global',
    $stylesheet);

$t = new XML_process_stylesheet($stylesheet);
$stylesheet = $t->buf();

if ($debug) {
    print "DOCUMENT:";
    print "<pre>"; print preg_replace("/</", "&lt;", $document); print "</pre>";
    print "<hr>";
    print "STYLESHEET:";
    print "<pre>"; print preg_replace("/</", "&lt;", $stylesheet); print "</pre>";
}

//
// ================== Execute the stylesheet
//

//$tmpfile = dirname($stylesheetpath) . "/" . getmypid() . ".xsl";
$tmpfile = "/tmp/tkl-tmp-" . getmypid() . ".xsl";


$tf = fopen($tmpfile, "w");
fputs($tf, $stylesheet);
fclose($tf);


$arguments = array(
    '/_xml' => $document,
    '/_xsl' => $stylesheet
    );

$parameters = array(
    'path' => $path,
    'root' => $root,
    'portpath' => $dir,
    'lang' => $lang,
    'tkl_authenticated' => $tkl_authenticated,
    'tkl_bin' => $tkl_bin,
    'tkl_cwd' => $tkl_cwd,
    'tkl_portal_cwd' => get_portal_cwd( $tkl_cwd ),
    'tkl_fn' => preg_replace("'^.*/'", "", $_SERVER['PATH_INFO']),
    'tkl_docroot' => $_SERVER['DOCUMENT_ROOT'],
    'server_name' => $_SERVER['SERVER_NAME'],
    );

foreach ($_REQUEST as $key => $value) {
    if (!is_array($value) && !defined($parameters[$key])) {
        if (preg_match('/^utf8_/', $key)) {
            $tname = preg_replace('/^utf8_/', '', $key);
            $parameters[$tname] = stripslashes($value);
        }
        else {
            $parameters[$key] = stripslashes($value);
        }
    }
}


function make_admin_index () {
    global $debug, $root, $tkl_cwd, $tkl_bin;
    $file = $_SERVER['DOCUMENT_ROOT'] . "/$tkl_cwd/admin.tkl";
    if (file_exists($file)) {
	$ret = join('', file($file));
    } else {
	$file = $_SERVER['DOCUMENT_ROOT'] . $tkl_bin . "/admin/admin.tkl";
	if (file_exists($file)) {
	    $ret = join('', file($file));
	} else {
	    die("<b>Fatal: Found no admin.tkl</b>");
	}
    }
    $temp_cwd = "";
    do {					// Find directory.tkl....
      $directory = normalize_path($_SERVER['DOCUMENT_ROOT'] . "/$tkl_cwd/$temp_cwd/directory.tkl");

	if (file_exists($directory)) {
	    break;
	}
	if (file_exists($_SERVER['DOCUMENT_ROOT'] . "/$tkl_cwd/$temp_cwd/tkl.config")) {
	    die("Found no directory.tkl within portal area");
	}
	$temp_cwd .= "../";
    } while (1);
    if ($debug) {
	echo "Identified dir_config file '$directory'";
    }

    $config_parms = "<dir_config>$temp_cwd</dir_config>";
    
    $ret = preg_replace("/<admin_config>(.*?)<\/admin_config>/", "<admin_config>$config_parms</admin_config>", $ret, 1);
    if ($debug) {
	echo "Using admin index.tkl file:<br/><pre>", ($ret), "</pre><hr/>";
    }

    return $ret;
}


function xslt_trap_error($parser, $errorno, $level, $fields) {
    $m = "Error Number $errorno, Level $level, Fields;\n";
    if(is_array($fields)) {
	while(list($key, $value) = each($fields)) {
	    $m .= "<br> $key => $value\n";
	}
    } else {
	$m .= "$fields";
    }
    echo "<p><b>Error</b>: $m";
}


// Read an argument string and parse into (hopefully) SOAP-friendly structures.
// Each param is made a member of &array
// aa       => $array[] = aa
// aa=bb    => $array[aa] = bb
// aa.bb    => $array[aa][] = bb
// aa.bb=cc => $array[aa][bb] = cc
// .aa=bb   => $array[top][aa] = bb
// .        => $array[top+1] = array()
// .aa=bb&.cc=dd => array('aa' => 'bb', 'cc' => 'dd')
function grok_arg(&$array, $arg) {
    if (preg_match("/^([^.=]*)\.(.*)$/", $arg, $match)) { // complex
	$head = $match[1];
	$tail = $match[2];
	if ($head == '') {
	    if ($tail == '')
		$head = sizeof($array);
	    else
		$head = max(sizeof($array) - 1, 0);
	}
	if (!is_array($array[$head]))
	    $array[$head] = array();
	if ($tail)
	    grok_arg($array[$head], $tail);
    }
    else { // primitive
	if (!preg_match("/^([^=]*)(=(.*))?$/", $arg, $mmatch))
	    return;
	if ($mmatch[2]) {
	    $name = $mmatch[1];
	    $value = $mmatch[3];
	}
	else { // no index given
	    $name = sizeof($array);
	    $value = $mmatch[1];
	}
	$array[$name] = $value;
    }
}


function function_unique ($att) {
    global $tkl_cwd;
    
    if (!isset($att['format']) || !strlen($format = $att['format'])) {
	die("<b>You must specify format</b>");
    }
    
    $filename = $exist = $file_spec = $ret = '';
    
    $format = check_suffix($format);
    
    if ($att['type'] == 'globallyUnique') {
	$a = gettimeofday();
	$stamp = time() . '-' . $a['usec'] . '-' . getmypid();
	$filename = preg_replace("/%/", $stamp, $format);
    } elseif ($att['type'] == 'fixedName') {
	//echo "CHECKING='",$_SERVER['DOCUMENT_ROOT'] . "/$tkl_cwd/$format'<br>";
	if (is_file($_SERVER['DOCUMENT_ROOT'] . "/$tkl_cwd/$format")) {
	    $exist = 1;
	} else {
	    $exist = 0;
	    $filename = $format;
	}
    } elseif ($att['type'] == 'userProvided') {
	$file_spec = 1;
    } else {
	die("<b>Unknown naming scheme: " . $att['type']);
    }
    $ret .= "<unique>$filename</unique>\n";
    $ret .= "<exists>$exist</exists>\n";
    $ret .= "<file_spec>$file_spec</file_spec>\n";
    //echo "<hr/><pre>", htmlentities($ret), "</pre><hr/>";

    return $ret;
}


function function_grant ($att) {
    if (!strlen($att['file']) || !strlen($att['type'])) {
	die("<b>Fatal:</b> tkl-grant scheme handler must be provided with file as well as type arguments.");
    }
    $ret = "<granted>" . is_granted($att['file'], $att['type']) . "</granted>\n";

    return $ret;
}


function function_default ($att) {
    global $dir, $tkl_bin;

    if (!strlen($rel_path = $att['path'])) {
	die("<b>Fatal:</b> Scheme handler for tkl-default must be passed the path argument");
    }
    if (is_file("$dir/$rel_path")) {
	$abs_path = "$dir/$rel_path";
    } elseif (is_file($_SERVER['DOCUMENT_ROOT'] . '/' . $tkl_bin . '/' . $rel_path)) {
	$abs_path = $_SERVER['DOCUMENT_ROOT'] . '/' . $tkl_bin . '/' . $rel_path;
    } else {
	return "<error>No such file</error>";
    }
    return "<abs_path>$abs_path</abs_path>";
}


function function_file_exists ($att) {
    $ret = "";
    if (strlen($file = $att['file'])) {
	$ret .= "<exists>";
	if (file_exists($file)) {
	    $ret .= "1";
	} else {
	    $ret .= "0";
	}
	$ret .= "</exists>";
    } else {
	die("<b>Fatal:</b> Scheme tkl-file-exists: Parameter file must be specified");
    }
    return $ret;
}


function cmd_handler ($scheme, $path) {
    $handlers = array(
        'tkl-path' => 'function_path',
	'tkl-find' => 'function_find',
	'tkl-mail' => 'function_mail',
	'tkl-unique' => 'function_unique',
	'tkl-grant' => 'function_grant',
	'tkl-default' => 'function_default',
	'tkl-file-exists' => 'function_file_exists',
	'tkl-time' => 'function_time',
    );
    $res = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    $res .= "<$scheme>";
	if (!preg_match('/\/*(.*?)(\?(.*))?/', $path, $match)) {
	    print "Malformed path for $scheme";
	    return '';
	}
	$target = $match[1];
	$args = $match[3];
	$att = array('target' => $target);
	if ($args) {
	    foreach (explode('&', $args) as $arg) {
		list ($name, $value) = explode('=', $arg);
                #print ("<b>Arg: '$arg'</b><br/>");
		if (!strlen($name) || !strlen($value)) {
		    print "Bad attribute to $scheme: $arg";
		    return '';
		}
		$att[$name] = $value;
	    }
	}
	$res .= $handlers[$scheme]($att);
    $res .= "</$scheme>";
    return $res;
}

function scheme_handler($xsl, $scheme, $path) {
  global $cwd, $dir, $debug;
  if ($debug) {
    echo "Calling: scheme_handler($xsl, $scheme, $path)<br/>";
  }
//    echo "Calling: $scheme, PATH='$path'<br/>";
//    if ($scheme != "tkl-user" and $scheme != "tkl-path" and $scheme != "tkl-grant" and $scheme != "tkl-find" and $scheme != "tkl-file" and $scheme != "tkl-admin-header") {
//	exit;
//    }
    $tkl_root = preg_replace("/[^\/]*$/", "", $_SERVER['DOCUMENT_ROOT'] . $_SERVER['SCRIPT_NAME']);
###print "DOCUMENT_ROOT='" . $_SERVER['DOCUMENT_ROOT'] . "'<BR>\n";
###print "SCRIPT_NAME='" . $_SERVER['SCRIPT_NAME'] . "'<BR>\n";
###print "scheme_handler(): xsl='$xsl', scheme='$scheme', path='$path', tkl_root='$tkl_root'<BR>\n";
    if (strlen($dir)) {				// Try portal specific library first...
	$lib_dir = "$dir/lib/$scheme";
    } elseif (strlen($cwd)) {
	$lib_dir = $_SERVER['DOCUMENT_ROOT'] . "/$cwd";
    } else {
	echo "<b>Warning:</b> Unable to look for local header handlers.<br/>";
    }
    if (!is_dir($lib_dir) || (isset($_REQUEST['admin']) && $_REQUEST['admin'])) { // Always use the default handlers in the admin-interface...
	$lib_dir = "$tkl_root/lib/$scheme";	// Otherwise, use the default tklite-version...
    }
    if ($debug) {
	if (is_dir($lib_dir)) {
	    echo "Identified scheme handle library: '$lib_dir'<br/>";
	}
    }
###print "lib_dir='$lib_dir'<BR>\n";
    if (!is_dir($lib_dir)) {
	echo "<b>Warning: Unknown scheme '$scheme'</b><br/>";
	return "";
    }

    if (is_file($handler_script = "$lib_dir/handler.php")) {		// Is this a php-handler?
	if ($debug) {
	    echo "Loading php-handler: $handler_script <br/>";
	}
	require_once($handler_script);
	$handle_name = "scheme_" . preg_replace("/\-/", "_", $scheme);
	if ($debug) {
	    echo "php-handler call: $handle_name($scheme, $path)<br/><br/>";
	}
	return $handle_name($scheme, $path);
    } elseif (is_file($handler_script = "$lib_dir/handler.pl")) {	// Or a Perl handler?
	if ($debug) {
	    echo "\n<br/>Loading Perl-handler: $handler_script<br/>";
	}
	$temp = "handle-" . getmypid();
	$error = "$temp.err";
	$output = "$temp.out";
	passthru("(/bin/cat $handler_script; echo \"print handler('$scheme', '$path')\") | /usr/bin/perl >$output 2>$error");
	if (is_file($error)) {
	    if (strlen($err_msg = join("\n", file($error)))) {
		echo "<p/><b>Perl reported an error:</b> $err_msg";
	    }
	    unlink($error);
	}
	$ret = join("\n", file($output));
	unlink($output);
	return $ret;
    } else {
	echo "<b>Scheme handler language unsupported for $scheme</b><br/>";
	return "";
    }
}

$xsl = xslt_create();
xslt_set_base($xsl, "file://$tmpfile");
xslt_set_error_handler($xsl, "xslt_trap_error");
xslt_set_scheme_handlers($xsl, array('get_all' => 'scheme_handler'));

$result = xslt_process($xsl, 'arg:/_xml', 'arg:/_xsl', NULL, $arguments,
    $parameters);
xslt_free($xsl);
unlink($tmpfile);

if (!$result)
    die("error");

if ($debug) {
    print "<hr>RESULT<p><pre>"; print preg_replace("/</", "&lt;", $result); print "</pre>";
} else
    print $result;

session_write_close();

if ($tkl_execute_footer) {
    $match = array();
    preg_match('/\/?(.*?):(.*)/', $tkl_execute_footer, $match);
    $scheme = $match[1]; $args = $match[2];
    scheme_handler(0, $scheme, $args);
}

scheme_handler( 0, 'tkl-footer', '' );

// -----------------------------------------------------------------
// Utility stuff -- move everything below this to module files

function function_time($att) {
    if ($att['format']) {
	return strftime($att['format']);
    }
    else {
	return time();
    }
}


function function_path($att) {
    global $tkl_cwd;
    global $path;
    $res = '';
    $dirp = '';

    $cwd = preg_replace("'/$'", "", $tkl_cwd);
    $abspath = annihilate_path("/$path");

    if (preg_match("'/([^/]*).tkl$'", $abspath, $match)) {
        if ($match[1] != 'index') {
	    $res = "<step path='$cwd/$match[1].tkl'>" .
	      grok_file(join('', file($abspath)), $att) .
	      '</step>';
        }
        $abspath = preg_replace("'/[^/]*$'", "", $abspath);
    }


    while (1) {

	if ($att['no_index'] || file_exists("$abspath/index.tkl")) {
	    if (!strlen($cwd)) {
		$cwd = "/";
	    }
	    $node = "<step path='$cwd'>";
	    if (file_exists("$abspath/index.tkl")) {
		$node .= grok_file(join('', file("$abspath/index.tkl")), $att);
	    } else {
		preg_match("/([^\/]*)$/", realpath($abspath), $match);
		$node .= "<title>" . $match[1] . "</title>";
	    }
	    $node .= "</step>\n";
	    $res = $node . $res;
	}
	if (file_exists("$abspath/tkl.config"))
	    break;
	$cwd = preg_replace("/\/[^\/]*$/", "", $cwd); // up one dir
	$abspath = preg_replace("/\/[^\/]*$/", "", $abspath); // up one dir
    }
    return $res;
}

function find_files($path, $location, $att, $absolute = '', $level = 0) {
    global $root, $dirhide;
    $path = urldecode($path);

    if (preg_match("/^\//", $path)) {
	$location = $root;
	$absolute = $_SERVER['DOCUMENT_ROOT'];
	$path = preg_replace("/^./", "", $path);
    }
    if (!preg_match("/([^\/]*)(\/(.+))?/", $path, $match))
	return '';
    $local = $match[1];
    $tail = $match[3];
    if (preg_match("/[*?]/", $local)) {
	// Convert glob pattern to regexp
	$local = preg_replace('/\./', '\\.', $local);
	$local = preg_replace('/\?/', '.', $local);
	$local = preg_replace('/\*/', '.*', $local);
	if (!($d = @opendir($absolute . $location)))
	    return '';
	$tmpbuf = '';
	while (strlen($f = readdir($d))) {
	    if ($f == 'CVS') continue;
	    if (preg_match("/^$local\$/", $f) && !preg_match('/^\./', $f)) {
		$tpath = $f . ($tail ? "/$tail" : '');
		$tmpbuf .= find_files($tpath, $location, $att, $absolute,
							$level);
	    }
	}
	closedir($d);
	return $tmpbuf;
    }
    if ($tail) {
	return find_files($tail, "$location/$local", $att, $absolute, $level);
    }
    if (@is_dir("$absolute$location/$local")) {
	if ($dirhide[$local])
	    return '';
	if ($att['level'] && ($att['level'] < $level + 1))
	    return '';
	else {
            return "\n<dir path=\"$absolute$location/$local/\" " .
	        "level=\"" . ($level + 1) . "\" att=\"" . $att['level'] . "\">" .
	        find_files("*", "$location/$local", $att, $absolute, $level + 1) .
	        "</dir>";
	}    
    }
    $this_file = "$absolute$location/$local";
    if (@file_exists($this_file)) {
	if ($att['mask'] && $att['mask'] != $local)
	    return '';
	if (!is_xml($local)) {
	    return "";
	}
	$file_type = filetype("$absolute$location/$local");
	if ($file_type != "file" && $file_type != "link") {
	    return '';
	}
	if (strlen($att['select'])) {	// No reason to read file, if we don't select anything...
	    $fl = join('', file("$absolute$location/$local"));
	    //echo "FIND_FILES:<br/><pre>$fl</pre><hr/>";
	} else {
	    $fl = "";
	}

	// Hidden attribute is set
	if (preg_match("/<[^?!][^>]*hidden=.1./", $fl) && !$_REQUEST['admin']) {
	    return '';
	}
	if ($att['type']) {
	    // Divine document element
	    preg_match('/<([^!?][^\s>]*)/', $fl, $match);
	    if ($att['type'] != $match[1])
	       return '';
	}

	if ($local == 'index.tkl' and !$att['show_index']) {
	    $local = '';
	}
	if ($file_type == "link" && preg_match("/(.*?)([^\/]*)$/", readlink($this_file), $matches)) {
	    $symlinkdir = normalize_path($matches[1]);
	    $link_attr = " symlinkdir=\"$symlinkdir\" symlinkfile=\"" . $matches[2] . "\"";
	} else {
	    $link_attr = "";
	}
	return "\n<file path=\"$location/$local\"$link_attr>" .
	    grok_file($fl, $att) .
	    "</file>";
    }
}

function xml_getelement($xml, $element) {
    preg_match_all("/(<$element\s*.*?>\s*.*?\s*<\/$element>)/s", $xml, $res,
   	 PREG_PATTERN_ORDER);
    return $res[1];
}

function xml_getelement_content($xml, $element) {
    preg_match_all("/<$element\s*.*?>(.*?)<\/$element>/s", $xml, $res,
   	 PREG_PATTERN_ORDER);
    return $res[1];
}



// Extract elements from file if specified by select-attribute
function grok_file($fl, $att) {
    $res = '';
    global $lang;
    $alpha_prefix = 'den|det|et|en|der|die|das|the|a|an';

    if ($att['select']) {
	foreach (explode('|', $att['select']) as $field) {
	    $alphasort = 0;
	    if (preg_match("'.*/@alphasort'", $field)) {
		$alphasort = 1;
		$field = preg_replace("'/.*$'", "", $field);
	    }
	    foreach (xml_getelement($fl, $field) as $elem) {
		if (!preg_match('/<[^>]*xml:lang\s*=\s*["\'](.*?)["\']/',
		        $elem, $match) || $match[1] == $lang) {
		    if ($alphasort) {
			$lower = strtolower($elem);
			preg_match("/<.*?>(($alpha_prefix)\s+)?(.*?)<\//", $lower, $match);
			$tmp = preg_replace("/aa/", "}", $match[3]);
			$tmp = preg_replace("/[]/", "{", $tmp);
			$tmp = preg_replace("/[]/", "|", $tmp);
			$tmp = preg_replace("/[]/", "}", $tmp);
			$elem = preg_replace("/([\s>])/", " alphasort=\"$tmp\"\\1", $elem, 1);
		    }
		    $res .= $elem;
		}
	    }
	}
    }
    if(preg_match('/(<?xml version[^>]*encoding=)("iso-8859-1")/i', $fl))
        return utf8_encode($res);
    return $res;
}

function function_find($att) {
    if (!($path = $att['path']))
	return "<error>must specify path attr</error>";
    //echo "\nfind_files 1<br>\n";
    return find_files($path, ".", $att);
}

function alphasort_callback($match) {

    $alpha_prefix = 'den|det|et|en|der|die|das|the|a|an';
    $lower = strtolower($match[4]);
    $tmp = preg_replace("/^($alpha_prefix)\s+/", "", $lower);
    $tmp = preg_replace("/aa/", "}", $tmp);
    $tmp = preg_replace("/[]/", "{", $tmp);
    $tmp = preg_replace("/[]/", "|", $tmp);
    $tmp = preg_replace("/[]/", "}", $tmp);
    return "<$match[1] alphasort=\"$tmp\">$match[4]</$match[2]>";
}

function function_search($att) {
    global $document;
    global $debug;

    if (!$att['target'])
	return '<error>No target specified</error>';
    $number = $att['number'] OR $number = 0;
    $start = $att['start'] OR $start = 1;
    $syntax = $att['syntax'] OR $syntax = 'xml';
    $wrap = $att['wrap'];
    $res = '';

    //return '<server host="bagel/gils" status="1"><hits>0</hits></server>';

    $y = yaz_connect($att['target'], array('persistent' => FALSE, 'charset' => 'UTF-8'));
    yaz_range($y, $start, $number);
    yaz_syntax($y, $syntax);

    if ($att['cclquery']) {  // Find CCL fields and parse query
	$cclfields = array();

	if ($arr = xml_getelement($document, 'cclfield')) {
	    foreach ($arr as $elem) {
		if (!preg_match("'<cclfield\s.*fieldname=\"(.*?)\".*>(.*?)<\/cclfield>'", $elem, $match))
		    continue;
		$fieldn = $match[1];
		$val = $match[2];
		$cclfields[$fieldn] = $val;
	    }
	}
	if ($cclfields) {
	    yaz_ccl_conf($y, $cclfields);
	    if (!yaz_ccl_parse($y, $att['cclquery'], $out))
		return '<bad_query/>';
	    $query = $out['rpn'];
	}
	list($pqfprefix) = xml_getelement_content($document, 'pqfprefix');
	list($pqfsuffix) = xml_getelement_content($document, 'pqfsuffix');
	if ($pqfprefix) $query = "$pqfprefix $query";
	if ($pqfsuffix) $query = "$query $pqfsuffix";

	if ($debug)
	    print "<p/>CCL-Query='" . $att['cclquery'] . "', RPN=$query<br/>";
    }
    else
	$query = $att['query'];

    if (!$query)
	return '<no_query/>';

        
    if ( isset( $att['pqfprefix'] ) ) {
      $query = $att['pqfprefix'] . " " . $query;
    }
    
    if ( isset( $att['pqfsuffix'] ) ) {
      $query .= " " . $att['pqfsuffix'];
    }

    //print "<pre/>RPN=$query<pre/>";

    yaz_search($y, 'rpn', $query);
    yaz_wait();
    if (yaz_errno($y))
	return "<error code=\"" . yaz_errno($y) . "\">" . yaz_error($y) .
	       " at target " . $att['target'] . "</error>";

    $hits = yaz_hits($y);

    if ($wrap)
	$res .= "<search>";
    $res .= "<start>$start</start><number>$number</number>";

    $res .= "<server url=\"". $att['target'] . "\" status=\"1\">";
    $res .= "<hits>$hits</hits>";

    $end = $start + $number - 1;
    if ($end > $hits)
	$end = $hits;
    $res .= "<end>$end</end>";

    for ($recno = $start, $count = 1;
                $recno <= $hits && $count <= $number; $recno++, $count++) {
	$res .= "<record offset=\"$recno\"";
	$rec = preg_replace("/<\?.*?\?>/", "", yaz_record($y, $recno, 'string'));
	// removed because it makes ill-formed "&amp;amp;amp;" output
	//$rec = preg_replace("/&/", "&amp;", $rec);
	if (!$rec)
	    $res .= " error=\"No record at that position\">";
	else {
	    if ($att['alphasort']) {
		$fld = $att['alphasort'];

		$rec = preg_replace_callback("/<(($fld)(\s+[^>]*)?)>(.*?)<\/.*?>/", 'alphasort_callback', $rec);
	    }
	    $res .= ">$rec";
	}
	$res .= "</record>";

    }

    $res .= '</server>';
    if ($wrap)
	$res .= "</search>";

    $t = new XML_process_stylesheet($res);
    $res = $t->buf();
    //$res = preg_replace("/&/", "&amp;", $res);
    return $res;
}

function function_mail($att) {
    if (!$att['to'])
	die("No recipient address for mail");
    $extraheaders = "";
    if ( $att['from'] ) {
      $extraheaders = "From: ".$att['from'];
    }
    $result = @mail($att['to'], $att['subject'], utf8_decode(urldecode($att['message'])), $extraheaders);
    if ($result)
	return "<status>OK</status>";
    else
	return "<error>Failed to send mail</error>";
}

function function_session_var($att) {
    if (!$att['name'])
	die("No 'name' given for session-var");
    $name = $att['name'];

    if ($_SESSION[$name] && !$_REQUEST[$name])
	$_REQUEST[$name] = $_SESSION[$name];
    elseif (!$_REQUEST[$name] && $att['default'])
	$_REQUEST[$name] = $att['default'];
    $_SESSION[$name] = $_REQUEST[$name];
}

// This scans any XML document for commands (elements at the top level in the
// http://www.indexdata.dk/TKL namsepace), and calls the associated functions.
// The results are placed in the elements themselves.
class XML_process_stylesheet {

    var $outbuf;      // buffer for XML output
    var $level;       // level in the hierarchy
    var $command_ns;  // prefix for commands
    var $current_tag;
    var $stack;
    var $stackp;
    var $skip;

    var $fun = array (
        'search' => 'function_search',
	'time' => 'function_time',
	'find' => 'function_find',
	'path' => 'function_path',
	'session-var' => 'function_session_var',
	);

    function XML_process_stylesheet($xml) {
	$this->outbuf = '';
	$this->level = -1;
	$this->comand_ns = undef;
	$this->stack = array();
	$this->stackp = -1;
	$this->skip = 0;

	$enc="UTF-8";
        if (preg_match('/<?xml version[^>]*encoding="iso-8859-1"/i', $xml)) {
	    $enc="ISO-8859-1";
        }
	$xp = xml_parser_create($enc);

	xml_parser_set_option($xp, XML_OPTION_CASE_FOLDING, 0);
	xml_parser_set_option($xp, XML_OPTION_TARGET_ENCODING, "UTF-8");
	xml_set_object($xp, &$this);
	xml_set_element_handler($xp, "elem_begin", "elem_end");
	xml_set_default_handler($xp, "default_handler");
	xml_set_character_data_handler($xp, "character_data_handler");
	if (!xml_parse($xp, $xml)) {
	    print "Error parsing stylesheet (line #" . xml_get_current_line_number($xp) . ": " . xml_error_string(xml_get_error_code($xp)) . "; Current element &lt;" . $this->current_tag . "&gt;<br/>";
	    $idx = xml_get_current_byte_index($xp);
	    $start = $idx;
	    $udoc = preg_replace("/</", "&lt;", $xml);	
	    echo preg_replace("/</", "&lt;", substr($xml, 0, $start-1));
	    echo "<b>";
	    echo preg_replace("/</", "&lt;", substr($xml, $start, 1));
	    echo "</b>";
	    echo preg_replace("/</", "&lt;", substr($xml, $start+1, 10000));
	    exit();
        }
	xml_parser_free($xp);
    }

    function default_handler($xp, $data) {
	if ($this->skip)
	    return;
        if ($this->stackp == -1) {
	    $data = preg_replace('/encoding="[-a-zA-Z0-9]+"/', 'encoding="UTF-8"', $data);
	}
	$this->outbuf .= "$data";
    }

    function character_data_handler($xp, $data) {
	if ($this->skip)
	    return;
        $tmp = preg_replace("/&/", '&amp;', $data);
        $tmp = preg_replace("/</", '&lt;', $tmp);
        $tmp = preg_replace("/>/", '&gt;', $tmp);
	$this->outbuf .= "$tmp";
    }

    function elem_end($xp, $elem) {
	$this->level--;
	$this->stackp--;
	if (!$this->skip)
	    $this->outbuf .= "</$elem>";
	if ($this->stackp >= 0)
	    $this->skip = $this->stack[$this->stackp]['skip'];
    }

    // The meat. Dump elements. Make note of namespace prefixes for
    // the 'commands'. Execute commands when found.
    function elem_begin($xp, $elem, $att) {
	global $lang;

	$skip = 0;
	$command_ns = $this->command_ns;
	$this->level++;
	$this->current_tag = $elem;
	if ($this->stackp >= 0 && $this->stack[$this->stackp]['skip'])
	    $skip = 1;
	elseif ($att['xml:lang'] && $att['xml:lang'] != $lang)
	    $skip = 1;
	$this->skip = $skip;
	$this->stackp++;
	$this->stack[$this->stackp] = array('skip' => $skip, 'tag' => $elem);
	if ($skip)
	    return;
	$this->outbuf .= "<$elem";
	if ($att) {
	    foreach ($att as $k => $v) {
		$tmp = preg_replace("/&/", '&amp;', $v);
		$tmp = preg_replace("/</", '&lt;', $tmp);
		$tmp = preg_replace("/>/", '&gt;', $tmp);
		$tmp = preg_replace("/'/", '&apos;', $tmp);
		$tmp = preg_replace("/\"/", '&quot;', $tmp);
	        $this->outbuf .= " $k=\"$tmp\"";

		if ($this->level == 0 || $this->level == 1) {
		    if (preg_match("/^xmlns(:(.+))?/", $k, $match) &&
			               $v == "http://www.indexdata.dk/TKL") {
			$command_ns = $match[2];
			if ($this->level == 0) // global namespace
			    $this->command_ns = $command_ns;
		    }
		}
	    }
	}
	$this->outbuf .= ">";

	if ($this->level == 1 && $command_ns && preg_match(
	       "/^$command_ns:(.*)/", $elem, $res)) {
	    $fun_name = $res[1];
	    if ($this->fun[$fun_name]) {
		$this->outbuf .= $this->fun[$fun_name]($att);
	    } else {
		$this->outbuf .= "<error>No such function: '$fun_name'</error>";
	    }
	}
    }

    function buf() {
	return $this->outbuf;
    }
}


?>
