<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: search.php,v 1.15 2004/06/14 11:51:09 adam Exp $
*/

$zebraidx = "/usr/bin/zebraidx";
$zebrasrv = "/usr/bin/zebrasrv";

function search_stop($path) {
    $pidfile = join('', file("$path/zebrasrv.pid"));
    posix_kill($pidfile, 1);
}

function search_start($path) {
    global $zebrasrv;

    system("cd $path; nohup $zebrasrv -l db/server.log -c db/zebra.cfg unix:db/socket > /dev/null &");
}

function search_index($filename) {
    $document_root = $_SERVER['DOCUMENT_ROOT'];
    global $zebraidx;

    $filename = preg_replace("'/\.'", '', $filename);  // Remove /./ in path

    // in case our argument has superfluous slashes
    $filename = preg_replace("'//'", "/", $filename);

    $fname = preg_replace("'^.*/'", "", $filename);
    $docdir = preg_replace("'/[^/]*$'", "", $filename);
    $localpart = preg_replace("'^$document_root/'", "", $docdir);

    $portroot = '';
    for ($pr = $localpart; $pr; $pr = preg_replace("'/?[^/]*$'", "", $pr)) {
	if (file_exists("$document_root/$pr/tkl.config")) {
	    $portroot = $pr;
	    break;
	}
    }

    $directory = undef;
    for ($pr = $localpart; $pr; $pr = preg_replace("'/?[^/]*$'", "", $pr)) {
        if (file_exists("$document_root/$pr/directory.tkl")) {
	    $directory = join('', file("$document_root/$pr/directory.tkl"));
	    break;
	}
    }
    
    if (!$directory)
	return;
    list ($searchable) = search_xml_getelement($directory, "searchable");
    if (!$searchable || !preg_match("/>\s*(.*?)\s*</", $searchable, $match) || 
	$match[1] != "1")
	return;

    if (!isset($portroot))
	die("Unable to locate portroot for $filename");

    database_prerequisites("$document_root/$portroot");
    $portpath = preg_replace("'^$portroot/'", '', $localpart);
    $cmd = "cd $document_root/$portroot; $zebraidx -L -l db/update.log -c db/zebra.cfg update $portpath";
    system($cmd);
    system("cd $document_root/$portroot; $zebraidx -l db/update.log -c db/zebra.cfg commit");
}

function search_index_all($path, $root = '') {
    global $zebraidx;

    $path = preg_replace("'/$'", "", $path);
    $path = preg_replace("'//'", "/", $path);

    if (!$root) {   // Top
	$root = $path;
	system("cd $root; $zebraidx -l db/update.log -c db/zebra.cfg init");
    }

    if (file_exists("$path/directory.tkl")) {
	$directory = join('', file("$path/directory.tkl"));
	list ($searchable) = search_xml_getelement($directory, "searchable");
	if ($searchable && preg_match("/>\s*(.*?)\s*</", $searchable, $match) && 
	    $match[1] == "1")
	       $search = 1;
    }

    if ($search) {
	database_prerequisites($root);
	$portpath = preg_replace("'^$root(/?)'", '', $path);
	$cmd = "cd $root; $zebraidx -L -l db/update.log -c db/zebra.cfg update $portpath";
	system($cmd);
    }
    else {
	// Recurse
	$d = opendir($path);
	while (false != ($file = readdir($d))) {
	    if (is_dir("$path/$file") && !preg_match("/^\./", $file))
		search_index_all("$path/$file", $root);
	}
	closedir($d);
    }

    if ($root == $path) { // Top
	system("cd $root; $zebraidx -l db/update.log -c db/zebra.cfg commit");
    }
}

$zebra_cfg = 
"# This file is automatically generated by the file search.php. Do not edit.

profilePath: /usr/share/idzebra/tab
recordId: file
storeData: 1
storeKeys: 1
recordType.tkl: grs.xml
register: db/register:1000M
shadow: db/shadow:1000M
lockdir: db/lock
tmpdir: db/tmp
keytmpdir: db/tmp
";

function database_prerequisites($path) {
    global $zebra_cfg;

    if (!is_dir("$path/db"))
	mkdir("$path/db", 0777);
    if (!is_dir("$path/db/register"))
	mkdir("$path/db/register", 0777);
    if (!is_dir("$path/db/shadow"))
	mkdir("$path/db/shadow", 0777);
    if (!is_dir("$path/db/tab"))
	mkdir("$path/db/tab", 0777);
    if (!is_dir("$path/db/lock"))
	mkdir("$path/db/lock", 0777);
    if (!is_dir("$path/db/tmp"))
	mkdir("$path/db/tmp", 0777);
    if (!file_exists("$path/db/zebra.cfg")) {
	$fl = fopen("$path/db/zebra.cfg", 'w');
	fputs($fl, $zebra_cfg);
	fclose($fl);
    }
}

function search_xml_getelement($xml, $element) {
    preg_match_all("/(<$element\s*.*?>\s*.*?\s*<\/$element>)/s", $xml, $res,
   	 PREG_PATTERN_ORDER);
    return $res[1];
}

?>
