<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: hierarchy.php,v 1.18 2005/01/03 10:36:49 marc Exp $
*/
?>
<?php
require "../config.php";
require "../standards.php";
require "../domtools.php";


// setting required parameters
if (!isset($fieldtext) and !strlen($fieldtext)){
  $fieldtext = "";
}
if (!isset($hierarchy_dir) and !strlen($hierarchy_dir)){
  print '<html><body>
     In your scheme you must set the tag <br/>
     &lt;hierarchy_dir>portal/path/to/start/dir&lt;/hierarchy_dir><br/>
     Set also the tags<br/> 
     &lt;hierarchy_filetype>filename.tkl&lt;/hierarchy_filetype><br/>
     &lt;hierarchy_xpath>xpath/to/value/element&lt;/hierarchy_xpath><br/>
     if you have a special configuration on where to find the directory titles.
     The tags<br/> 
     &lt;hierarchy_type>filename.tkl&lt;/hierarchy_type><br/>
     &lt;hierarchy_adddepth>n&lt;/hierarchy_adddepth><br/>
     &lt;hierarchy_leaf>1&lt;/hierarchy_leaf><br/>
     are considered experimental.
    </body></html>';
  exit;
}
if (!isset($hierarchy_filetype) and !strlen($hierarchy_filetype)){
  $hierarchy_filetype = "index.tkl";
}
if (!isset($hierarchy_xpath) and !strlen($hierarchy_xpath)){
  $hierarchy_xpath = "";
}
//if (!isset($hierarchy_type) and !strlen($hierarchy_type)){
//  $hierarchy_type = "full";
//}
if (!isset($hierarchy_adddepth) and !strlen($hierarchy_adddepth)){
  $hierarchy_adddepth = 1;
}
//if (!isset($hierarchy_leaf) and !strlen($hierarchy_leaf)){
//  $hierarchy_leaf = 0;
//}


$doc_root = "";
find_portal_root();
$doc_root = "/" . $doc_root;
$hier_portal_dir = $doc_root . "/" . $hierarchy_dir;
$hier_server_dir = total_path($hier_portal_dir);

// if we stand somewhere in  $hierarchy_dir, use $cwd as starting point, 
// else use $hierarchy_dir as starting point
$hier_server_cwd = $hier_server_dir;
if (isset($cwd)) {
  $found = strpos($cwd,$hier_portal_dir);
  if (is_int($found) && (0 == $found)) {
    $hier_server_cwd = total_path($cwd);
  }
}


$xml_file_hierarchy = dir_hierarchy($hier_server_dir);

print_xhtml($xml_file_hierarchy);


// ------------ function definitions --------------


function html_get_parameters($new_cwd){
  global $fieldid, $cwd, $fieldtype, 
    $hierarchy_dir, $hierarchy_filetype,  $hierarchy_leaf, $hierarchy_xpath;
  
  $parameter = "";
  $parameter .= "?fieldid=$fieldid";
  //$parameter .= "&amp;xpath=$xpath";
  if (isset($new_cwd) and strlen($new_cwd)) {
    $parameter .= "&amp;cwd=$new_cwd";
  } else {
    $parameter .= "&amp;cwd=$cwd";
  }
  //$parameter .= "&amp;fieldtype=$fieldtype";
  $parameter .= "&amp;hierarchy_dir=$hierarchy_dir";
  if (isset($hierarchy_filetype) and strlen($hierarchy_filetype)) {
    $parameter .= "&amp;hierarchy_filetype=$hierarchy_filetype";
  }
  if (isset($hierarchy_xpath) and strlen($hierarchy_xpath)) {
    $parameter .= "&amp;hierarchy_xpath=$hierarchy_xpath";
  }
  if (isset($hierarchy_type) and strlen($hierarchy_type)) {
    $parameter .= "&amp;hierarchy_type=$hierarchy_type";
  }
  if (isset($hierarchy_adddepth) and strlen($hierarchy_adddepth)) {
    $parameter .= "&amp;hierarchy_adddepth=$hierarchy_adddepth";
  }
  if (isset($hierarchy_leaf) and strlen($hierarchy_leaf)) {
    $parameter .= "&amp;hierarchy_leaf=$hierarchy_leaf";
  }
  return $parameter;
}  

function html_href($new_cwd){
  global $PHP_SELF;
  return  $PHP_SELF . html_get_parameters($new_cwd);
}


function total_path($doc_root_path) {
  return $_SERVER['DOCUMENT_ROOT'] . $doc_root_path;
}


function doc_root_path($total_path) {
  return str_replace($_SERVER['DOCUMENT_ROOT'], "", $total_path);
}

function calculate_indent($int) {
  $indent = "";
  //$indent .= $int;
  if (0 < $int) {
    for ($i = 0; $i < $int; $i++){
      //$indent .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
      $indent .= "|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    }
    //$indent .= "&#x21b3;";
    $indent .= "|->&nbsp;";
  }
    return $indent;
}


function dir_hierarchy ($dir) {
  global $hier_server_dir, $hierarchy_adddepth;
  
  if (!strlen($dir)) {
    return 0;
  }
  $dirs = array();
  add_recursive_dirs(&$dirs, $hier_server_dir, 0, $hierarchy_adddepth);
  
  return $dirs;
}

function add_recursive_dirs ($dirs, $dir, $depth, $add_depth){
  global $fieldtext, $hier_server_cwd, $hierarchy_adddepth;
  
  $add_dir = false;
  $hier_in_dir = (0 === strpos($dir, $hier_server_cwd)) ;
  $dir_in_hier = (0 === strpos($hier_server_cwd, $dir)) ; 
  //print "dir:             $dir <br/>\n";
  //print "hier_server_cwd: $hier_server_cwd <br/>\n";
  //print "hier_in_dir:       $hier_in_dir <br/>\n";
  //print "dir_in_hier:       $dir_in_hier <br/>\n";
  //print "depth:           $depth <br/>\n";
  //print "add_depth:       $add_depth <br/>\n";
  //print "<br/>\n";
  
  
  if (0 >= (int)$hierarchy_adddepth) {
    //print("AAA '$hierarchy_adddepth'<br/>");
    // show all directories if long directory listing 
    $add_dir = true;
  } else {
    //print("BBB '$hierarchy_adddepth'<br/>");
    // show short directory listing
     if ($dir_in_hier) {
       // show always all dirs towards portal path
       $add_dir = true;
     }
     if ($hier_in_dir && $add_depth >= 0) {
       // show only dirs towards leaves if add_depth count is not down to zero
       $add_depth -= 1;
       $add_dir = true;
     }
  }
      
      
  if ($add_dir) {
    // get this directory information 
    $info = get_hierarchy_info($dir);
    if (is_array($info)){
      $info['indent'] = calculate_indent($depth);
      // send information back to editor and mark dir as current dir
      if ($dir == $hier_server_cwd) {
	$fieldtext = $info["value"];
	$info["current"] = 1;
      }
      $dirs[] = $info;
    }

    // get index in array of directories
    $dir_index = count($dirs) - 1;
    
    // recurse to subdirs
    if ($dh = @opendir($dir)) {
      while (strlen($entry = readdir($dh))) {
	if ( "." == $entry or ".." == $entry or "CVS" == $entry ){
	  continue;
	}
        // there are subdirs 
	if (is_dir("$dir/$entry")) {
          // that means that the last added dir in dirs is _not_ a leaf dir
          $dirs[$dir_index]['leaf'] = 0;
          // recursively descent into subdirs
	  add_recursive_dirs (&$dirs, "$dir/$entry", $depth +1, $add_depth);
	}
      }
      closedir($dh);
    } else {
      $dirs['error'] .=  $dir . " ";
    }
  }
}

function get_hierarchy_info ($dir) {
  global $doc_root, $hierarchy_dir, $hierarchy_filetype, $hierarchy_xpath;

  $xml_file = $dir . "/" . $hierarchy_filetype;
  $hierarchy_info = array();
  //$hierarchy_info['path'] = $dir;
  $hierarchy_info['path'] = doc_root_path($dir);
  $hierarchy_info["current"] = 0;
  $hierarchy_info["leaf"] = 1;

  //print($dir . "<br/>");
  //print(doc_root_path($dir) . "<br/>");

  if ( !($dom = @domxml_open_file($xml_file))) {
    return 0;
  } else {
    $root = $dom->document_element();

    // get title info from $hierarchy_filetype
    $titlenodes = get_elements_by_tagname($root, "title");
    if (isset($titlenodes[0]) 
	and ($title = (get_content($titlenodes[0])))){
      $hierarchy_info['title'] = $title;
    }
	
    $value='';
    if (strlen($hierarchy_xpath)) {
      $node_xpath = explode("/", $hierarchy_xpath);
      $root_name = array_shift($node_xpath);

      // check  $hierarchy_filetype is $hierarchytype
      if (!($root_name == $root->tagname())) {
	//print("Root tagname should be:" . $hierarchytype 
	//. "was:" . $root->tagname());
	return 0;
      }
      
      // go recursively down to xpath in $hierarchy_xpath
      $subnode = $root;
      foreach ($node_xpath as $nodestring) {
	$subnodes =  get_elements_by_tagname($subnode, $nodestring);
	if (!isset($subnodes[0])) {
	  return 0;
	}
	$subnode = $subnodes[0];  
      }
      
      // finally, get value of last subnode
      if (!($value = get_content($subnode))) {
	return 0;
      }
      $hierarchy_info["value"] = $value;
    }
    else {  // no xpath given - take portal dir path as value
      //$value = str_replace($_SERVER['DOCUMENT_ROOT'] . $doc_root, "", $dir);
      //$value = $dir;
      $hierarchy_info["value"] 
        = str_replace($doc_root ."/", "", $hierarchy_info["path"]);
    }

    // got all, return
    return $hierarchy_info;
  }
}


function print_debug_get_parameters() {
  global $_GET;
  if (is_array($_GET)) {
    print("      <h2>GET Parameter Listing</h2>\n");
    print("        <table>\n");
      print("          <tr>");
      print("<th>parameter</th>");
      print("<th>value</th>");
      print("</tr>\n");
    foreach ($_GET as $key => $value) {
      print("          <tr>");
      print("<td>");
      print($key);
      print("</td>");
      print("<td>");
      print($value);
      print("</td>");
      print("</tr>\n");
    }
    print("        </table>\n");
  }
}

function print_debug_hier_dirs(){
  global $doc_root, $cwd, 
     $hierarchy_dir, $hier_portal_dir, $hier_server_dir, $hier_server_cwd;
  print("<h2>Dir variables</h2>\n");
  print("root: $root <br/>\n");
  print("doc_root: $doc_root <br/>\n");
  print("hierarchy_dir: $hierarchy_dir <br/>\n");
  print("hier_portal_dir: $hier_portal_dir <br/>\n");
  print("hier_server_dir: $hier_server_dir <br/>\n");
  print("cwd: $cwd <br/>\n");
  print("hier_server_cwd: $hier_server_cwd <br/>\n");
}

function print_debug_hierarchy($hier) {
  
  if (is_array($hier) and isset($hier[0])) {
    print("      <h2>Hierarchy Listing</h2>\n");
    print("        <table>\n");
    print("          <tr>");
    foreach ($hier[0] as $key => $value) {
      print("<th>");
      print($key);
      print("</th>");
    }
    print("<th>Link</th>");

    print("</tr>\n");
    foreach($hier as $entry) {
      print("          <tr>");
      foreach ($entry as $key => $value) {
	print("<td>");
	print($value);
	print("</td>");
      }
      print("<td><a href=". html_href($entry['path']) . ">Browse</a></td>"); 
      print("</tr>\n");
      //print("<tr><td>". html_href($entry['path']) . "</td></tr>"); 
    }
    print("        </table>\n");
  }
}

function print_hierarchy($hier) {
  global $fieldid, $hierarchy_adddepth, $hierarchy_leaf;
  
  if (is_array($hier) and isset($hier['error'])) {
    print("      <h2>Error</h2>\n");
    print("      Could not open directory " . $hier['error'] . "<br/>\n");
  }
  
  $dark = false;
  
  if (is_array($hier) and isset($hier[0])) {
    print("        <table>\n");
    print("          <tr>");
    print("<th>Hierarchy</th>");
    print("<th>Send</th>");
    print("</tr>\n");
    foreach($hier as $entry) {
      if ($dark = !$dark){ 
	print("          <tr class='dark'>");
      } else {
	print("          <tr>");
      }
	  
      print("<td>");
      if ((0 >= (int)$hierarchy_adddepth) || $entry['leaf']){
	// printing full hierarchy, or leaf nodes - no anchors
	print("<b>" . $entry['indent'] . $entry['title'] . "&nbsp;&nbsp;<b/>");
      } else {
        // printing partial hierarchy - anchors and navigation hint
	print($entry['indent'] 
	      . "<a href=" . html_href($entry['path']) . "><b>" 
	      . $entry['title'] . "&nbsp;&nbsp;</b></a>");
      }
      print( "</td>");

      //print("<td>"); 
      //print($entry['value']);
      //print("</td>");

        // print OK button if leaf, or if not leaf and not $hierarchy_leaf set
      if (!isset($hierarchy_leaf) || 1 != $hierarchy_leaf 
          || $entry['leaf']) {  
        print("<td>");
        print '<input type="submit" value="OK"' 
          . ' onclick="send_and_close(\'' . $fieldid 
          . '\', \'' . $entry['value'] . '\', \'' 
          . $entry['value'] . ' -> ' . $entry['title'] . '\' )">';
        print("</td>");
      }

      //print("<td><a href=". html_href($entry['path']) . ">Browse</a></td>"); 
      print("</tr>\n");
      //print("<tr><td>". html_href($entry['path']) . "</td></tr>"); 
    }
    print("        </table>\n");
  }
}


function print_xhtml($xml_file_hierarchy) 
{
  global $fieldtext, $fieldid;

  header("Content-Type: text/html; charset=utf-8");
  print '<?xml version="1.0" encoding="UTF-8"?>
  <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" 
                      "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
  <html>
  <head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <title>Keystone Hierarchy Browser</title>
  <link rel="stylesheet" type="text/css" href="../admin/admin.css">
  <script language="JavaScript">
    ';
  print "
  function close_n_exit () {
    update_content();
    close();
  }

  function update_content () {
    if ('' != '$fieldtext')
      {
        for (var i = 0; i<this.opener.document.main.elements.length; i++) 
	  {
	    if (this.opener.document.main.elements[i].id 
	        == '$fieldid') 
	      {
	        this.opener.document.main.elements[i].value 
		  = '$fieldtext';
	      }
	  }
      }
  }

  function send_and_close (strid, strvalue, strdisplay) {
    if ('' != strvalue)
      { if (input_elm = this.opener.document.getElementById(strid)){
           input_elm.value = strvalue;
        }
        if (text_elm = this.opener.document.getElementById('text_' + strid)){
           if ('' != strdisplay) {
              text_elm.innerHTML = strdisplay;
           } else {
              text_elm.innerHTML = strvalue;
           }
        }
      }
    close();
  }
    ";
  

  print '
  </script>

  </head>
  <body>
    <div id="hierarchy" class="hierarchy">
      <h2>Keystone Hierarchy Browser</h2>
  ';

  //print_debug_hier_dirs();
  //print_debug_get_parameters();
  //print_debug_hierarchy($xml_file_hierarchy);
  print_hierarchy($xml_file_hierarchy);

  print '
      <p>
        <input type="button" value="Cancel" onClick="window.close()">
      </p> 

    </div>
  </body>
  </html>
  ';

  //        <input type="submit" value="Submit" onclick="close_n_exit()">
//     print '
//       <p>
//         <input type="submit" value="' . $fieldtext . '" 
//                onclick="send_and_close(\'' . $fieldid . '\', \'' . $fieldtext . '\' )">
//       </p> 

}

