<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: schema-editor.php,v 1.31 2006/05/08 08:57:37 sondberg Exp $
*/

require("config.php");
require("standards.php");
find_portal_root();
$this_user = check_auth_user();

$typeArray = array (
    "text" => array( "da" =>"Text", "en" => "Text", "el" => "Text"),
    "dropdown" =>  array( "da" =>"Dropdown", "en" => "Drop down", "el" => "Drop down"),
    "textarea" =>  array( "da" =>"Textarea", "en" => "Text area", "el" => "Text area"),
    "radiobutton" =>  array( "da" =>"Radio button", "en" => "Radio button", "el" => "Radio button"),
    "checkbox" =>  array( "da" =>"Check box", "en" => "Check box", "el" => "Check box"),
    "date" =>  array( "da" =>"Dato felt", "en" => "Date field", "el" => "Date field"),
    "url" =>  array( "da" =>"URL felt", "en" => "URL field", "el" => "URL field"),
    "password" =>  array( "da" =>"Password felt", "en" => "Password field", "el" => "Password field"),
    "hidden" =>  array( "da" =>"Skjult felt", "en" => "Hidden field", "el" => "Hidden field"),
    "upload" =>  array( "da" =>"Fil upload", "en" => "File upload", "el" => "File upload")
);

?>
<HTML>
<HEAD>
    <TITLE>Schema editor</TITLE>
    <link href="admin/xform.css" rel="stylesheet" type="text/css" media="screen, all" />
    <link rel="author" href="http://www.indexdata.dk" />
    <script language="JavaScript">
        <!--
        function submitIt (action,nummer,level) {
        	document.schema.action.value = action;
        	document.schema.nummer.value = nummer;
        	document.schema.level.value = level;
        	document.schema.submit();
     	}
        //-->
    </script>
    <script language="JavaScript1.1"><!--
    function validateValues(what) {
        var valid = true;
        var checkBoxes = false;
        var checkboxChecked = false;

        var radioButtons = false;
        var radioChecked = false;
        var newField = false;

        for (var i=0, j=what.elements.length; i<j; i++) {
            myType = what.elements[i].type;
            baseName = what.elements[i].name.replace(/[^a-zA-Z]+/g,'');
            if (myType == 'radio') {
                radioButtons = true;
                if (what.elements[i].checked) {
                    radioChecked = true;
                }
            }
            if (myType == 'checkbox') {
                checkBoxes = true;
                if (what.elements[i].checked) {
                    checkboxChecked = true;
                }
            }
            var field1 = /\BauthoriZURL\B/;
            var field2 = /\Balloweddata\B/;
            var result1 = baseName.match(field1);
            var result2 = baseName.match(field2);
            if (myType == 'text' || myType == 'textarea') {
                if (result1 != null || result2 != null) {
                    continue;
                } else {
                    if (what.elements[i].value == "") {
                        valid = false;
                    }
                }
            }
            if (myType == 'select-one' || myType == 'select-multiple') {
                if (baseName == 'fieldtype') {
                    if (what.elements[i].selectedIndex == 0) {
                        valid = false;
                    }
                    newField = true;
                }
            }
        }

        if ((checkBoxes && !checkboxChecked) || (radioButtons && !radioChecked)) {
//            valid = false;
        }

        if (!valid) {
            if (!newField) {
                alert('Felterne er ikke udfyldt korrekt!\n Alle felter skal være udfyldt.');
            } else {
                alert('Felterne er ikke udfyldt korrekt!\n Alle eksisterende felter skal være udfyldt og for nyoprettede felter skal, Feltnavn, XML feltnavn, Felttype og Hjælpetekst udfyldes');
            }
        } else {
            document.schema.save.value=1;
            document.schema.submit()
        }
        return valid;
    }
    //--></script>
</HEAD>
<BODY>
<?php
foreach (array_merge($_POST,$_GET) as $name => $value) {
    $$name = $value;
}

if ($filename != "") {
     $path_parts = pathinfo($filename);
    if ($path != "") {
        $filename = $path."/".$recordtype.".xsd";
    } elseif ($path_parts["extension"] != "xsd") {
        $path = rtrim($filename, "/");
        $filename = "";
    }
} else {
    if ($recordtype != "") {
       $filename = $recordtype.".xsd";
    }
}

$viewXSD = 0;
$i = 0;
$fieldnames = array('fieldname','XMLfieldname','mandatory','fieldtype','alloweddata','helptext','langdep','searchable','authoriZURL', 'repeatable');
$parseResult = array();

function stripNamespace($string) {
    list($namespace,$name)= split (":", $string, 2);
    if ($name == "") {
        return $string;
    } else {
        return $name;
    }
}


function htmlIndent ($level) {
    global $HTMLindent;
    while ($level >= 1) {
        $outstring = $outstring.$HTMLindent;
        $level--;
    }
    return $outstring;
}

function indent ($level) {
    global $indent;
    while ($level > 0) {
        $outstring = $outstring.$indent;
        $level--;
    }
    return $outstring;
}

function set_checkbox ($type) {
    if ($type['attr']['minOccurs']['value'] > 0) {
        $checked[min] = "CHECKED";
    }
    if ($type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['langdep'][0]['value']) {
        $checked[lang] = "CHECKED";
    }
    if ($type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['searchable'][0]['value'] == "1") {
        $checked[search] = "CHECKED";
    }
    if ($type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['repeatable'][0]['value'] == "1") {
       $checked[repeat] = "CHECKED";
    }
    return $checked;
}

function make_buttons($i, $htmlPath, $level, $type="field") {
   global $antal, $newfield, $filename, $action;
   if ($newfield || !$filename || $action == "subfield" || $action == "attributes" || $action == "choice") {
        return "";
    }
    $nextFieldname = "fieldname". $i + 1;
    if ($i > 0) {
        $outstring = "<a href=\"javascript:submitIt('up','".$htmlPath."','$level');\" title=\"Ryk dette felt op\">".trans_text("11")."</a><br>\n";
    }
    if ($i != $antal - 1) {
        $outstring .= "<a href=\"javascript:submitIt('down','".$htmlPath."','$level');\" title=\"Ryk dette felt ned\">".trans_text("12")."</a><br>\n";
    }
    $outstring .= "<a href=\"javascript:submitIt('delete','".$htmlPath."','$level');\" title=\"Slet dette felt\">".trans_text("13")."</a><br>\n";
    if ($type != "attribute") {
        $outstring .= "<a href=\"javascript:submitIt('subfield','".$htmlPath."[subfield]','$level');\" title=\"Opret et underfelt under dette felt\">".trans_text("14")."</a><br>\n";
        $outstring .= "<a href=\"javascript:submitIt('choice','".$htmlPath."[choice]','$level');\" title=\"Opret et choice-underfelt under dette felt\">".trans_text("24")."</a><br>\n";
        $outstring .= "<a href=\"javascript:submitIt('attributes','".$htmlPath."[attributes]','$level');\" title=\"Knyt attributter til dette felt\">".trans_text("15")."</a>\n";
// Here goes the UTF-8 branch conflict...
//$outstring .= "<a href=\"javascript:submitIt('down','".$htmlPath."','$level');\" title=\"Ryk dette felt ned\">".trans_text("12")."</a><br>\n";
//    }
//    $outstring .= "<a href=\"javascript:submitIt('delete','".$htmlPath."','$level');\" title=\"Slet dette felt\">".trans_text("13")."</a><br>\n";
//    if ($type != "attribute") {
//        $outstring .= "<a href=\"javascript:submitIt('subfield','".$htmlPath."[subfield]','$level');\" title=\"Opret et underfelt under dette felt\">".trans_text("14")."</a><br>\n";
////        $outstring .= "<a href=\"javascript:submitIt('choice','".$htmlPath."[choice]','$level');\" title=\"Opret et choice-underfelt under dette felt\">".trans_text("24")."</a><br>\n";
//        $outstring .= "<a href=\"javascript:submitIt('attributes','".$htmlPath."[attributes]','$level');\" title=\"Knyt attributter til dette felt\">".trans_text("15")."</a>\n";
//>>>>>>> 1.22.2.1
}
return $outstring;
}

function make_text($type, $level, $formPath, $i) {
$checked = set_checkbox ($type);
make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], "text", $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authorizurl']['value'], "", $level, $formPath, $i);
}

function make_textarea($type, $level, $htmlPath, $i) {
$checked = set_checkbox ($type);
make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], "textarea", $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authorizurl']['value'], "", $level, $htmlPath, $i);
}

function make_dropdown($type, $level, $htmlPath, $i) {
$checked = set_checkbox ($type);
make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], "dropdown", $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authorizurl']['value'], "", $level, $htmlPath, $i);
}

function make_radiobutton($type, $level, $htmlPath, $i) {
$checked = set_checkbox ($type);
make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], "radiobutton", $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authorizurl']['value'], "", $level, $htmlPath, $i);
}

function make_date($type, $level, $htmlPath, $i) {
$checked = set_checkbox ($type);
make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], "date", $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authorizurl']['value'], "", $level, $htmlPath, $i);
}

function make_url($type, $level, $htmlPath, $i) {
$checked = set_checkbox ($type);
make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], "url", $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authorizurl']['value'], "", $level, $htmlPath, $i);
}

function make_password($type, $level, $htmlPath, $i) {
$checked = set_checkbox ($type);
make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], "password", $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authorizurl']['value'], "", $level, $htmlPath, $i);
}

function make_hidden($type, $level, $htmlPath, $i) {
$checked = set_checkbox ($type);
make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], "hidden", $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authorizurl']['value'], "", $level, $htmlPath, $i);
}

function make_complex($type, $level, $htmlPath, $i) {
$checked = set_checkbox ($type);
make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], "complex", $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authorizurl']['value'], "", $level, $htmlPath, $i);
}

function make_type_dropdown ($fieldtype="") {
global $typeArray, $lang;
echo "<option value=\"\">".trans_text("23")."\n";
foreach ($typeArray as $value => $langArray) {
    if ($fieldtype == $value) {
	echo "    <option value=\"$value\" selected>$langArray[$lang]\n";
    } else {
	echo "    <option value=\"$value\">$langArray[$lang]\n";
    }
}
}

function make_new($Xpath="", $level=1, $i=0) {
echo "<tr name=\"new\"><td>".htmlIndent($level).trans_text("2").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][fieldname][value]\" value=\"\"></td>\n";
echo "<td rowspan=4 align=\"center\"><input type=\"checkbox\" name=\"f".$Xpath."[$i][mandatory][value]\" value=1><br><small>".trans_text("7")."</small><br><input type=\"checkbox\" name=\"f".$Xpath."[$i][searchable][value]\" value=1 $searchcked><br><small>".trans_text("8")."</small></TD>
    <td rowspan=4 align=\"center\"><input type=\"checkbox\" name=\"f".$Xpath."[$i][langdep][value]\" value=1><br><small>".trans_text("9")."</small><br><input type=\"checkbox\" name=\"f".$Xpath."[$i][repeatable][value]\" value=1 $repeadchecked><br><small>".trans_text("10")."</small></TD></TR>\n";
echo "<TR>
	<TD>".htmlIndent($level).trans_text("3").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][XMLfieldname][value]\" value=\"\"><br></TD></TR>\n";
echo "<tr><td>".htmlIndent($level).trans_text("22").": </td><td>".htmlIndent($level)."
	    <select class=\"forminput\" name=\"f".$Xpath."[$i][fieldtype][value]\">\n";
	    make_type_dropdown ();
echo "
	    </select>
	</td>
    </TR>\n";
echo "<TR><TD>".htmlIndent($level).trans_text("6").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][helptext][value]\" value=\"\"></TD></TR>\n";
echo "<TR><TD>".htmlIndent($level).trans_text("5").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][authoriZURL][value]\" value=\"\"></TD></TR>\n";
echo "<tr><td colspan=\"5\" style=\"line-height: 11px;\" class=\"dotted\">&nbsp;</td></TD></TR>\n\n";
$i++;
}

function make_choice($Xpath="", $level=1, $i=0) {
echo "<tr name=\"new\"><td>".htmlIndent($level).trans_text("2").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][fieldname][value]\" value=\"\"></td>\n";
echo "<td rowspan=4 align=\"center\"><input type=\"checkbox\" name=\"f".$Xpath."[$i][mandatory][value]\" value=1><br><small>".trans_text("7")."</small><br><input type=\"checkbox\" name=\"f".$Xpath."[$i][searchable][value]\" value=1 $searchcked><br><small>".trans_text("8")."</small></TD>
    <td rowspan=4 align=\"center\"><input type=\"checkbox\" name=\"f".$Xpath."[$i][langdep][value]\" value=1><br><small>".trans_text("9")."</small><br><input type=\"checkbox\" name=\"f".$Xpath."[$i][repeatable][value]\" value=1 $repeadchecked><br><small>".trans_text("10")."</small></TD></TR>\n";
echo "<TR>
	<TD>".htmlIndent($level).trans_text("3").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][XMLfieldname][value]\" value=\"\"><br></TD></TR>\n";
echo "<tr><td>".htmlIndent($level).trans_text("22").": </td><td>".htmlIndent($level)."
	    <select class=\"forminput\" name=\"f".$Xpath."[$i][fieldtype][value]\">\n";
	    make_type_dropdown ();
echo "
	    </select>
	</td>
    </TR>\n";
echo "<TR><TD>".htmlIndent($level).trans_text("6").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][helptext][value]\" value=\"\"></TD></TR>\n";
echo "<TR><TD>".htmlIndent($level).trans_text("5").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][authoriZURL][value]\" value=\"\"></TD></TR>\n";
echo "<tr><td colspan=\"5\" style=\"line-height: 11px;\" class=\"dotted\">&nbsp;</td></TD></TR>\n\n";
$i++;
}

function make_attributes($Xpath="", $level=1, $i=0) {
echo "<tr><td>".htmlIndent($level).trans_text("16").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][fieldname][value]\" value=\"\"></td>\n";
echo "<td rowspan=4 align=\"center\"><input type=\"checkbox\" name=\"f".$Xpath."[$i][mandatory][value]\" value=1><br><small>".trans_text("7")."</small><br><input type=\"checkbox\" name=\"f".$Xpath."[$i][searchable][value]\" value=1 $searchcked><br><small>".trans_text("8")."</small></TD>
    <td rowspan=4 align=\"center\">&nbsp;</TD></TR>\n";
echo "<TR>
	<TD>".htmlIndent($level).trans_text("17").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][XMLfieldname][value]\" value=\"\"><br></TD></TR>\n";
echo "<tr><td>".htmlIndent($level).trans_text("4").": </td><td>".htmlIndent($level)."
	    <select class=\"forminput\" name=\"f".$Xpath."[$i][fieldtype][value]\">";
	    make_type_dropdown ();
echo "
	    </select>
	</td>
    </TR>\n";
echo "<TR><TD>".htmlIndent($level).trans_text("6").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][helptext][value]\" value=\"\"></TD></TR>\n";
echo "<TR><TD>".htmlIndent($level).trans_text("5").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$Xpath."[$i][authoriZURL][value]\" value=\"\"></TD></TR>\n";
echo "<tr><td colspan=\"5\" style=\"line-height: 11px;\" class=\"dotted\">&nbsp;</td></TD></TR>\n\n";
$i++;
}

function make_default() {
global $mandatory_fields, $path;
echo "<tr><td>Navnet på denne dokumenttype: </td><td><input type=\"text\" class=\"forminput\" name=\"recordtype\" value=\"\"></td></TR>";
echo "<input type=\"hidden\" name=\"path\" value=\"$path\">";
echo "<tr><td>Beskrivelse: </td><td><input type=\"text\" class=\"forminput\" name=\"fieldname\" value=\"\"></td></TR>
<tr><td colspan=\"5\" style=\"line-height: 11px;\" class=\"dotted\">&nbsp;</td></TD></TR>\n\n";
foreach ($mandatory_fields as $i => $field) {
    make_formHTML ($field[0], $field[1], $field[2], $field[3], $field[4], $field[5], $field[6], $field[7], "", "", "", "", $i);
}
}

function make_formHTML ($fieldnamevalue, $minchecked, $searchcked, $langchecked, $repeadchecked, $XMLfieldname, $fieldtype, $helptext, $authoriZURL="", $alloweddata="", $level="", $formPath="", $i) {
echo "<tr><td>".htmlIndent($level).trans_text("2").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$formPath."[$i][fieldname][value]\" value=\"$fieldnamevalue\"></td>\n";
echo "<td rowspan=4 align=\"center\"><input type=\"checkbox\" name=\"f".$formPath."[$i][mandatory][value]\" value=1 $minchecked><br><small>".trans_text("7")."</small><br><input type=\"checkbox\" name=\"f".$formPath."[$i][searchable][value]\" value=1 $searchcked><br><small>".trans_text("8")."</small></TD>
<td rowspan=4 align=\"center\"><input type=\"checkbox\" name=\"f".$formPath."[$i][langdep][value]\" value=1 $langchecked><br><small>".trans_text("9")."</small><br><input type=\"checkbox\" name=\"f".$formPath."[$i][repeatable][value]\" value=1 $repeadchecked><br><small>".trans_text("10")."</small></TD>\n";
echo "<td rowspan=3>" .make_buttons($i, $formPath."[$i][XMLfieldname]", $level). "</td></tr>\n";
echo "<tr><td><small>".htmlIndent($level).trans_text("3").": </small></td><td><small>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$formPath."[$i][XMLfieldname][value]\" value=\"$XMLfieldname\"></small></td></tr>\n";
echo "<tr><td><small>".htmlIndent($level).trans_text("22").": </small></td><td><small>".htmlIndent($level)."
<select class=\"forminput\" name=\"f".$formPath."[$i][fieldtype][value]\">\n";
	    make_type_dropdown ($fieldtype);
echo "    </select>
       </small></td><tr>\n";
if ($authoriZURL != "") {
    echo "<TR><TD><small>".htmlIndent($level).trans_text("5").": </small></td><td><small>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$formPath."[$i][authoriZURL][value]\" value=\"$authoriZURL\"></small></td><tr>\n";
}
echo "<TR><TD><small>".htmlIndent($level).trans_text("6").": </small></td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$formPath."[$i][helptext][value]\" value=\"$helptext\">
</TD></TR>\n";
echo "<tr><td colspan=\"5\" style=\"line-height: 11px;\" class=\"dotted\">&nbsp;</TD></TR>\n\n";
$i++;
}

function make_attr_formHTML ($fieldnamevalue, $minchecked, $searchcked, $langchecked, $repeadchecked, $XMLfieldname, $fieldtype, $helptext, $authoriZURL="", $alloweddata="", $level="", $formPath="", $i) {
echo "<tr><td>".htmlIndent($level).trans_text("16").": </td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$formPath."[$i][fieldname][value]\" value=\"$fieldnamevalue\"></td>\n";
echo "<td rowspan=4 align=\"center\"><input type=\"checkbox\" name=\"f".$formPath."[$i][mandatory][value]\" value=1 $minchecked><br><small>".trans_text("7")."</small><br><input type=\"checkbox\" name=\"f".$formPath."[$i][searchable][value]\" value=1 $searchcked><br><small>".trans_text("8")."</small></TD>
<td rowspan=4 align=\"center\">&nbsp;</TD>\n";
echo "<td rowspan=3>" .make_buttons($i, $formPath."[$i][XMLfieldname]", $level, "attribute"). "</td></tr>\n";
echo "<tr><td><small>".htmlIndent($level).trans_text("17").": </small></td><td><small>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$formPath."[$i][XMLfieldname][value]\" value=\"$XMLfieldname\"></small></td></tr>\n";
echo "<tr><td><small>".htmlIndent($level).trans_text("4").": </small></td><td><small>".htmlIndent($level)."
<select class=\"forminput\" name=\"f".$formPath."[$i][fieldtype][value]\">\n";
make_type_dropdown ($fieldtype);
echo "    </select>
       </small></td><tr>\n";
if ($authoriZURL != "") {
    echo "<TR><TD><small>".htmlIndent($level).trans_text("5").": </small></td><td><small>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$formPath."[$i][authoriZURL][value]\" value=\"$authoriZURL\"></small></td><tr>\n";
}
echo "<TR><TD><small>".htmlIndent($level).trans_text("6").": </small></td><td>".htmlIndent($level)."<input type=\"text\" class=\"forminput\" name=\"f".$formPath."[$i][helptext][value]\" value=\"$helptext\"></TD></TR>\n";
echo "<tr><td colspan=\"5\" style=\"line-height: 11px;\" class=\"dotted\">&nbsp;</TD></TR>\n\n";
$i++;
}

function pickFieldname ($key) {
$key = strtolower($key);
if (!strstr($key,"xmlfieldname") ) {
    return 0;
} else  {
    return 1;
}
}

function saveField ($fileid, $f, $level=1, $type="") {
global $languages;

foreach ($f as $i => $fieldArray) {
    if (!is_array($fieldArray)) {
	continue;
    }
    foreach ($fieldArray as $arrayFieldName =>$subarray) {
	foreach ($subarray as $treeType => $xxx) {
	    if ($treeType == "value") {
		if ($f[$i]['XMLfieldname']['value'] == "" || $arrayFieldName != "XMLfieldname") {
		    continue;
		}
		if ($f[$i]['langdep']['value']) {
		    $f[$i]['mandatory']['value'] = count($languages);
		} elseif (!$f[$i]['mandatory']['value']) {
		    $f[$i]['mandatory']['value'] = 0;
		}
		if ($f[$i]['langdep']['value'] && $f[$i]['repeatable']['value'] == "") {
		    $f[$i]['maxoccures']['value'] = count($languages);
		} elseif($f[$i]['repeatable']['value'] != "") {
		    $f[$i]['maxoccures']['value'] = unbounded;
		} else {
		    $f[$i]['maxoccures']['value'] = 1;
		}
		if ($type == "attributes") {
		    fputs ($fileid, "  <xs:attribute name=\"".$f[$i]['XMLfieldname']['value']."\" type=\"xs:string\">\n");
		} else {
		    if (is_array($subarray['attributes']) || is_array($subarray['subfield'])) {
			fputs ($fileid, "  <xs:element name=\"".$f[$i]['XMLfieldname']['value']."\" minOccurs=\"".$f[$i]['mandatory']['value']."\" maxOccurs=\"".$f[$i]['maxoccures']['value']."\">\n");
		    } elseif ($f[$i]['fieldtype']['value'] == "textarea") {
			fputs ($fileid, "  <xs:element name=\"".$f[$i]['XMLfieldname']['value']."\" type=\"xs:anyType\" minOccurs=\"".$f[$i]['mandatory']['value']."\" maxOccurs=\"".$f[$i]['maxoccures']['value']."\">\n");
		    } elseif ($f[$i]['fieldtype']['value'] == "date") {
			fputs ($fileid, "  <xs:element name=\"".$f[$i]['XMLfieldname']['value']."\" type=\"xs:date\" minOccurs=\"".$f[$i]['mandatory']['value']."\" maxOccurs=\"".$f[$i]['maxoccures']['value']."\">\n");
		    } elseif ($fieldtype[$i]['value'] == "url") {
			fputs ($fileid, "  <xs:element name=\"".$f[$i]['XMLfieldname']['value']."\" type=\"xs:anyURI\" minOccurs=\"".$f[$i]['mandatory']['value']."\" maxOccurs=\"".$f[$i]['maxoccures']['value']."\">\n");
		    } elseif ($alloweddata[$i]['value'] == "") {
			fputs ($fileid, "  <xs:element name=\"".$f[$i]['XMLfieldname']['value']."\" type=\"xs:string\" minOccurs=\"".$f[$i]['mandatory']['value']."\" maxOccurs=\"".$f[$i]['maxoccures']['value']."\">\n");
		    } else {
			fputs ($fileid, "  <xs:element name=\"".$f[$i]['XMLfieldname']['value']."\" minOccurs=\"".$f[$i]['mandatory']['value']."\" maxOccurs=\"".$f[$i]['maxoccures']['value']."\">\n");
		    }
		}
		if ($f[$i]['helptext']['value'] != "" || $f[$i]['fieldname']['value'] != "" || $f[$i]['fieldtype']['value'] != "" || $f[$i]['searchable']['value'] != "" || $f[$i]['authoriZURL']['value'] != "" ||$f[$i]['langdep']['value'] != "" || $f[$i]['repeatable']['value'] != "") {
		    fputs ($fileid, "    <xs:annotation>\n");
		    if ($f[$i]['helptext']['value'] != "" || $f[$i]['fieldname']['value'] != "") {
			fputs ($fileid, "      <xs:documentation>\n");
			if ($f[$i]['helptext']['value'] != "") {
			    fputs ($fileid, "        <helptext>".$f[$i]['helptext']['value']."</helptext>\n");
			}
			if ($f[$i]['fieldname'] != "") {
			    fputs ($fileid, "        <fieldname>".$f[$i]['fieldname']['value']."</fieldname>\n");
			}
			fputs ($fileid, "      </xs:documentation>\n");
		    }
		    if ($f[$i]['fieldtype']['value'] != "" || $f[$i]['searchable']['value'] != "" || $f[$i]['authoriZURL']['value'] != "" || $f[$i]['langdep']['value'] != "" || $f[$i]['repeatable']['value'] != "") {

			fputs ($fileid, "      <xs:appinfo>\n");
			if ($f[$i]['fieldtype']['value'] != "") {
			    if (is_array($subarray['subfield'])) {
				fputs ($fileid, "        <fieldtype>complex</fieldtype>\n");
			    } else {
				fputs ($fileid, "        <fieldtype>".$f[$i]['fieldtype']['value']."</fieldtype>\n");
			    }
			}
			if ($f[$i]['searchable']['value'] != "") {
			    fputs ($fileid, "        <searchable>1</searchable>\n");
			}
			if ($f[$i]['repeatable']['value'] != "") {
			    fputs ($fileid, "        <repeatable>1</repeatable>\n");
			}
			if ($f[$i]['authoriZURL']['value'] != "") {
			    fputs ($fileid, "        <authoriZURL>".$f[$i]['authoriZURL']['value']."</authoriZURL>\n");
			}
			if ($f[$i]['langdep']['value'] != "") {
			    fputs ($fileid, "        <langdep>".$f[$i]['langdep']['value']."</langdep>\n");
			}
			fputs ($fileid, "      </xs:appinfo>\n");
		    }
		    fputs ($fileid, "    </xs:annotation>\n");
		}
		if ($f[$i]['alloweddata']['value'] != "") {
		    fputs ($fileid, "    <xs:simpleType>\n");
		    fputs ($fileid, "      <xs:restriction base=\"xs:string\">\n");
		    foreach (split(";", $f[$i]['alloweddata']['value']) as $dataentry) {
			$dataentry = trim($dataentry);
			if ($dataentry != "") {
			    fputs ($fileid, "          <xs:enumeration value=\"$dataentry\"/>\n");
			}
		    }
		    fputs ($fileid, "      </xs:restriction>\n");
		    fputs ($fileid, "    </xs:simpleType>\n");
		}
		if (is_array($subarray['subfield'])) {
		    $indentString = indent($level + 1);
		    fputs ($fileid, "$indentString<xs:complexType>\n");
		    fputs ($fileid, "$indentString<xs:sequence>\n");
		    saveField($fileid, $subarray['subfield'], $level + 1);
		    fputs ($fileid, "$indentString</xs:sequence>\n");
		    fputs ($fileid, "$indentString</xs:complexType>\n");
		}
		if (is_array($subarray['choice'])) {
		    echo "Saving choice";
		    $indentString = indent($level + 1);
		    fputs ($fileid, "$indentString<xs:complexType>\n");
		    fputs ($fileid, "$indentString<xs:choice>\n");
		    saveField($fileid, $subarray['choice'], $level + 1);
		    fputs ($fileid, "$indentString</xs:choice>\n");
		    fputs ($fileid, "$indentString</xs:complexType>\n");
		}
// Here goes the UTF-8 branch conflict!
//                    if (is_array($subarray['choice'])) {
//                        echo "Saving choice";
//                        $indentString = indent($level + 1);
//                        fputs ($fileid, "$indentString<xs:complexType>\n");
//                        fputs ($fileid, "$indentString<xs:choice minOccurs=\"1\">\n");
//                        saveField($fileid, $subarray['choice'], $level + 1);
//                        fputs ($fileid, "$indentString</xs:choice>\n");
//                        fputs ($fileid, "$indentString</xs:complexType>\n");
//                    }
//>>>>>>> 1.22.2.1
		if (is_array($subarray['attributes'])) {
		    $indentString = indent($level + 1);
		    fputs ($fileid, "$indentString<xs:complexType>\n");
		    fputs ($fileid, "$indentString  <xs:simpleContent>\n");
		    fputs ($fileid, "$indentString    <xs:extension base=\"xs:string\">\n");
//                        fputs ($fileid, "$indentString<xs:attribute name=\"hidden\" type=\"xs:boolean\" default=\"0\">\n");
		    saveField($fileid, $subarray['attributes'], $level + 2, "attributes");
//                        fputs ($fileid, "$indentString</xs:attribute>\n");
		    fputs ($fileid, "$indentString    </xs:extension>\n");
		    fputs ($fileid, "$indentString  </xs:simpleContent>\n");
		    fputs ($fileid, "$indentString</xs:complexType>\n");
		}
		if ($type == "attributes") {
		    fputs ($fileid, "  </xs:attribute>\n");
		} else {
		    fputs ($fileid, "  </xs:element>\n");
		}
	    }
	}
    }
}
}

function saveXSD () {
global $f, $filename, $xsd_header, $xsd_footer, $xsd_attributes, $recordtype, $_POST, $fieldnames, $languages, $fieldname;
global $fieldname, $XMLfieldname, $mandatory, $fieldtype, $alloweddata, $helptext, $langdep, $searchable, $authoriZURL, $repeatable;
$fileid = fopen($filename, "w+");
fputs ($fileid, "$xsd_header\n");
fputs ($fileid, "<xs:element name=\"$recordtype\">\n");
if ($fieldname != "") {
    fputs ($fileid, "    <xs:annotation>\n");
    fputs ($fileid, "      <xs:documentation>\n");
    if ($fieldname != "") {
	fputs ($fileid, "        <fieldname>$fieldname</fieldname>\n");
    }
    fputs ($fileid, "      </xs:documentation>\n");
    fputs ($fileid, "    </xs:annotation>\n");
}
fputs ($fileid, "<xs:complexType>\n");
fputs ($fileid, "<xs:sequence>\n");
saveField($fileid, $f);
fputs ($fileid, "</xs:sequence>\n");
fputs ($fileid, "<xs:attribute name=\"hidden\" type=\"xs:boolean\" default=\"0\">\n");
fputs ($fileid, "  <xs:annotation>\n");
fputs ($fileid, "    <xs:documentation>\n");
fputs ($fileid, "      <fieldname>Skjult post</fieldname>\n");
fputs ($fileid, "      <helptext>Skal denne post være skjult?</helptext>\n");
fputs ($fileid, "    </xs:documentation>\n");
fputs ($fileid, "    <xs:appinfo>\n");
fputs ($fileid, "      <fieldtype>checkbox</fieldtype>\n");
fputs ($fileid, "    </xs:appinfo>\n");
fputs ($fileid, "  </xs:annotation>\n");
fputs ($fileid, "</xs:attribute>\n");
//    fputs ($fileid, "$xsd_attributes\n");
fputs ($fileid, "<xs:attribute name=\"creator\" type=\"xs:boolean\" default=\"0\">\n");
fputs ($fileid, "  <xs:annotation>\n");
fputs ($fileid, "    <xs:documentation>\n");
fputs ($fileid, "      <fieldname>Forfatter</fieldname>\n");
fputs ($fileid, "      <helptext>Forfatteren til dette dokument</helptext>\n");
fputs ($fileid, "    </xs:documentation>\n");
fputs ($fileid, "    <xs:appinfo>\n");
fputs ($fileid, "      <fieldtype>hidden</fieldtype>\n");
fputs ($fileid, "    </xs:appinfo>\n");
fputs ($fileid, "  </xs:annotation>\n");
fputs ($fileid, "</xs:attribute>\n");
fputs ($fileid, "$xsd_attributes\n");
fputs ($fileid, "</xs:complexType>\n");
fputs ($fileid, "</xs:element>\n");
fputs ($fileid, "$xsd_footer\n");
fclose($fileid);
}

function moveup ($htmlPath) {
global $f;
reset($f);
$path = explode("][", trim($htmlPath, "[]"));
array_pop($path);
$upPath = $path;
if ($path[count($path) - 1] == 0) {
    return;
}
$upPath[count($upPath) - 1] = $path[count($path) - 1] - 1;
$subarrayTemp = get_value($f, $path);
$subarray = get_value($f, $upPath);
set_xsd_node($f, $upPath, $subarrayTemp);
set_xsd_node($f, $path, $subarray);
}

function movedown ($htmlPath) {
global $f;
reset($f);
$path = explode("][", trim($htmlPath, "[]"));
array_pop($path);
$downPath = $path;
$downPath[count($downPath) - 1] = $path[count($path) - 1] + 1;
$subarrayTemp = get_value($f, $path);
$subarray = get_value($f, $downPath);
set_xsd_node($f, $downPath, $subarrayTemp);
set_xsd_node($f, $path, $subarray);
}

function delete ($nummer, $level) {
global $f;
$path = explode("][", trim($nummer, "[]"));
array_pop($path);
set_xsd_node($f, $path, "");
}

function set_xsd_node (&$f, $path, $value) {
$entry = array_shift($path);
if (count($path)) {
    set_xsd_node($f[$entry], $path, $value);
} else {
    $f[$entry] = $value;
}
}

function get_value (&$f, &$path) {
$value = get_node($f, $path);
//    return stripslashes($value);
return $value;
}


function get_node (&$f, &$path) {
$value = $f;
foreach ($path as $key) {
	$value = $value[$key];
}
return $value;
}

function makeForm ($f, $level=0, $formPath="") {
global $action, $nummer;
//Fields
if ((key($f['xs:complexType'][0]['subtree']) == "xs:sequence" || key($f['xs:complexType'][0]['subtree']) == "xs:choice") && is_array($f['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element'])) {
    foreach ($f['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element'] as $i => $type) {
	foreach ($type as $dataType => $subarray) {
	    if ($dataType == "attr") {
		$checked = set_checkbox ($type);
		make_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['fieldtype'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authoriZURL'][0]['value'], "", $level, $formPath, $i);
		if ($action == "subfield") {
		    $insertArray = explode("][XMLfieldname][subfield]", $nummer);
		    if (trim($insertArray[$level], "[]") == $i && count($insertArray) - 2 == $level ) {
			make_new($formPath."[$i][XMLfieldname][subfield]", $level + 1, count($f['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element'][$i]['subtree']['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element']));
		    }
		} elseif ($action == "choice") {
		    $insertArray = explode("][XMLfieldname][choice]", $nummer);
		    if (trim($insertArray[$level], "[]") == $i && count($insertArray) - 2 == $level ) {
			make_choice($formPath."[$i][XMLfieldname][choice]", $level + 1, count($f['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element'][$i]['subtree']['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element']));
		    }
		} elseif ($action == "attributes") {
		    $insertArray = explode("][XMLfieldname][attributes]", $nummer);
		    if (trim($insertArray[$level], "[]") == $i && count($insertArray) - 2 == $level ) {
			make_attributes($formPath."[$i][XMLfieldname][attributes]", $level + 1, count($f['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element'][$i]['subtree']['xs:complexType'][0]['subtree']['xs:simpleContent'][0]['subtree']['xs:extension'][0]['subtree']['xs:attribute']));
		    }
		}
	    } elseif (is_array($subarray['xs:complexType'][0]['subtree'])) {
		if (key($subarray['xs:complexType'][0]['subtree']) == "xs:sequence") {
		    makeForm($subarray, $level + 1, $formPath."[$i][XMLfieldname][subfield]");
		} elseif (key($subarray['xs:complexType'][0]['subtree']) == "xs:simpleContent") {
		    makeForm($subarray, $level + 1, $formPath."[$i][XMLfieldname][attributes]");
		}
	    }
	}
    }
//Attributes
} elseif (key($f['xs:complexType'][0]['subtree']) == "xs:simpleContent" && is_array($f['xs:complexType'][0]['subtree']['xs:simpleContent'][0]['subtree']['xs:extension'][0]['subtree']['xs:attribute'])) {
    foreach ($f['xs:complexType'][0]['subtree']['xs:simpleContent'][0]['subtree']['xs:extension'][0]['subtree']['xs:attribute'] as $i => $type) {
	foreach ($type as $dataType => $subarray) {
	    if ($dataType == "attr") {
		$checked = set_checkbox ($type);
		make_attr_formHTML($type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value'], $checked['min'], $checked['search'], $checked['lang'], $checked['repeat'], $type['attr']['name']['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['fieldtype'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['helptext'][0]['value'], $type['subtree']['xs:annotation'][0]['subtree']['xs:appinfo'][0]['subtree']['authoriZURL'][0]['value'], "", $level, $formPath, $i);
		if ($action == "subfield") {
		    $insertArray = explode("][XMLfieldname][subfield]", $nummer);
		    if (trim($insertArray[$level], "[]") == $i && count($insertArray) - 2 == $level ) {
			make_new($formPath."[$i][XMLfieldname][subfield]", $level + 1, count($f['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element'][$i]['subtree']['xs:complexType'][0]['subtree']['xs:sequence']));
		    }
		} elseif ($action == "choice") {
		    $insertArray = explode("][XMLfieldname][choice]", $nummer);
		    if (trim($insertArray[$level], "[]") == $i && count($insertArray) - 2 == $level ) {
			make_choice($formPath."[$i][XMLfieldname][choice]", $level + 1, count($f['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element'][$i]['subtree']['xs:complexType'][0]['subtree']['xs:sequence']));
		    }
		} elseif ($action == "attributes") {
		    $insertArray = explode("][XMLfieldname][attributes]", $nummer);
		    if (trim($insertArray[$level], "[]") == $i && count($insertArray) - 2 == $level ) {
			make_attributes($formPath."[$i][XMLfieldname][attributes]", $level + 1, count($f['xs:complexType'][0]['subtree']['xs:sequence'][0]['subtree']['xs:element'][$i]['subtree']['xs:complexType'][0]['subtree']['xs:sequence']));
		    }
		}

//                } elseif (is_array($subarray['xs:complexType'])) {
	    } elseif (is_array($subarray['xs:complexType'][0]['subtree'])) {
		if (key($subarray['xs:complexType'][0]['subtree']) == "xs:sequence") {
//                        print "Type: ".key($subarray['xs:complexType'][0]['subtree'])."<br>";
		    makeForm($subarray, $level + 1, $formPath."[$i][XMLfieldname][subfield]");
		} elseif (key($subarray['xs:complexType'][0]['subtree']) == "xs:simpleContent") {
//                        print "Type: ".key($subarray['xs:complexType'][0]['subtree'])."<br>";
		    makeForm($subarray, $level + 1, $formPath."[$i][XMLfieldname][attributes]");
		}
	    }
	}
    }
}
return $i;
}

function stripslashes_array($arr = array()) {
$rs = array();
while (list($key,$val) = each($arr)) {
    if(is_array($arr[$key])) $rs[$key] = stripslashes_array($arr[$key]); else $rs[$key] = htmlspecialchars(stripslashes($val),ENT_QUOTES);
}
return $rs;
}

if (is_array($f)) {
$f = stripslashes_array($f);
}

if ($save) {
saveXSD();
}
if ($action == "up") {
moveup($nummer, $level);
saveXSD();
} elseif ($action == "down") {
movedown($nummer, $level);
saveXSD();
} elseif ($action == "delete") {
delete($nummer, $level);
saveXSD();
}

if ($filename) {
if (!($dom_xml = domxml_open_file($filename))) {
    echo "Kunne ikke åbne/parse XSD fil '$filename'";
    die;
}
create_struct($f = array(), $dom_xml->document_element(), NULL);
//    print "<pre>f:<br>";
//    print_r($f);
//    print "</pre>";
}
if ($viewXSD) {
print "parse complete<p>\n";
}

$antal = count($XMLfieldname);

echo "<FORM name=\"schema\" method=\"post\" action=\"$PHPSELF\" onSubmit=\"return validateValues(document.schema)\">
<TABLE border=0 cellpadding=0 cellspacing=0>
<tr>";

if ($filename) {
reset($f);
$first = current($parseResult);
echo "<td colspan=\"2\"><span class=\"headline\">".trans_text("1").": " .$f['xs:schema'][0]['subtree']['xs:element'][0]['attr']['name']['value']. "</span><br>
" .$f['xs:schema'][0]['subtree']['xs:element'][0]['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value']. "</td>\n";
} else {
echo "<td class=\"headline\" colspan=\"2\">Opret en ny dokumenttype</td>\n";
}
echo "<td align=\"right\">
	<a href=\"admin.php?cwd=$cwd\"><img src=\"grafik/button_return_da.gif\" style=\"border: 0px;\" width=\"68\" height=\"22\" alt=\"".trans_text('21')."\" /></a>
	<a href=\"#\" onClick=\"return validateValues(document.schema);\"><img src=\"grafik/button_save_$lang.gif\" style=\"border: 0px;\" width=\"41\" height=\"22\" alt=\"Save\" /></a>
      </td>
    </tr>
    <tr>
      <td colspan=\"5\" class=\"line\" height=\"10\">&nbsp;</td>
    </tr>
    <tr>
      <td colspan=\"5\" height=\"10\">&nbsp;</td>
    </tr>";

if ($filename) {
echo "      <input type=\"hidden\" name=\"filename\" value=\"$filename\">
    <input type=\"hidden\" name=\"path\" value=\"$path\">
    <input type=\"hidden\" name=\"recordtype\" value=\"" .$f['xs:schema'][0]['subtree']['xs:element'][0]['attr']['name']['value']. "\">
    <input type=\"hidden\" name=\"fieldname\" value=\"" .$f['xs:schema'][0]['subtree']['xs:element'][0]['subtree']['xs:annotation'][0]['subtree']['xs:documentation'][0]['subtree']['fieldname'][0]['value']. "\">
    <input type=\"hidden\" name=\"action\" value=\"\">
    <input type=\"hidden\" name=\"nummer\" value=\"\">
    <input type=\"hidden\" name=\"cwd\" value=\"$cwd\">
    <input type=\"hidden\" name=\"level\" value=\"\">
    <input type=\"hidden\" name=\"lang\" value=\"$lang\">
    <input type=\"hidden\" name=\"save\" value=\"\">\n";
$f = $f['xs:schema'][0]['subtree']['xs:element'][0]['subtree'];
$i = makeForm($f);
if ($newfield) {
    make_new("","",$i + 1);
} elseif ($newchoice) {
    make_choice("","",$i + 1);
} elseif ($newattribute) {
    make_attributes("","",$i + 1);
}
} else {
 make_default();
}
echo "  <tr>
      <td colspan=\"5\" class=\"line\" height=\"10\">&nbsp;</td>
    </tr>
    <tr>
      <td height=\"8\"> </td>
    </tr>
    <tr>
	<td>
	<a href=\"admin.php?cwd=$cwd\"><img src=\"grafik/button_return_da.gif\" style=\"border: 0px;\" width=\"68\" height=\"22\" alt=\"".trans_text('21')."\" /></a>
	<a href=\"#\" onClick=\"return validateValues(document.schema);\"><img src=\"grafik/button_save_$lang.gif\" style=\"border: 0px;\" width=\"41\" height=\"22\" alt=\"".trans_text('18')."\" /><a>
	    <!--<br><input type=\"submit\" value=\"".trans_text('18')."\" name=\"save\">-->
	</td>\n";
if ($filename && !$newfield && !$newattribute && $action != "subfield") {
echo "
	<td align=\"right\">
	    <input type=\"submit\" value=\"".trans_text('19')."\" name=\"newfield\">
	</TD>
<!--         <td align=\"right\">
	    <input type=\"submit\" value=\"".trans_text('25')."\" name=\"newchoice\">
	</TD> -->
	<td align=\"right\">
//<<<<<<< schema-editor.php
                <input type=\"submit\" value=\"".trans_text('25')."\" name=\"newchoice\">
            </TD>
            <td align=\"right\">
                <input type=\"submit\" value=\"".trans_text('20')."\" name=\"newattribute\">
//=======
//                <input type=\"submit\" value=\"".trans_text('20')."\" name=\"newattribute\">
//>>>>>>> 1.22.2.1
            </TD>\n";
}
echo "
        </TR>
        <tr><td colspan=\"5\">&nbsp;</td></tr>
        <tr><td colspan=\"5\" align=\"center\"><font size=\"1\">".$this_user['name']."</font></td></tr>

    </TABLE>
</FORM>\n";
?>
</BODY>
</HTML>

