<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: read_local_config.php,v 1.9 2004/10/11 12:07:54 sondberg Exp $
*/

if (is_file($_SERVER['DOCUMENT_ROOT']."/$root/local_config.phpi")) {
    require($_SERVER['DOCUMENT_ROOT']."/$root/local_config.phpi");
} else if (is_file($_SERVER['DOCUMENT_ROOT']."/$doc_root/local_config.phpi")) {
    require($_SERVER['DOCUMENT_ROOT']."/$doc_root/local_config.phpi");
}


// Get a configuration setting
function get_tkl_config ($field) {
    global $portal_config;

    if (!is_array($portal_config)) {
	parse_tkl_config();
    }
    
    return $portal_config[$field];
}


// Load the cached version of the config file or parse tkl.config from scratch
function parse_tkl_config () {
    global $root, $doc_root, $portal_config;
    
    $config_dir = $_SERVER['DOCUMENT_ROOT'];
    
    if (strlen($root)) {
	$config_dir .= "/$root";
    } else {
	$config_dir .= "/$doc_root";
    }
    
    $php_config = "$config_dir/tkl.config.phpi";
    $tkl_config = "$config_dir/tkl.config";
    
    if (file_exists($php_config)) {
	if (!file_exists($tkl_config)) {
	    die("<b>Fatal</b>: parse_tkl_config couldn't find file '$tkl_config'");
	}

	if (filemtime($php_config) > filemtime($tkl_config)) {
	    include $php_config;
	    return;
	}
    }

    // Too bad, the php version of the config file is older than the tkl.config
    // so we have to parse the whole thing once again...

    $tkl_config_raw = join("", file($tkl_config));

    // Check if this claims to be XML...
    if (!preg_match("/\s*<\?xml.*\?>/", $tkl_config_raw)) {
	return;
    }

    if (!$dom = domxml_open_mem($tkl_config_raw)) {
	die("<b>Fatal:</b> Error while parsing the configuration file: $tkl_config");
    }

    $portal_config = parse_subtree( $doc_elem = $dom->document_element() );
    
    $php_code = "<?php\n\n";
    $php_code .= "// This file is auto-generated - DO NOT EDIT !!!\n";
    $php_code .= "// Please put your configuration settings into tkl.config\n\n";
    $php_code .= "\$portal_config = array(\n";
    $php_code .= serialize_config( $portal_config );
    $php_code .= ");\n\n?>";

    if (!$fh = fopen($php_config, "w")) {
	echo "<b>Warning:</b> Unable to cache config file in $php_config<br/>";
	return;
    }

    fputs($fh, $php_code);
    fclose($fh);
}


function serialize_config ($hash, $level = 1) {
    $ret = "";
    $indent = "        ";

    foreach ( $hash as $name => $value ) {
        $ret .= str_repeat( $indent, $level ) . "'$name' => ";
        
        if ( is_array( $value ) ) {
            $ret .= "array(\n" . serialize_config( $value, $level + 1) . "\n";
            $ret .= str_repeat( $indent, $level ) . "),\n";
        } else {
            $ret .= "'$value',\n";
        }
    }

    return $ret;
}


function parse_subtree ($node) {
    global $tkl_config;
    $portal_config = array( );

    if (is_array($settings = $node->child_nodes())) {
	foreach ($settings as $setting) {
	    if ($setting->node_type() == XML_ELEMENT_NODE) {
		if (strlen($name = $setting->get_attribute('name'))) {
		    $name = preg_replace("/'/", "\'", $name);
		    $name = preg_replace("/\"/", "\"", $name);
                    
		    if (strlen($value = $setting->get_attribute('value'))) {
                        $value = preg_replace("/'/", "\'", $value);
                        $value = preg_replace("/\"/", "\"", $value);
                        $portal_config[$name] = $value;
                    } else {
                        $portal_config[$name] = parse_subtree($setting);
                    }
		} else {
		    die("<b>Fatal:</b> Syntax error in config file: $tkl_config");
		}
	    }
	}
    }

    return $portal_config;
}

?>
