<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: prop.php,v 1.17 2005/06/16 10:59:45 marc Exp $
*/

require "config.php";
require "standards.php";
require "read_local_config.php";

find_portal_root();
$this_user = check_auth_user();

?>

<html>
  <head>
    <title>Properties of <?php echo $file?></title>
    <link rel="stylesheet" type="text/css" href="admin/admin.css" />
    <script language="JavaScript">
    <!--- Comment to stop JavaScript from being read by unfriendly browers
    function launch(field_name, form_name, script, cwd) {
	gallery=window.open(script+"?cwd="+cwd+"&field_name="+field_name+"&form_name="+form_name,"gallery",'toolbar=1,menubar=0,status=1,scrollbars=0,SCROLLING=NO,resizable="yes",WIDTH=300,height=380')
    }
    function confirm_remove(file) {
	if (confirm("Do you wish to delete the file " + file + " ?")) {
	    document.prop_remove_form.submit();
	}
    }
    function close_win() {
	close();
    }

    function check_field (content) {
	var trimmed = (content.replace(/^\s+/,'')).replace(/\s+$/,'');
	if (trimmed.length > 0) {
	    return true;
	} else {
	    alert("The path field must not be empty!");
	    return false;
	}
    }
	
    // End of comment to hide script -->
    </script>

			
  </head>
  <body>
  <h1>Properties of <em><?php echo $file?></em></h1><hr/>


<?php

echo "<table width=\"100%\">";
    echo "<form name=\"prop_move_form\" method=\"get\" action=\"$admin_process\" onSubmit=\"return check_field(move_file_dir.value)\">\n";
echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">\n";
echo "<input type=\"hidden\" name=\"close_win\" value=\"1\">\n";
echo "<input type=\"hidden\" name=\"move_file\" value=\"$file\">\n";
echo "<tr><td>&nbsp;</td></tr>\n";

// Insert various information about this TKL file
$f = "$abs_cwd/$file";
echo "<tr><td><b>Size</b></td><td>", filesize($f), " byte(s)</td></tr>\n";
$file_info = get_file_info($f);
$file_info['created'] = strlen($file_info['created']) ? $file_info['created'] : "N/A";
$file_info['creator'] = strlen($file_info['creator']) ? $file_info['creator'] : "N/A";
$file_info['modifier'] = strlen($file_info['modifier']) ? $file_info['modifier'] : "N/A";
$file_info['modified'] = strlen($file_info['modified']) ? $file_info['modified'] : "N/A";
echo "<tr><td><b>Created</b></td><td>", $file_info['created'], " by <em>", $file_info['creator'], "</em> </td></tr>\n";
echo "<tr><td><b>Modified</b></td><td>", $file_info['modified'], " by <em>", $file_info['modifier'], "</em> </td></tr>\n";
echo "<tr><td>&nbsp;</td></tr>";

echo "<tr><td><b>Move file to</b></td><td><input type=\"text\" name=\"move_file_dir\">";
echo "&nbsp;<a href=\"#\" onClick='launch(\"move_file_dir\",\"prop_move_form\",\"$browse_script\",\"$cwd\");return false;'><img src=\"grafik/lup.gif\" border=\"0\"></a></td>";
echo "<td align=\"right\"><input type=\"submit\" value=\"Move\"></td></tr>";
echo "</form>\n";

$allow_symlinks = get_tkl_config( 'allow_symlinks' );

if ( !is_link("$abs_cwd/$file") &&
     ( !isset( $allow_symlinks ) ||
       $allow_symlinks != 'no' ) ) {

    echo "<form name=\"prop_link_form\" method=\"get\" action=\"$admin_process\" onSubmit=\"return check_field(make_link_dir.value)\">\n";
    echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">\n";
    echo "<input type=\"hidden\" name=\"close_win\" value=\"1\">\n";
    echo "<input type=\"hidden\" name=\"make_link_file\" value=\"$file\">\n";
    echo "<tr><td><b>Create link in directory</b></td><td><input type=\"text\" name=\"make_link_dir\">";
    echo "&nbsp;<a href=\"#\" onClick='launch(\"make_link_dir\",\"prop_link_form\",\"$browse_script\",\"$cwd\");return false;'><img src=\"grafik/lup.gif\" border=\"0\"></a></td>";
    echo "<td align=\"right\"><input type=\"submit\" value=\"Create\"></td></tr>";
    echo "</form>\n";
}
echo "<form name=\"prop_remove_form\" method=\"get\" action=\"$admin_process\">\n";
echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">\n";
echo "<input type=\"hidden\" name=\"close_win\" value=\"1\">\n";
echo "<input type=\"hidden\" name=\"remove\" value=\"", trim_filename("$abs_cwd/$file"), "\">";
echo "<tr><td><b>Delete file</b></td><td colspan=\"2\" align=\"right\"><input type=\"button\" value=\"Delete\" onClick=\"confirm_remove('$file')\"></td></tr>\n";
echo "</form>\n";
echo "<tr><td>&nbsp;</td></tr>\n";

if ( !isset( $allow_symlinks ) ||
     $allow_symlinks != 'no' ) {
    
    echo "<tr><td align=\"left\" valign=\"top\"><b>Secondary (link) records in the directories:</b></td>\n";
    
    get_links($_SERVER['DOCUMENT_ROOT'] . "/$doc_root", $all_links = array());
    $abs_file = normalize_path("$abs_cwd/$file");
    $links = $all_links[$abs_file];
    
    if (is_array($links) && count($links) > 0) {
        echo "<td colspan=\"2\"><ul>\n";

	$portal_root = normalize_path( $_SERVER['DOCUMENT_ROOT']
	                               . '/' . $doc_root . '/' );

        $web_portal_root = normalize_path( '/' . $doc_root . '/' );

        foreach ($links as $link) {
	    $rel_path = substr($link,  strlen( $portal_root ));
	    $uri = $web_portal_root . $rel_path;
	    $dir_uri = dirname( $uri );
	    $index_dir = dirname( $link );
	    
	    //echo "REL_PATH='$rel_path'<br/>";
	    //echo "INDEX_DIR='$index_dir'<br/>";
	    //echo "URI='$uri'<br/>";
	    //echo "DIR_URI='$dir_uri'<br/>";

            $steps = split('/', dirname($rel_path));

            $loop_dir =  $portal_root;
            $linktext = get_title_or_dirname($portal_root . "/index.tkl");
            
            foreach ( $steps as $step) {
              $loop_dir = normalize_path($loop_dir . $step . '/');
              //echo "LOOP_DIR='$loop_dir'<br/>";
              
              $linktext .= ' > ' . get_title_or_dirname($loop_dir . "/index.tkl");
            }
            echo "<li>"
                  . "<a href=\"$dir_uri?admin=1\" target=\"new\">$linktext</a>"
                  . "</li>\n";
        }
        
        echo "</ul></td>\n";
    } else {
        echo "<td colspan=\"2\">None</td>";
    }
    
    echo "</tr>\n";
}

echo "<tr><td colspan=\"3\" align=\"right\"><form><input type=\"button\" onClick=\"close_win()\" value=\"Return\"></form></td></tr>\n";
echo "</table>";


?>
    <hr/>
    <center><font size="1"><?php echo $this_user['name']?></font></center>

  </body>
</html>
