<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: handler.php,v 1.10 2003/12/17 16:55:58 adam Exp $
*/
	
function make_well_formed_sql($str){
	$patterns[0] = "/&/";
	$patterns[1] = "/'/";
	$patterns[2] = "/>/";
	$patterns[3] = "/</";
	$patterns[4] = "/\"/";

	$replacements[0] = "&amp;";
	$replacements[1] = "&apos;";
	$replacements[2] = "&gt;";
	$replacements[3] = "&lt;";
	$replacements[4] = "&quot;";

	return preg_replace($patterns, $replacements, $str);
}

function scheme_tkl_sql($scheme, $path) {
    global $db_conn;
    $arg_str = preg_replace("/^.*?\/\?/", "", $path);
    $parms = explode("&", $arg_str);
    $xmlbuf="";
    foreach ($parms as $arg) {
	if (preg_match("/^([^=]*)=(.*)$/", $arg, $match)) {
	    $varname = $match[1];
	    $value = $match[2];
	    $$varname = $value;
	} else {
	    die("Argument format unknown '$arg'");
	}
    }
    if (!isset($encoding))
	$encoding = "UTF-8";
    if (!isset($xml))
	$xml = 1;
    if (!strlen($type)) {
	die("Argument type must be set");
    } elseif ($type == "connect") {
	if (!$host) {
	    die("Argument host must be set");
	}
	if (!$db) {
	    die("Argument db must be set");
	}
	if (isset($db_user)) {
	    $db_conn = mysql_connect($host, $db_user, $db_pwd);
	} else {
	    $db_conn = mysql_connect($host);
	}
	mysql_select_db($db, $db_conn);
    } elseif ($type == "exec") {
	if (!strlen($sql)) {
	    die("Argument sql must be specified");
	}
	$result = mysql_query($sql, $db_conn);
	$num_rows = @mysql_num_rows($result);
	$num_affected = mysql_affected_rows($db_conn);
	while ($row = @mysql_fetch_assoc($result)) {
	    $xmlbuf .= "  <record>\n";
	    foreach ($row as $fieldname => $fieldval) {
		if ($xml == 0)
		    $cdata = make_well_formed_sql($fieldval);
		else
		    $cdata = $fieldval;
		if ($encoding == "ISO-8859-1")
		   $cdata = utf8_encode($cdata);
		$xmlbuf .= "    <$fieldname>" . $cdata . "</$fieldname>\n";
	    }
	    $xmlbuf .= "  </record>\n";
	}
    } else {
	die("Don't know what todo with '$type'");
    }
    $ret = '<?xml version="1.0" encoding="UTF-8"?>';
    $ret .= "\n<sql hits=\"$num_rows\" affected=\"$num_affeced\">\n" . $xmlbuf . "</sql>\n";
    //echo "<pre>", htmlentities($ret), "</pre>";
	
    return $ret; 
}

?>
