<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: handler.php,v 1.2 2003/09/09 13:56:02 adam Exp $
*/

function scheme_tkl_soap($scheme, $path) {
    global $root;
    $fun = '';

    if (!preg_match("'^([^?]*)(\?(.+))?'", $path, $match)) {
	print "Malformed path for tkl-search";
	return '';
    }
    $wsdl = $match[1];
    $args = $match[3];
    $wsdl = preg_replace("/^./", "", $wsdl); // Remove leading /
    if (preg_match("/^\//", $wsdl)) {
	$wsdl = $_SERVER['DOCUMENT_ROOT'] . $root . $wsdl;
    }
    $att = array('target' => $target, 'wrap' => 1);
    $arg_a = array();
    if ($args) {
	foreach (explode('&', $args) as $arg) {
	    if (preg_match("/^tkl:fun=(.*)$/", $arg, $match))
		$fun = $match[1];
	    else
		grok_arg($arg_a, $arg);
	}
    }

    if (!$fun)
	die("SOAP call must specify tkl:fun argument");

    $soap = new soapclient($wsdl, 'wsdl');
    if (!($res = $soap->call($fun, $arg_a)))
	return '<?xml version="1.0" encoding="UTF-8" ?><error>NOTHING</error>';

   $rtext = $soap->response;   // this is probably not technically part of the nusoap API
   $rtext = preg_replace("/^.*?\s*\n\s*\n/s", "", $rtext);
   return $rtext;
}

?>
