<?php

/* $Id: handler.php,v 1.1 2004/11/09 12:45:15 sondberg Exp $
 * -------------------------------------------------------------
 * Handler to do the math involved with constructing a pager
 *
 */

function scheme_tkl_pager($scheme, $path) {
    global $dir;
    $args = parse_scheme_path( $path );
    $xml = "";

    if ( !isset( $args['hits'] ) ||
	 !isset( $args['inc'] ) ||
	 !isset( $args['offset'] ) ) {

	die("Handler tkl-pager must be called with parms: hits, inc, offset");
    }

    $hits = $args['hits'];
    $inc = $args['inc'];
    $offset = $args['offset'];

    $xml = "<tkl-pager>\n";

    $floating = $hits / $inc;

    $pages = (int) $floating;

    if ( $floating > $pages ) {
        $pages ++;
    }
    
    $off = 1;

    for ( $p = 1; $p <= $pages; $p ++ ) {
	$max = $off + $inc - 1;
	if ( $max > $hits ) {
	    $max = $hits;
	}
	
	$xml .= "  <page page=\"$p\" offset=\"$off\" max=\"$max\"/>\n";
	$off += $inc;
    }

    $xml .= "</tkl-pager>";
    
    return $xml;
}

?>
