<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk
 
   This file is part of TKLITE.
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.
 
   $Id: handler.php,v 1.1 2004/06/03 10:33:19 anders Exp $
*/

function make_tkl_global_xml($myvar,$name,$well_formed='',$add_slashes=''){
	if(is_array($myvar)){
       		$xml ="<global>";
       		foreach ($myvar as $mv) {
       			if(strlen($add_slashes)) $mv = addslashes($mv);
     			if(strlen($well_formed)) $xml .= "<".$name.">".make_tkl_well_formed($mv)."</".$name.">";
			else $xml .= "<".$name.">".$mv."</".$name.">";
		}
		$xml .= "</global>";
	} else {
		if(strlen($add_slashes)) $myvar = addslashes($myvar);
		if(strlen($well_formed)) $xml = "<global><".$name.">".make_tkl_well_formed($myvar)."</".$name."></global>";
		else $xml = "<global><".$name.">".$myvar."</".$name."></global>";
	}
	return $xml;
}

function make_tkl_well_formed($str){
    $patterns[0] = "/&/";
    $patterns[1] = "/'/";
    $patterns[2] = "/>/";
    $patterns[3] = "/</";
    $patterns[4] = "/\"/";
                                                                                                                   
    $replacements[0] = "&amp;";
    $replacements[1] = "&apos;";
    $replacements[2] = "&gt;";
    $replacements[3] = "&lt;";
    $replacements[4] = "&quot;";
                                                                                                                   
    return preg_replace($patterns, $replacements, $str);
}



function scheme_tkl_global($scheme, $path) {
    global $dir;
    $arg_str = preg_replace("/^.*?\/\?/", "", $path);
    $parms = explode("&", $arg_str);
	$xml = "";
    foreach ($parms as $arg) {
		if (preg_match("/^([^=]*)=(.*)$/", $arg, $match)) {
            $varname = $match[1];
            $value = $match[2];
            $$varname = $value;
        } else {
            die("Argument format unknown '$arg'");
        }
    }
    
    if (!strlen($type)) {
        die("Argument type must be set");
    } else if($type == "global"){
        if (!$name) {
            die("Argument name must be set");
        
	}
	$myvar = $$name;
        $xml = make_tkl_global_xml($myvar,$name,$well_formed,$add_slashes);
		
    } else {
        if (!$name) {
            die("Argument name must be set");
        }
	$method = "HTTP_{$type}_VARS";
        global ${$method};
        $myvar = ${$method}[$name];
        $xml = make_tkl_global_xml($myvar,$name,$well_formed,$add_slashes);
    }	
    return $xml;
}

?>
