<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: handler.php,v 1.1 2004/03/17 10:18:20 sondberg Exp $
*/

function scheme_tkl_config($scheme, $path) {
    $res = "<tkl-config>";
    $arg_str = preg_replace("/^.*?\/\?/", "", $path);
    $parms = explode("&", $arg_str);
    
    foreach ($parms as $arg) {
	if (preg_match("/^([^=]*)=(.*)$/", $arg, $match)) {
	    $varname = $match[1];
	    $value = $match[2];
	    $$varname = $value;
	} else {
	    die("Argument format unknown '$arg'");
	}
    }

    if (!strlen($name)) {
	die("<b>Fatal:</b> tkl-config handler: Argument <b>name</b> must be specified!");
    }
    
    $setting = get_tkl_config($name);
    if (isset($setting)) {
	$res .= "  <setting>$setting</setting>\n";
    } else {
	$res .= "  <error>Undefined</error>\n";
    }
    $res .= "</tkl-config>";
    return $res;
}

?>
