<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: handle_call.php,v 1.7 2003/09/09 13:56:01 adam Exp $
*/

require "config.php";
require "standards.php";
require "search.php";

find_portal_root();
$this_user = check_auth_user();

$success = "";

if ($close_win) {
    echo <<<END
<html>
  <head>
    <script language="JavaScript">
        <!--- Comment to stop JavaScript from being read by unfriendly browers
	function close_refresh () {
	    opener.location.reload();
	    close();
	}
    </script>
  </head>
  <body onLoad="close_refresh()">
  </body>
</html>
END;
}

if (isset($remove)) {
    if (is_granted($remove, "write")) {
	get_links($_SERVER['DOCUMENT_ROOT'] . "/$doc_root", $all_links = array());
	if (is_array($links = $all_links[$remove])) {
	    $new_master = array_shift($links);		// Grab the first link and make it a real record file...
	    system("rm -f $new_master");
	    system("cp $remove $new_master");
	    search_index($new_master);
	    foreach ($links as $link) {
		system("rm -f $link");
		if (!my_symlink($new_master, $link)) {
		    exception("Kunne ikke ndre eksistererende link <em>$link</em> til <em>$new_master</em>");
		    die;
		}
	    }
	}
	system("rm -f $remove");
	search_index($remove);
    }
    if (!$close_win) {
	header("Location: $admin_script?" . makeparms($context));
    }
} elseif (isset($make_link_dir)) {
    $abs_file = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$make_link_dir/$make_link_file";
    if (is_granted($abs_file, "write")) {
	if (!my_symlink("$abs_cwd/$make_link_file", $abs_file)) {
	    exception("Kunne ikke oprette linket <b>$abs_cwd/$make_link_file</b>");
	    die;
	}
    } else {
	echo "<b>Du har ikke lov til at oprette links i dette katalog</b>";
	die;		// Make some fancy java-script woodoo to show this message...
    }
    if (!$close_win) {
	header("Location: $admin_script?" . makeparms($context));
    }
} elseif (isset($move_file)) {
    $abs_file = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$move_file_dir$move_file";
    $orig_file = "$abs_cwd/$move_file";
    if (is_granted($orig_file, "write") && is_granted($abs_file, "write")) {
	system("cp $orig_file $abs_file");
	update_links($orig_file, $abs_file);
	system("rm $orig_file");
	search_index($orig_file);
	search_index($abs_file);
    } else {
	echo "<b>Du har ikke lov til at flytte filen</b>";
	die;		// make some java-script woodoo to show this message...
    }
    if (!$close_win) {
	header("Location: $admin_script?" . makeparms($context));
    }
} elseif ($action == "directory") {
    if (strlen($new_dir)) {
	if (strlen($new_dir)) {
	    $new_dir = preg_replace("/^\s+/", "", $new_dir);
	    $new_dir = preg_replace("/\s+$/", "", $new_dir);
	    $new_dir = remove_special_chars($new_dir);
	}
	if (!strlen($new_dir)) {
	    $error = 1;
	} elseif (file_exists("$abs_cwd/$new_dir")) {
	    $error = 2;
	} elseif (preg_match("/([\/|\.])/", $new_dir, $match)) {
	    $new_err = 3;
	} elseif (!mkdir("$abs_cwd/$new_dir", 0755)) {
	    $new_err = 4;
	}
	if ($auto_index = get_auto_index()) {
	    if (!file_exists($pop_up = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$xsd_path/$auto_index")) {
		$pop_up = "$xsd_path/$auto_index";
	    }
	    $index_candidate = "$abs_cwd/$new_dir/index.tkl";
	    if (!file_exists($index_candidate)) {
		$pop_up_write = $index_candidate;
	    }
	    $reload = 1;
	}
    } elseif (strlen($mv_dir_old) && strlen($mv_dir_new)) {
	if (preg_match("/^\//", $mv_dir_new)) {
	    if ($this_user['usertype'] != "administrator") {
		$error = 5;
	    }
	    $new_abs_cwd = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$mv_dir_new";
	} else {
	    $new_abs_cwd = "$abs_cwd/$mv_dir_new";
	}
	if (!$error) {
	    if (is_dir($new_abs_cwd)) {
		$error = 2;
	    } else {
		$error = recursive_copy("$abs_cwd/$mv_dir_old", $new_abs_cwd);
		if ($error) {
		    system("rm -rf $new_abs_cwd");
		} else {
		    $mv_suc = "Omdbt til <b>$mv_dir</b>";
		    $sys_abs_cwd = check_chrs("$abs_cwd/$mv_dir_old");
		    system("rm -rf $sys_abs_cwd");
		}
	    }
	}
    } elseif (strlen($del_dir)) {
	if (!is_dir("$abs_cwd/$del_dir")) {
	    $error = 6;
	} elseif (!is_empty("$abs_cwd/$del_dir")) {
	    $error = 7;
	} elseif (!rmdir("$abs_cwd/$del_dir")) {
	    $error = 4;
	} else {
	    $del_suc = "Underkatalog <b>$del_dir</b> slettet";
	}
    }
    //header("Location: $admin_script?" . makeparms($context, array("reload"=>$reload, "pop_up_write"=>$pop_up_write, "pop_up"=>$pop_up, "new_suc"=>$new_suc, "mv_suc"=>$mv_suc, "created_dir"=>$new_dir, "del_suc"=>$del_suc, "new_err"=>$new_err, "del_err"=>$del_err, "mv_err"=>$mv_err)));
    header("Location: shell.php?cwd=$cwd&admin=1&error=$error&pop_up_write=$pop_up_write&pop_up=$pop_up");
} elseif ($action == "index") {
    if (!$reindex && !$portal_path) {
	exception("What path?");
    }
    if ($reindex) {
	search_index_all($reindex);
	header("Location: $admin_script?" . makeparms($context, array("reindex"=>$reindex)));
    } elseif ($start_search) {
	search_start($portal_path);
	header("Location: $admin_script?" . makeparms($context, array("start_search"=>$start_search)));
    } elseif ($stop_search) {
	search_stop($portal_path);
	header("Location: $admin_script?" . makeparms($context, array("stop_search"=>$stop_search)));
    } else {
	exception("Don't know what to do!");
    }
} else {
    exception("Unknown type of action '$action'");
}
    
?>
