<?php
/*
   Copyright (C) 2002-2006 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: domtools.php,v 1.12 2006/05/15 09:40:37 sondberg Exp $
*/

function dom_select($node, $xpath) {	// The get_elements_by_tagname doesn't seem to work (the expected way) :-(
    $tag = array_shift($xpath);
    if (is_array($kids = $node->child_nodes())) {
	foreach ($kids as $kid) {
	    if ($kid->tagname == $tag) {
		if (count($xpath) > 0) {
		    return dom_select($kid, $xpath);
		} else {
		    return $kid;
		}
	    }
	}
    }
    return 0;
}

function dom_select_ext ($node, $xpath) {	// The get_elements_by_tagname doesn't seem to work (the expected way) :-(
    $tag = array_shift($xpath);
    if (is_array($kids = $node->child_nodes())) {
	foreach ($kids as $kid) {
	    if ($kid->tagname == $tag) {
		if (count($xpath) > 0) {
		    return dom_select($kid, $xpath);
		} else {
		    $ret = array($kid);
		    while ($kid = $kid->next_sibling()) {
			if ($kid->tagname == $tag) {
			    $ret[] = $kid;
			}
		    }
		    return $ret;
		}
	    }
	}
    }
    return 0;
}

function dump_xml ($node, $include_base = 0) {
    $type = $node->node_type();

    if ($type == XML_TEXT_NODE) {
	return tkl_string_to_xml($node->content);
	// return escape_amp(escape_ltgt($node->content));
    } elseif ($type == XML_ELEMENT_NODE) {
	$name = $node->tagname;
	$xml = "";
	$xml_head = "<$name";
	$xml_foot = "";

	if (is_array($attributes = $node->attributes())) {
	    foreach ($attributes as $attr) {
		$xml_head .= " " . $attr->name() . "=\"" . tkl_string_to_xml($attr->value()) . "\"";
	    }
	}

	if ($node->has_child_nodes()) {
	    $xml_head .= ">";
	    if (is_array($kiddoz = $node->child_nodes())) {
		foreach ($kiddoz as $kid) {
		    $xml .= dump_xml($kid, 1);
		}
	    }
	    $xml_foot .= "</$name>";
	} else {
	    $xml_head .= "/>";
	}

	if ($include_base) {
	    return $xml_head . $xml . $xml_foot;
	} else {
	    return $xml;
	}
    } elseif ($type == XML_COMMENT_NODE) {
	// So far, we ignore comments...
    } else {
	echo "<b>Warning:</b> Unknown type fo DOM node: $type<br/>";
	return "";
    }
}

?>
