<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: config.php,v 1.52 2006/05/08 08:57:37 sondberg Exp $
*/

// General global settings for Toolkit Lite

// Indent used when producing XML
$indent = "  ";

// Cache expiring time
$cache_expire = 15;

// Indent when producing HTML
$HTMLindent = "&nbsp;&nbsp;&nbsp;&nbsp;";

// Admin interface Language
$admin_lang = "en";

// Default user-space language
$default_user_lang = "en";

// Members of an admin-session:
$context = array("action", "cwd");

// XML header used in all XML
$xml_header = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n";

// XML schema instance attribute
$xml_schema_instance_attr = "xsi:noNamespaceSchemaLocation";

// XML schema instance namespace
$xml_schema_instance_ns = "http://www.w3.org/2001/XMLSchema-instance";

//XSD header used in all XSD
$xsd_header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<!--This is a computergenerated file - DON'T CHANGE BY HAND - TKL -->
<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">";

//XSD footer used in all XSD
$xsd_footer = "</xs:schema>";

//XSD attributes used in all XSD
$xsd_attributes = "<xs:attribute name=\"creator\" type=\"xs:string\">
  <xs:annotation>
    <xs:appinfo>
      <fieldtype>hidden</fieldtype>
    </xs:appinfo>
  </xs:annotation>
</xs:attribute>
<xs:attribute name=\"created\" type=\"xs:string\">
  <xs:annotation>
    <xs:appinfo>
      <fieldtype>hidden</fieldtype>
    </xs:appinfo>
  </xs:annotation>
</xs:attribute>
<xs:attribute name=\"modifier\" type=\"xs:string\">
  <xs:annotation>
    <xs:appinfo>
      <fieldtype>hidden</fieldtype>
    </xs:appinfo>
  </xs:annotation>
</xs:attribute>
<xs:attribute name=\"modified\" type=\"xs:string\">
  <xs:annotation>
    <xs:appinfo>
      <fieldtype>hidden</fieldtype>
    </xs:appinfo>
  </xs:annotation>
</xs:attribute>";

// The path to the XML schema repository
$xsd_path = "schemas";

// The name of the XML editor php script
$xml_editor = "xform2.php";

// The property script
$admin_property = "prop.php";

// The name of the XML schema editor
$xsd_editor = "schema-editor.php";

// List of URL's in a portal
$url_list_file = "urls.tkl";

// The record suffix
$xml_suffix = ".tkl";

// The directory configuration file
$dir_config = "directory.tkl";

// The directory schema
$dir_schema = "directory.xsd";

// The administrator interface
$admin_script = "admin.php";

// The administrator system call script
$admin_process = "handle_call.php";

// The browser script
$browse_script = "dirbrowse.php";

// Global portal index file
$global_index = "global.index";

// Portal specific user list
$user_list = "users.tkl";

// Portal specific list of bad urls
$bad_urls = "badurls.tkl";

// XSLT stylesheet to render the bad urls list
$bad_urls_xslt = "badurls.xsl";

// User privileges
$privileges = array(
			'administrator'	=>	array(
							'allow'	=> array(
										'write'	=> '@portal',
										'read'	=> '@portal',
										'create'=> '@portal',
										'index' => 1,
								   ),
							'deny'	=> array(),
						),

			'user'		=>	array(
							'allow'	=> array(
										'write'	=> '@home',
										'read'	=> '@portal',
										'create'=> '@home',
								   ),
							'deny'	=> array(
										'write'	=> array('directory.tkl'=>1, 'users.tkl'=>1, '*.xsd'=>1),
										'read'	=> array('users.tkl'=>1, '*.xsd'=>1),
								   ),
						),
			'spectator'	=>	array(
							'allow'	=> array(
										'read' => '@portal'
								   ),
							'deny'	=> array(
										'read'	=> array('users.tkl'=>1),
								   ),
						),
	      );

// Document root directory
//$doc_root = "tkl";

// The languages supported by the portal
$languages = array(
			0	=>	array("abbr"=>"da", "desc"=>"Dansk"),
			1	=>	array("abbr"=>"en", "desc"=>"Engelsk"),
			2	=>	array("abbr"=>"el", "desc"=>"Greek") );

//Mandatory fields
//Syntax: fieldname, required field [checked], searchable [checked], language dependant [checked], repeadable [checked], XML fieldname, field type [text, textarea, dropdown] , helptext.
$mandatory_fields = array(
    array('Titel', 'checked', 'checked', 'checked', '', 'title', 'text', 'Her skal titlen stå'),
    array('Type', 'checked', 'checked', '', '', 'type', 'text', 'Postens type'),
    array('Beskrivelse', 'checked', 'checked', 'checked', '', 'description', 'text', 'Kort beskrivelse af posten'),
    array('URL', 'checked', 'checked', '', '', 'identifier', 'url', 'Resourcens URL'),
    array('Emneord', 'checked', 'checked', 'checked', 'checked', 'subject', 'text', 'Emneord der kan knyttes til resourcen'),
    array('Forfatter', 'checked', 'checked', '', 'checked', 'creator', 'text', 'Forfatterens navn'),
    array('Udgiver', 'checked', 'checked', '', 'checked', 'publisher', 'text', 'Den organisation der udgiver resourcen'),
);

//Number of terms to show in scan.
$scannumber = 10;

//The timeout for the robot when it connects and reads/writes (in seconds)
$robotTimeout = 10;

//The number of times in a row  a URL should have errors before a email is send to the owner of the document.
$robotErrorNr = 3;

//Email address for the administrator of the URL checker.
$robot_admin_email = "perhans@indexdata.dk";

// Entity references
$ent_ref = array(
			'amp'	=>	'&',
			'lt'  =>	'<',
			'gt'  =>	'>',
		);

// The name of the portal
$portalName = "Def Link";

$trans_lang = array(
    '1' => array('da' => 'Navnet på denne dokumenttype', 'en' => 'The name of this document type', 'el' => 'Το όνομα του τύπου του εγγράφου'),
    '2' => array('da' => 'Feltnavn', 'en' => 'Field name', 'el' => 'Όνομα πεδίου'),
    '3' => array('da' => 'XML feltnavn', 'en' => 'XML field name', 'el' => 'Όνομα XML πεδίου'),
    '4' => array('da' => 'Attributtype', 'en' => 'Attribute type', 'el' => 'Τύπος ιδιότητας'),
    '5' => array('da' => 'Sti til autoritetsfil', 'en' => 'Path to authorisation files', 'el' => 'Μονοπάτι στα αρχεία εξουσιοδότησης'),
    '6' => array('da' => 'Hjælpetekst', 'en' => 'Help text', 'el' => 'Κείμενο βοήθειας'),
    '7' => array('da' => 'Obligatorisk', 'en' => 'Mandatory', 'el' => 'Υποχρεωτικό'),
    '8' => array('da' => 'Søgbar', 'en' => 'Searchable', 'el' => 'Αναζητίσιμο'),
    '9' => array('da' => 'Sprogafhængig', 'en' => 'Language depedant', 'el' => 'Εξαρτούμενο από τη γλώσσα'),
    '10' => array('da' => 'Kan gentages', 'en' => 'Repeadable', 'el' => 'Επαναλαμβανόμενο'),
    '11' => array('da' => 'Op', 'en' => 'Up', 'el' => 'Πάνω'),
    '12' => array('da' => 'Ned', 'en' => 'Down', 'el' => 'Κάτω'),
    '13' => array('da' => 'Slet', 'en' => 'Delete', 'el' => 'Διαγραφή'),
    '14' => array('da' => 'Underfelt', 'en' => 'Sub field', 'el' => 'Υποπεδίο'),
    '15' => array('da' => 'Attribut', 'en' => 'Attribute', 'el' => 'Ιδιότητα'),
    '16' => array('da' => 'Attributnavn', 'en' => 'Attribut name', 'el' =>'Όνομα ιδιότητας'),
    '17' => array('da' => 'XML attributnavn', 'en' => 'XML attribut name', 'el' =>'Όνομα XML ιδιότητας'),
    '18' => array('da' => 'Gem', 'en' => 'Save', 'el' =>'Αποθήκευση'),
    '19' => array('da' => 'Nyt felt', 'en' => 'New field', 'el' =>'Νέο πεδίο'),
    '20' => array('da' => 'Ny attribut', 'en' => 'New attribute', 'el' =>'Νέα ιδιότητα'),
    '21' => array('da' => 'Tilbage', 'en' => 'Back', 'el' =>'Πίσω'),
    '22' => array('da' => 'Felttype', 'en' => 'Field type', 'el' =>'Τύπος πεδίου'),
    '23' => array('da' => 'Vælg type', 'en' => 'Chose type', 'el' =>'Επιλέξτε τύπο'),
    '24' => array('da' => 'Choice', 'en' => 'Choice', 'el' =>'Επιλογή'),
    '25' => array('da' => 'Ny choice', 'en' => 'New choice', 'el' =>'Νέα επιλογή')
);

?>
