<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: badurls.xsl,v 1.3 2003/09/09 13:56:01 adam Exp $
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" encoding="UTF-8"/>

<xsl:param name="cwd"/>

<xsl:template match="/badurls">
  <html>
    <head>
      <title>
        Links der skal opdateres
      </title>
      <link rel="stylesheet" type="text/css" href="styles.css" />
    </head>
    <body>
    <table>
        <tr><td align="center"><h1>Links der skal opdateres</h1></td></tr>
        <tr>
            <td>
                <table>
                    <tr>
                        <td colspan="2" style="line-height: 11px;" class="dotted">&#xa0;</td>
                    </tr>
                    <xsl:for-each select="BADURL">
                        <tr>
                             <td>
                                <a href="{URL}"><xsl:value-of select="URL"/></a>
                                <br/>
                                <small>Error code: <xsl:value-of select="ERRORCODE"/>, Checket <xsl:value-of select="CHECKEDNUMBER"/> gange, sidst <xsl:value-of select="CHECKEDLAST"/></small>
                            </td>
                            <td>
                                <a href="xform.php?xml_file={FILENAME}&amp;cwd={$cwd}">Ret</a>
                            </td>
                        </tr>
                         <tr>
                            <td colspan="2" style="line-height: 11px;" class="dotted">&#xa0;</td>
                        </tr>
                    </xsl:for-each>
                    <tr>
                        <td align="center">&amp;lt;&#xa0;<a name="menu"></a><a href="javascript:history.back();">Tilbage</a>&#xa0;&amp;gt;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </body>
  </html>
</xsl:template>
</xsl:stylesheet>
