/* Javascript stuff for xform2 */
/* $Id: xform.js,v 1.16 2006/05/19 11:04:43 sondberg Exp $ */

/* Append one element of the type path */
function set_append(path) {
    document.main.append.value = path;
    document.main.submit();
}

/* Sets the element path to be moved one step up */
function set_moveup(path) {
    document.main.move_up.value = path;
    document.main.submit();
}

/* Sets which element path should be inserted */
function set_choice(path) {
    document.main.choice_path.value = path;
    document.main.submit();
}

/* Sets xform in a validation mode */
function set_valid(v) {
    document.main.valid.value = v;
    document.main.submit();
}

/* Deletes the element path v */
function set_delete(v) {
    document.main.delete_node.value = v;
    document.main.submit();
}


/* Unlink the tkl file */
function set_unlink (text) {
    if ( confirm( text ) ) {
        document.main.unlink.value = 1;
        document.main.submit( );
    }
}

/* Invokes the XHTML popup editor */
function popup_editor(formid, fieldid) {
    window.open("simple_editor.php?formid="+formid+"&fieldid="+escape(fieldid), 'popupeditor', 'toolbar=0,location=0,menubar=0,status=0,scrollbars=1,SCROLLING=yes,resizable=yes,WIDTH=900,height=600');
}

/* Invokes the hierarchy popup browser */
function pop_up_win (script) {
    window.open(script, '', 'width=600,height=700,screenX=1,screenY=1,top=1,left=1,resizable=yes,scrollbars=1,scrolling=yes');
    }



/* Inserts today's date in the field */
function insert_today(field, form) {
    d = new Date();
    yy = d.getYear();
    var year = (yy < 1000) ? yy + 1900 : yy;
    month = new String(d.getMonth() + 1);
    date = new String(d.getDate());
    if (month.length < 2) {
	month = "0" + month;
    }
    if (date.length < 2) {
	date = "0" + date;
    }
    document[form][field].value = year + "-" + month + "-" + date;
}

/* Appends value val to the field */
function append_value(field, form, val) {
    document[form][field].value += val;
}

/* Not a clue what this function does, anybody? */
function launch(feltNavn, form_name, target, field) {
    var word = new Array();
    string = document[form_name][feltNavn].value.replace(/(\ +)/g, "%20");
    word = string.split(/[;]+/);
    var length = word.length - 1;
    while ((word[length]=="") && (length>0)) {
	length--;
    }
    var word2 = word[length];
    if (word2.indexOf("%20") == 0) {
	word2 = word2.replace(/%20/, "");
    }
    word2 = word2.replace(/[ ]/g, "%20");
    gallery=window.open("browse.php?target="+target+"&form_name="+form_name+"&field_name="+feltNavn+"&term1="+escape(word2)+"&field1="+field+"&type="+feltNavn,"gallery",'toolbar=0,location=0,menubar=0,status=0,scrollbars=1,SCROLLING=yes,resizable=yes,WIDTH=305,height=390')
}

/* Invokes the check URL box */
function launch_checkURL(feltNavn, form_name, cwd) {
    window.open("scripts/single_url.php?cwd="+cwd+"&url="+document[form_name][feltNavn].value, 'urlcheck', 'toolbar=0,location=0,menubar=0,status=0,scrollbars=1,SCROLLING=yes,resizable=yes,WIDTH=305,height=390')
}

/* Invokes the check Z-URL box */
function launch_checkZURL(feltNavn, form_name, cwd) {
    window.open("scripts/z-probe.php?zurl="+document[form_name][feltNavn].value, 'zprobe', 'toolbar=0,location=0,menubar=0,status=0,scrollbars=1,SCROLLING=yes,resizable=yes,WIDTH=400,height=200')
}

/* Puts xform in saving and validation mode */
function set_save(v) {
    document.main.save.value = v;
    document.main.valid.value = v;
    document.main.submit();
}

/* Reloads the window which opened xform in the first place, and closes the xform window */
function close_win() {
    if ( opener ) {
        opener.location.reload();
    }

    close();
}

/* Sets xform in close down mode (execute clean up code) */
function set_close() {
    document.main.close_win.value = 1;
    document.main.submit();
}

/* Start the directory browser window */
function dir_browse(cwd) {
    gallery=window.open("dirbrowse.php?cwd="+cwd+"&field_name=choose_dir&form_name=main","gallery",'toolbar=0,menubar=0,status=1,scrollbars=0,SCROLLING=NO,resizable="yes",WIDTH=300,height=380');
}

/* Sets focus on the field given by field_id and attempts to scroll a bit more down to make the field visible */
function set_focus (field_id) {
    init_java();
    document.main.elements[field_id].focus();
    window.scrollBy(0, 100);
}

/* Clean up and shut down */
function clean_up () {
    document.main.close_win.value = 1;
    document.main.submit();
    close_win();
}

/* Show the part of the page corresponding to currentPage, and hide the rest */
function update_page () {
    max_page = document.main.max_page.value;
    currentPage = document.main.currentPage.value;

    if (max_page <= 1) {
        /* Don't update anything, if there is only a single page */
	return;
    }
    
    for (p = 1; p <= max_page; p ++) {
	cells = panels[p];
	if (!cells) {
	    break;
	}
	if (p == currentPage) {
	    for (i = 0; i < cells.length; i ++) {
		showCell(cells[i]);
	    }
	} else {
	    for (i = 0; i < cells.length; i ++) {
		hideCell(cells[i]);
	    }
	}
    }
}

/* Hide a cell given by cell_id */
function hideCell(cell_id) {
    if ( cell = document.getElementById(cell_id) ) {
        cell.style.display = 'none';
    } else {
        alert( 'Could not find cell_id=' + cell_id );
    }
}

/* Show cell given by cell_id */
function showCell(cell_id) {
    if ( cell = document.getElementById(cell_id) ) {
        display_cell( cell );
    } else {
        alert( 'Could not find cell_id=' + cell_id );
    }
}


/* This function should be pretty platform independent, works for IE and
 * Firefox. Not sure about Opera etc.
 */
function display_cell (cell) {
    if ( window.ActiveXObject ) {
        cell.style.display = 'block';
    } else {
        if ( cell.tagName == 'TR' ) {
            cell.style.display = 'table-row';
        } else if ( cell.tagName == 'TD' ) {
            cell.style.display = 'table-cell';
        } else {
            cell.style.display = 'block';
        }
    }
}

/* Change active page to page */
function change_page(page) {
    document.main.currentPage.value = page;
    update_page();
    other_pages();
}

/* Update the other pages navigation bar */
function other_pages() {
    max_page = document.main.max_page.value;
    currentPage = document.main.currentPage.value;
    
    if (max_page <= 1) {	/* Don't show anything if only one page */
	return;
    }
    
    cell_top = document.getElementById('other_pages1');
    cell_buttom = document.getElementById('other_pages2');
    html = '';
    
    for (p = 1; p <= max_page; p ++) { 
	if (p == currentPage) {
	    html = html + '[' + pageTextList[p - 1] + ']&#xa0;';
	} else {
	    html = html + '<a href="#" onClick="change_page(' + p + ')">[' + pageTextList[p - 1] + ']</a>&#xa0;';
	}
    }
    cell_top.innerHTML = html;
    cell_buttom.innerHTML = html;
}

var panels = new Array();

/* Show/hide the correct parts of the screen, should be called every time xform is loaded! */
function init_java () {
    update_page();
    other_pages();
}

/* Associate cell id with panel */
function set_id (panel, id) {
    if (!panels[panel]) {
	panels[panel] = new Array();
    }
    
    next_key = panels[panel].length;
    panels[panel][next_key] = id;
}

function changeImages() {
	document[changeImages.arguments[0]].src = changeImages.arguments[1];
}

function morerows(f, name)
{
    for (var i = 0; i< f.length; i++)
    {
        var e = f.elements[i];
        if (e.name == name &&
	     (e.type == "textarea" || e.type == "text")
	    )
	{
	    if (e.rows > 14)
	        e.rows = 4;
	    else
	        e.rows = e.rows * 3;
	    e.focus();
	    e.click();
	}
    }
}

