<?php

/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: show_stat.php,v 1.5 2004/03/11 12:39:17 sondberg Exp $
*/

header("Content-Type: text/html; charset=utf-8");

require "../standards.php";

class stat_stream extends XMLstream {
    var $count;
    var $types;
    var $record;
    var $date;
    var $editors;
    var $html;
    var $size;
    var $total_size;
    
    function dump_record ($tag, $attr) {
	$options = $this->options;
	$fields = $options['fields'];
	$type = preg_replace("/\.xsd$/", "", $this->record['xsd']);
	$this->record['type'] = $type;
	$types = &$this->types;
	$user = strlen($this->record['user']) ? $this->record['user'] : 'unknown';
	$editors = &$this->editors;
	$abs_file = $_SERVER['DOCUMENT_ROOT'] . $options[portalroot] . $this->record[file];

	if (!file_exists($abs_file) || !is_readable($abs_file)) {
	    return;
	}


	if (!strlen($type)) {
	    $type = "none";
	}

	$types[$type] = 1;
	$editors[$user] = 1;
	
	if ($options['selected_type'] != "all" && $options['selected_type'] != $type) {
	    return;
	}

	if ($options['selected_editor'] != "all" && $options['selected_editor'] != $user) {
	    return;
	}

	$this->record['changed'] = date("Y-m-d, H:i:s", filemtime($_SERVER['DOCUMENT_ROOT'] .
				   "/$options[portalroot]/" .
				   $this->record['file']));
	
	$this->count ++;
	$this->size += $this->record['size'];
	
	$this->html .= "<tr class=\"";
	
	if ($this->count % 2) {
	    $this->html .= "dark";
	} else {
	    $this->html .= "light";
	}
	
	$this->html .= "\">\n";
	
	foreach ($fields as $field) {
	    $this->html .= "  <td>";

	    if ($field == "file") {
		$this->html .= "<a href=\"$options[portalroot]" . $this->record[$field] . "?edit=1\" target=\"_blank\">" .
		     $this->record[$field] . "</a>";
	    } else {
		$this->html .= $this->record[$field]; 
	    }

	    $this->html .= "</td>";
	    
	}
	
	$this->html .= "</tr>\n";
	
	$this->record = array();
    }

    function store_field ($tag, $attr) {
	$cdata = trim($this->cdata);

	if (!strlen($cdata)) {
	    $cdata = "unknown";
	}
	
	$this->record[$tag] = $cdata;
    }

    function set_date ($tag, $attr) {
	$this->date = $attr['created'];
	$this->total_size = $attr['size'];
    }
}
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" type="text/css" href="admin.css" />
<link rel="author" href="http://www.indexdata.dk" />
</head>
<body>
<table width="100%" cellspacing="0">

<?php

$portal_root = preg_replace("/\/$/", "", $_REQUEST['root']);

$root = $_SERVER['DOCUMENT_ROOT'] . "/$portal_root";
$selected_type = $_REQUEST['select_type'];
$selected_type = strlen($selected_type) ? $selected_type : "all";

$selected_editor = $_REQUEST['select_editor'];
$selected_editor = strlen($selected_editor) ? $selected_editor : "all";

$stat_file = "$root/stat.tkl";

if (!@is_readable($stat_file)) {
    echo "<tr><td>Missing statistical report file stat.tkl</td></tr>";
    echo "<tr><td>Please configure and run /etc/cron.daily/tkl</td></tr>";
    exit;
}

$s = new stat_stream(array('xmlfile' => $stat_file));

$callbacks = array(
			'/stat/record'		=> 'dump_record',
			'/stat/record/*'	=> 'store_field',
			'/stat'			=> 'set_date',
		  );


$s->set_option('callbacks', $callbacks);
$s->set_option('fields', array('type', 'file', 'user', 'changed', 'size'));
$s->set_option('selected_type', $selected_type);
$s->set_option('selected_editor', $selected_editor);
$s->set_option('portalroot', $portal_root);

$s->parse();

echo "<tr><td><b>Portal statistics:</b></td>",
     "<td colspan=\"4\" align=\"right\"><b>Last updated: ", $s->date, "</b></td></tr>\n";

echo "<tr><td colspan=\"5\">&nbsp;</td></tr>\n";

echo "<form name=\"sort_form\" method=\"get\">\n";
echo "<input type=\"hidden\" name=\"root\" value=\"$portal_root\"/>\n";
echo "<input type=\"hidden\" name=\"select_type\" value=\"$selected_type\"/>\n";
echo "<input type=\"hidden\" name=\"select_editor\" value=\"$selected_editor\"/>\n";

echo "<tr><td colspan=\"2\"><b>Select editor:</b>&nbsp;<select name=\"select_editor\" onChange=\"submit()\">\n";

$sorted_editors = array_keys($s->editors);
natcasesort($sorted_editors);
array_unshift($sorted_editors, "all");

foreach ($sorted_editors as $user) {
    echo "  <option value=\"$user\"";
    if ($user == $selected_editor) {
	echo " selected=\"selected\"";
    }
    echo ">$user</option>\n";
}

echo "</select></td>\n";

echo "<td colspan=\"3\"><b>Select document type:</b>&nbsp;<select name=\"select_type\" onChange=\"submit()\">\n";

$sorted_types = array_keys($s->types);
natcasesort($sorted_types);
array_unshift($sorted_types, "all");

foreach ($sorted_types as $type) {
    echo "  <option value=\"$type\"";
    if ($selected_type == $type) {
	echo "  selected=\"selected\"";
    }
    echo ">$type</option>\n";
}

echo "</select></td></tr>\n";

echo "</form>\n";

echo "<tr><td colspan=\"5\">&nbsp</td></tr>\n";

echo "<tr><td colspan=\"3\"><b>Number of records shown: ", $s->count, "</b></td>";
echo "<td colspan=\"2\" align=\"right\"><b>", $s->size, " byte(s) of ", $s->total_size, " byte(s) in total</b></td></tr>\n";

echo "<tr><td colspan=\"5\">&nbsp</td></tr>\n";

echo $s->html;

$s->close();

?>

</table>
</body>
</html>
