<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: admin.xsl,v 1.61 2006/05/18 09:15:44 sondberg Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0">

    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="tkl_authenticated"/>
    <xsl:param name="root"/>
    <xsl:param name="lang"/>
    <xsl:param name="query"/>
    <xsl:param name="admin_cwd"/>
    <xsl:param name="tkl_bin"/>
    <xsl:param name="tkl_cwd"/>
    <xsl:param name="tkl_docroot"/>
    <xsl:param name="error" select="0"/>
    <xsl:param name="pop_up"/>
    <xsl:param name="pop_up_write"/>
    <xsl:param name="reload"/>
    <xsl:param name="overview"/>
    <xsl:param name="dead"/>
    <xsl:param name="stat"/>
    <xsl:param name="help"/>
    <xsl:param name="edit_schemas"/>
    <xsl:param name="link_target"/>
    <xsl:param name="stat_type"/>
    <xsl:param name="home"/>
    <xsl:param name="preload"/>
    <xsl:param name="preload_schema"/>
    <xsl:param name="dir_offset" select="'1'"/>
    <xsl:param name="file_offset" select="'1'"/>
    <xsl:param name="pager_increment" select="'30'"/>      <!-- Number of files/dirs to show on each page -->
    
    <xsl:variable name="path" select="concat($tkl_docroot, '/', $tkl_cwd)"/>
    <xsl:variable name="title" select="document('tkl-file://index.tkl')/portal/title"/>
    <xsl:variable name="this_user" select="document('tkl-user:/')"/>
    <xsl:variable name="quote">'</xsl:variable>
    <xsl:variable name="xml_editor">xform2.php</xsl:variable>
    <xsl:variable name="process_script">handle_call.php</xsl:variable>
    <xsl:variable name="prop_script">prop.php</xsl:variable>
    <xsl:variable name="schema_edit">schema-editor2.php</xsl:variable>
    <xsl:variable name="amp">&amp;</xsl:variable>
    <xsl:variable name="help_file">help.tkl</xsl:variable>
    <xsl:variable name="file_text">	<!-- File in singularis and pluralis -->
      <span xml:lang="da">file(r)</span>
      <span xml:lang="en">file(s)</span>
      <span xml:lang="el">αρχείο/α</span>
    </xsl:variable>
    <xsl:param name="stat_editor" select="$this_user/tkl-user/login"/> <!-- Chosen editor in stat page is per default the login user -->

<xsl:template name="main-page">
  <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <title>Administration - <xsl:value-of select="$title"/> - <xsl:value-of select="$this_user/tkl-user/name"/></title>
        <link rel="stylesheet" type="text/css" href="{$tkl_bin}/admin/admin.css" />
        <link rel="author" href="http://www.indexdata.dk" />
        <script type="text/javascript" src="{$tkl_bin}/admin/admin.js">
        </script>
    </head>
    <body>
      <xsl:attribute name="onLoad">
        <xsl:choose>
	  <xsl:when test="string-length($pop_up_write) &gt; 0">
	    <xsl:choose>
	      <xsl:when test="document(concat('tkl-file-exists:/?file=', $pop_up_write))/tkl-file-exists/exists = 0">pop_up_win('<xsl:value-of select="concat($tkl_bin, '/', $xml_editor, '?schema=', $pop_up, '&amp;admin_lang=', $lang, '&amp;cwd=', $tkl_cwd, '&amp;write_file=', $pop_up_write)"/>')</xsl:when>
	    </xsl:choose>
	  </xsl:when>
	</xsl:choose>
      </xsl:attribute>
      <form name="admin_main" method="get" action="{concat($tkl_bin, '/', $process_script)}">
        <input type="hidden" name="cwd" value="{$tkl_cwd}"/>
        <input type="hidden" name="action" value=""/>
	<input type="hidden" name="new_dir" value=""/>
	<input type="hidden" name="del_dir" value=""/>
	<input type="hidden" name="mv_dir_old" value=""/>
	<input type="hidden" name="mv_dir_new" value=""/>
      </form>
      <table border="0" cellpadding="0" cellspacing="0" width="100%">
        <tr>
	  <td width="50%" style="font: bold 18px verdana, arial, helvetica, sans-serif; color: #da7600;">
	    <xsl:value-of select="/admin/title"/>
	  </td>
	  <xsl:call-template name="menu"/>
	</tr>
	<tr>
	  <td colspan="6" style="border-bottom: 1px solid #627792;">&#xa0;</td>
	</tr>
	<tr>
	  <td colspan="6" height="25" valign="bottom">
	    <b><span xml:lang="da">Sti</span><span xml:lang="en">Path</span><span xml:lang="el">Μονοπάτι</span></b>
	  </td>
	</tr>
	<tr>
	  <td colspan="6" height="16" style="color: #da7600;" valign="bottom">
	    <xsl:call-template name="insert-path"/>
	  </td>
	</tr>
	<tr>
	  <td class="void" colspan="6" height="8" style="border-bottom: 1px solid #627792;">&#xa0;</td>
	</tr>
	<tr>
	  <td colspan="6" class="void" height="10">&#xa0;</td>
	</tr>
      </table>
      <table border="0" cellpadding="0" cellspacing="0" width="100%">
        <tr>
	  <td width="50%">&#xa0;</td>
	  <td width="10%">&#xa0;</td>
	  <td width="10%">&#xa0;</td>
	  <td width="10%">&#xa0;</td>
	  <td width="10%">&#xa0;</td>
	  <td width="10%">&#xa0;</td>
	</tr>
      
	<xsl:choose>
	  <xsl:when test="string-length($edit_schemas)">
	    <xsl:call-template name="insert-schemas"/>
	  </xsl:when>
	  <xsl:when test="string-length($dead)">
	    <xsl:call-template name="insert-dead"/>
	  </xsl:when>
	  <xsl:when test="string-length($stat)">
	    <tr>
	      <td colspan="6">
	        <table border="0" cellpadding="0" cellspacing="0" width="100%">
		  <xsl:call-template name="insert-stat"/>
		</table>
	      </td>
	    </tr>
	  </xsl:when>
	  <xsl:when test="string-length($help)">
	    <xsl:call-template name="insert-help"/>
	  </xsl:when>
	  <xsl:when test="string-length($home) or
	    (not(string-length($overview)) and $this_user/*/usertype != 'administrator')">
	    <xsl:call-template name="insert-home"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:call-template name="insert-overview"/>
	  </xsl:otherwise>
	</xsl:choose>
	<tr>
	  <td class="void" colspan="6" height="20" style="border-bottom: 1px solid #627792;">&#xa0;</td>
	</tr>
	<tr>
	  <td colspan="6" align="center"><xsl:value-of select="$this_user/tkl-user/name"/></td>
	</tr>
      </table>
    </body>
  </html>
</xsl:template>


<xsl:template name="insert-help">
  <xsl:variable name="helpdoc" select="document(concat('file:', $tkl_docroot, '/', $tkl_bin, '/admin/', $help_file))"/>

  <tr>
    <td colspan="6"><b><xsl:value-of select="$helpdoc/*/title[@xml:lang=$lang]"/></b></td>
  </tr>
  <tr>
    <td colspan="6">&#xa0;</td>
  </tr>
  <tr>
    <td colspan="6"><xsl:copy-of select="$helpdoc/*/body[@xml:lang=$lang]"/></td>
  </tr>
  <tr>
    <td colspan="6">
      <span xml:lang="da">Du kan installere DC-tkl-knappen <a href="{$tkl_bin}/dc-tkl2.php?cwd={$root}"><b>her</b></a>.</span>
      <span xml:lang="en">You can download the DC-tkl button <a href="{$tkl_bin}/dc-tkl2.php?cwd={$root}"><b>here</b></a>.</span>
      <span xml:lang="el">Μπορείτε να πάρετε το κουμπί DC-tkl<a href="{$tkl_bin}/dc-tkl2.php?cwd={$root}"><b>από εδώ</b></a>.</span>
    </td>
  </tr>
</xsl:template>

<xsl:template name="insert-stat">
  <iframe width="100%" height="400" frameborder="0" src="{$tkl_bin}/admin/show_stat.php?root={$root}"/>
</xsl:template>


<xsl:template name="insert-dead">
  <tr>
    <td colspan="6">
      <b><span xml:lang="da">Døde links</span><span xml:lang="en">Dead links</span><span xml:lang="el">Ανενεργοί σύνδεσμοι</span>:</b>
    </td>
  </tr>
  <tr>
    <td colspan="6">&#xa0;</td>
  </tr>
  
  <xsl:variable name="dead_exists" select="document('tkl-find:/?path=/badurls.tkl&amp;level=1')/tkl-find"/>

  <xsl:choose>
    <xsl:when test="$dead_exists/file/@path">
      <xsl:variable name="dead" select="document('tkl-file://badurls.tkl')"/>
      <tr>
        <td><b>URL</b></td>
	<td colspan="2"><b><span xml:lang="da">Fejlkode</span><span xml:lang="en">Error code</span><span xml:lang="el">Κωδικός λάθους</span></b></td>
	<td><b><span xml:lang="da">Sidst checket</span><span xml:lang="en">Last checked</span><span xml:lang="el">τελυταίος έλεγχος</span></b></td>
	<td align="center"><b># check</b></td>
      </tr>
      <tr>
        <td>&#xa0;</td>
      </tr>
      <xsl:for-each select="$dead/badurls/BADURL">
        <tr>
          <xsl:attribute name="class">
	    <xsl:choose>
	      <xsl:when test="position() mod 2 = 1">dark</xsl:when>
	      <xsl:when test="position() mod 2 = 0">light</xsl:when>
	    </xsl:choose>
	  </xsl:attribute>
	  <td><a href="{URL}" target="_blank"><xsl:value-of select="URL"/></a></td>
	  <td colspan="2"><xsl:value-of select="ERRORCODE"/></td>
	  <td><xsl:value-of select="CHECKEDLAST"/></td>
	  <td align="center"><xsl:value-of select="CHECKEDNUMBER"/></td>
	  <td align="center">
	    <a href="{$tkl_bin}/{$xml_editor}?xml_file={FILENAME}" target="_blank">
	      <span xml:lang="da">Ret</span>
	      <span xml:lang="en">Edit</span>
	      <span xml:lang="el">Τροποποίηση</span>
	    </a>
	  </td>
	</tr>
      </xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
      <tr>
        <td colspan="4">
	  <span xml:lang="da">Ingen oplysninger om døde links (badurls.tkl)</span>
	  <span xml:lang="en">No information about dead links (badurls.tkl)</span>
	  <span xml:lang="el">Δεν υπάρχουν πληροφορίες για τους ανενεργούσ συνδέσμους (badurls.tkl)</span>
	</td>
      </tr>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="insert-todo">
  Under construction
</xsl:template>


<xsl:template name="insert-home">
  <tr>
    <td colspan="6">
      <b>
	<span xml:lang="da">Mine hjemmekatalog(er):</span>
	<span xml:lang="en">My home directories:</span>
	<span xml:lang="el">Οι αρχικοί μου κατάλογοι:</span>
      </b>
    </td>
  </tr>
  <tr>
    <td colspan="6" class="void" height="10">&#xa0;</td>
  </tr>

  <xsl:for-each select="$this_user/tkl-user/area">
    <xsl:variable name="dirtitle" select="document(concat('tkl-find://?path=', ., 'index.tkl&amp;select=title'))"/>

    <tr>
      <xsl:attribute name="class">
        <xsl:if test="position() mod 2 = 1">dark</xsl:if>
        <xsl:if test="position() mod 2 = 0">light</xsl:if>
      </xsl:attribute>
      <td colspan="1">
        <a href="?admin=1&amp;overview=1&amp;cwd={$root}/{.}">
	  <xsl:value-of select="."/>
	</a>
      </td>
      <td colspan="5">
        <xsl:choose>
	  <xsl:when test="string-length($dirtitle) > 0">
	    <xsl:value-of select="$dirtitle"/>
	  </xsl:when>
	  <xsl:otherwise>?</xsl:otherwise>
	</xsl:choose>
      </td>
    </tr>
  </xsl:for-each>
</xsl:template>


<xsl:template name="insert-schemas">
  <tr>
    <td colspan="4"><b>
      <span xml:lang="da">XML schemaer</span>
      <span xml:lang="en">XML schemas</span>
      <span xml:lang="el">XML σχήματα</span>
    </b></td>
    <td colspan="2" align="right">
      <a href="{concat($tkl_bin, '/', $schema_edit, '?cwd=', $tkl_cwd, '&amp;filename=', $tkl_docroot, $root, '/schemas/')">
        <span xml:lang="da">Tilføj schema</span>
	<span xml:lang="en">Add schema</span>
	<span xml:lang="el">Προσθήκη σχήματος</span>
      </a>
    </td>
  </tr>
  <tr>
    <td colspan="6" class="void" height="10">&#xa0;</td>
  </tr>
  <xsl:variable name="xsd_files" select="document('tkl-find:/?path=/schemas/*.xsd&amp;level=1')/tkl-find"/>
  <xsl:for-each select="$xsd_files/file">
    <tr>
      <xsl:attribute name="class">
        <xsl:choose>
	  <xsl:when test="position() mod 2 = 1">dark</xsl:when>
	  <xsl:when test="position() mod 2 = 0">light</xsl:when>
	</xsl:choose>
      </xsl:attribute>
      <xsl:variable name="xsd_file" select="substring-after(@path, 'schemas/')"/>
      <xsl:variable name="show_xsd" select="substring-before($xsd_file, '.xsd')"/>
      <td colspan="4"><xsl:value-of select="$show_xsd"/></td>
      <td>
        <a href="{concat($tkl_bin, '/', $schema_edit, '?cwd=', $tkl_cwd, '&amp;filename=', $tkl_docroot, $root, '/schemas/', $xsd_file)}">
	  <span xml:lang="da">Ret</span>
	  <span xml:lang="en">Edit</span>
	  <span xml:lang="el">Τροποποίηση</span>
	</a>
      </td>
      <td>
        <a href="#">
	  <span xml:lang="da">Slet</span>
	  <span xml:lang="en">Delete</span>
	  <span xml:lang="el">Διαγραφή</span>
	</a>
      </td>
    </tr>
  </xsl:for-each>
</xsl:template>

<xsl:template name="insert-overview">
	<tr>
	  <td colspan="4">
	    <b>
	    <span xml:lang="da">Underkataloger i dette katalog</span>
	    <span xml:lang="en">Sub-directories in this directory</span>
	    <span xml:lang="el">Υποκατάλογοι σ' αυτόν τον κατάλογο</span>
	    :</b>
	  </td>
	  <td colspan="2" align="right">
	    <xsl:choose>
	      <xsl:when test="document(concat('tkl-grant://?type=create&amp;file=', $tkl_cwd))/tkl-grant/granted = 1">
	        <xsl:variable name="prompt_text">
		  <span xml:lang="da">Angiv katalognavn:</span>
		  <span xml:lang="en">Enter directory name:</span>
		  <span xml:lang="el">Εισάγετε το όνομα του καταλόγου:</span>
		</xsl:variable>

	        <a href="#" onClick="return prompt_newdir('{$prompt_text}')">
		  <span xml:lang="da"><img src="{$tkl_bin}/grafik/button_opret_underkatalog.gif" width="132" height="19" style="border: 0px;" alt="Opret underkatalog"/></span>
		  <span xml:lang="en"><img src="{$tkl_bin}/grafik/button_create_directory.gif" width="120" height="19" style="border: 0px;" alt="Create directory"/></span>
		  <span xml:lang="el"><img src="{$tkl_bin}/grafik/button_create_directory_el.gif" width="120" height="19" style="border: 0px;" alt="Create directory"/></span>
		</a>
	      </xsl:when>
	      <xsl:otherwise>
	        <span xml:lang="da"><img src="{$tkl_bin}/grafik/button_opret_underkatalog_off.gif" width="132" height="19" style="border: 0px;"/></span>
		<span xml:lang="en"><img src="{$tkl_bin}/grafik/button_create_directory_off.gif" width="132" height="19" style="border: 0px;"/></span>
		<span xml:lang="el"><img src="{$tkl_bin}/grafik/button_create_directory_off_el.gif" width="132" height="19" style="border: 0px;"/></span>
	      </xsl:otherwise>
	    </xsl:choose>
	  </td>
	</tr>
	<tr>
	  <td colspan="6" class="void" height="10">&#xa0;</td>
	</tr>

        <xsl:call-template name="insert-sub-dirs">
	  <xsl:with-param name="subdirs" select="document(concat(
                'tkl-browse:/?path=*&amp;select=title',
                '&amp;type=dir',
                '&amp;offset=', $dir_offset,
                '&amp;count_dir_content=1',
                '&amp;number=', $pager_increment) )"/>
	</xsl:call-template>

	<tr>
	  <td class="void" colspan="6" height="8" style="border-bottom: 1px solid #627792;">&#xa0;</td>
	</tr>
	<tr>
	  <td colspan="6" class="void" height="10">&#xa0;</td>
	</tr>
	<tr>
	  <td colspan="6">
	    <b>
	    <span xml:lang="da">Dokumenter</span>
	    <span xml:lang="en">Documents</span>
	    <span xml:lang="el">Έγγραφα</span>
	    :</b>
	  </td>
	</tr>
	<xsl:call-template name="insert-documents">
	  <xsl:with-param name="subdirs" select="document('tkl-browse:/?number=500&amp;path=*.tkl&amp;select=title')"/>
	</xsl:call-template>
</xsl:template>


<xsl:template name="insert-sub-dirs">
  <xsl:param name="subdirs"/>

  <xsl:variable name="deldir_text">
    <span xml:lang="da">Er du sikker på, at du vil slette kataloget?</span>
    <span xml:lang="en">Are you sure you want to delete directory?</span>
    <span xml:lang="el">είστε σίγουρος οτι θέλετε να διαγράψετε τον κατάλογο?</span>
  </xsl:variable>

  <xsl:variable name="refuse_deldir">
    <span xml:lang="da">Folderen kan ikke slettes, da den ikke er tom!</span>
    <span xml:lang="en">The folder cannot be deleted, it is not empty!</span>
    <span xml:lang="el">The folder cannot be deleted, it is not empty!</span>
  </xsl:variable>
  
  <xsl:variable name="mvdir_text">
    <span xml:lang="da">Angiv nyt katalognavn, - hvis du vil flytte kataloget til en anden sti i portalen, så angiv \<xsl:value-of select="$quote"/>/ny/sti/til/katalog\<xsl:value-of select="$quote"/></span>
    <span xml:lang="en">Enter new directory name - if you intend to move the directory to another position within this portal, enter \<xsl:value-of select="$quote"/>/new/path/to/directory\<xsl:value-of select="$quote"/></span>
    <span xml:lang="el">Δώστε το νέο όνομα του καταλόγου - αν θέλετε να μεταφέρετε τον κατάλογο σε άλλο σημείο του portal, δώστε \<xsl:value-of select="$quote"/>/new/path/to/directory\<xsl:value-of select="$quote"/></span>
  </xsl:variable>

  <xsl:variable name="del_link">
    <span xml:lang="da">Slet</span><span xml:lang="en">Delete</span><span xml:lang="el">Διαγραφή</span>
  </xsl:variable>

  <xsl:variable name="mv_link">
    <span xml:lang="da">Omdøb</span><span xml:lang="en">Rename</span><span xml:lang="el">Μετονομασία</span>
  </xsl:variable>
  
  <tr>
    <td colspan="4">
      <xsl:call-template name="admin-pager">
        <xsl:with-param name="pager_hits" select="$subdirs/tkl-browse/hits"/>
        <xsl:with-param name="pager_offset" select="$dir_offset"/>
        <xsl:with-param name="pager_var" select="'dir_offset'"/>
      </xsl:call-template>
    </td>
  </tr>
  <tr>
    <td colspan="4">&#xa0;</td>
  </tr>

  <xsl:for-each select="$subdirs/*/dir">
    <xsl:sort select="translate(@path, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
    
    <xsl:variable name="dirname" select="@path"/>

    <xsl:variable name="test" select="document(concat(
                'tkl-find:/?path=', $dirname, '&amp;mask=index.tkl&amp;level=1&amp;select=title'))"/>

    <xsl:if test="not(starts-with($dirname, 'upl-'))"> <!-- we hide upload directories -->
      <tr>
	<xsl:attribute name="class">
	  <xsl:choose>
	    <xsl:when test="position() mod 2 = 1">dark</xsl:when>
	    <xsl:when test="position() mod 2 = 0">light</xsl:when>
	  </xsl:choose>
	</xsl:attribute>
        
	<xsl:variable name="rel_path" select="concat($tkl_cwd, '/', $dirname)"/>

	<td colspan="4"><a href="{$tkl_bin}/shell.php?cwd={$rel_path}&amp;admin=1&amp;overview=1"
	                   title="{@count} {$file_text}">
	  <xsl:value-of select="$dirname"/>&#xa0;-&#xa0;
	  "<xsl:choose>
	    <xsl:when test="$test/tkl-find/dir/file[1]">
	      <xsl:value-of select="$test/tkl-find/dir/file[1]/title"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <span xml:lang="da">Ingen titel</span><span xml:lang="en">No title</span><span xml:lang="el">Χωρίς τίτλο</span>
	    </xsl:otherwise>
	  </xsl:choose>"
	</a></td>
	<td>
	  <xsl:choose>
	    <xsl:when test="document(concat('tkl-grant://?type=write&amp;file=', $tkl_cwd))/tkl-grant/granted = 1">
              <xsl:choose>
                <xsl:when test="@count = 0">
                  <a href="#" onClick="return prompt_deldir('{$deldir_text}',
                                                    '{$dirname}')"><xsl:copy-of
                                                       select="$del_link"/></a>
                </xsl:when>
                <xsl:otherwise>
                  <a href="#" onClick="alert('{$refuse_deldir}')">
                    <xsl:copy-of select="$del_link"/>
                  </a>
                </xsl:otherwise>
              </xsl:choose>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:copy-of select="$del_link"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</td>
	<td>
	  <xsl:choose>
	    <xsl:when test="document(concat('tkl-grant://?type=write&amp;file=', $tkl_cwd))/tkl-grant/granted = 1">
	      <a href="#" onClick="return prompt_mvdir('{$mvdir_text}', '{$dirname}')"><xsl:copy-of select="$mv_link"/></a>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:copy-of select="$mv_link"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</td>
      </tr>
    </xsl:if>
  </xsl:for-each>
</xsl:template>


<xsl:template name="insert-documents">
  <xsl:param name="subdirs"/>

  <xsl:variable name="allowed_schema">
    <xsl:if test="$this_user/*/usertype = 'administrator'">
      <allowSchema schema="directory.xsd">
	<fileNaming>fixedName</fileNaming>
	<nameMask>directory.tkl</nameMask>
      </allowSchema>
    </xsl:if>
  </xsl:variable>

  <xsl:variable name="dir_config" select="/admin/admin_config/dir_config"/>
  
  <xsl:variable name="directory" select="document(concat('tkl-file:/', $dir_config, 'directory.tkl'))/directory"/>
  
  <xsl:variable name="sorted_dir">
    <xsl:for-each select="$directory/allowSchema">
      <xsl:sort select="@schema"/>
      <xsl:copy-of select="."/>
    </xsl:for-each>
    <xsl:if test="not($directory/allowSchema[@schema='directory.xsd'])"> <!-- Allow directory.xsd if not already there -->
      <xsl:copy-of select="$allowed_schema"/>
    </xsl:if>
  </xsl:variable>
  
  <xsl:variable name="filtered_dir">
    <xsl:for-each select="$sorted_dir/allowSchema">
      <xsl:if test="not(preceding-sibling::allowSchema[1]/@schema = @schema)">
        <xsl:copy-of select="."/>
      </xsl:if>
    </xsl:for-each>
  </xsl:variable>
  
  <xsl:for-each select="$filtered_dir/allowSchema">
    <xsl:variable name="naming" select="document(concat('tkl-unique://?format=', translate(nameMask, '#', '%'), '&amp;type=', fileNaming, '&amp;dummy=', position()))/tkl-unique"/>
    <xsl:variable name="this_schema" select="substring-before(@schema, '.xsd')"/>
    <xsl:variable name="this_overviewfield" select="overviewField"/>

    <tr>
      <td colspan="6" class="void" height="25">&#xa0;</td>
    </tr>

    <xsl:variable name="docs" select="$subdirs/*/file[name(document(concat('tkl-file:/', @path))/*) = $this_schema]"/>
    
    <tr>
      <td colspan="3">
        <b><xsl:value-of select="$this_schema"/></b>:&#xa0;<xsl:value-of select="count($docs)"/>&#xa0;<xsl:value-of select="$file_text"/>
      </td>
      <td colspan="3" align="right">
        <xsl:choose>
	  <xsl:when test="document(concat('tkl-grant://?type=create&amp;file=', $tkl_cwd))/tkl-grant/granted = 1 and not($naming/exists = 1)">
	    <xsl:variable name="schema_path" select="document(concat('tkl-default://?path=schemas/', @schema))/tkl-default"/>

	    <xsl:call-template name="insert-user-templates">
	      <xsl:with-param name="schema" select="$this_schema"/>
	    </xsl:call-template>

	    <xsl:variable name="default_file">
	      <xsl:choose>
	        <xsl:when test="$preload_schema = $this_schema"><xsl:value-of select="$preload"/></xsl:when>
		<xsl:otherwise></xsl:otherwise>
	      </xsl:choose>
	    </xsl:variable>

	    <a href="javascript:pop_up_win('{concat($tkl_bin, '/', $xml_editor, '?schema=', $schema_path/abs_path, '&amp;admin_lang=', $lang, '&amp;write_file=', $path, '/', $naming/unique, '&amp;cwd=', $tkl_cwd, '&amp;file_spec=', $naming/file_spec, '&amp;default_file=', $default_file)}')">
	      <span xml:lang="da"><img src="{$tkl_bin}/grafik/button_opret_dokument.gif" width="120" height="19" style="border: 0px;" alt="Opret dokument" /></span>
	      <span xml:lang="en"><img src="{$tkl_bin}/grafik/button_create_document.gif" width="120" height="19" style="border: 0px;" alt="Create document" /></span>
	      <span xml:lang="el"><img src="{$tkl_bin}/grafik/button_create_document_el.gif" width="120" height="19" style="border: 0px;" alt="Create document" /></span>
	    </a>
	  </xsl:when>
	  <xsl:otherwise>
	    <span xml:lang="da"><img src="{$tkl_bin}/grafik/button_opret_dokument_off.gif" width="120" height="19" style="border: 0px;" alt="Opret dokument" /></span>
	    <span xml:lang="en"><img src="{$tkl_bin}/grafik/button_create_document_off.gif" width="120" height="19" style="border: 0px;" alt="Create document" /></span>
	    <span xml:lang="el"><img src="{$tkl_bin}/grafik/button_create_document_off_el.gif" width="120" height="19" style="border: 0px;" alt="Create document" /></span>
	  </xsl:otherwise>
	</xsl:choose>
      </td>
    </tr>
    <tr>
      <td colspan="6" class="void" height="10">&#xa0;</td>
    </tr>
    <xsl:for-each select="$docs">
      <xsl:sort select="translate(title, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
      <xsl:variable name="tkl_file" select="@path"/>
      <xsl:variable name="tkl_doc" select="document(concat('tkl-file:/', $tkl_file))"/>
      <xsl:variable name="tkl_doctitle">
        <xsl:choose>
          <xsl:when test="$this_overviewfield">
            <xsl:value-of select="$tkl_doc/*/*[name()=$this_overviewfield]"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="title"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:call-template name="insert-tkl-file">
        <xsl:with-param name="tkl_doc" select="$tkl_doc"/>
	<xsl:with-param name="tkl_file" select="$tkl_file"/>
	<xsl:with-param name="title" select="string($tkl_doctitle)"/>
	<xsl:with-param name="class">
	  <xsl:choose>
	    <xsl:when test="position() mod 2 = 1">dark</xsl:when>
	    <xsl:when test="position() mod 2 = 0">light</xsl:when>
	  </xsl:choose>
	</xsl:with-param>
      </xsl:call-template>
    </xsl:for-each>
    <xsl:if test="not($docs)">
      <tr class="dark">
        <td colspan="6">
	  <span xml:lang="da">Ingen dokumenter</span>
	  <span xml:lang="en">No documents</span>
	  <span xml:lang="el">Κανένα έγγραφο</span>
	</td>
      </tr>
    </xsl:if>
  </xsl:for-each>
</xsl:template>


<xsl:template name="insert-user-templates">
  <xsl:param name="schema"/>
  <xsl:variable name="select_title">
    <span xml:lang="da">Ønsker du at indlæse en gemt bruger template i editoren?</span>
    <span xml:lang="en">Do you wish to load a saved user template into the editor?</span>
    <span xml:lang="el">Θέλετε να φορτώσετε ένα αποθηκευμένο πρότυπο στον κειμενογράφο? </span>
  </xsl:variable>
  <xsl:variable name="template_dir" select="document('tkl-config:/?name=user_template_dir')/tkl-config/setting"/>
  <xsl:variable name="templates" select="document(concat('tkl-find:/?path=/', $template_dir, '/',
  							 $this_user/tkl-user/login, '/*.tkl'))/tkl-find"/>
  
  <xsl:variable name="drop_down">
    <xsl:for-each select="$templates/file">
      <xsl:variable name="portal_file" select="substring-after(@path, $root)"/>
      <xsl:variable name="candidate" select="document(concat('tkl-file:/', $portal_file))"/>
      
      <xsl:if test="name($candidate/*) = $schema">
        <option value="{$portal_file}">
	  <xsl:if test="$preload_schema = $schema and $portal_file = $preload">
	    <xsl:attribute name="selected">selected</xsl:attribute>
	  </xsl:if>
	  <xsl:choose>
	    <xsl:when test="$candidate/*/title"><xsl:value-of select="$candidate/*/title"/></xsl:when>
	    <xsl:otherwise><xsl:value-of select="substring-after($portal_file,
	    					 concat('/', $template_dir, '/',
						 $this_user/tkl-user/login, '/'))"/></xsl:otherwise>
	  </xsl:choose>
	</option>
      </xsl:if>
    </xsl:for-each>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="string-length($template_dir) and $drop_down/option">
      <form name="preload_{$schema}" method="get">
      <input type="hidden" name="preload_schema" value="{$schema}"/>
      <input type="hidden" name="cwd" value="{$tkl_cwd}"/>
      <input type="hidden" name="admin" value="1"/>
      <input type="hidden" name="overview" value="1"/>
      <select name="preload" title="{$select_title}" onChange="submit()">
        <option value="">	<!-- Always allow user not to use temnplates ... -->
	  <span xml:lang="da">Nyt dokument</span>
	  <span xml:lang="en">New document</span>
	  <span xml:lang="el">Νέο έγγραφο</span>
	</option>
        <xsl:copy-of select="$drop_down"/>
      </select>
      </form>
    </xsl:when>
  </xsl:choose>

</xsl:template>


<xsl:template name="insert-tkl-file">
  <xsl:param name="tkl_doc"/>
  <xsl:param name="class" select="light"/>
  <xsl:param name="tkl_file"/>
  <xsl:param name="title"/>
  <xsl:variable name="edit">
    <span xml:lang="da">Ret</span><span xml:lang="en">Edit</span><span xml:lang="el">Τροποποίηση</span>
  </xsl:variable>
  <xsl:variable name="prop">
    <span xml:lang="da">Egenskaber</span><span xml:lang="en">Properties</span><span xml:lang="el">Ιδιότητες</span>
  </xsl:variable>
  <xsl:variable name="follow_link">
    <span xml:lang="da">Gå til primær</span><span xml:lang="en">Goto primary</span>
    <span xml:lang="el">Μετάβαση στην πηγή</span>
  </xsl:variable>
  
  <tr class="{$class}">
    <td colspan="3">
      <xsl:if test="$tkl_doc/*/@hidden = '1'">
        <xsl:attribute name="style">font-style: italic;</xsl:attribute>
      </xsl:if>
	 
      <xsl:choose>
        <xsl:when test="string-length($title) &gt; 0"><xsl:value-of select="$title"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$tkl_file"/></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:if test="@symlinkdir">
        <img src="{$tkl_bin}/grafik/arrow_blue_right.gif"/>
	<a href="{$root}?admin=1&amp;cwd={$tkl_cwd}/{@symlinkdir}&amp;link_target={@symlinkfile}"><xsl:value-of select="$follow_link"/></a>
      </xsl:if>
      <xsl:if test="$link_target and $link_target = $tkl_file"><img align="right" src="{$tkl_bin}/grafik/arrow_blue_right.gif"/></xsl:if> 
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="document(concat('tkl-grant://?type=read&amp;file=', $tkl_file))/tkl-grant/granted = 1">
	  <a href="javascript:pop_up_win('{concat($tkl_bin, '/', $xml_editor, '?xml_file=', $path, '/', $tkl_file, '&amp;admin_lang=', $lang, '&amp;local_xsd_path=&amp;cwd=', $tkl_cwd)}')">
	    <xsl:copy-of select="$edit"/>
	  </a>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:copy-of select="$edit"/>
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="document(concat('tkl-grant://?type=write&amp;file=', $tkl_file))/tkl-grant/granted = 1">
	  <a href="javascript:small_window('{concat($tkl_bin, '/', $prop_script, '?file=', $tkl_file, '&amp;cwd=', $tkl_cwd)}')"><xsl:copy-of select="$prop"/></a>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:copy-of select="$prop"/>
	</xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>
  

<!-- produces path of "breadcrumbs" back to the root -->
<xsl:template name="insert-path">
    <xsl:variable name="path" select="document('tkl-path://?select=title&amp;no_index=1')/tkl-path"/>
    <xsl:for-each select="$path/step">
      <xsl:choose>
      <xsl:when test="following-sibling::step">
	<a href="{$tkl_bin}/shell.php?cwd={@path}&amp;admin=1&amp;overview=1">
	  <xsl:variable name="file_title" select="title"/>
	  <xsl:choose>
	    <xsl:when test="string-length($file_title) &gt; 0"><xsl:value-of select="$file_title"/></xsl:when>
	    <xsl:otherwise>
	      <span xml:lang="da">Ingen titel</span><span xml:lang="en">No title</span><span xml:lang="el">Χωρίς τίτλο</span>
	    </xsl:otherwise>
	  </xsl:choose>
	</a>&#xa0;&gt;&#xa0;
      </xsl:when>
      <xsl:otherwise>
	<span style="color: #000000;"><xsl:value-of select="."/></span>
      </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
</xsl:template>


<xsl:template name="menu">
  <!-- Out-commented by Anders: Could not figure out why it was there...
  <xsl:variable name="mod_root">
    <xsl:choose>
      <xsl:when test="string-length(substring-after($root, '/')) &gt; 0"><xsl:value-of select="$root"/></xsl:when>
    </xsl:choose>
  </xsl:variable>
  -->
  <td colspan="5">
    <table width="100%">
      <tr>
        <xsl:for-each select="/*/menuitem">
          <td width="{ceiling(100 div last())}%" align="center">
	    <b>
	      <a href="?admin=1&amp;cwd={$tkl_cwd}&amp;{@path}" class="top"><xsl:value-of select="."/></a>
	    </b>
	  </td>
	</xsl:for-each>
      </tr>
    </table>
  </td>
</xsl:template>


<xsl:template match="admin">
    <xsl:call-template name="main-page"/>
</xsl:template>


<xsl:template name="main-body">
    <xsl:variable name="subjects" select="document(concat('tkl-find://',
        '?path=links/*',
	'&amp;mask=index.tkl',
	'&amp;select=title',
	'&amp;level=2'))"/>

    <xsl:for-each select="$subjects/*/dir">
        <xsl:sort select="@path"/>
        <p/>
	<b><a href="{@path}"><xsl:value-of select="file"/></a></b>
	<br/>
	<xsl:for-each select="dir">
	    <xsl:sort select="@path"/>
	    <a href="{file/@path}"><xsl:value-of select="file"/></a>
	    <br/>
	</xsl:for-each>
    </xsl:for-each>
</xsl:template>


<xsl:template name="admin-pager">
  <xsl:param name="pager_offset"/>
  <xsl:param name="pager_hits"/>
  <xsl:param name="pager_var"/>
  <xsl:param name="pager_max_pages" select="'10'"/>
  <xsl:variable name="pager_session" select="concat(
        '&amp;cwd=', $tkl_cwd,
        '&amp;file_offset=', $file_offset,
        '&amp;dir_offset=', $dir_offset,
        '&amp;overview=1',
        '&amp;admin=1&amp;')"/>
  
  <xsl:variable name="pager"  select="document(concat(
                              'tkl-pager:/?hits=', $pager_hits,
                              '&amp;inc=', $pager_increment,
                              '&amp;offset=', $pager_offset ) )"/>
                              
  <xsl:if test="count($pager/tkl-pager/page) &gt; 1">
      <p>
        <span xml:lang="da">Flere sider</span>
        <span xml:lang="en">Other pages</span>:&#xa0;
        <span xml:lang="el">Άλλες σελίδες</span>:&#xa0;
      
      <xsl:variable name="current_page" select="$pager/tkl-pager/page[@offset = $pager_offset]/@page"/>
      
      <xsl:if test="$pager/tkl-pager/page[1]/@page &lt; ($current_page - $pager_max_pages + 1)">
        &lt;&lt;&lt;&#xa0;
      </xsl:if>
      
      <xsl:for-each select="$pager/tkl-pager/page[@page &gt; ($current_page - $pager_max_pages) and @page &lt; ($current_page + $pager_max_pages)]">
        <xsl:choose>
          <xsl:when test="@offset = $pager_offset">
            <b><xsl:value-of select="@page"/></b>
          </xsl:when>
          <xsl:otherwise>
            <a href="{concat('?', $pager_session, $pager_var, '=', @offset) }"><xsl:value-of select="@page"/></a>
          </xsl:otherwise>
        </xsl:choose>
        
        <xsl:if test="not( position() = last() )">&#xa0;|&#xa0;</xsl:if>
      </xsl:for-each>
      
      <xsl:if test="$pager/tkl-pager/page[last()]/@page &gt; ($current_page + $pager_max_pages - 1)">
        &#xa0;&gt;&gt;&gt;
      </xsl:if>
      </p>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
