<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKLITE.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: admin.php,v 1.73 2003/09/09 13:56:01 adam Exp $
*/

require "config.php";
require "standards.php";

header("Content-Type: text/html; charset=utf-8");

//$debug = 1;
find_portal_root();
require "read_local_config.php";
$this_user = check_auth_user();

?>

<html>
  <head>
    <title>Administration af portal</title>
    <link rel="stylesheet" type="text/css" href="styles.css" />
    <script language="javascript1.2">
      function pop_up_win (schema, cwd, pop_up_write) {
	  window.open("<?php echo $xml_editor?>?schema="+schema+"&cwd="+cwd+"&write_file="+pop_up_write, 'autoindex', 'width=600,height=600,screenX=1,screenY=1,top=1,left=1,resizable=yes,scrollbars=1,scrolling=yes');
      }
      function remove_file (file, abs_file) {
	  if (confirm("Vil du slette filen "+ file + "?")) {
	      document.remove_form.remove.value = abs_file;
	      document.remove_form.submit();
	  }
      }
      function properties (file, cwd) {
	  window.open("<?php echo $admin_property?>?file="+file+"&cwd="+cwd, 'autoindex', 'width=550,height=350,screenX=1,screenY=1,top=1,left=1,resizable=yes,scrollbars=1,scrolling=yes');
      }
    </script>
  </head>

  <body bgcolor="white"<?php

  if ($pop_up && !file_exists("$abs_cwd/$created_dir/index.tkl")) {
      echo " onLoad=\"pop_up_win('$pop_up', '$cwd', '$pop_up_write')\"";
  }
  ?>><table width="100%">
    <form name="dummy">
    <input type="hidden" name="reload" value="<?php echo $reload ?>">
    </form>

    <tr><td align="center"><h1>Administration af portal</h1></td></tr>
    <tr><td>&nbsp;</td></tr>
    <tr><td style="line-height: 11px;" class="dotted">&nbsp;</td></tr>
    <tr><td>

<?php

$valid_actions = array(
    "add_dir"	=>	array('', "Underkataloger"),
    "xsd"	=>	array('administrator', "Tilfj/editer schema"),
    "badurls"	=>	array('', "Dde links"),
    "index"	=>	array('administrator', "Indeksering"),
    "others"	=>	array('', "Andre funktioner"),
    "help"	=>	array('', "Hjlp"),
);

if (!($dir_conf = default_file($dir_config))) {
    exception("Manglende eller forkert <b>$dir_config</b> i portalen med rod i <b>$doc_root</b>");
    dir;
}

browse();
if (isset($action)) {
    $fct = "action_$action";
    echo "<table width=\"100%\">\n";
    echo "<tr><td style=\"line-height: 11px;\" class=\"dotted\">&nbsp;</td></tr>\n";
    if (function_exists($fct)) {
	echo "<tr><td>\n";
	echo "<!-- The action='$action' HTML starts here -->\n";
	$fct();
	echo "<!-- Action='$action' HTML stops here -->\n";
	echo "</td></tr>\n";
    } else {
	exception("Handlingen '$action' er ikke understttet");
	die;
    }
    echo "</table>\n";
}


function browse () {
    global  $xml_suffix, $doc_root, $cwd, $dir_schema, $dir_config, $xsd_path, $abs_cwd, $admin_process, $admin_script, $xml_editor, $context, $highlight;
    $cols = 1;
    $width = (int) (100 / $cols);
    $count = 0;
    $files = array();
    $schemas = get_schemas();
    $apache = $_SERVER['DOCUMENT_ROOT'];
    $abs_xsd_path = "$apache/$doc_root/$xsd_path";
    $global_xsd_path = $xsd_path;

    echo "<table width=\"100%\"><tr>\n";
    echo "<td width=\"$width%\" colspan=\"$cols\"><h2>", insert_path($admin_script), "</h2></td></tr>\n<tr><td width=\"$width%\" colspan=\"$cols\">&nbsp;</td></tr>\n<tr>";
    if (is_array($content = dir_content($abs_cwd))) {
	if (is_array($dirs = $content['dir'])) {
	    usort($dirs, "dir_cmp");
	    foreach ($dirs as $entry) {
		$count ++;
		echo "<td width=\"$width%\"><a href=\"$admin_script?";
		if (file_exists($indexer = "$abs_cwd/$entry/index.tkl")) {
		    $show_entry = get_title($indexer);
		    if (strlen(trim($show_entry))) {
			$show_entry = "$entry&nbsp;-&nbsp;&quot;$show_entry&quot;";
		    } else {
			$show_entry = $entry;
		    }
		} else {
		    $show_entry = $entry;
		}
		echo makeparms($context, array("cwd"=>"$cwd/$entry")), "\" title=\"", get_last_updated("$apache/$doc_root/$entry"), "\">[&nbsp;$show_entry&nbsp;]</a></td>";
		if ($count % $cols == 0) {
		    echo "</tr>\n<tr>";
		}
	    }
	}
	if (is_array($records = $content['file'])) {
	    foreach ($records as $entry) {
		if ($schema = extract_schema("$abs_cwd/$entry")) {
		    if (!strlen($title = get_title("$abs_cwd/$entry"))) {
			$title = "Ingen titel";
		    }
		    if (!strlen($creator = get_creator("$abs_cwd/$entry"))) {
			$creator = "Ukendt";
		    }
		    $files[$schema][] = array("show_record"=>$entry, "file"=>$entry, "title"=>$title, "creator"=>$creator);
		} else {
		    $files['unknown_schema'][] = $entry;
		}
	    }
	    if (!$count) {
		echo "<td>Ingen underkataloger</td>";
		$count ++;
	    }
	}
	$missing = $cols - ($count % $cols);
	if ($missing) {
	    echo "<td colspan=\"$missing\">&nbsp</td>";
	}
	echo "</tr><tr><td>&nbsp;</td></tr><tr><td colspan=\"$cols\" style=\"line-height: 11px;\" class=\"dotted\">&nbsp;</td></tr></table>\n";
	echo "<h2>Dokumenter i dette katalog</h2>";
	echo "<table cellpadding=\"10\" border=\"0\" rules=\"rows\">\n";
	echo "<tr><td width=\"20%\"><b>Dokumenttype</b></td><td width=\"80%\"><b>Dokumenter</b></td></tr>\n";
	$cols = 1;
	echo "<form name=\"remove_form\" action=\"$admin_process\" method=\"post\">";
	echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">";
	echo "<input type=\"hidden\" name=\"remove\" value=\"\">";
	echo "</form>";
	foreach ($files as $schema => $file_list) {
	    $show_schema = get_show_schema($schema);
	    echo "<tr ><td width=\"20%\" valign=\"top\"><b>" . preg_replace("/\..*?$/", "", $show_schema) . "</b></td><td width=\"80%\">";
	    $count = 0;
	    echo "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n";
	    usort($file_list, "title_cmp");
	    if (is_array($schema_info = $schemas[$schema])) {
		if ($schema != $dir_schema) {
		    echo "<tr><td valign=\"top\" colspan=\"4\">";
		    insert_new_record($schema, $schema_info);
		    echo "</td></tr>";
		    $schemas[$schema] = 0;
		}
	    }
	    foreach ($file_list as $file_info) {
		echo "<tr>";
		$file = $file_info['file'];
		$show_record = $file_info['show_record'];
		$count ++;
		$changed = get_last_updated("$abs_cwd/$file");
		$title = $file_info['title'];
		$creator = $file_info['creator'];
		$hidden = get_hidden("$abs_cwd/$file");
		$local_xsd_path = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$xsd_path";

		echo "<td valign=\"top\" width=\"30%\">";
		if ($highlight == $show_record) {
		    echo "<b>";
		}
		print "$show_record";
		if ($highlight == $show_record) {
		    echo "</b>";
		}
		if (is_link("$abs_cwd/$file")) {
		    $link = readlink("$abs_cwd/$file");
		    $cwd_path = preg_split("/\//", $cwd);
		    $link_path = preg_split("/\//", $link);
		    $target_file = array_pop($link_path);
		    foreach ($link_path as $entry) {
			if ($entry == "..") {
			    array_pop($cwd_path);
			} else {
			    $cwd_path[] = $entry;
			}
		    }
		    $target_cwd = join("/", $cwd_path);

		    echo "&nbsp;<a href=\"?", makeparms($context, array('highlight'=>$target_file, 'cwd'=>$target_cwd)), "\" title=\"Flg dette link til dets kilde\">(link)</a>";
		}
		print "</td><td valign=\"top\" width=\"50%\">";
		if ($highlight == $show_record) {
		    echo "<b>";
		}
		if ($hidden)
		    print "<em>";
		print "$title";
		if ($hidden)
		    print "</em>";
		if ($highlight == $show_record) {
		    echo "</b>";
		}
		print "</td><td valign=\"top\" width=\"10%\">";


		if (is_granted($file, "read")) {
		    echo "<a href=\"$xml_editor?", makeparms($context, array("xml_file"=>"$abs_cwd/$file", "local_xsd_path"=>$local_xsd_path)), "\" title=\"Sidst ndret: $changed - Oprettet af: $creator\"", editor_popup(), ">Ret</a>";
		} else {
		    echo "Ret";
		}
		echo "</td><td valign=\"top\" width=\"10%\">";
		if (is_granted($file, "write")) {
		    echo "<a href=\"javascript:properties('$file', '$cwd')\">Egenskaber</a>";
		} else {
		    echo "Egenskaber";
		}
		echo "</td></tr>";
		echo "\n";
	    }
	    echo "</table>";
	}
	foreach ($schemas as $schema => $schema_info) {
	    if (!is_array($schema_info)) {
		continue;
	    }
	    if ($schema == $dir_schema) {
		if (file_exists("$abs_cwd/$dir_config")) {
		    continue;
		}
	    }
	    $show_schema = preg_replace("/\.xsd$/", "", get_show_schema($schema));
	    echo "<tr><td width=\"20%\" valign=\"top\"><b>$show_schema</b></td><td width=\"80%\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100\"><tr><td valign=\"top\" colspan=\"4\">";
	    insert_new_record($schema, $schema_info);
	    echo "</tr></td></table>";
	    echo "</td></tr>\n";
	}
	echo "</td></tr>";
	echo "</table>\n";
	echo "&nbsp;<p>";
	//get_links($_SERVER['DOCUMENT_ROOT'] . "/$doc_root", $all_links = array());
	//echo "<pre>";
	//print_r($all_links);
	//echo "</pre>\n";
    } else {
	exception("Kan ikke finde document katalog '$cwd'");
    }
}


function dir_cmp ($a, $b) {
    return strcmp(strtolower($a), strtolower($b));
}


function title_cmp ($a, $b) {
    return strcmp(strtolower($a['title']), strtolower($b['title']));
}


function get_show_schema ($full_schema_name) {
    return preg_replace("/^.*\//", "", $full_schema_name);
}



function insert_new_record ($schema, $schema_info) {
    global $cwd, $abs_cwd, $xml_editor, $context;

    if (!is_granted($cwd, "create")) {
	echo "&nbsp;";
	return;
    }
    if ($unique_file = create_file_name($schema, $abs_cwd)) {
	$write_file = "$abs_cwd/$unique_file";
    } else {
	$write_file = $abs_cwd;
	$file_spec = 1;
    }
    if ($unique_file && file_exists($write_file)) {
	echo "&nbsp;";
	return;
    }
    $show_schema = get_show_schema($schema);
    $schema_file = $schema_info['file'];
    echo "<a href=\"$xml_editor?", makeparms($context, array("schema"=>$schema_file, "write_file"=>$write_file, "file_spec"=>$file_spec)), "\"", editor_popup(), " title=\"Opret et nyt dokument af typen $show_schema\"><b>Opret dokument</b></a>";
}


function editor_popup () {
    return " onClick=\"window.open('', 'xform', 'width=600,height=600,screenX=1,screenY=1,top=1,left=1,resizable=yes,scrollbars=1,scrolling=yes')\" target=\"xform\"";
}


function action_add_dir () {
    global $dir_conf, $new_err, $new_suc, $xml_editor, $del_suc, $mv_suc, $del_err, $mv_err, $new_dir, $xsd_path, $mv_dir, $del_dir, $abs_cwd, $cwd, $admin_process, $action, $created_dir;

    echo "<h2>Rediger underkataloger</h2>\n";
    if (!is_granted($cwd, "create")) {
	echo "<b>Du har ikke brugerrettighed til at manipulere med underkataloger</b>";
	return;
    }
    echo "<table width=\"100%\">\n";

    echo "<tr><form name=\"add_dir\" method=\"get\" action=\"$admin_process\">";
    echo "<input type=\"hidden\" name=\"action\" value=\"$action\">";
    echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">";
    echo "<input type=\"hidden\" name=\"abs_cwd\" value=\"$abs_cwd\">";
    echo "<td><b>Nyt underkatalog:</b></td>";
    echo "<td><input name=\"new_dir\" type=\"text\" value=\"$new_dir\"></td>";
    echo "<td><input value=\"Udfr\" type=\"submit\"></td><td width=\"30%\">";
    if ($new_err) {
	echo $new_err;
    } elseif ($new_suc) {
	echo $new_suc, "<br>";
    }
    echo "</td></tr>";
    echo "</form></tr>\n";

    echo "<tr><form name=\"chg_dir\" method=\"get\" action=\"$admin_process\">";
    echo "<input type=\"hidden\" name=\"action\" value=\"$action\">";
    echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">";
    echo "<input type=\"hidden\" name=\"abs_cwd\" value=\"$abs_cwd\">";
    echo "<td><b>Omdb dette katalog til:</b></td>";
    echo "<td><input name=\"mv_dir\" type=\"text\"></td>";
    echo "<td><input value=\"Udfr\" type=\"submit\"></td><td width=\"30%\">";
    if ($mv_err) {
	echo $mv_err;
    } else {
	echo $mv_suc;
    }
    echo "</td></tr>";
    echo "</form></tr>\n";

    echo "<tr><form name=\"del_dir\" method=\"get\" action=\"$admin_process\">";
    echo "<input type=\"hidden\" name=\"action\" value=\"$action\">";
    echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">";
    echo "<input type=\"hidden\" name=\"abs_cwd\" value=\"$abs_cwd\">";
    echo "<td><b>Slet underkatalog:</b></td>";
    echo "<td><input name=\"del_dir\" type=\"text\"></td>";
    echo "<td><input value=\"Udfr\" type=\"submit\"></td><td width=\"30%\">";
    if ($del_err) {
	echo $del_err;
    } else {
	echo $del_suc;
    }
    echo "</td></tr>";
    echo "</form></tr>\n";
    echo "</table>\n";
}


function action_badurls () {
    global $doc_root, $bad_urls, $bad_urls_xslt;
    $xslt = xslt_create();
    $full_bad_urls = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$bad_urls";
    $full_bad_urls_xslt = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$bad_urls_xslt";

    if (!file_exists($full_bad_urls)) {
	echo "<b>Mangler filen <em>$full_bad_urls</em></b>";
	return;
    }
    if (!file_exists($full_bad_urls_xslt)) {
	echo "<b>Mangler filen <em>$full_bad_urls_xslt</em></b>";
	return;
    }
    if ($result = @xslt_process($xslt, $full_bad_urls, $full_bad_urls_xslt)) {
	echo $result;
    } else {
	echo sprintf("Kunne ikke hndtere XML dokument [%d]: %s", xslt_errno($xslt), xslt_error($xslt));
    }
    xslt_free($xslt);
}


function get_index_xsd() {
    global $doc_root, $xsd_path, $dir_conf;
    $index_xsd = 0;

    if ($config = file($dir_conf)) {
	foreach ($config as $line) {
	    if (preg_match("/<autoIndex>(.*?)<\/autoIndex>/", $line, $match)) {
		$index_xsd = $match[1];
		break;
	    }
	}
    }
    if (!strlen($index_xsd)) {
	return 0;
    }
    $file = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$xsd_path/$index_xsd";
    if (file_exists($file)) {
	return $file;
    } elseif (file_exists($file = "$xsd_path/$index_xsd")) {
	return $file;
    } else {
	return 0;
    }
}


function get_schemas () {
    global $xsd_path, $doc_root, $dir_conf;
    $port_xsd_path = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$xsd_path";
    $global_xsd_path = $xsd_path;
    $schema_repositories = array($global_xsd_path, $port_xsd_path);
    $schemas = array();
    if ($config = file($dir_conf)) {
	$allowed = array();
	foreach ($config as $line) {
	    if (preg_match("/<allowSchema\s+(.*?)>/", $line, $match)) {
		$attributes = preg_split("/\s+/", $match[1]);
		foreach ($attributes as $attr) {
		    if (preg_match("/(.*?)=\"(.*?)\"/", $attr, $match)) {
			$key = $match[1];
			$value = $match[2];
		    } else {
			exception("Ukendt attribut-format: '$attr'<br>");
			die;
		    }
		    if ($key == "schema") {
			$allowed[$value] = 1;
		    }
		}
	    }
	}
    } else {
	$allowed = 0;
    }

    foreach ($schema_repositories as $rep) {
	if ($dir = @opendir($rep)) {
	    while ($entry = readdir($dir)) {
		if (($entry == '.') or ($entry == '..') or (!preg_match("/\.xsd$/", $entry))) {
		    continue;
		}
		if (is_array($allowed)) {
		    if ($allowed[$entry]) {
			$schemas[$entry] = array('name'=>$entry, 'file'=>"$rep/$entry");
		    }
		} else {
		    $schemas[$entry] = array('name'=>$entry, 'file'=>"$rep/$entry");
		}
	    }
	    closedir($dir);
	}
    }
    return $schemas;
}


function action_add_rec () {
    global $dir_config, $dir_schema, $dir_conf, $cwd, $abs_cwd, $doc_root, $xsd_path, $xml_editor;
    $cols = 5;
    $abs_xsd_path = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$xsd_path";
    $global_xsd_path = $xsd_path;
    $width = (int) (100 / $cols);
    $schemas = get_schemas();
    $count = 0;

    echo "<h2>Tilfj en post</h2>";
    echo "<table width=\"100%\"><tr><td colspan=\"5\"><b>Vlg XML schema for post:</b></td></tr><tr><td>&nbsp;</td></tr><tr>\n";
    foreach ($schemas as $entry => $schema_info) {
	$schema_file = $schema_info['file'];
	$schema_name = $schema_info['name'];
	$count ++;
	$file_spec = 0;
	if ($schema_name == $dir_schema) {
	    $write_file = "$abs_cwd/$dir_config";
	} elseif ($unique_file = create_file_name($entry, $abs_cwd)) {
	    $write_file = "$abs_cwd/$unique_file";
	} else {
	    $write_file = $abs_cwd;
	    $file_spec = 1;
	}
	echo "<td width=\"$width%\"><a href=\"$xml_editor?schema=$schema_file&write_file=$write_file&file_spec=$file_spec\">$entry</a></td>";
	if ($count % $cols == 0) {
	    echo "</tr>\n<tr>";
	}
    }
    if ($missing = $cols - ($count % $cols)) {
	echo "<td colspan=\"$missing\" width=\"$width%\">&nbsp;</td>";
    }
    echo "</tr></table>\n";
}


function action_help () {
    echo "<h2>Hjlpeside</h2>";
    echo "Her kommer der noget vildledende tekst";
}


function action_index () {
    global $cwd, $doc_root, $start_search, $stop_search, $admin_process, $action, $reindex;
    $apache = $_SERVER['DOCUMENT_ROOT'];
    $portal_path = "$apache/$doc_root";

    echo "<h2>Indeksering</h2>\n";
    if (!is_granted($cwd, "index")) {
	echo "<b>Du har ikke brugerrettighed til administration af sgemaskine.</b>";
	return;
    }
    echo "<table width=\"100%\">\n";
    echo "<form name=\"index\" method=\"post\" action=\"$admin_process\">\n";
    echo "<input type=\"hidden\" name=\"action\" value=\"$action\">";
    echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">";
    echo "<input type=\"hidden\" name=\"reindex\" value=\"$portal_path\">";
    echo "<tr><td width=\"30%\">Foretag total reindeksering</td>";
    echo "<td width=\"30%\"><input type=\"submit\" value=\"Udfr\"></td>";
    echo "</form>\n";
    echo "<td width=\"40%\">";
    if ($reindex) {
	echo "Portal er nu reindekseret";
    } else {
	echo "&nbsp;";
    }
    echo "</td></tr>\n";
    echo "<tr><td>&nbsp;</td></tr>\n";


//    echo "<tr>\n";
//    echo "<form name=\"start_search\" method=\"post\" action=\"$admin_process\">\n";
//    echo "<input type=\"hidden\" name=\"action\" value=\"$action\">";
//    echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">";
//    echo "<input type=\"hidden\" name=\"start_search\" value=\"1\">";
//    echo "<input type=\"hidden\" name=\"portal_path\" value=\"$portal_path\">";
//    echo "<td width=\"30%\">Start sgemaskine</td>";
//    echo "<td width=\"30%\"><input type=\"submit\" value=\"Udfr\"></td>";
//    echo "</form>\n";
//    echo "<td width=\"40%\">";
//    if ($start_search) {
//	echo "Sgemaskine startet";
//    } else {
//	echo "&nbsp;";
//    }
//    echo "</td></tr>";
//    echo "<tr><td>&nbsp;</td></tr>\n";
//    echo "<tr>\n";
//    echo "<form name=\"stop_search\" method=\"post\" action=\"$admin_process\">\n";
//    echo "<input type=\"hidden\" name=\"action\" value=\"$action\">";
//    echo "<input type=\"hidden\" name=\"cwd\" value=\"$cwd\">";
//    echo "<input type=\"hidden\" name=\"stop_search\" value=\"1\">";
//    echo "<input type=\"hidden\" name=\"portal_path\" value=\"$portal_path\">";
//    echo "<td width=\"30%\">Stop sgemaskine</td>";
//    echo "<td width=\"30%\"><input type=\"submit\" value=\"Udfr\"></td>";
//    echo "</form>\n";
//    echo "<td width=\"40%\">";
//    if ($stop_search) {
//	echo "Sgemaskine stoppet";
//    } else {
//	echo "&nbsp;";
//    }
//    echo "</td></tr>";


    echo "</table>\n";
}

// Returns a unique generic record file format: schema-recno.tkl
function create_file_name($schema, $dir) {
    global $doc_root, $global_index, $xml_suffix, $dir_conf;

    if (preg_match("/(.*)\.xsd$/", $schema, $match)) {
	$prefix = $match[1];
    } else {
	exception("Schema filnavn ukendt: '$schema'");
	die;
    }
    $type = 0;
    $mask = "";
    $found = 0;
    if ($config = file($dir_conf)) {
	while ($line = array_shift($config)) {
	    if ($found) {
		if (preg_match("/<fileNaming>(.*?)<\/fileNaming>/", $line, $match)) {
		    $type = $match[1];
		}
		if (preg_match("/<nameMask>(.*?)<\/nameMask>/", $line, $match)) {
		    $mask = $match[1];
		    if (!strlen($mask)) {
			$mask = "#";
		    }
		}
		if (strlen($mask) && $type) {
		    break;
		}
		if (preg_match("/<\/allowSchema>/", $line)) {
		    break;
		}
		continue;
	    }
	    if (preg_match("/<allowSchema\s+(.*?)>/", $line, $match)) {
		$attributes = preg_split("/\s+/", $match[1]);
		foreach ($attributes as $attr) {
		    if (preg_match("/(.*?)=\"(.*?)\"/", $attr, $match)) {
			$key = $match[1];
			$value = $match[2];
			if ($key == "schema" && $value == "$schema") {
			    $found = 1;
			}
		    } else {
			exception("Ukendt attribut-format: '$attr'<br>");
			die;
		    }
		}
	    }
	}
    }
    if (!$found) {
	return 0;
    }
    if ($type == "locallyUnique") {
	$highest = 0;
	if ($dh = @opendir($dir)) {
	    while ($entry = readdir($dh)) {
		if (preg_match("/^$prefix\-(\d+)/", $entry, $match)) {
		    $recno = (int) $match[1];
		    if ($recno > $highest) {
			$highest = $recno;
		    }
		}
	    }
	    closedir($dh);
	} else {
	    exception("Kataloget '$dir' kunne ikke bnes. Kontakt systemadministrator!");
	    die;
	}
	$highest ++;
	return preg_replace("/#/", $highest, $mask) . $xml_suffix;
    } elseif ($type == "globallyUnique") {
	$offset = 0;
	if ($index_file = default_file($global_index)) {
	    if (file_exists($index_file)) {
		$content = file($index_file);
		foreach ($content as $line) {
		    $line = trim($line);
		    if (!strlen($line)) {
			continue;
		    }
		    $offset = (int) $line;
		}
	    }
	} else {
	    $index_file = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$global_index";
	}
	$offset ++;
	if (!($fh = fopen($index_file, "w"))) {
	    exception("Kunne ikke bne global index fil '$index_file' for skrivning");
	    die;
	}
	fputs($fh, $offset);
	fclose($fh);
	return preg_replace("/#/", $offset, $mask) . $xml_suffix;
    } elseif ($type == "userProvided") {
	return 0;
    } elseif ($type == "fixedName") {
	return $mask;
    } else {
	exception("Ukendt type navngivning '$type'");
	die;
    }
}


function file_dist (&$files) {
    $dist = array();

    foreach ($files as $file) {
	if (!strlen($xsd = extract_schema($file))) {
	    $xsd = "Ukendt";
	}
	if (!strlen($creator = get_creator($file))) {
	    $creator = "Ukendt";
	}
	$dist[$xsd][$creator] ++;
    }
    return $dist;
}


function action_others () {
    global $doc_root, $abs_cwd, $admin_script, $cwd, $which_stat, $context, $this_user;

    if ($which_stat == 0) {
	$files = get_files($abs_cwd);
    } elseif ($which_stat == 1) {
	$files = get_files($_SERVER['DOCUMENT_ROOT'] . "/$doc_root", 1);
    }
    $dist = file_dist($files['passed']);
    echo "<h2>Andre funktioner</h2>\n";
    echo "<table width=\"100%\">\n";
    echo "<tr><td colspan=\"2\"><h3>";
    if ($which_stat == 0) {
	echo "Statistik for dette katalog";
    } elseif ($which_stat == 1) {
	echo "Statistik for hele portalen";
    }
    echo "</h3></td></tr>\n";
    echo "<tr><td>&nbsp;</td></tr>\n";
    echo "<tr><td><h3>Type</h3></td><td><h3>Information</h3></td></tr>\n";
    $total = 0;
    foreach ($dist as $xsd => $sub_dist) {
	$show_xsd = preg_replace("/\.xsd$/", "", $xsd);
	echo "<tr><td width=\"25%\" valign=\"top\"><b>$show_xsd</b></td><td width=\"75%\"><table width=\"100%\">\n";
	$sub_total = 0;
	foreach ($sub_dist as $user => $count) {
	    $sub_total += $count;
	    if ($user_info = get_user_info($user)) {
		$user_name = $user_info['name'] . " ($user)";
	    } else {
		$user_name = "Ukendt ejer";
	    }
	    echo "<tr><td width=\"80%\">$user_name</td><td width=\"20%\">$count</td></tr>\n";
	}
	$total += $sub_total;
	echo "<tr><td width=\"80%\"><b>Sub total</b></td><td width=\"20%\"><b>$sub_total</b></td></tr>\n";
	echo "<tr><td>&nbsp;</td></tr>\n";
	echo "</table></td></tr>\n";
    }
    echo "<tr><td>&nbsp;</td><td><table width=\"100%\">";
    echo "<tr><td width=\"80%\"><b>Total</b></td><td width=\"20%\"><b>$total</b></td></tr>\n";
    echo "</table></td></tr>\n";
    echo "<tr><td colspan=\"2\">";
    if ($which_stat == 0) {
	echo "<a href=\"$admin_script?", makeparms($context, array("which_stat"=>1)), "#menu\">Vis portalstatistik</a>";
    } else {
	echo "<a href=\"$admin_script?", makeparms($context, array("which_stat"=>0)), "#menu\">Tilbage</a>";
    }
    echo "</td></tr>\n";
    echo "<tr><td>&nbsp;</td></tr>\n";
    echo "<tr><td colspan=\"2\">Opret DC-tkl knap <a href=\"dc-tkl.php?cwd=$cwd\">her</a>.</td></tr>\n";
    echo "</table>\n";
}


function action_xsd() {
    global $doc_root, $cwd;
    print "<h2>Schema-vedligeholdelse</h2><p/>";
    $rd = $_SERVER['DOCUMENT_ROOT'] . '/' . $doc_root;
    $d = opendir("$rd/schemas");
    print "<table width=\"100%\">";
    while (false != ($f = readdir($d))) {
	if (preg_match("/(.*)\.xsd$/", $f, $match)) {
	    print "<tr><td>";
	    print "$match[1]<br>";
	    print "</td><td>";
	    print "<a href=\"schema-editor.php?cwd=$cwd&filename=$rd/schemas/$match[1].xsd\">Ret</a>";
	    print "</td><td>";
	    print "<a href=\"javascript:remove_file('$match[1].xsd', '$rd/schemas/$match[1].xsd')\">Slet</a>";
	    print "</td></tr>";
	}
    }
    closedir($d);
    print "<tr><td>";
    print "&nbsp;<br><a href=\"schema-editor.php?cwd=$cwd&filename=$rd/schemas/\">Opret nyt schema</a>";
    print "</td></tr>";
    print "</table>";
}


function make_menu () {
    global $valid_actions, $context, $action, $admin_script, $doc_root, $xsd_path, $this_user;

    $ret = "";

    print "<a name=\"menu\">&nbsp;</a>";
    foreach ($valid_actions as $name => $val) {
        $text = $val[1];
	$auth = $val[0];
	if ($auth && $this_user['usertype'] != $auth)
	    continue;
	if ($ret) {
	    $ret .= "&nbsp;|&nbsp;";
	}
	if ($action != $name) {
	    if (preg_match("/^_(.*)/", $name, $match)) {
		$uri = $GLOBALS[$match[1]];
		$filename = $_SERVER['DOCUMENT_ROOT'] . "/$doc_root/$xsd_path";
		$ret .= "<a href=\"$uri?" . makeparms($context,  array("action"=>"", "filename"=>$filename)) . "\">$text</a>";
	    } else {
		$ret .= "<a href=\"$admin_script?" . makeparms($context, array("action"=>$name)) . "#menu\">$text</a>";
	    }
	} else {
	    $ret .= $text;
	}
    }
    return $ret;
}

?>
    </td></tr>
    <tr><td colspan="5" align="center"><font size="1"><?php echo $this_user['name']?></font></td></tr>
    <tr><td colspan="5" style="line-height: 11px;" class="dotted">&nbsp;</td></tr>
    <tr><td align="center">&lt;&nbsp;<?php echo make_menu() ?>&nbsp;&gt;</td></tr>
    </td></tr>
    </table>
  </body>
</html>
