<?xml version="1.0"?>
<!--
    $Id: manage_users.xsl,v 1.2 2007-05-23 18:07:43 jakub Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>

  <xsl:template name="insert-body">
    <h3>Access management.</h3>

    <form name="userForm" method="post">
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="userid" value="null"/>
      <input type="hidden" name="page" value="{$page}"/>

      <xsl:call-template name="insert-user-list"/>
      
    </form>

    <br/>

    <form name="rangeForm" method="post">
      <input type="hidden" name="page" value="{$page}"/>
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="rangeid" value="null"/>

    <xsl:call-template name="insert-range-list"/>
    
    </form>
    
  </xsl:template>

  <xsl:template name="insert-user-list">
    
    <br/>
    <b>Login credentials:</b>
    <br/><br/>

    <input type="button" value="Add login"
      onclick="set_action(document.userForm, 'adduser')"/>

    <ul>
      <xsl:for-each select="php:function('get_users_list')/*/*">
        <li>
          <xsl:value-of select="@name"/>
          <input type="button" value="Edit" 
            onclick="set_action(document.userForm, 'edituser', '{@id}')"/>
          <input type="button" value="Delete"
            onclick="set_action(document.userForm, 'deleteuser', '{@id}')"/>
        </li>
      </xsl:for-each>
    </ul>
        
    <input type="button" value="Add login"
        onclick="set_action(document.userForm, 'adduser')"/>

  </xsl:template>

  <xsl:template name="insert-range-list">
    
    <br/>
    <b>IP ranges:</b>
    <br/><br/>

    <input type="button" value="Add range"
      onclick="set_action(document.rangeForm, 'addrange')"/>

    <ul>
      <xsl:for-each select="php:function('get_ranges_list')/*/*">
        <li>
          <xsl:value-of select="@name"/>
          <input type="button" value="Edit" 
            onclick="set_action(document.rangeForm, 'editrange', '{@id}')"/>
          <input type="button" value="Delete"
            onclick="set_action(document.rangeForm, 'deleterange', '{@id}')"/>
        </li>
      </xsl:for-each>
    </ul>
        
    <input type="button" value="Add range"
        onclick="set_action(document.rangeForm, 'addrange')"/>

  </xsl:template>

</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
