<?php

/**
 * Base class that represents a row from the 'user' table.
 *
 * Users
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * Wed May 14 12:41:24 2008
 *
 * @package    masterkey.om
 */
abstract class BaseUser extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        UserPeer
	 */
	protected static $peer;


	/**
	 * The value for the user_id field.
	 * @var        int
	 */
	protected $user_id;


	/**
	 * The value for the user_name field.
	 * @var        string
	 */
	protected $user_name;


	/**
	 * The value for the institution field.
	 * @var        string
	 */
	protected $institution;


	/**
	 * The value for the email field.
	 * @var        string
	 */
	protected $email;


	/**
	 * The value for the login field.
	 * @var        string
	 */
	protected $login;


	/**
	 * The value for the enc_pass field.
	 * @var        string
	 */
	protected $enc_pass;


	/**
	 * The value for the sel_enabled field.
	 * Note: this column has a database default value of: true
	 * @var        boolean
	 */
	protected $sel_enabled;


	/**
	 * The value for the records_page field.
	 * Note: this column has a database default value of: 0
	 * @var        int
	 */
	protected $records_page;


	/**
	 * The value for the thumbs field.
	 * Note: this column has a database default value of: 0
	 * @var        int
	 */
	protected $thumbs;


	/**
	 * The value for the type field.
	 * Note: this column has a database default value of: 0
	 * @var        int
	 */
	protected $type;


	/**
	 * The value for the state field.
	 * Note: this column has a database default value of: 0
	 * @var        int
	 */
	protected $state;


	/**
	 * The value for the selection field.
	 * @var        string
	 */
	protected $selection;


	/**
	 * The value for the ourl_resolver field.
	 * @var        string
	 */
	protected $ourl_resolver;


	/**
	 * The value for the group_id field.
	 * @var        int
	 */
	protected $group_id;

	/**
	 * @var        AccessGroup
	 */
	protected $aAccessGroup;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [user_id] column value.
	 * User Id
		
	 * @return     int
	 */
	public function getUserId()
	{

		return $this->user_id;
	}

	/**
	 * Get the [user_name] column value.
	 * User full name
		
	 * @return     string
	 */
	public function getUserName()
	{

		return $this->user_name;
	}

	/**
	 * Get the [institution] column value.
	 * Encrypted user password
		
	 * @return     string
	 */
	public function getInstitution()
	{

		return $this->institution;
	}

	/**
	 * Get the [email] column value.
	 * Encrypted user password
		
	 * @return     string
	 */
	public function getEmail()
	{

		return $this->email;
	}

	/**
	 * Get the [login] column value.
	 * Login name
		
	 * @return     string
	 */
	public function getLogin()
	{

		return $this->login;
	}

	/**
	 * Get the [enc_pass] column value.
	 * Encrypted user password
		
	 * @return     string
	 */
	public function getEncPass()
	{

		return $this->enc_pass;
	}

	/**
	 * Get the [sel_enabled] column value.
	 * Remember last selection
		
	 * @return     boolean
	 */
	public function getSelEnabled()
	{

		if ($this->sel_enabled === null && $this->isNew() && !$this->isColumnModified(UserPeer::SEL_ENABLED)) {
			return true;
		}

		return $this->sel_enabled;
	}

	/**
	 * Get the [records_page] column value.
	 * 
		
	 * @return     int
	 */
	public function getRecordsPage()
	{

		if ($this->records_page === null && $this->isNew() && !$this->isColumnModified(UserPeer::RECORDS_PAGE)) {
			return 0;
		}

		return $this->records_page;
	}

	/**
	 * Get the [thumbs] column value.
	 * 
		
	 * @return     int
	 */
	public function getThumbs()
	{

		if ($this->thumbs === null && $this->isNew() && !$this->isColumnModified(UserPeer::THUMBS)) {
			return 0;
		}

		return $this->thumbs;
	}

	/**
	 * Get the [type] column value.
	 * 
		
	 * @return     int
	 */
	public function getType()
	{

		if ($this->type === null && $this->isNew() && !$this->isColumnModified(UserPeer::TYPE)) {
			return 0;
		}

		return $this->type;
	}

	/**
	 * Get the [state] column value.
	 * 
		
	 * @return     int
	 */
	public function getState()
	{

		if ($this->state === null && $this->isNew() && !$this->isColumnModified(UserPeer::STATE)) {
			return 0;
		}

		return $this->state;
	}

	/**
	 * Get the [selection] column value.
	 * 
		
	 * @return     string
	 */
	public function getSelection()
	{

		return $this->selection;
	}

	/**
	 * Get the [ourl_resolver] column value.
	 * OpenURL resolver address
		
	 * @return     string
	 */
	public function getOurlResolver()
	{

		return $this->ourl_resolver;
	}

	/**
	 * Get the [group_id] column value.
	 * 
		
	 * @return     int
	 */
	public function getGroupId()
	{

		return $this->group_id;
	}

	/**
	 * Set the value of [user_id] column.
	 * User Id
	 * @param      int $v new value
	 * @return     void
	 */
	public function setUserId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->user_id !== $v) {
			$this->user_id = $v;
			$this->modifiedColumns[] = UserPeer::USER_ID;
		}

	} // setUserId()

	/**
	 * Set the value of [user_name] column.
	 * User full name
	 * @param      string $v new value
	 * @return     void
	 */
	public function setUserName($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->user_name !== $v) {
			$this->user_name = $v;
			$this->modifiedColumns[] = UserPeer::USER_NAME;
		}

	} // setUserName()

	/**
	 * Set the value of [institution] column.
	 * Encrypted user password
	 * @param      string $v new value
	 * @return     void
	 */
	public function setInstitution($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->institution !== $v) {
			$this->institution = $v;
			$this->modifiedColumns[] = UserPeer::INSTITUTION;
		}

	} // setInstitution()

	/**
	 * Set the value of [email] column.
	 * Encrypted user password
	 * @param      string $v new value
	 * @return     void
	 */
	public function setEmail($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->email !== $v) {
			$this->email = $v;
			$this->modifiedColumns[] = UserPeer::EMAIL;
		}

	} // setEmail()

	/**
	 * Set the value of [login] column.
	 * Login name
	 * @param      string $v new value
	 * @return     void
	 */
	public function setLogin($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->login !== $v) {
			$this->login = $v;
			$this->modifiedColumns[] = UserPeer::LOGIN;
		}

	} // setLogin()

	/**
	 * Set the value of [enc_pass] column.
	 * Encrypted user password
	 * @param      string $v new value
	 * @return     void
	 */
	public function setEncPass($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->enc_pass !== $v) {
			$this->enc_pass = $v;
			$this->modifiedColumns[] = UserPeer::ENC_PASS;
		}

	} // setEncPass()

	/**
	 * Set the value of [sel_enabled] column.
	 * Remember last selection
	 * @param      boolean $v new value
	 * @return     void
	 */
	public function setSelEnabled($v)
	{

		if ($this->sel_enabled !== $v || $v === true) {
			$this->sel_enabled = $v;
			$this->modifiedColumns[] = UserPeer::SEL_ENABLED;
		}

	} // setSelEnabled()

	/**
	 * Set the value of [records_page] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setRecordsPage($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->records_page !== $v || $v === 0) {
			$this->records_page = $v;
			$this->modifiedColumns[] = UserPeer::RECORDS_PAGE;
		}

	} // setRecordsPage()

	/**
	 * Set the value of [thumbs] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setThumbs($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->thumbs !== $v || $v === 0) {
			$this->thumbs = $v;
			$this->modifiedColumns[] = UserPeer::THUMBS;
		}

	} // setThumbs()

	/**
	 * Set the value of [type] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setType($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->type !== $v || $v === 0) {
			$this->type = $v;
			$this->modifiedColumns[] = UserPeer::TYPE;
		}

	} // setType()

	/**
	 * Set the value of [state] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setState($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->state !== $v || $v === 0) {
			$this->state = $v;
			$this->modifiedColumns[] = UserPeer::STATE;
		}

	} // setState()

	/**
	 * Set the value of [selection] column.
	 * 
	 * @param      string $v new value
	 * @return     void
	 */
	public function setSelection($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->selection !== $v) {
			$this->selection = $v;
			$this->modifiedColumns[] = UserPeer::SELECTION;
		}

	} // setSelection()

	/**
	 * Set the value of [ourl_resolver] column.
	 * OpenURL resolver address
	 * @param      string $v new value
	 * @return     void
	 */
	public function setOurlResolver($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->ourl_resolver !== $v) {
			$this->ourl_resolver = $v;
			$this->modifiedColumns[] = UserPeer::OURL_RESOLVER;
		}

	} // setOurlResolver()

	/**
	 * Set the value of [group_id] column.
	 * 
	 * @param      int $v new value
	 * @return     void
	 */
	public function setGroupId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->group_id !== $v) {
			$this->group_id = $v;
			$this->modifiedColumns[] = UserPeer::GROUP_ID;
		}

		if ($this->aAccessGroup !== null && $this->aAccessGroup->getGroupId() !== $v) {
			$this->aAccessGroup = null;
		}

	} // setGroupId()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 * 
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default. 
	 * 
	 * @return    boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array(UserPeer::SEL_ENABLED,UserPeer::RECORDS_PAGE,UserPeer::THUMBS,UserPeer::TYPE,UserPeer::STATE))) {
				return false;
			}

			if ($this->sel_enabled !== true) {
				return false;
			}

			if ($this->records_page !== 0) {
				return false;
			}

			if ($this->thumbs !== 0) {
				return false;
			}

			if ($this->type !== 0) {
				return false;
			}

			if ($this->state !== 0) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0)
	{
		try {

			$this->user_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->user_name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->institution = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->email = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->login = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->enc_pass = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
			$this->sel_enabled = ($row[$startcol + 6] !== null) ? (boolean) $row[$startcol + 6] : null;
			$this->records_page = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
			$this->thumbs = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
			$this->type = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
			$this->state = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
			$this->selection = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
			$this->ourl_resolver = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
			$this->group_id = ($row[$startcol + 13] !== null) ? (int) $row[$startcol + 13] : null;
			$this->resetModified();

			$this->setNew(false);

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 14; // 14 = UserPeer::NUM_COLUMNS - UserPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating User object", $e);
		}
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(UserPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			UserPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.  If the object is new,
	 * it inserts it; otherwise an update is performed.  This method
	 * wraps the doSave() worker method in a transaction.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(UserPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			$affectedRows = $this->doSave($con);
			$con->commit();
			UserPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aAccessGroup !== null) {
				if ($this->aAccessGroup->isModified() || $this->aAccessGroup->isNew()) {
					$affectedRows += $this->aAccessGroup->save($con);
				}
				$this->setAccessGroup($this->aAccessGroup);
			}


			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = UserPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setUserId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += UserPeer::doUpdate($this, $con);
				}
				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aAccessGroup !== null) {
				if (!$this->aAccessGroup->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aAccessGroup->getValidationFailures());
				}
			}


			if (($retval = UserPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(UserPeer::DATABASE_NAME);

		if ($this->isColumnModified(UserPeer::USER_ID)) $criteria->add(UserPeer::USER_ID, $this->user_id);
		if ($this->isColumnModified(UserPeer::USER_NAME)) $criteria->add(UserPeer::USER_NAME, $this->user_name);
		if ($this->isColumnModified(UserPeer::INSTITUTION)) $criteria->add(UserPeer::INSTITUTION, $this->institution);
		if ($this->isColumnModified(UserPeer::EMAIL)) $criteria->add(UserPeer::EMAIL, $this->email);
		if ($this->isColumnModified(UserPeer::LOGIN)) $criteria->add(UserPeer::LOGIN, $this->login);
		if ($this->isColumnModified(UserPeer::ENC_PASS)) $criteria->add(UserPeer::ENC_PASS, $this->enc_pass);
		if ($this->isColumnModified(UserPeer::SEL_ENABLED)) $criteria->add(UserPeer::SEL_ENABLED, $this->sel_enabled);
		if ($this->isColumnModified(UserPeer::RECORDS_PAGE)) $criteria->add(UserPeer::RECORDS_PAGE, $this->records_page);
		if ($this->isColumnModified(UserPeer::THUMBS)) $criteria->add(UserPeer::THUMBS, $this->thumbs);
		if ($this->isColumnModified(UserPeer::TYPE)) $criteria->add(UserPeer::TYPE, $this->type);
		if ($this->isColumnModified(UserPeer::STATE)) $criteria->add(UserPeer::STATE, $this->state);
		if ($this->isColumnModified(UserPeer::SELECTION)) $criteria->add(UserPeer::SELECTION, $this->selection);
		if ($this->isColumnModified(UserPeer::OURL_RESOLVER)) $criteria->add(UserPeer::OURL_RESOLVER, $this->ourl_resolver);
		if ($this->isColumnModified(UserPeer::GROUP_ID)) $criteria->add(UserPeer::GROUP_ID, $this->group_id);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(UserPeer::DATABASE_NAME);

		$criteria->add(UserPeer::USER_ID, $this->user_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getUserId();
	}

	/**
	 * Generic method to set the primary key (user_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setUserId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of User (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setUserName($this->user_name);

		$copyObj->setInstitution($this->institution);

		$copyObj->setEmail($this->email);

		$copyObj->setLogin($this->login);

		$copyObj->setEncPass($this->enc_pass);

		$copyObj->setSelEnabled($this->sel_enabled);

		$copyObj->setRecordsPage($this->records_page);

		$copyObj->setThumbs($this->thumbs);

		$copyObj->setType($this->type);

		$copyObj->setState($this->state);

		$copyObj->setSelection($this->selection);

		$copyObj->setOurlResolver($this->ourl_resolver);

		$copyObj->setGroupId($this->group_id);


		$copyObj->setNew(true);

		$copyObj->setUserId(NULL); // this is a pkey column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     User Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     UserPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new UserPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a AccessGroup object.
	 *
	 * @param      AccessGroup $v
	 * @return     void
	 * @throws     PropelException
	 */
	public function setAccessGroup(AccessGroup $v = null)
	{
		if ($v === null) {
			$this->setGroupId(NULL);
		} else {
			$this->setGroupId($v->getGroupId());
		}

		$this->aAccessGroup = $v;


	}


	/**
	 * Get the associated AccessGroup object
	 *
	 * @param      PDO Optional Connection object.
	 * @return     AccessGroup The associated AccessGroup object.
	 * @throws     PropelException
	 */
	public function getAccessGroup(PDO $con = null)
	{
		if ($this->aAccessGroup === null && ($this->group_id !== null)) {
			$this->aAccessGroup = AccessGroupPeer::retrieveByPK($this->group_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aAccessGroup->addUsers($this);
			 */
		}
		return $this->aAccessGroup;
	}

} // BaseUser
