<?php
class RangeData extends DOMDocument
{
    public function __construct($maskId)
    {
        $target = IpMaskPeer::retrieveByPK($maskId);

        parent::__construct('1.0', 'utf-8');
        $root = $this->appendChild( new DOMElement('range') );

        $root->setAttribute( 'id', $target->getMaskId() );
        $root->setAttribute( 'name', $target->getMaskName() );
        $root->setAttribute( 'lower', long2ip( $target->getMaskLower() ));
        $root->setAttribute( 'upper', long2ip( $target->getMaskUpper() ));
        $root->setAttribute( 'group_id', $target->getGroupId() );
    }
}
