<?php

/**
 * Base class that represents a row from the 'target' table.
 *
 * Target table
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * Wed May 21 16:42:14 2008
 *
 * @package    masterkey.om
 */
abstract class BaseTarget extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        TargetPeer
	 */
	protected static $peer;


	/**
	 * The value for the target_id field.
	 * @var        int
	 */
	protected $target_id;


	/**
	 * The value for the target_name field.
	 * @var        string
	 */
	protected $target_name;


	/**
	 * The value for the conn_string field.
	 * @var        string
	 */
	protected $conn_string;


	/**
	 * The value for the rec_enc field.
	 * @var        string
	 */
	protected $rec_enc;


	/**
	 * The value for the query_enc field.
	 * @var        string
	 */
	protected $query_enc;


	/**
	 * The value for the req_syn field.
	 * @var        string
	 */
	protected $req_syn;


	/**
	 * The value for the element_set field.
	 * @var        string
	 */
	protected $element_set;


	/**
	 * The value for the xslt field.
	 * @var        string
	 */
	protected $xslt;


	/**
	 * The value for the ccl_map_id field.
	 * @var        int
	 */
	protected $ccl_map_id;


	/**
	 * The value for the holding_type field.
	 * @var        int
	 */
	protected $holding_type;


	/**
	 * The value for the holding_xsl field.
	 * @var        string
	 */
	protected $holding_xsl;


	/**
	 * The value for the url_recipe field.
	 * @var        string
	 */
	protected $url_recipe;


	/**
	 * The value for the proxy_conn_string field.
	 * @var        string
	 */
	protected $proxy_conn_string;


	/**
	 * The value for the ill_email field.
	 * @var        string
	 */
	protected $ill_email;

	/**
	 * @var        CclMap
	 */
	protected $aCclMap;

	/**
	 * @var        array ZAuth[] Collection to store aggregation of ZAuth objects.
	 */
	protected $collZAuths;

	/**
	 * @var        Criteria The criteria used to select the current contents of collZAuths.
	 */
	private $lastZAuthCriteria = null;

	/**
	 * @var        array TargetRefCat[] Collection to store aggregation of TargetRefCat objects.
	 */
	protected $collTargetRefCats;

	/**
	 * @var        Criteria The criteria used to select the current contents of collTargetRefCats.
	 */
	private $lastTargetRefCatCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [target_id] column value.
	 * Z39.50 target Id
		
	 * @return     int
	 */
	public function getTargetId()
	{

		return $this->target_id;
	}

	/**
	 * Get the [target_name] column value.
	 * Target name
		
	 * @return     string
	 */
	public function getTargetName()
	{

		return $this->target_name;
	}

	/**
	 * Get the [conn_string] column value.
	 * Z39.50 connection string
		
	 * @return     string
	 */
	public function getConnString()
	{

		return $this->conn_string;
	}

	/**
	 * Get the [rec_enc] column value.
	 * Record encoding
		
	 * @return     string
	 */
	public function getRecEnc()
	{

		return $this->rec_enc;
	}

	/**
	 * Get the [query_enc] column value.
	 * Query encoding
		
	 * @return     string
	 */
	public function getQueryEnc()
	{

		return $this->query_enc;
	}

	/**
	 * Get the [req_syn] column value.
	 * Request syntax
		
	 * @return     string
	 */
	public function getReqSyn()
	{

		return $this->req_syn;
	}

	/**
	 * Get the [element_set] column value.
	 * Element set name
		
	 * @return     string
	 */
	public function getElementSet()
	{

		return $this->element_set;
	}

	/**
	 * Get the [xslt] column value.
	 * XSL Transform for record normalization
		
	 * @return     string
	 */
	public function getXslt()
	{

		return $this->xslt;
	}

	/**
	 * Get the [ccl_map_id] column value.
	 * CCL map id
		
	 * @return     int
	 */
	public function getCclMapId()
	{

		return $this->ccl_map_id;
	}

	/**
	 * Get the [holding_type] column value.
	 * Holding type
		
	 * @return     int
	 */
	public function getHoldingType()
	{

		return $this->holding_type;
	}

	/**
	 * Get the [holding_xsl] column value.
	 * Holding extraction stylesheet
		
	 * @return     string
	 */
	public function getHoldingXsl()
	{

		return $this->holding_xsl;
	}

	/**
	 * Get the [url_recipe] column value.
	 * Local system URL recipe
		
	 * @return     string
	 */
	public function getUrlRecipe()
	{

		return $this->url_recipe;
	}

	/**
	 * Get the [proxy_conn_string] column value.
	 * Optional Z39.50 proxy
		
	 * @return     string
	 */
	public function getProxyConnString()
	{

		return $this->proxy_conn_string;
	}

	/**
	 * Get the [ill_email] column value.
	 * Optional email used for ILL
		
	 * @return     string
	 */
	public function getIllEmail()
	{

		return $this->ill_email;
	}

	/**
	 * Set the value of [target_id] column.
	 * Z39.50 target Id
	 * @param      int $v new value
	 * @return     void
	 */
	public function setTargetId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->target_id !== $v) {
			$this->target_id = $v;
			$this->modifiedColumns[] = TargetPeer::TARGET_ID;
		}

	} // setTargetId()

	/**
	 * Set the value of [target_name] column.
	 * Target name
	 * @param      string $v new value
	 * @return     void
	 */
	public function setTargetName($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->target_name !== $v) {
			$this->target_name = $v;
			$this->modifiedColumns[] = TargetPeer::TARGET_NAME;
		}

	} // setTargetName()

	/**
	 * Set the value of [conn_string] column.
	 * Z39.50 connection string
	 * @param      string $v new value
	 * @return     void
	 */
	public function setConnString($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->conn_string !== $v) {
			$this->conn_string = $v;
			$this->modifiedColumns[] = TargetPeer::CONN_STRING;
		}

	} // setConnString()

	/**
	 * Set the value of [rec_enc] column.
	 * Record encoding
	 * @param      string $v new value
	 * @return     void
	 */
	public function setRecEnc($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->rec_enc !== $v) {
			$this->rec_enc = $v;
			$this->modifiedColumns[] = TargetPeer::REC_ENC;
		}

	} // setRecEnc()

	/**
	 * Set the value of [query_enc] column.
	 * Query encoding
	 * @param      string $v new value
	 * @return     void
	 */
	public function setQueryEnc($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->query_enc !== $v) {
			$this->query_enc = $v;
			$this->modifiedColumns[] = TargetPeer::QUERY_ENC;
		}

	} // setQueryEnc()

	/**
	 * Set the value of [req_syn] column.
	 * Request syntax
	 * @param      string $v new value
	 * @return     void
	 */
	public function setReqSyn($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->req_syn !== $v) {
			$this->req_syn = $v;
			$this->modifiedColumns[] = TargetPeer::REQ_SYN;
		}

	} // setReqSyn()

	/**
	 * Set the value of [element_set] column.
	 * Element set name
	 * @param      string $v new value
	 * @return     void
	 */
	public function setElementSet($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->element_set !== $v) {
			$this->element_set = $v;
			$this->modifiedColumns[] = TargetPeer::ELEMENT_SET;
		}

	} // setElementSet()

	/**
	 * Set the value of [xslt] column.
	 * XSL Transform for record normalization
	 * @param      string $v new value
	 * @return     void
	 */
	public function setXslt($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->xslt !== $v) {
			$this->xslt = $v;
			$this->modifiedColumns[] = TargetPeer::XSLT;
		}

	} // setXslt()

	/**
	 * Set the value of [ccl_map_id] column.
	 * CCL map id
	 * @param      int $v new value
	 * @return     void
	 */
	public function setCclMapId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->ccl_map_id !== $v) {
			$this->ccl_map_id = $v;
			$this->modifiedColumns[] = TargetPeer::CCL_MAP_ID;
		}

		if ($this->aCclMap !== null && $this->aCclMap->getCclMapId() !== $v) {
			$this->aCclMap = null;
		}

	} // setCclMapId()

	/**
	 * Set the value of [holding_type] column.
	 * Holding type
	 * @param      int $v new value
	 * @return     void
	 */
	public function setHoldingType($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->holding_type !== $v) {
			$this->holding_type = $v;
			$this->modifiedColumns[] = TargetPeer::HOLDING_TYPE;
		}

	} // setHoldingType()

	/**
	 * Set the value of [holding_xsl] column.
	 * Holding extraction stylesheet
	 * @param      string $v new value
	 * @return     void
	 */
	public function setHoldingXsl($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->holding_xsl !== $v) {
			$this->holding_xsl = $v;
			$this->modifiedColumns[] = TargetPeer::HOLDING_XSL;
		}

	} // setHoldingXsl()

	/**
	 * Set the value of [url_recipe] column.
	 * Local system URL recipe
	 * @param      string $v new value
	 * @return     void
	 */
	public function setUrlRecipe($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->url_recipe !== $v) {
			$this->url_recipe = $v;
			$this->modifiedColumns[] = TargetPeer::URL_RECIPE;
		}

	} // setUrlRecipe()

	/**
	 * Set the value of [proxy_conn_string] column.
	 * Optional Z39.50 proxy
	 * @param      string $v new value
	 * @return     void
	 */
	public function setProxyConnString($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->proxy_conn_string !== $v) {
			$this->proxy_conn_string = $v;
			$this->modifiedColumns[] = TargetPeer::PROXY_CONN_STRING;
		}

	} // setProxyConnString()

	/**
	 * Set the value of [ill_email] column.
	 * Optional email used for ILL
	 * @param      string $v new value
	 * @return     void
	 */
	public function setIllEmail($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->ill_email !== $v) {
			$this->ill_email = $v;
			$this->modifiedColumns[] = TargetPeer::ILL_EMAIL;
		}

	} // setIllEmail()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 * 
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default. 
	 * 
	 * @return    boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0)
	{
		try {

			$this->target_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->target_name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->conn_string = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->rec_enc = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->query_enc = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->req_syn = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
			$this->element_set = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
			$this->xslt = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
			$this->ccl_map_id = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
			$this->holding_type = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
			$this->holding_xsl = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
			$this->url_recipe = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
			$this->proxy_conn_string = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
			$this->ill_email = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
			$this->resetModified();

			$this->setNew(false);

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 14; // 14 = TargetPeer::NUM_COLUMNS - TargetPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Target object", $e);
		}
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TargetPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			TargetPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.  If the object is new,
	 * it inserts it; otherwise an update is performed.  This method
	 * wraps the doSave() worker method in a transaction.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TargetPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			$affectedRows = $this->doSave($con);
			$con->commit();
			TargetPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aCclMap !== null) {
				if ($this->aCclMap->isModified() || $this->aCclMap->isNew()) {
					$affectedRows += $this->aCclMap->save($con);
				}
				$this->setCclMap($this->aCclMap);
			}


			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = TargetPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setTargetId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += TargetPeer::doUpdate($this, $con);
				}
				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collZAuths !== null) {
				foreach ($this->collZAuths as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collTargetRefCats !== null) {
				foreach ($this->collTargetRefCats as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aCclMap !== null) {
				if (!$this->aCclMap->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCclMap->getValidationFailures());
				}
			}


			if (($retval = TargetPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collZAuths !== null) {
					foreach ($this->collZAuths as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collTargetRefCats !== null) {
					foreach ($this->collTargetRefCats as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(TargetPeer::DATABASE_NAME);

		if ($this->isColumnModified(TargetPeer::TARGET_ID)) $criteria->add(TargetPeer::TARGET_ID, $this->target_id);
		if ($this->isColumnModified(TargetPeer::TARGET_NAME)) $criteria->add(TargetPeer::TARGET_NAME, $this->target_name);
		if ($this->isColumnModified(TargetPeer::CONN_STRING)) $criteria->add(TargetPeer::CONN_STRING, $this->conn_string);
		if ($this->isColumnModified(TargetPeer::REC_ENC)) $criteria->add(TargetPeer::REC_ENC, $this->rec_enc);
		if ($this->isColumnModified(TargetPeer::QUERY_ENC)) $criteria->add(TargetPeer::QUERY_ENC, $this->query_enc);
		if ($this->isColumnModified(TargetPeer::REQ_SYN)) $criteria->add(TargetPeer::REQ_SYN, $this->req_syn);
		if ($this->isColumnModified(TargetPeer::ELEMENT_SET)) $criteria->add(TargetPeer::ELEMENT_SET, $this->element_set);
		if ($this->isColumnModified(TargetPeer::XSLT)) $criteria->add(TargetPeer::XSLT, $this->xslt);
		if ($this->isColumnModified(TargetPeer::CCL_MAP_ID)) $criteria->add(TargetPeer::CCL_MAP_ID, $this->ccl_map_id);
		if ($this->isColumnModified(TargetPeer::HOLDING_TYPE)) $criteria->add(TargetPeer::HOLDING_TYPE, $this->holding_type);
		if ($this->isColumnModified(TargetPeer::HOLDING_XSL)) $criteria->add(TargetPeer::HOLDING_XSL, $this->holding_xsl);
		if ($this->isColumnModified(TargetPeer::URL_RECIPE)) $criteria->add(TargetPeer::URL_RECIPE, $this->url_recipe);
		if ($this->isColumnModified(TargetPeer::PROXY_CONN_STRING)) $criteria->add(TargetPeer::PROXY_CONN_STRING, $this->proxy_conn_string);
		if ($this->isColumnModified(TargetPeer::ILL_EMAIL)) $criteria->add(TargetPeer::ILL_EMAIL, $this->ill_email);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(TargetPeer::DATABASE_NAME);

		$criteria->add(TargetPeer::TARGET_ID, $this->target_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getTargetId();
	}

	/**
	 * Generic method to set the primary key (target_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setTargetId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Target (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setTargetName($this->target_name);

		$copyObj->setConnString($this->conn_string);

		$copyObj->setRecEnc($this->rec_enc);

		$copyObj->setQueryEnc($this->query_enc);

		$copyObj->setReqSyn($this->req_syn);

		$copyObj->setElementSet($this->element_set);

		$copyObj->setXslt($this->xslt);

		$copyObj->setCclMapId($this->ccl_map_id);

		$copyObj->setHoldingType($this->holding_type);

		$copyObj->setHoldingXsl($this->holding_xsl);

		$copyObj->setUrlRecipe($this->url_recipe);

		$copyObj->setProxyConnString($this->proxy_conn_string);

		$copyObj->setIllEmail($this->ill_email);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getZAuths() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
				$copyObj->addZAuth($relObj->copy($deepCopy));
			}
			}

			foreach ($this->getTargetRefCats() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
				$copyObj->addTargetRefCat($relObj->copy($deepCopy));
			}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setTargetId(NULL); // this is a pkey column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Target Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     TargetPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new TargetPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a CclMap object.
	 *
	 * @param      CclMap $v
	 * @return     void
	 * @throws     PropelException
	 */
	public function setCclMap(CclMap $v = null)
	{
		if ($v === null) {
			$this->setCclMapId(NULL);
		} else {
			$this->setCclMapId($v->getCclMapId());
		}

		$this->aCclMap = $v;


	}


	/**
	 * Get the associated CclMap object
	 *
	 * @param      PDO Optional Connection object.
	 * @return     CclMap The associated CclMap object.
	 * @throws     PropelException
	 */
	public function getCclMap(PDO $con = null)
	{
		if ($this->aCclMap === null && ($this->ccl_map_id !== null)) {
			$this->aCclMap = CclMapPeer::retrieveByPK($this->ccl_map_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aCclMap->addTargets($this);
			 */
		}
		return $this->aCclMap;
	}

	/**
	 * Temporary storage of collZAuths to save a possible db hit in
	 * the event objects are add to the collection, but the
	 * complete collection is never requested.
	 *
	 * @return     void
	 * @deprecated - This method will be removed in 2.0 since arrays
	 *				are automatically initialized in the addZAuths() method.
	 * @see        addZAuths()
	 */
	public function initZAuths()
	{
		if ($this->collZAuths === null) {
			$this->collZAuths = array();
		}
	}

	/**
	 * Gets an array of  objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Target has previously been saved, it will retrieve
	 * related ZAuths from storage. If this Target is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PDO $con
	 * @param      Criteria $criteria
	 * @return     array []
	 * @throws     PropelException
	 */
	public function getZAuths($criteria = null, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collZAuths === null) {
			if ($this->isNew()) {
			   $this->collZAuths = array();
			} else {

				$criteria->add(ZAuthPeer::TARGET_ID, $this->getTargetId());

				ZAuthPeer::addSelectColumns($criteria);
				$this->collZAuths = ZAuthPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(ZAuthPeer::TARGET_ID, $this->getTargetId());

				ZAuthPeer::addSelectColumns($criteria);
				if (!isset($this->lastZAuthCriteria) || !$this->lastZAuthCriteria->equals($criteria)) {
					$this->collZAuths = ZAuthPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastZAuthCriteria = $criteria;
		return $this->collZAuths;
	}

	/**
	 * Returns the number of related ZAuths.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PDO $con
	 * @throws     PropelException
	 */
	public function countZAuths($criteria = null, $distinct = false, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ZAuthPeer::TARGET_ID, $this->getTargetId());

		return ZAuthPeer::doCount($criteria, $distinct, $con);
	}

	/**
	 * Method called to associate a ZAuth object to this object
	 * through the ZAuth foreign key attribute.
	 *
	 * @param      ZAuth $l ZAuth
	 * @return     void
	 * @throws     PropelException
	 */
	public function addZAuth(ZAuth $l)
	{
		$this->collZAuths = (array) $this->collZAuths;
		array_push($this->collZAuths, $l);
		$l->setTarget($this);
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Target is new, it will return
	 * an empty collection; or if this Target has previously
	 * been saved, it will retrieve related ZAuths from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Target.
	 */
	public function getZAuthsJoinAccessGroup($criteria = null, $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collZAuths === null) {
			if ($this->isNew()) {
				$this->collZAuths = array();
			} else {

				$criteria->add(ZAuthPeer::TARGET_ID, $this->getTargetId());

				$this->collZAuths = ZAuthPeer::doSelectJoinAccessGroup($criteria, $con);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(ZAuthPeer::TARGET_ID, $this->getTargetId());

			if (!isset($this->lastZAuthCriteria) || !$this->lastZAuthCriteria->equals($criteria)) {
				$this->collZAuths = ZAuthPeer::doSelectJoinAccessGroup($criteria, $con);
			}
		}
		$this->lastZAuthCriteria = $criteria;

		return $this->collZAuths;
	}

	/**
	 * Temporary storage of collTargetRefCats to save a possible db hit in
	 * the event objects are add to the collection, but the
	 * complete collection is never requested.
	 *
	 * @return     void
	 * @deprecated - This method will be removed in 2.0 since arrays
	 *				are automatically initialized in the addTargetRefCats() method.
	 * @see        addTargetRefCats()
	 */
	public function initTargetRefCats()
	{
		if ($this->collTargetRefCats === null) {
			$this->collTargetRefCats = array();
		}
	}

	/**
	 * Gets an array of  objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Target has previously been saved, it will retrieve
	 * related TargetRefCats from storage. If this Target is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PDO $con
	 * @param      Criteria $criteria
	 * @return     array []
	 * @throws     PropelException
	 */
	public function getTargetRefCats($criteria = null, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTargetRefCats === null) {
			if ($this->isNew()) {
			   $this->collTargetRefCats = array();
			} else {

				$criteria->add(TargetRefCatPeer::TARGET_ID, $this->getTargetId());

				TargetRefCatPeer::addSelectColumns($criteria);
				$this->collTargetRefCats = TargetRefCatPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(TargetRefCatPeer::TARGET_ID, $this->getTargetId());

				TargetRefCatPeer::addSelectColumns($criteria);
				if (!isset($this->lastTargetRefCatCriteria) || !$this->lastTargetRefCatCriteria->equals($criteria)) {
					$this->collTargetRefCats = TargetRefCatPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastTargetRefCatCriteria = $criteria;
		return $this->collTargetRefCats;
	}

	/**
	 * Returns the number of related TargetRefCats.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PDO $con
	 * @throws     PropelException
	 */
	public function countTargetRefCats($criteria = null, $distinct = false, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(TargetRefCatPeer::TARGET_ID, $this->getTargetId());

		return TargetRefCatPeer::doCount($criteria, $distinct, $con);
	}

	/**
	 * Method called to associate a TargetRefCat object to this object
	 * through the TargetRefCat foreign key attribute.
	 *
	 * @param      TargetRefCat $l TargetRefCat
	 * @return     void
	 * @throws     PropelException
	 */
	public function addTargetRefCat(TargetRefCat $l)
	{
		$this->collTargetRefCats = (array) $this->collTargetRefCats;
		array_push($this->collTargetRefCats, $l);
		$l->setTarget($this);
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Target is new, it will return
	 * an empty collection; or if this Target has previously
	 * been saved, it will retrieve related TargetRefCats from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Target.
	 */
	public function getTargetRefCatsJoinCategory($criteria = null, $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTargetRefCats === null) {
			if ($this->isNew()) {
				$this->collTargetRefCats = array();
			} else {

				$criteria->add(TargetRefCatPeer::TARGET_ID, $this->getTargetId());

				$this->collTargetRefCats = TargetRefCatPeer::doSelectJoinCategory($criteria, $con);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(TargetRefCatPeer::TARGET_ID, $this->getTargetId());

			if (!isset($this->lastTargetRefCatCriteria) || !$this->lastTargetRefCatCriteria->equals($criteria)) {
				$this->collTargetRefCats = TargetRefCatPeer::doSelectJoinCategory($criteria, $con);
			}
		}
		$this->lastTargetRefCatCriteria = $criteria;

		return $this->collTargetRefCats;
	}

} // BaseTarget
