<?php

/**
 * Base class that represents a row from the 'category' table.
 *
 * Category table
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * Wed May 21 16:42:14 2008
 *
 * @package    masterkey.om
 */
abstract class BaseCategory extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        CategoryPeer
	 */
	protected static $peer;


	/**
	 * The value for the cat_id field.
	 * @var        int
	 */
	protected $cat_id;


	/**
	 * The value for the cat_name field.
	 * @var        string
	 */
	protected $cat_name;


	/**
	 * The value for the parent_id field.
	 * Note: this column has a database default value of: 0
	 * @var        int
	 */
	protected $parent_id;

	/**
	 * @var        Category
	 */
	protected $aCategoryRelatedByParentId;

	/**
	 * @var        array Category[] Collection to store aggregation of Category objects.
	 */
	protected $collCategorysRelatedByParentId;

	/**
	 * @var        Criteria The criteria used to select the current contents of collCategorysRelatedByParentId.
	 */
	private $lastCategoryRelatedByParentIdCriteria = null;

	/**
	 * @var        array TargetRefCat[] Collection to store aggregation of TargetRefCat objects.
	 */
	protected $collTargetRefCats;

	/**
	 * @var        Criteria The criteria used to select the current contents of collTargetRefCats.
	 */
	private $lastTargetRefCatCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [cat_id] column value.
	 * Category Id
		
	 * @return     int
	 */
	public function getCatId()
	{

		return $this->cat_id;
	}

	/**
	 * Get the [cat_name] column value.
	 * Category name
		
	 * @return     string
	 */
	public function getCatName()
	{

		return $this->cat_name;
	}

	/**
	 * Get the [parent_id] column value.
	 * Parent category Id
		
	 * @return     int
	 */
	public function getParentId()
	{

		if ($this->parent_id === null && $this->isNew() && !$this->isColumnModified(CategoryPeer::PARENT_ID)) {
			return 0;
		}

		return $this->parent_id;
	}

	/**
	 * Set the value of [cat_id] column.
	 * Category Id
	 * @param      int $v new value
	 * @return     void
	 */
	public function setCatId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->cat_id !== $v) {
			$this->cat_id = $v;
			$this->modifiedColumns[] = CategoryPeer::CAT_ID;
		}

	} // setCatId()

	/**
	 * Set the value of [cat_name] column.
	 * Category name
	 * @param      string $v new value
	 * @return     void
	 */
	public function setCatName($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->cat_name !== $v) {
			$this->cat_name = $v;
			$this->modifiedColumns[] = CategoryPeer::CAT_NAME;
		}

	} // setCatName()

	/**
	 * Set the value of [parent_id] column.
	 * Parent category Id
	 * @param      int $v new value
	 * @return     void
	 */
	public function setParentId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->parent_id !== $v || $v === 0) {
			$this->parent_id = $v;
			$this->modifiedColumns[] = CategoryPeer::PARENT_ID;
		}

		if ($this->aCategoryRelatedByParentId !== null && $this->aCategoryRelatedByParentId->getCatId() !== $v) {
			$this->aCategoryRelatedByParentId = null;
		}

	} // setParentId()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 * 
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default. 
	 * 
	 * @return    boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array(CategoryPeer::PARENT_ID))) {
				return false;
			}

			if ($this->parent_id !== 0) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0)
	{
		try {

			$this->cat_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->cat_name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->parent_id = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
			$this->resetModified();

			$this->setNew(false);

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 3; // 3 = CategoryPeer::NUM_COLUMNS - CategoryPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Category object", $e);
		}
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CategoryPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			CategoryPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.  If the object is new,
	 * it inserts it; otherwise an update is performed.  This method
	 * wraps the doSave() worker method in a transaction.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CategoryPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			$affectedRows = $this->doSave($con);
			$con->commit();
			CategoryPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aCategoryRelatedByParentId !== null) {
				if ($this->aCategoryRelatedByParentId->isModified() || $this->aCategoryRelatedByParentId->isNew()) {
					$affectedRows += $this->aCategoryRelatedByParentId->save($con);
				}
				$this->setCategoryRelatedByParentId($this->aCategoryRelatedByParentId);
			}


			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = CategoryPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setCatId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += CategoryPeer::doUpdate($this, $con);
				}
				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collCategorysRelatedByParentId !== null) {
				foreach ($this->collCategorysRelatedByParentId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collTargetRefCats !== null) {
				foreach ($this->collTargetRefCats as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aCategoryRelatedByParentId !== null) {
				if (!$this->aCategoryRelatedByParentId->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCategoryRelatedByParentId->getValidationFailures());
				}
			}


			if (($retval = CategoryPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collTargetRefCats !== null) {
					foreach ($this->collTargetRefCats as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(CategoryPeer::DATABASE_NAME);

		if ($this->isColumnModified(CategoryPeer::CAT_ID)) $criteria->add(CategoryPeer::CAT_ID, $this->cat_id);
		if ($this->isColumnModified(CategoryPeer::CAT_NAME)) $criteria->add(CategoryPeer::CAT_NAME, $this->cat_name);
		if ($this->isColumnModified(CategoryPeer::PARENT_ID)) $criteria->add(CategoryPeer::PARENT_ID, $this->parent_id);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(CategoryPeer::DATABASE_NAME);

		$criteria->add(CategoryPeer::CAT_ID, $this->cat_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getCatId();
	}

	/**
	 * Generic method to set the primary key (cat_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setCatId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Category (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCatName($this->cat_name);

		$copyObj->setParentId($this->parent_id);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getCategorysRelatedByParentId() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
				$copyObj->addCategoryRelatedByParentId($relObj->copy($deepCopy));
			}
			}

			foreach ($this->getTargetRefCats() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
				$copyObj->addTargetRefCat($relObj->copy($deepCopy));
			}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setCatId(NULL); // this is a pkey column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Category Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     CategoryPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new CategoryPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Category object.
	 *
	 * @param      Category $v
	 * @return     void
	 * @throws     PropelException
	 */
	public function setCategoryRelatedByParentId(Category $v = null)
	{
		if ($v === null) {
			$this->setParentId(ColumnDefaultValue::__set_state(array(
   'value' => '0',
   'type' => 'value',
)));
		} else {
			$this->setParentId($v->getCatId());
		}

		$this->aCategoryRelatedByParentId = $v;


	}


	/**
	 * Get the associated Category object
	 *
	 * @param      PDO Optional Connection object.
	 * @return     Category The associated Category object.
	 * @throws     PropelException
	 */
	public function getCategoryRelatedByParentId(PDO $con = null)
	{
		if ($this->aCategoryRelatedByParentId === null && ($this->parent_id !== null)) {
			$this->aCategoryRelatedByParentId = CategoryPeer::retrieveByPK($this->parent_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aCategoryRelatedByParentId->addCategorysRelatedByParentId($this);
			 */
		}
		return $this->aCategoryRelatedByParentId;
	}

	/**
	 * Temporary storage of collCategorysRelatedByParentId to save a possible db hit in
	 * the event objects are add to the collection, but the
	 * complete collection is never requested.
	 *
	 * @return     void
	 * @deprecated - This method will be removed in 2.0 since arrays
	 *				are automatically initialized in the addCategorysRelatedByParentId() method.
	 * @see        addCategorysRelatedByParentId()
	 */
	public function initCategorysRelatedByParentId()
	{
		if ($this->collCategorysRelatedByParentId === null) {
			$this->collCategorysRelatedByParentId = array();
		}
	}

	/**
	 * Gets an array of  objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Category has previously been saved, it will retrieve
	 * related CategorysRelatedByParentId from storage. If this Category is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PDO $con
	 * @param      Criteria $criteria
	 * @return     array []
	 * @throws     PropelException
	 */
	public function getCategorysRelatedByParentId($criteria = null, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCategorysRelatedByParentId === null) {
			if ($this->isNew()) {
			   $this->collCategorysRelatedByParentId = array();
			} else {

				$criteria->add(CategoryPeer::PARENT_ID, $this->getCatId());

				CategoryPeer::addSelectColumns($criteria);
				$this->collCategorysRelatedByParentId = CategoryPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(CategoryPeer::PARENT_ID, $this->getCatId());

				CategoryPeer::addSelectColumns($criteria);
				if (!isset($this->lastCategoryRelatedByParentIdCriteria) || !$this->lastCategoryRelatedByParentIdCriteria->equals($criteria)) {
					$this->collCategorysRelatedByParentId = CategoryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCategoryRelatedByParentIdCriteria = $criteria;
		return $this->collCategorysRelatedByParentId;
	}

	/**
	 * Returns the number of related CategorysRelatedByParentId.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PDO $con
	 * @throws     PropelException
	 */
	public function countCategorysRelatedByParentId($criteria = null, $distinct = false, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CategoryPeer::PARENT_ID, $this->getCatId());

		return CategoryPeer::doCount($criteria, $distinct, $con);
	}

	/**
	 * Method called to associate a Category object to this object
	 * through the Category foreign key attribute.
	 *
	 * @param      Category $l Category
	 * @return     void
	 * @throws     PropelException
	 */
	public function addCategoryRelatedByParentId(Category $l)
	{
		$this->collCategorysRelatedByParentId = (array) $this->collCategorysRelatedByParentId;
		array_push($this->collCategorysRelatedByParentId, $l);
		$l->setCategoryRelatedByParentId($this);
	}

	/**
	 * Temporary storage of collTargetRefCats to save a possible db hit in
	 * the event objects are add to the collection, but the
	 * complete collection is never requested.
	 *
	 * @return     void
	 * @deprecated - This method will be removed in 2.0 since arrays
	 *				are automatically initialized in the addTargetRefCats() method.
	 * @see        addTargetRefCats()
	 */
	public function initTargetRefCats()
	{
		if ($this->collTargetRefCats === null) {
			$this->collTargetRefCats = array();
		}
	}

	/**
	 * Gets an array of  objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Category has previously been saved, it will retrieve
	 * related TargetRefCats from storage. If this Category is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PDO $con
	 * @param      Criteria $criteria
	 * @return     array []
	 * @throws     PropelException
	 */
	public function getTargetRefCats($criteria = null, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTargetRefCats === null) {
			if ($this->isNew()) {
			   $this->collTargetRefCats = array();
			} else {

				$criteria->add(TargetRefCatPeer::CAT_ID, $this->getCatId());

				TargetRefCatPeer::addSelectColumns($criteria);
				$this->collTargetRefCats = TargetRefCatPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(TargetRefCatPeer::CAT_ID, $this->getCatId());

				TargetRefCatPeer::addSelectColumns($criteria);
				if (!isset($this->lastTargetRefCatCriteria) || !$this->lastTargetRefCatCriteria->equals($criteria)) {
					$this->collTargetRefCats = TargetRefCatPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastTargetRefCatCriteria = $criteria;
		return $this->collTargetRefCats;
	}

	/**
	 * Returns the number of related TargetRefCats.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PDO $con
	 * @throws     PropelException
	 */
	public function countTargetRefCats($criteria = null, $distinct = false, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(TargetRefCatPeer::CAT_ID, $this->getCatId());

		return TargetRefCatPeer::doCount($criteria, $distinct, $con);
	}

	/**
	 * Method called to associate a TargetRefCat object to this object
	 * through the TargetRefCat foreign key attribute.
	 *
	 * @param      TargetRefCat $l TargetRefCat
	 * @return     void
	 * @throws     PropelException
	 */
	public function addTargetRefCat(TargetRefCat $l)
	{
		$this->collTargetRefCats = (array) $this->collTargetRefCats;
		array_push($this->collTargetRefCats, $l);
		$l->setCategory($this);
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Category is new, it will return
	 * an empty collection; or if this Category has previously
	 * been saved, it will retrieve related TargetRefCats from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Category.
	 */
	public function getTargetRefCatsJoinTarget($criteria = null, $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTargetRefCats === null) {
			if ($this->isNew()) {
				$this->collTargetRefCats = array();
			} else {

				$criteria->add(TargetRefCatPeer::CAT_ID, $this->getCatId());

				$this->collTargetRefCats = TargetRefCatPeer::doSelectJoinTarget($criteria, $con);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(TargetRefCatPeer::CAT_ID, $this->getCatId());

			if (!isset($this->lastTargetRefCatCriteria) || !$this->lastTargetRefCatCriteria->equals($criteria)) {
				$this->collTargetRefCats = TargetRefCatPeer::doSelectJoinTarget($criteria, $con);
			}
		}
		$this->lastTargetRefCatCriteria = $criteria;

		return $this->collTargetRefCats;
	}

} // BaseCategory
