<?php

/**
 * Base class that represents a row from the 'access_group' table.
 *
 * Group of users
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * Wed May 21 16:42:14 2008
 *
 * @package    masterkey.om
 */
abstract class BaseAccessGroup extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        AccessGroupPeer
	 */
	protected static $peer;


	/**
	 * The value for the group_id field.
	 * @var        int
	 */
	protected $group_id;


	/**
	 * The value for the group_name field.
	 * @var        string
	 */
	protected $group_name;


	/**
	 * The value for the logo field.
	 * @var        string
	 */
	protected $logo;

	/**
	 * @var        array User[] Collection to store aggregation of User objects.
	 */
	protected $collUsers;

	/**
	 * @var        Criteria The criteria used to select the current contents of collUsers.
	 */
	private $lastUserCriteria = null;

	/**
	 * @var        array IpMask[] Collection to store aggregation of IpMask objects.
	 */
	protected $collIpMasks;

	/**
	 * @var        Criteria The criteria used to select the current contents of collIpMasks.
	 */
	private $lastIpMaskCriteria = null;

	/**
	 * @var        array ZAuth[] Collection to store aggregation of ZAuth objects.
	 */
	protected $collZAuths;

	/**
	 * @var        Criteria The criteria used to select the current contents of collZAuths.
	 */
	private $lastZAuthCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [group_id] column value.
	 * Group Id
		
	 * @return     int
	 */
	public function getGroupId()
	{

		return $this->group_id;
	}

	/**
	 * Get the [group_name] column value.
	 * Group name
		
	 * @return     string
	 */
	public function getGroupName()
	{

		return $this->group_name;
	}

	/**
	 * Get the [logo] column value.
	 * group logo
		
	 * @return     string
	 */
	public function getLogo()
	{

		return $this->logo;
	}

	/**
	 * Set the value of [group_id] column.
	 * Group Id
	 * @param      int $v new value
	 * @return     void
	 */
	public function setGroupId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->group_id !== $v) {
			$this->group_id = $v;
			$this->modifiedColumns[] = AccessGroupPeer::GROUP_ID;
		}

	} // setGroupId()

	/**
	 * Set the value of [group_name] column.
	 * Group name
	 * @param      string $v new value
	 * @return     void
	 */
	public function setGroupName($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->group_name !== $v) {
			$this->group_name = $v;
			$this->modifiedColumns[] = AccessGroupPeer::GROUP_NAME;
		}

	} // setGroupName()

	/**
	 * Set the value of [logo] column.
	 * group logo
	 * @param      string $v new value
	 * @return     void
	 */
	public function setLogo($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->logo !== $v) {
			$this->logo = $v;
			$this->modifiedColumns[] = AccessGroupPeer::LOGO;
		}

	} // setLogo()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 * 
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default. 
	 * 
	 * @return    boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0)
	{
		try {

			$this->group_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->group_name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->logo = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->resetModified();

			$this->setNew(false);

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 3; // 3 = AccessGroupPeer::NUM_COLUMNS - AccessGroupPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating AccessGroup object", $e);
		}
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AccessGroupPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			AccessGroupPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.  If the object is new,
	 * it inserts it; otherwise an update is performed.  This method
	 * wraps the doSave() worker method in a transaction.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AccessGroupPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			$affectedRows = $this->doSave($con);
			$con->commit();
			AccessGroupPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = AccessGroupPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setGroupId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += AccessGroupPeer::doUpdate($this, $con);
				}
				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collUsers !== null) {
				foreach ($this->collUsers as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collIpMasks !== null) {
				foreach ($this->collIpMasks as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collZAuths !== null) {
				foreach ($this->collZAuths as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = AccessGroupPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collUsers !== null) {
					foreach ($this->collUsers as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collIpMasks !== null) {
					foreach ($this->collIpMasks as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collZAuths !== null) {
					foreach ($this->collZAuths as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(AccessGroupPeer::DATABASE_NAME);

		if ($this->isColumnModified(AccessGroupPeer::GROUP_ID)) $criteria->add(AccessGroupPeer::GROUP_ID, $this->group_id);
		if ($this->isColumnModified(AccessGroupPeer::GROUP_NAME)) $criteria->add(AccessGroupPeer::GROUP_NAME, $this->group_name);
		if ($this->isColumnModified(AccessGroupPeer::LOGO)) $criteria->add(AccessGroupPeer::LOGO, $this->logo);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(AccessGroupPeer::DATABASE_NAME);

		$criteria->add(AccessGroupPeer::GROUP_ID, $this->group_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getGroupId();
	}

	/**
	 * Generic method to set the primary key (group_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setGroupId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of AccessGroup (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setGroupName($this->group_name);

		$copyObj->setLogo($this->logo);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getUsers() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
				$copyObj->addUser($relObj->copy($deepCopy));
			}
			}

			foreach ($this->getIpMasks() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
				$copyObj->addIpMask($relObj->copy($deepCopy));
			}
			}

			foreach ($this->getZAuths() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
				$copyObj->addZAuth($relObj->copy($deepCopy));
			}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setGroupId(NULL); // this is a pkey column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     AccessGroup Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     AccessGroupPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new AccessGroupPeer();
		}
		return self::$peer;
	}

	/**
	 * Temporary storage of collUsers to save a possible db hit in
	 * the event objects are add to the collection, but the
	 * complete collection is never requested.
	 *
	 * @return     void
	 * @deprecated - This method will be removed in 2.0 since arrays
	 *				are automatically initialized in the addUsers() method.
	 * @see        addUsers()
	 */
	public function initUsers()
	{
		if ($this->collUsers === null) {
			$this->collUsers = array();
		}
	}

	/**
	 * Gets an array of  objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this AccessGroup has previously been saved, it will retrieve
	 * related Users from storage. If this AccessGroup is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PDO $con
	 * @param      Criteria $criteria
	 * @return     array []
	 * @throws     PropelException
	 */
	public function getUsers($criteria = null, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUsers === null) {
			if ($this->isNew()) {
			   $this->collUsers = array();
			} else {

				$criteria->add(UserPeer::GROUP_ID, $this->getGroupId());

				UserPeer::addSelectColumns($criteria);
				$this->collUsers = UserPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(UserPeer::GROUP_ID, $this->getGroupId());

				UserPeer::addSelectColumns($criteria);
				if (!isset($this->lastUserCriteria) || !$this->lastUserCriteria->equals($criteria)) {
					$this->collUsers = UserPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastUserCriteria = $criteria;
		return $this->collUsers;
	}

	/**
	 * Returns the number of related Users.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PDO $con
	 * @throws     PropelException
	 */
	public function countUsers($criteria = null, $distinct = false, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(UserPeer::GROUP_ID, $this->getGroupId());

		return UserPeer::doCount($criteria, $distinct, $con);
	}

	/**
	 * Method called to associate a User object to this object
	 * through the User foreign key attribute.
	 *
	 * @param      User $l User
	 * @return     void
	 * @throws     PropelException
	 */
	public function addUser(User $l)
	{
		$this->collUsers = (array) $this->collUsers;
		array_push($this->collUsers, $l);
		$l->setAccessGroup($this);
	}

	/**
	 * Temporary storage of collIpMasks to save a possible db hit in
	 * the event objects are add to the collection, but the
	 * complete collection is never requested.
	 *
	 * @return     void
	 * @deprecated - This method will be removed in 2.0 since arrays
	 *				are automatically initialized in the addIpMasks() method.
	 * @see        addIpMasks()
	 */
	public function initIpMasks()
	{
		if ($this->collIpMasks === null) {
			$this->collIpMasks = array();
		}
	}

	/**
	 * Gets an array of  objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this AccessGroup has previously been saved, it will retrieve
	 * related IpMasks from storage. If this AccessGroup is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PDO $con
	 * @param      Criteria $criteria
	 * @return     array []
	 * @throws     PropelException
	 */
	public function getIpMasks($criteria = null, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collIpMasks === null) {
			if ($this->isNew()) {
			   $this->collIpMasks = array();
			} else {

				$criteria->add(IpMaskPeer::GROUP_ID, $this->getGroupId());

				IpMaskPeer::addSelectColumns($criteria);
				$this->collIpMasks = IpMaskPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(IpMaskPeer::GROUP_ID, $this->getGroupId());

				IpMaskPeer::addSelectColumns($criteria);
				if (!isset($this->lastIpMaskCriteria) || !$this->lastIpMaskCriteria->equals($criteria)) {
					$this->collIpMasks = IpMaskPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastIpMaskCriteria = $criteria;
		return $this->collIpMasks;
	}

	/**
	 * Returns the number of related IpMasks.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PDO $con
	 * @throws     PropelException
	 */
	public function countIpMasks($criteria = null, $distinct = false, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(IpMaskPeer::GROUP_ID, $this->getGroupId());

		return IpMaskPeer::doCount($criteria, $distinct, $con);
	}

	/**
	 * Method called to associate a IpMask object to this object
	 * through the IpMask foreign key attribute.
	 *
	 * @param      IpMask $l IpMask
	 * @return     void
	 * @throws     PropelException
	 */
	public function addIpMask(IpMask $l)
	{
		$this->collIpMasks = (array) $this->collIpMasks;
		array_push($this->collIpMasks, $l);
		$l->setAccessGroup($this);
	}

	/**
	 * Temporary storage of collZAuths to save a possible db hit in
	 * the event objects are add to the collection, but the
	 * complete collection is never requested.
	 *
	 * @return     void
	 * @deprecated - This method will be removed in 2.0 since arrays
	 *				are automatically initialized in the addZAuths() method.
	 * @see        addZAuths()
	 */
	public function initZAuths()
	{
		if ($this->collZAuths === null) {
			$this->collZAuths = array();
		}
	}

	/**
	 * Gets an array of  objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this AccessGroup has previously been saved, it will retrieve
	 * related ZAuths from storage. If this AccessGroup is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PDO $con
	 * @param      Criteria $criteria
	 * @return     array []
	 * @throws     PropelException
	 */
	public function getZAuths($criteria = null, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collZAuths === null) {
			if ($this->isNew()) {
			   $this->collZAuths = array();
			} else {

				$criteria->add(ZAuthPeer::GROUP_ID, $this->getGroupId());

				ZAuthPeer::addSelectColumns($criteria);
				$this->collZAuths = ZAuthPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(ZAuthPeer::GROUP_ID, $this->getGroupId());

				ZAuthPeer::addSelectColumns($criteria);
				if (!isset($this->lastZAuthCriteria) || !$this->lastZAuthCriteria->equals($criteria)) {
					$this->collZAuths = ZAuthPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastZAuthCriteria = $criteria;
		return $this->collZAuths;
	}

	/**
	 * Returns the number of related ZAuths.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PDO $con
	 * @throws     PropelException
	 */
	public function countZAuths($criteria = null, $distinct = false, PDO $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ZAuthPeer::GROUP_ID, $this->getGroupId());

		return ZAuthPeer::doCount($criteria, $distinct, $con);
	}

	/**
	 * Method called to associate a ZAuth object to this object
	 * through the ZAuth foreign key attribute.
	 *
	 * @param      ZAuth $l ZAuth
	 * @return     void
	 * @throws     PropelException
	 */
	public function addZAuth(ZAuth $l)
	{
		$this->collZAuths = (array) $this->collZAuths;
		array_push($this->collZAuths, $l);
		$l->setAccessGroup($this);
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this AccessGroup is new, it will return
	 * an empty collection; or if this AccessGroup has previously
	 * been saved, it will retrieve related ZAuths from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in AccessGroup.
	 */
	public function getZAuthsJoinTarget($criteria = null, $con = null)
	{
		
		if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collZAuths === null) {
			if ($this->isNew()) {
				$this->collZAuths = array();
			} else {

				$criteria->add(ZAuthPeer::GROUP_ID, $this->getGroupId());

				$this->collZAuths = ZAuthPeer::doSelectJoinTarget($criteria, $con);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(ZAuthPeer::GROUP_ID, $this->getGroupId());

			if (!isset($this->lastZAuthCriteria) || !$this->lastZAuthCriteria->equals($criteria)) {
				$this->collZAuths = ZAuthPeer::doSelectJoinTarget($criteria, $con);
			}
		}
		$this->lastZAuthCriteria = $criteria;

		return $this->collZAuths;
	}

} // BaseAccessGroup
