#!/bin/sh

CWD=$(dirname $0)
BUILD_DIR=$CWD/../tmp
XSLT_BIN=/usr/bin/xsltproc
CONFIG=$CWD/../build.conf
PROPEL_BUILD=/usr/bin/propel-gen
OUTPUT_DIR=$CWD/../../php/propel_build
AUTH_PUBLIC=$CWD/../../public/auth
MANAGE_PUBLIC=$CWD/../../public/manage
DEMO_PUBLIC=$CWD/../../public/demo
DATA_DIR=$CWD/../../data


if ! [ -x $PROPEL_BUILD ] ; then
    echo "Install Propel from pecl: Expects executable $PROPEL_BUILD";
    exit 1;
fi

if ! [ -f $CONFIG ] ; then
    echo "You'll need to have the file: $CONFIG";
    exit 1;
fi

test -d $BUILD_DIR || mkdir $BUILD_DIR
test -d $OUTPUT_DIR || mkdir $OUTPUT_DIR

$XSLT_BIN $CWD/propel-build.xsl $CONFIG > $BUILD_DIR/build.properties
$XSLT_BIN $CWD/propel-runtime-conf.xsl $CONFIG > $BUILD_DIR/runtime-conf.xml
$XSLT_BIN $CWD/propel-schema.xsl $CONFIG > $BUILD_DIR/schema.xml

$PROPEL_BUILD $BUILD_DIR

cp -a $BUILD_DIR/build/* $OUTPUT_DIR
cp -a $OUTPUT_DIR/sql/schema.sql $DATA_DIR/masterkey-drop-add-tables.sql 
rm -rf $BUILD_DIR

#touch $AUTH_PUBLIC/propel.log
#chmod 666 $AUTH_PUBLIC/propel.log

#touch $MANAGE_PUBLIC/propel.log
#chmod 666 $MANAGE_PUBLIC/propel.log

#ln -s ../auth $DEMO_PUBLIC/auth
