/* $Id: loginEvents.js,v 1.1.1.1 2007-05-09 17:26:11 jakub Exp $ */

my_auth = new Auth({    "onAuthorSuccess": my_authsuccess,
                        "onAuthorFailure": my_authfailure,
                        "onIpSuccess": my_ipsuccess,
                        "onIpFailure": my_ipfailure,
                        "onHsSuccess": my_hssuccess,
                        "onHsFailure": my_hsfailure,
                        "output": "json" 
                        });

var loggedIn = false;
var ipAuth = false;

$(document).ready(function()
    {
        my_auth.ipAuthenticate();
        $("#username").blur(checkLogin);
        $("#password").blur(checkLogin);
    }
);

function checkLogin()
{
    if(loggedIn)
        return;
    if( $("#username").val() && $("#password").val() ) {
        my_auth.handshake();
        $("#message").text("Trying to log in...");
    }
}

function logOut()
{
    /* ip auth one more time?*/
    loggedIn = false;
    $("#message").text("Enter your username and password to log in.");
    $("ul.dir").remove();
    /*curQuery.clearFilter();*/
}


/* handshake callback */
function my_hssuccess (data)
{
    my_auth.authorize($("#username").val(), $("#password").val());
}

function my_hsfailure()
{
    alert("Out of service");
}

/* ip auth callback */
function my_ipsuccess(data)
{
    ipAuth = true;
    $("#message").text("IP authorized: "+data["authorization"]["ipaddr"]+". ");

    $("#targetSelection").empty();
    var catTree = buildTree(data["authorization"]["categories"], new Bool());

    catTree.addClass('dir')
        .appendTo("#targetSelection")
        .Treeview();
}

function my_ipfailure(data)
{
    alert('Your IP is unknown. Login to use the service.');
}

/* auth callbacks */
function my_authsuccess(data)
{
    loggedIn = true;
    ipAuth = false; //takes precedence
    
    $("#message").text("Logged in as "+my_auth.username+". ");
    $("#message").append(' [<a href="#" onclick="logOut()">logout</a>]');
    
    $("#targetSelection").empty();
    var catTree = buildTree(data["authorization"]["categories"], new Bool());

    catTree.addClass('dir')
        .appendTo("#targetSelection")
        .Treeview();
}

function my_authfailure()
{
    $("#message").text("Failed to login.");
}

/* category browsing functions */

var Bool = function () {
    this.isEmpty = true;
}

function buildTree(data, currentBool)
{
    var catsUl = $('<ul></ul>');
    
    if (data) {
        for(var i = 0; i < data.length; i++) {

            var catLi = $('<li id="catid_' + data[i]["catid"] 
                + '" class="closed"><input type="checkbox" onclick="checkCategory(this)"/><b>'
                + data[i]["catname"] + '</b></li>');

            var childBool = new Bool();
            var subUl = buildTree( data[i]["subcats"], childBool );           
             
            for( var j=0; j < data[i]["targets"].length; j++) {
                childBool.isEmpty = false;
                subUl.append('<li id="'
                            +data[i]["targets"][j]["id"]
                            +'"><input type="checkbox" onclick="'
                            + 'checkTarget(this, this.nextSibling.nodeValue)'
                            + '" class="targetCb" value="'
                            +data[i]["targets"][j]["id"]+'"/>'
                            +data[i]["targets"][j]["name"]+'</li>');
            }
            
            if ( !childBool.isEmpty ) {
                currentBool.isEmpty = false;
                catLi.append(subUl);
                catsUl.append(catLi);
            }
        }
    }
    if( !currentBool.isEmpty ) {
        return catsUl;
    } else {
        return $('<ul></ul>');
    }
}

function checkCategory(catCheckbox)
{
    if( catCheckbox.checked == true ) {
        $(catCheckbox)
            .parent()
            .children('ul')
            .children('li')
            .children('input')
            .each( function(){
                    if ( this.checked == false ) {
                        this.checked = true;
                    if(this.className == 'targetCb')
                        checkTarget(this, this.nextSibling.nodeValue);
                    else
                        checkCategory(this);
                    }
                } );
    } else {
        $(catCheckbox)
            .parent()
            .children('ul')
            .children('li')
            .children('input')
            .each( function(){
                    if ( this.checked == true ) {
                        this.checked = false;
                    if(this.className == 'targetCb')
                        checkTarget(this, this.nextSibling.nodeValue);
                    else
                        checkCategory(this);
                    }
                } );
    }
}

function checkTarget(targetCheckbox, targetName)
{
/*    if( targetCheckbox.checked == true ) {
        targetCheckbox
        .setAttribute('filterpos', 
                curQuery.addFilter(targetName, targetCheckbox.value) );
    } else {
        curQuery.removeFilter( targetCheckbox.getAttribute('filterpos') );
        targetCheckbox
        .removeAttribute('filterpos');
    }*/
}

function getChecked() {
    $('input:checkbox.targetCb').each( function(){ 
            if( $(this).is(':checked') )
            alert( $(this).val() ); 
            }
            );
};
