<?php
require_once 'php/classes/WsResponseFactory.class.php';
require_once 'Auth.class.php';
require_once 'CategoryTreeHash.class.php';

class AuthWS
{
    private $request;
    private $response;
    private $session;
    private $auth;

    public function __construct (&$r, &$s)
    {
        $this->request = &$r;
        $this->session = &$s;
        
        isset( $this->request['output'] )
            ? $output = $this->request['output']
            : $output = 'json';

        $this->response = 
            WsResponseFactory::getResponse($output);
        
        $this->auth = new Auth();
    }
    
    public function start ()
    {
        $this->response->header();
        $this->dispatchCommand();
    }

    public function stop ()
    {
        exit;
    }

    public function sendResponse ()
    {
        echo $this->response->printResponse();
    }
    
    private function dispatchCommand ()
    {
        switch( strtolower($this->request['command']) )
        {
            case 'check' :
                $this->response->setRoot('auth-check');
                $this->doCheck();
                break;

            case 'handshake' :
                $this->response->setRoot('auth-handshake');
                $this->doHandshake();
                break;
            
            case 'login' :
                $this->response->setRoot('auth-login');
                try {
                    $this->doLogin();
                } catch (Exception $e) {
                    $this->response->addError( $e->getMessage() );
                }
                break;

            case 'tree' :
                $this->response->setRoot('tree');
                $this->doTree();
                break;
           
            default :
                $this->response->setRoot('auth-error');
                $this->response->addError('Command unknown or missing.');
        }
    }

    private function doCheck()
    {
        if ( isset( $this->session['auth']['policy'] )
            && $this->auth->authByPolicy( $this->session['auth']['policy'] ) ) {
            $this->response->addEntry('status', 'success' );
            $this->response->appendEntry( $this->session['auth']['policy'], 'policy' );
            $this->response->addEntry('seed' , $this->auth->handshake() );
        } else {
            $this->response->addEntry('status', 'failed' );
            $this->response->addEntry('seed' , $this->auth->handshake() );
        }
    }

    private function doHandshake ()
    {
        $this->response->addEntry('seed' , $this->auth->handshake() );
    }

    private function doLogin ()
    {
        unset( $this->session['auth'] );

        if ( isset($this->request['ipaddr']) )
            $this->auth->setIpAddr( $this->request['ipaddr'] );
        
        if ( isset($this->request['user']) )
            $this->auth->setUsername( $this->request['user'] );

        if ( isset($this->request['pass']) )
            $this->auth->setPassword( $this->request['pass'] );

        if ( isset($this->request['seedid']) )
            $this->auth->setSeedId( $this->request['seedid'] );

        if ( $this->auth->authenticate() ) {
            $this->session['auth'] = array();
            $this->session['auth']['policy'] = $this->auth->getPolicy();
            $this->response->addEntry('status', 'success');
            $this->response->appendEntry( $this->session['auth']['policy'], 'policy' );
        } else {
            $this->response->addEntry('status', 'failed');
        }
    }

    private function doTree()
    {
        if ( isset( $this->session['auth']['policy'] ) 
            && $this->auth->authByPolicy( $this->session['auth']['policy'] ) )
        {
            $targets = $this->auth->authorize();
            
            $catTree = new CategoryTreeHash();
            $catTree->insertTargets($targets);
            
            $target_list = array();

            foreach ($targets as $t) {
                $target = $t->getTarget();
                $target_list[ $target->getConnString() ] = array(
                    
                        'target_name'   => $target->getTargetName(),
                        'rec_enc'       => $target->getRecEnc(),
                        'query_enc'     => $target->getQueryEnc(),
                        'rec_syn'       => $target->getReqSyn(),
                        'holding_type'  => $target->getHoldingType(),
                        'holding_xsl'   => $target->getHoldingXsl()

                    );
            }
            
            $this->response->addEntry('logo', $this->auth->getGroupLogoURI() );
            $this->response->addEntry('targets', json_encode($target_list) );
            $this->response->addEntry('categories', json_encode($catTree->getTree()) );
        } else {
            $this->response->addError('Not authenticated.');
        }
    }
}
