<?xml version="1.0"?>
<!--
    $Id: manage_group.xsl,v 1.3 2007-07-25 14:53:13 jakub Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>

  <xsl:variable name="groupid" select="string($input/data/@groupid)"/>
  <xsl:variable name="group_form" select="$input/subtree[@name = 'group']"/>

  <xsl:template name="insert-body">
    <h3>Authorization group management.</h3>
    
    <form name="groupForm" method="post">
      <input type="hidden" name="page" value="{$page}"/>
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="groupid" value="null"/>


      <xsl:choose>
        <xsl:when test="$action = 'editgroup'">
          <br/>
          <b>Edit group:</b>
          <br/>
          <br/>
          <xsl:choose>
            <xsl:when test="$group_form">
              <xsl:call-template name="insert-group-data">
                <xsl:with-param name="group" select="$group_form/*"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="insert-group-data">
                <xsl:with-param name="group"
                      select="php:function('get_group_data', $groupid)/*"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>

        <xsl:when test="$action = 'addgroup'">
          <br/>
          <b>Add group:</b>
          <br/>
          <br/>
          <xsl:call-template name="insert-group-data">
            <xsl:with-param name="group" select="/*/defaultGroup"/>
          </xsl:call-template>
        </xsl:when>

        <xsl:otherwise>
          <xsl:call-template name="insert-group-list"/>
        </xsl:otherwise>
      
      </xsl:choose>

    </form>

    <br/>
  </xsl:template>

  <xsl:template name="insert-group-data">
    
    <xsl:param name="group"/>    
    
    <table>
      <tr>
        <td><b>Group name:</b></td>
        <td><input type="text" name="data[name]" value="{$group/@name}" /></td>
      </tr>
      <tr>
        <td><b>Group logo:</b></td>
        <td><input type="text" name="data[logo]" value="{$group/@logo}" /></td>
      </tr>
    </table>

    <xsl:call-template name="insert-resource-list">
      <xsl:with-param name="targets"
        select="php:function('get_targets_sel_group', $groupid)/*"/>
    </xsl:call-template>

    <br/>
    
    <table>
      <tr>
        <td>
          <input type="button" value="Save"
              onclick="set_action(document.groupForm, 'savegroup',
                                       '{$groupid}')" />
        </td>
        <td>
          <input type="button" value="Delete"
              onclick="set_action(document.groupForm, 'deletegroup',
                                       '{$groupid}')" />
        </td>
        <td>
          <input type="button" value="Cancel"
              onclick="set_action(document.groupForm, 'switchpage')"/>
        </td>
      </tr>
    </table>

  </xsl:template>

  <xsl:template name="insert-group-list">
    
    <br/>
    <b>Stored groups:</b>
    <br/>
    <br/>

    <input type="button" value="Add group"
      onclick="set_action(document.groupForm, 'addgroup')"/>

    <ul>
      <xsl:for-each select="php:function('get_groups_list')/*/*">
        <li>
          <xsl:value-of select="@name"/>
          <input type="button" value="Edit" 
            onclick="set_action(document.groupForm, 'editgroup', '{@id}')"/>
          <input type="button" value="Delete"
            onclick="set_action(document.groupForm, 'deletegroup', '{@id}')"/>
        </li>
      </xsl:for-each>
    </ul>
        
    <input type="button" value="Add group"
        onclick="set_action(document.groupForm, 'addgroup')"/>

  </xsl:template>
  
  <xsl:template name="insert-resource-list">
    <xsl:param name="targets"/>
    <br/>
    <b>Assign resources:</b>
    <br/>
    <br/>
    <table>
      
      <xsl:for-each select="$targets/*">
        <tr>
          <td>
            <input type="checkbox" name="target[{@id}][target_id]" value="{@id}"
              onclick="toggleInputs(new Array('zuser_{@id}','zpass_{@id}'));">
            <xsl:if test="@selected">
              <xsl:attribute name="checked">checked</xsl:attribute>
            </xsl:if>
            </input>
            <b><xsl:value-of select="@name"/></b>
          </td>
          <td>
            User:
            <input type="text" id="zuser_{@id}" 
              name="target[{@id}][zuser]" value="{@zuser}">
            <xsl:if test="not(@selected)">
              <xsl:attribute name="disabled">disabled</xsl:attribute>
            </xsl:if>
            </input>
          </td>
          <td>
            Pass:
            <input type="text" id="zpass_{@id}"
              name="target[{@id}][zpass]" value="{@zpass}">
            <xsl:if test="not(@selected)">
              <xsl:attribute name="disabled">disabled</xsl:attribute>
            </xsl:if>
            </input>
          </td>
        </tr>
      </xsl:for-each>

    </table>
  
  </xsl:template>

</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
