<?php

/**
 * Base class that represents a row from the 'ccl_spec' table.
 *
 * CCL to PQF mapping specificiations
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * Wed May 14 12:41:24 2008
 *
 * @package    masterkey.om
 */
abstract class BaseCclSpec extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        CclSpecPeer
	 */
	protected static $peer;


	/**
	 * The value for the ccl_spec_id field.
	 * @var        int
	 */
	protected $ccl_spec_id;


	/**
	 * The value for the ccl_map_id field.
	 * @var        int
	 */
	protected $ccl_map_id;


	/**
	 * The value for the ccl_qual field.
	 * @var        string
	 */
	protected $ccl_qual;


	/**
	 * The value for the pqf field.
	 * @var        string
	 */
	protected $pqf;

	/**
	 * @var        CclMap
	 */
	protected $aCclMap;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [ccl_spec_id] column value.
	 * Specificiation ID
		
	 * @return     int
	 */
	public function getCclSpecId()
	{

		return $this->ccl_spec_id;
	}

	/**
	 * Get the [ccl_map_id] column value.
	 * Relation to cclmap table
		
	 * @return     int
	 */
	public function getCclMapId()
	{

		return $this->ccl_map_id;
	}

	/**
	 * Get the [ccl_qual] column value.
	 * CCL qualifier
		
	 * @return     string
	 */
	public function getCclQual()
	{

		return $this->ccl_qual;
	}

	/**
	 * Get the [pqf] column value.
	 * PQF string
		
	 * @return     string
	 */
	public function getPqf()
	{

		return $this->pqf;
	}

	/**
	 * Set the value of [ccl_spec_id] column.
	 * Specificiation ID
	 * @param      int $v new value
	 * @return     void
	 */
	public function setCclSpecId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->ccl_spec_id !== $v) {
			$this->ccl_spec_id = $v;
			$this->modifiedColumns[] = CclSpecPeer::CCL_SPEC_ID;
		}

	} // setCclSpecId()

	/**
	 * Set the value of [ccl_map_id] column.
	 * Relation to cclmap table
	 * @param      int $v new value
	 * @return     void
	 */
	public function setCclMapId($v)
	{

		// Since the native PHP type for this column is integer,
		// we will cast the input value to an int (if it is not).
		if ($v !== null && !is_int($v) && is_numeric($v)) {
			$v = (int) $v;
		}

		if ($this->ccl_map_id !== $v) {
			$this->ccl_map_id = $v;
			$this->modifiedColumns[] = CclSpecPeer::CCL_MAP_ID;
		}

		if ($this->aCclMap !== null && $this->aCclMap->getCclMapId() !== $v) {
			$this->aCclMap = null;
		}

	} // setCclMapId()

	/**
	 * Set the value of [ccl_qual] column.
	 * CCL qualifier
	 * @param      string $v new value
	 * @return     void
	 */
	public function setCclQual($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->ccl_qual !== $v) {
			$this->ccl_qual = $v;
			$this->modifiedColumns[] = CclSpecPeer::CCL_QUAL;
		}

	} // setCclQual()

	/**
	 * Set the value of [pqf] column.
	 * PQF string
	 * @param      string $v new value
	 * @return     void
	 */
	public function setPqf($v)
	{

		// Since the native PHP type for this column is string,
		// we will cast the input to a string (if it is not).
		if ($v !== null && !is_string($v)) {
			$v = (string) $v; 
		}

		if ($this->pqf !== $v) {
			$this->pqf = $v;
			$this->modifiedColumns[] = CclSpecPeer::PQF;
		}

	} // setPqf()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 * 
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default. 
	 * 
	 * @return    boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0)
	{
		try {

			$this->ccl_spec_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->ccl_map_id = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
			$this->ccl_qual = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->pqf = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->resetModified();

			$this->setNew(false);

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 4; // 4 = CclSpecPeer::NUM_COLUMNS - CclSpecPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating CclSpec object", $e);
		}
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CclSpecPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			CclSpecPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.  If the object is new,
	 * it inserts it; otherwise an update is performed.  This method
	 * wraps the doSave() worker method in a transaction.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CclSpecPeer::DATABASE_NAME);
		}

		try {
			$con->beginTransaction();
			$affectedRows = $this->doSave($con);
			$con->commit();
			CclSpecPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	/**
	 * Stores the object in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aCclMap !== null) {
				if ($this->aCclMap->isModified() || $this->aCclMap->isNew()) {
					$affectedRows += $this->aCclMap->save($con);
				}
				$this->setCclMap($this->aCclMap);
			}


			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = CclSpecPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setCclSpecId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += CclSpecPeer::doUpdate($this, $con);
				}
				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aCclMap !== null) {
				if (!$this->aCclMap->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCclMap->getValidationFailures());
				}
			}


			if (($retval = CclSpecPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(CclSpecPeer::DATABASE_NAME);

		if ($this->isColumnModified(CclSpecPeer::CCL_SPEC_ID)) $criteria->add(CclSpecPeer::CCL_SPEC_ID, $this->ccl_spec_id);
		if ($this->isColumnModified(CclSpecPeer::CCL_MAP_ID)) $criteria->add(CclSpecPeer::CCL_MAP_ID, $this->ccl_map_id);
		if ($this->isColumnModified(CclSpecPeer::CCL_QUAL)) $criteria->add(CclSpecPeer::CCL_QUAL, $this->ccl_qual);
		if ($this->isColumnModified(CclSpecPeer::PQF)) $criteria->add(CclSpecPeer::PQF, $this->pqf);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(CclSpecPeer::DATABASE_NAME);

		$criteria->add(CclSpecPeer::CCL_SPEC_ID, $this->ccl_spec_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getCclSpecId();
	}

	/**
	 * Generic method to set the primary key (ccl_spec_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setCclSpecId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of CclSpec (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCclMapId($this->ccl_map_id);

		$copyObj->setCclQual($this->ccl_qual);

		$copyObj->setPqf($this->pqf);


		$copyObj->setNew(true);

		$copyObj->setCclSpecId(NULL); // this is a pkey column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     CclSpec Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     CclSpecPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new CclSpecPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a CclMap object.
	 *
	 * @param      CclMap $v
	 * @return     void
	 * @throws     PropelException
	 */
	public function setCclMap(CclMap $v = null)
	{
		if ($v === null) {
			$this->setCclMapId(NULL);
		} else {
			$this->setCclMapId($v->getCclMapId());
		}

		$this->aCclMap = $v;


	}


	/**
	 * Get the associated CclMap object
	 *
	 * @param      PDO Optional Connection object.
	 * @return     CclMap The associated CclMap object.
	 * @throws     PropelException
	 */
	public function getCclMap(PDO $con = null)
	{
		if ($this->aCclMap === null && ($this->ccl_map_id !== null)) {
			$this->aCclMap = CclMapPeer::retrieveByPK($this->ccl_map_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aCclMap->addCclSpecs($this);
			 */
		}
		return $this->aCclMap;
	}

} // BaseCclSpec
