<?php
/* $Id: Auth.class.php,v 1.8 2007-09-27 11:18:44 jakub Exp $ */
require_once 'propel/Propel.php';
/* 
** Base Authorization and Authentication class
*/
class Auth
{
    private $username;
    private $password;
    private $ipAddr;
    private $noPassAuth;
    private $authGroup;
    private $policy;
    private $seedId;

    public function __construct ()
    {
        $this->policy = array();
        $this->noPassAuth = false;
    }

    // accessors
    
    public function setUsername ($username)
    {
        $this->username = $username;
    }
    public function setPassword ($password)
    {
        $this->password = $password;
    }
    
    public function setIPAddr ($ipAddr)
    {
        $this->ipAddr = $ipAddr;
    }

    public function setSeedId ($seedId)
    {
        $this->seedId = $seedId;
    }

    public function setNoPassAuthOn ()
    {
        $this->noPassAuth = true;
    }

    public function setNoPassAuthOff ()
    {
        $this->noPassAuth = false;
    }

    public function getPolicy ()
    {
        return $this->policy;
    }

    public function getGroupLogoURI ()
    {
        return $this->authGroup->getLogo();
    }

    // auth protocol functions

    public function handshake ()
    {
        return $this->makeSeed();
    }

    public function authenticate ()
    {
        // todo AUTH CHAIN
        if ( isset($this->username) )
            return $this->authWithCredentials();

        if ( isset($this->ipAddr) )
            return $this->authWithIP();

        throw new Exception('Missing mandatory authentication properties!');
    }

    public function authorize ()
    {
        if ( isset( $this->authGroup ) ) {
            $c = new Criteria();
            $c->addAscendingOrderByColumn(TargetPeer::TARGET_NAME);
            return $this->authGroup->getZAuthsJoinTarget($c);
        }
        else
            throw new Exception('Not authenticated!');
    }

    public function authByPolicy ($policy)
    {
        if ( isset( $policy['ipaddr'] ) )
            $this->ipAddr = $policy['ipaddr']['value'];
        
        if ( isset( $policy['username'] ) )
            $this->username = $policy['username']['value'];

        $this->setNoPassAuthOn();

        return $this->authenticate();
    }

    // internal auth functions

    private function authWithIP()
    {
        $this->addToPolicy('ipaddr', $this->ipAddr);
        
        $longIp = ip2long($this->ipAddr);

        $c = new Criteria();
        $c->add(IpMaskPeer::MASK_LOWER, $longIp, Criteria::LESS_EQUAL);
        $c->add(IpMaskPeer::MASK_UPPER, $longIp, Criteria::GREATER_EQUAL);
        
        /* fetch with related group object */
        $authenIp = IpMaskPeer::doSelectJoinAccessGroup($c);

        if( $authenIp ) {
            $this->authGroup =  $authenIp[0]->getAccessGroup();
            return true;
        } else {
	    $cc = new Criteria();
	    $cc->add(IpMaskPeer::MASK_LOWER, 0, Criteria::EQUAL);
	    $cc->add(IpMaskPeer::MASK_UPPER, 0, Criteria::EQUAL);
	    $guestIp = IpMaskPeer::doSelectJoinAccessGroup($cc);
	    if ($guestIp) {
		$this->authGroup = $guestIp[0]->getAccessGroup();
		return true;
	    } else
		return false;
        }
    }

    private function authWithCredentials ()
    {
        $this->addToPolicy('username', $this->username);

        $c = new Criteria();
        $c->add(UserPeer::LOGIN, $this->username );
        $user = UserPeer::doSelectJoinAccessGroup($c);

        // user does not exist
        if ( !$user )
            return false;

        $this->addToPolicy('userid', $user[0]->getUserId() );

        // authenticate without pass?
        if ( $this->noPassAuth ) {
            $this->authGroup = $user[0]->getAccessGroup();
            return true;
        }
        
        $this->addToPolicy('password', 'hidden' );

        // if seed was supplied use it (more secure)
        if ( isset( $this->seedId ) ) {
            $seed = $this->checkSeed( $this->seedId );
            $passFromDB = md5( $user[0]->getEncPass().$seed );
        } else {
            $passFromDB = md5( $user[0]->getEncPass() );
        }

        if( $passFromDB == $this->password ) {
            $this->authGroup = $user[0]->getAccessGroup();
            return true;
        } else {
            return false;
        }
    }
        
    private function makeSeed ()
    {
        $seed = new Seed();
        $seed->setSeedValue(mt_rand());
        $seed->save();
        return array("id" => $seed->getSeedId(), "value" => $seed->getSeedValue());
    }

    private function checkSeed ($seedId)
    {
        $criterium = new Criteria();
        $criterium->add(SeedPeer::SEED_ID, $seedId );

        $seed = SeedPeer::doSelectOne($criterium);
        
        if ($seed) {
            $seedValue = $seed->getSeedValue();
            $seed->delete();
            return $seedValue;
        } else {
            throw new Exception('Supplied Seed Id does not match.');
        }
    }

    private function addToPolicy ($type, $value)
    {
        $this->policy[$type] = array();
        $this->policy[$type]['used'] = 'yes';
        $this->policy[$type]['value'] = $value;
    }
}
