<?php
require_once 'includes.php';

/* $Id: index.php,v 1.6 2008-05-14 09:28:47 jakub Exp $
 * --------------------------------------------------------------------------
 * The main script - this dispatches control to page handers, action handlers
 * and finally to an xslt stylesheet.
 */

if (ini_get("magic_quotes_gpc"))
    echo "The magic_quotes_gpc php directive has to be switched off.";

main($_REQUEST);

function main (&$r) 
{
    global $config_file;
    $max_iterations = 5;
    $iter = 0;

    if (!isset($r['debug'])) {
        $r['debug'] = false;
    }

    if ($r['debug']) {
        $debug_opts = explode(";", $r['debug']);
        foreach ($debug_opts as $debug_opt) {
            switch ($debug_opt) {
                case "req":
                    echo "<b>REQUEST:</b>";
                    echo "<pre>";
                    print_r($r);
                    echo "</pre>";
                    break;
                case "srv":
                    echo "<b>SERVER:</b>";
                    echo "<pre>";
                    print_r($_SERVER);
                    echo "</pre>";
                    break;
                case "inc":
                    echo "<b>INCLUDE PATH:</b>";
                    echo "<pre>";
                    echo get_include_path();
                    echo "</pre>";
                    break;
            }
        }
    }

    if (!isset($r['page'])) {
        $r['page'] = 'index';
    }

    if (!isset($r['action'])) {
        $r['action'] = 'nop';
    }
    
    $xml_config = new DOMDocument;
    $xml_config->load($config_file);

    $r['config_dom'] = $xml_config;
    $r['pending'] = array($r['page']);
    
    for ( $p = array_shift($r['pending']);
          $p && $iter < $max_iterations;
          $p = array_shift($r['pending']), $iter++ ) {

        $page_handler = 'page_handler_' . $p;

        if (!function_exists($page_handler)) {
            exception(__FILE__, 'Page handler ' . $page_handler . ' not yet '.
                    'implemented');
        }

        $proc = get_xsltproc_by_page($p);
        $page_handler(&$r, $proc);
    }
    
    insert_data($xml_config, $r);
    
    if (false) {
        echo "XML_CONFIG:<pre>", htmlentities($xml_config->saveXML()), "<pre>";
    }
    
    $doc = $proc->transformToDoc($xml_config);
    $doc->formatOutput = true;
    echo $doc->saveXML();
}

