<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:php="http://php.net/xsl"
    exclude-result-prefixes="php" >
  <xsl:output method="html" doctype-public="-//W3C//DTD HTML 4.01 Strict//EN" />

  <xsl:template match="/record">
    <table border="0">
      <xsl:call-template name="location"/>
    </table>
  </xsl:template>

    <xsl:template name="date">
      <xsl:for-each select="md-date">
        <tr>
          <td class="item">Published:</td>
          <td><xsl:value-of select="."/></td>
        </tr>
      </xsl:for-each>
    </xsl:template>

    <xsl:template name="subject">               
      <xsl:if test="md-subject">
        <tr>
          <td class="item">Subject(s):</td>
            <td>
            <xsl:for-each select="md-subject">
              <a jsvalue="{.}" onclick="redirect('subject', this.getAttribute('jsvalue'))"><xsl:value-of select="."/></a>
              <xsl:if test="position() != last()">
                <xsl:text>, </xsl:text><br/>
              </xsl:if>
            </xsl:for-each>
          </td>
        </tr>
      </xsl:if>
    </xsl:template>

    <xsl:template name="lccn">
      <xsl:for-each select="md-lccn">
        <tr>
          <td class="item">LCCN:</td>
          <td><xsl:value-of select="."/></td>
        </tr>
      </xsl:for-each>
    </xsl:template>

    <xsl:template name="description">
      <xsl:for-each select="md-description">
        <tr>
          <td colspan="2">
            <xsl:choose>
              <xsl:when test="string-length(text()) &lt; 200">
                <i><xsl:value-of select="."/></i>
              </xsl:when>
              <xsl:otherwise>
                <i><xsl:value-of select="substring(text(), 0, 200)"/>...</i>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </xsl:for-each>
    </xsl:template>

    <xsl:template name="location">  
      <xsl:for-each select="location">
        <tr>
          <td class="item">
            Source:
          </td>
          <td>
            <b><xsl:value-of select="@name"/></b>
          </td>
        </tr>
        
        <tr>
          <td/>
          <td>
            <table>
              <xsl:call-template name="electronic-url-mtype"/>
              <xsl:call-template name="pub-date"/>
              <xsl:call-template name="citation"/>
              <xsl:call-template name="description"/>
              <xsl:call-template name="subject"/>
              <xsl:call-template name="open-url"/>
            </table>
          </td>
        </tr>
        
        <xsl:if test="position() != last()">
          <tr>
            <td colspan="2">
              <hr/>
            </td>
          </tr>
        </xsl:if>

      </xsl:for-each>
    </xsl:template>

    <xsl:template name="citation">
      <xsl:for-each select="md-citation">
        <tr>
          <td class="item">Journal Citation:</td>
          <td><xsl:value-of select="."/></td>
        </tr>
      </xsl:for-each>
    </xsl:template>

    <xsl:template name="electronic-url-mtype">
      <xsl:choose>
        <xsl:when test="md-electronic-url">
          <xsl:for-each select="md-electronic-url">
            <tr>
              <td>
                  <b><a href="{.}" target="_blank">
                    <xsl:text disable-output-escaping="yes">Go to Resource&nbsp;</xsl:text>
                    </a>
                  </b>
              </td>
              <td>
                  <xsl:call-template name="medium-icon-link">
                    <xsl:with-param name="medium" select="../md-medium" />
                  </xsl:call-template>
              </td>
            </tr>
          </xsl:for-each>
        </xsl:when>

        <xsl:when test="md-url_recipe/text()">
          <xsl:variable name="url">
            <xsl:call-template name="url-recipe"/>
          </xsl:variable>
          <tr>
            <td>
              <b><a href="{$url}" target="_blank">
                    Go to Resource
                    </a>
                  </b>
              </td>
              <td>
                  <xsl:call-template name="medium-icon-link">
                    <xsl:with-param name="medium" select="../md-medium" />
                  </xsl:call-template>
              </td>
            </tr>
        </xsl:when>

        <xsl:otherwise>
          <xsl:if test="md-medium">
            <tr>
                <td class="item">Type:</td>
              <td>
                  <xsl:call-template name="medium-icon-link">
                    <xsl:with-param name="medium" select="md-medium" />
                  </xsl:call-template>
              </td>
            </tr>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:template>

    <xsl:template name="url-recipe">
      <xsl:variable name="recipe" select="md-url_recipe"/>
      <xsl:variable name="prefix" select="substring-before($recipe, '{{')"/>
      <xsl:variable name="split" select="substring-after($recipe, '{{')"/>
      <xsl:variable name="field" select="substring-before($split, '}}')"/>
      <xsl:variable name="suffix" select="substring-after($split, '}}')"/>
      <xsl:variable name="value" select="normalize-space(*[name() = concat('md-', $field)])"/>
      <xsl:value-of select="concat($prefix, $value, $suffix)"/>
    </xsl:template>

    <xsl:template name="pub-date">
      <xsl:if test="not(md-citation)">
        <xsl:choose>
          <xsl:when test="md-publication-date">
            <tr>
              <td class="item">Pub. Date:</td>
              <td><xsl:value-of select="md-publication-date" /></td>
            </tr>
          </xsl:when>
          <xsl:otherwise>
            <tr>
              <td class="item">Pub. Date:</td>
              <td>unknown</td>
            </tr>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:template>
  
    <xsl:template name="open-url">
      <xsl:if test="md-open-url">
        <tr>
          <td class="item">OpenURL:</td>
          <td>
            <a href="{md-open-url}" target="_blank">Follow link</a>
          </td>
        </tr>
      </xsl:if>
    </xsl:template>


    <!--
    <xsl:template name="electronic-url">
      <xsl:for-each select="md-electronic-url">
        <tr>
          <td/>
          <td><b><a href="{.}" target="_blank">Go to resource</a></b></td>
        </tr>
      </xsl:for-each>
    </xsl:template>
    -->

    <!--
    <xsl:template name="medium">
      <xsl:for-each select="md-medium">
        <tr>
          <td class="item">
            Type:
          </td>
          <td>
            <xsl:call-template name="medium-icon-link">
              <xsl:with-param name="medium" select="." />
            </xsl:call-template>
          </td>
        </tr>
      </xsl:for-each>
    </xsl:template>
    -->

  <xsl:template name="medium-icon-link">
    <xsl:param name="medium"/>
    
    <xsl:variable name="icon">
      <xsl:choose>
        
        <xsl:when test="$medium = 'electronic resource'" >
          <xsl:text>mouse</xsl:text>
        </xsl:when>
        
        <xsl:when test="$medium = 'computer file'" >
          <xsl:text>mouse</xsl:text>
        </xsl:when>
        
        <xsl:when test="$medium = 'sound recording'" >
          <xsl:text>cd</xsl:text>
        </xsl:when>
        
        <xsl:when test="$medium = 'microfilm'" >
          <xsl:text>microfilm</xsl:text>
        </xsl:when>
 
        <xsl:when test="$medium = 'videorecording'" >
          <xsl:text>video</xsl:text>
        </xsl:when>
 
         <xsl:when test="$medium = 'person'" >
          <xsl:text>person</xsl:text>
        </xsl:when>

         <xsl:when test="$medium = 'article'" >
          <xsl:text>txt</xsl:text>
        </xsl:when>

        <xsl:otherwise>
          <xsl:text>book</xsl:text>
        </xsl:otherwise>

      </xsl:choose>
    </xsl:variable>

    <a style="cursor: default" title="{$medium}"><img src="{ concat('gfx/medium/icon_', $icon, '.gif') }" alt="{$medium}" /></a>

  </xsl:template>
        
</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
