<?xml version="1.0"?>
<!--
    $Id: mk_front.xsl,v 1.43 2007-10-26 13:46:29 adam Exp $
-->
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:php="http://php.net/xsl"
    exclude-result-prefixes="php" >

  <xsl:output method="html" doctype-public="-//W3C//DTD HTML 4.01//EN" />

  <xsl:include href="mk_globals.xsl"/>
  
  <xsl:template match="/page">
    <html>
    <xsl:call-template name="check-browser-compat"/>
      <head>
        <xsl:call-template name="insert-head-section"/>
      </head>

      <body>
        <xsl:call-template name="insert-body-section"/>
      </body>
    </html>
  </xsl:template>


  <xsl:template name="insert-head-section">
    <title><xsl:value-of select="pagetitle"/></title>
    <link rel="author" href="http://www.indexdata.dk" />
        
    <link href="css/styles.css" rel="stylesheet" type="text/css"
          media="screen, all" />
      
    <xsl:call-template name="insert-config-section"/>
    <xsl:call-template name="insert-js-includes"/>
    <xsl:call-template name="insert-custom-head-section"/>
  </xsl:template>


  <xsl:template name="insert-body-section">
    <xsl:if test="$multi_lang = 'yes'">
      <div class="lang_pager">
        <xsl:for-each select="languages/lang">
          <a class="toplink" href="?lang={.}"><xsl:value-of
             select="."/></a>
          <xsl:text> </xsl:text>
        </xsl:for-each>
      </div>
    </xsl:if>

    <div class="container">

      <xsl:if test="$auth = 'yes'">
        <div id="loginDiv" style="display: none">
          <h2><xsl:value-of select="logintitle"/></h2>
          [<a onclick="$(this.parentNode).hide();"><xsl:value-of select="hidelink"/></a>]
          <br/>
          <br/>
          <div id="login" class="login">
            <form id="loginForm" action="post" onSubmit="return false"
                  enctype="application/x-www-form-urlencoded; charset=UTF-8" 
                  accept-charset="UTF-8">
              <label for="username"><xsl:value-of select="userlabel"/></label>
              <input tabindex="1" type="text" name="username" id="username" size="10"/>
              <span><xsl:text> </xsl:text></span>
              <label for="password"><xsl:value-of select="passlabel"/></label>
              <input tabindex="2" type="password" name="password" id="password" size="10"/>
              <input type="submit" class="searchBtn" value="{loginbtnlabel}" />
            </form>
          </div>
          <p id="message"><xsl:value-of select="messages/login"/></p>
        </div>
      </xsl:if>

      <xsl:if test="$auth = 'yes' and $resource_select = 'yes'">
        <div id="targetSelDiv" style="display: none">
          <h2><xsl:value-of select="resseltitle"/></h2>
          [<a onclick="$(this.parentNode).hide();"><xsl:value-of select="hidelink"/></a>]
          <p id="resmessage"><xsl:value-of select="messages/resselnonauth"/></p>
          <div id="targetSelection"></div>
        </div>
      </xsl:if>

      <xsl:if test="$profile_edit = 'yes'">
        <div id="profileEditDiv" style="display: none">
          <h2><xsl:value-of select="profileedittitle"/></h2>
          [<a onclick="$(this.parentNode).hide();"><xsl:value-of select="hidelink"/></a>]
          <div id="profileEdit">
            <form name='userForm'>
              <table>
                <tr>
                  <td>
                    <b><xsl:value-of select="proffullusername"/></b>
                  </td>
                  <td>
                    <input type="text" name="name"/>
                  </td>
                </tr>

                <tr>
                  <td>
                    <b><xsl:value-of select="profinstitution"/></b>
                  </td>
                  <td>
                    <input type="text" name="institution"/>
                  </td>
                </tr>

                <tr>
                  <td>
                    <b><xsl:value-of select="profemail"/></b>
                  </td>
                  <td>
                    <input type="text" name="email"/>
                  </td>
                </tr>

                <tr>
                  <td>
                    <b><xsl:value-of select="proflogin"/></b>
                  </td>
                  <td>
                    <input type="text" name="login"/>
                  </td>
                </tr>

                <tr>
                  <td>
                    <b><xsl:value-of select="profourlres"/></b>
                  </td>
                  <td>
                    <input type="text" name="ourl_resolver"/>
                  </td>
                </tr>
                
                <tr>
                  <td colspan="3">
                  <br/>
                  <b><xsl:value-of select="profchangepass"/></b>
                  <br/>
                  <br/>
                  </td>
                </tr>
                
                <tr>
                  <td>
                    <b><xsl:value-of select="profoldpass"/></b>
                  </td>
                  <td>
                    <input type="password" name="oldpass"/>
                  </td>
                </tr>

<tr>
                  <td>
                    <b><xsl:value-of select="profnewpass"/></b>
                  </td>
                  <td>
                    <input type="password" name="pass1"/>
                  </td>
                </tr>


                <tr>
                  <td>
                    <b><xsl:value-of select="profretypepass"/></b>
                  </td>
                  <td>
                    <input type="password" name="pass2"/>
                  </td>
                </tr>

                <tr>
                  <td colspan="3">
                    <br />
                    <input type="button" class="searchBtn" value="Save" onclick="userdata.sentForm()"/>
                  </td>
                </tr>
              </table>
            </form>
          </div>
        </div>
      </xsl:if>

      <div class="topbar">
        <a href="?lang={$lang}">
          <img id="logo" src="gfx/logo.gif" alt="Masterkey" />
        </a>

        <xsl:call-template name="insert-topmenu"/>

        <div class="bluebox"></div>
      </div>

      <div class="search">  
        <form method="post" action="index.html" name="search">
          <div class="simple">
            <input type="text" name="query" class="search" maxlength="255" value="" />
            <input type="submit" class="searchBtn" value="{searchlabel}" />
            <!--<input type="image" src="gfx/button.gif" class="button" />-->
            <a id="advanced">
              <b id="advancedLinkText"><xsl:value-of select="advancedlink"/></b>
              <b id="simpleLinkText" style="display: none;"><xsl:value-of select="simplelink"/></b>
            </a>
          </div>
          <div class="advanced" style="display: none">
            <xsl:value-of select="anywherelabel"/>
            <input type="text" name="anywhere" class="advSearch" maxlength="255" value="" />
            <br/>
            <xsl:value-of select="titlelabel"/>
            <input type="text" name="title" class="advSearch" maxlength="255" value="" />
            <br/>
            <xsl:value-of select="authorlabel"/>
            <input type="text" name="author" class="advSearch" maxlength="255" value="" />
            <br/>
            <xsl:value-of select="subjectlabel"/>
            <input type="text" name="subject" class="advSearch" maxlength="255" value="" />
            <br/>
            <xsl:value-of select="datelabel"/>
            <input type="text" name="date" class="advSearch" maxlength="255" value="" />
            <br/>
          </div>
        </form>
      </div>

      <div class="main">

        <xsl:if test="$about">
          <div id="aboutDiv" style="display: none">
            <p><a onclick="backToSearch();"><xsl:value-of select='gobacksearch'/></a></p>
            <xsl:copy-of select="$about/*" />              
          </div>
        </xsl:if>

       <xsl:if test="$help">
          <div id="helpDiv" style="display: none">
            <p><a onclick="backToSearch();"><xsl:value-of select='gobacksearch'/></a></p>
            <xsl:copy-of select="$help/*" />
          </div>
        </xsl:if>
        
        <div class="leftbar" style="display: none">
          <div class="head">
            <div class="margin">
              <h2><xsl:value-of select="facetheader"/></h2>
            </div>
          </div>
          <div class="margin" style="padding-top: 15px;">
            <div id="termlists">
              <xsl:for-each select="facetitems/*">
                <div class="termlist" id="term_{@value}">
                 <xsl:choose>
                    <xsl:when test='@expanded = "yes"'>
                      <div class="termTitle">
                        <a href="{.}" class="selected"><xsl:value-of select="."/></a>
                      </div>
                      <div class="termEntries"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <div class="termTitle">
                        <a href="{.}" class="unselected"><xsl:value-of select="."/></a>
                      </div>
                      <div class="termEntries" style="display: none;"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </div>
                <hr/>
              </xsl:for-each>
            </div>
          </div>
        </div>

        <div class="content" style="display: none">
          
          <div class="head">
            <div class="margin">
              <div class="showing"></div>
            </div>
          </div>

          <div id="breadcrumb"/>
          
          <div class="sortBox">
            <xsl:value-of select="sortbylabel"/>
            <select name="sort" id="sort">
              <xsl:for-each select="sortbyitems/*">
                <option value="{@value}">
                  <xsl:if test="@default = 'yes'">
                    <xsl:attribute name="selected">selected</xsl:attribute>
                  </xsl:if>
                  <xsl:value-of select="."/>
               </option>
              </xsl:for-each>
            </select>
            <xsl:value-of select="perpagelabel1"/>
            <select name="perpage" id="perpage">
              <xsl:for-each select="perpageitems/*">
                <option value="{@value}">
                  <xsl:if test="@default = 'yes'">
                    <xsl:attribute name="selected">selected</xsl:attribute>
                  </xsl:if>
                  <xsl:value-of select="."/>
                </option>
              </xsl:for-each>
            </select>
            <xsl:value-of select="perpagelabel2"/>
          </div>
          
          <div class="upper">
            <div class="pages"/>
          </div>
   
          <div class="records"/>
            <div class="bottom">
              <div class="pages"/>
            </div>    
          </div>
            
          <div class="clear"/>
          <div class="trailer"/>
        
        </div>

    </div>

    <xsl:call-template name="insert-custom-body-section"/>
  </xsl:template>


  <xsl:template name="insert-topmenu">
    <div class="topmenu">
      <a href="{aboutlink/text()}" id="aboutLink" class="toplink">
        <xsl:value-of select="aboutlink"/>
      </a>
      <a href="{helplink/text()}" id="helpLink" class="toplink">
        <xsl:value-of select="helplink"/>
      </a>
      <xsl:if test="$auth = 'yes'">
        <a href="{loginlink/text()}" id="loginButton" class="toplink">
          <xsl:value-of select="loginlink"/>
        </a>
      </xsl:if>
      <xsl:if test="$auth = 'yes' and $resource_select = 'yes'">
        <a href="{reslink/text()}" id="resourceButton" class="toplink">
          <xsl:value-of select="reslink"/>
        </a>
      </xsl:if>

      <xsl:if test="$profile_edit = 'yes'">
        <a style="display: none;" href="{profilelink/text()}" id="profileButton" class="toplink">
          <xsl:value-of select="profilelink"/>
        </a>
      </xsl:if>

      <xsl:call-template name="insert-custom-topmenu-section"/>
    </div>
  </xsl:template>


  <!-- Keep empty: -->
  <xsl:template name="insert-custom-head-section"/>
  <xsl:template name="insert-custom-topmenu-section"/>
  <xsl:template name="insert-custom-body-section"/>

</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
