<?php

class Pz2Error
{
    public $message;
    public $code;
}

class Pz2Wrapper
{
    protected $sessionId;
    protected $pz2Url;
    protected $error;
    
    public function __construct ( $url )
    {
        $this->sessionId = null;
        $this->pz2Url = $url;
        $this->error = null;
    }

    public function setSessId ( $sessionId )
    {
        $this->sessionId = $sessionId;
    }
    
    public function getError ()
    {
        return $this->error;
    }

    public function restart ( $targets = null )
    {
            $this->init(false);
            return $this->sessionId;
    }

    public function relay ( $queryString )
    {
         return $this->checkResponse ( $this->pz2Url
            . '?' . $queryString
            . '&session=' . $this->sessionId );
    }

    protected function init ( $clear )
    {
        $clearOpt = $clear ? '&clear=1' : '';
        $response = $this->checkResponse ( $this->pz2Url  
            . '?command=init' . $clearOpt  );

        if ( !$this->error ) {
            $doc = new DOMDocument();
            $doc->loadXML( $response );    
            $this->sessionId = $doc->getElementsByTagName('session')->item(0)->nodeValue;
        }
    }
   
    protected function checkResponse ( $url, $form = null )
    {
        $ch = curl_init();
        curl_setopt( $ch, CURLOPT_URL, $url );
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt( $ch, CURLOPT_HEADER, false );

        if ($form) {
            curl_setopt( $ch, CURLOPT_POST, true);
            curl_setopt( $ch, CURLOPT_POSTFIELDS, $form);
        }


        $response = curl_exec( $ch );
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        curl_close($ch);
        
        $this->error = null;
        if ( $http_code == 417 ) {
            $this->parseError($response);
        } else if ( $http_code != 200 ) {
            throw new Exception ( $http_code.' http error.' , 102 );
        }

        return $response;
    }

    private function parseError ($response)
    {
        $doc = new DOMDocument();
        $doc->loadXML($response);

        $errorNode =  $doc->getElementsByTagName('error');
        if ( isset( $errorNode ) && $errorNode->length ) {
            $this->error = new Pz2Error();
            $this->error->message = $errorNode->item(0)->getAttribute('msg');
            $this->error->code = $errorNode->item(0)->getAttribute('code');
        }
    }
}
