<?php
require_once 'WsResponseFactory.class.php';

class Pz2Proxy
{
    private $response;
    private $request;
    private $session;
    private $server;
    private $conf;
    private $pz2;

    public function __construct (&$r, &$srv , $pz2)
    {
        $this->request = &$r;
        //$this->session = &$s;
        $this->server = &$srv;

        isset( $this->request['output'] )
            ? $output = $this->request['output']
            : $output = 'xml';

        $this->response = 
            WsResponseFactory::getResponse($output);

        $this->pz2 = $pz2;
    }

    public function start ()
    {
        $this->response->header();
        $this->dispatchCommand();
    }

    public function sendResponse ()
    {
        echo $this->response->printResponse();
    }

    private function dispatchCommand ()
    {
        if ( isset ($this->request['command']) ) {
            if ( $this->request['command'] == 'init' ) {
                $this->response->setRoot('pzproxy');
                $this->response->addError('Init not allowed.');
            } else {
                $this->proxyPz2Command( $this->request['command'], 
                    $this->server['QUERY_STRING'] );
            }
        } else {
                $this->response->setRoot('pzproxy');
                $this->response->addError('Missing command.');
        }
    }

    private function proxyPz2Command ( $command, $queryString)
    {
        //save query for a new search
        if ( $command == 'search' ) {
            mk_session_write('last_query_string', $queryString);
        }
        
        // is pz2session in phpsesion?
        if ( $pz2sessid = mk_session_read('pz2sessionid') ) {
             // reuse the pz2session
             $this->pz2->setSessId( $pz2sessid );
        } else {
            // no pz2session stored in phpsession
            // apply for new one
            try {
                mk_session_write('pz2sessionid', 
                    $this->pz2->restart());
            } catch (Exception $e) {
                $response = '<error code="'.$e->getCode()
                    .'" msg="'.$e->getMessage().'" >'
                    .'When trying to init pz2'.'</error>';
                echo $response;
                exit;
            }
        }
        
        // send a command and check if successful
        try {
            $response = $this->pz2->relay( $queryString );
            $error = $this->pz2->getError();

            if ($error) {
                if ( $error->code == 1 ) {
                    // try to restart one more
                    try {
                        mk_session_write('pz2sessionid',
                            $this->pz2->restart() );
                    } catch (Exception $e) {
                        $response = '<error code="'.$e->getCode()
                            .'" msg="'.$e->getMessage().'" >'
                        .'When trying to init pz2'.'</error>';
                        echo $response;
                        exit;
                    }
                    
                    // when not searching and there was an error
                    // try to init and reuse old query
                    if ( $command != 'search' 
                        && (( $last_qstring = 
                            mk_session_read('last_query_string') )
                        !== false ))
                        $response = $this->pz2->relay($last_qstring); 

                    $response = $this->pz2->relay( $queryString );
                }
            }
        //http errors between proxy and pz2
        } catch (Exception $e) {
            $response = '<error code="'.$e->getCode()
                .'" msg="'.$e->getMessage().'" >'
            .'When trying to call pz2'.'</error>';
        }
        
        echo $response;
        exit;
        
    }
}
