/* $Id: mkFilter.class.js,v 1.1 2007-10-02 10:32:26 jakub Exp $ */
/* Current targets filter object */

var mkFilter = function()
{
    this.filterHash = new Array();
    this.filterNums = 0;
};

mkFilter.prototype = 
{
    addFilter: function(name, value)
    {
        var filter = {"name": name, "id": value };
        this.filterHash[this.filterHash.length] = filter;
        this.filterNums++
        return  this.filterHash.length - 1;
    },
    
    setFilter: function(name, value)
    {
        this.filterHash = new Array();
        this.filterNums = 0;
        this.addFilter(name, value);
    },
    
    getFilter: function(index)
    {
        return this.filterHash[index].id;
    },
    
    getFilterName: function(index)
    {
        return this.filterHash[index].name;
    },
    
    removeFilter: function(index)
    {
        delete this.filterHash[index];
        this.filterNums--;
    },
    
    clearFilter: function()
    {
        this.filterHash = new Array();
        this.filterNums = 0;
    },
    
    getFilterString: function()
    { 
        if( this.filterNums <= 0 ) {
            return undefined;
        }

        var filter = 'pz:id=';
        for(var i = 0; i < this.filterHash.length; i++)
        {
            if (this.filterHash[i] == undefined) continue;
            if (filter > 'pz:id=') filter = filter + '|';            
            filter += this.filterHash[i].id; 
        }
        return filter;
    }
}
