/* $Id: mkEvents.class.js,v 1.2 2007-09-26 11:25:30 sondberg Exp $
 * ----------------------------------------------------------
 * Generic stackable event system
 */

var mkEvents = function ()
{
    this.events = new Array();
}

mkEvents.prototype = 
{
    attachEvent: function (type, handler, userParams)
    {
        if (typeof this.events[type] == 'undefined' )
            this.events[type] = new Array();
        
        this.events[type].push({
            'handler':      handler,
            'userParams':   userParams
        });
    },

    callEvents: function (type, params)
    {
        if (typeof this.events[type] != 'undefined' ) {
            for (var i=0; i < this.events[type].length; i++) {
                var handler = this.events[type][i];

                handler.handler(handler.userParams, params);
            }
        }
    }
}
