/* $Id: loginEvents.js,v 1.25 2007-10-08 12:22:30 jakub Exp $ */

my_auth = new Auth({    "onCheck": my_oncheck,
                        "onLogin": my_onlogin,
                        "output": "json",
		        "wspath" : "."
                        });

var loggedIn = false;
var ipAuth = false;
var targetInfo = false;

$(document).ready(
    function() {

        my_auth.check();
	
        if (typeof window.ResourceSelect != "undefined") {        
	    ressel = new ResourceSelect({    	
                                "divId": "targetSelection",
                                "userDataWS": "."
                                });
        }
        
        $('#loginButton').click(
            function(){ 
                $('#loginDiv').show();
                $('#username')[0].focus();
                return false;
            }
        );

        $('#resourceButton').click(
            function(){
                $('#targetSelDiv').show();
                return false;
            }
        );
        
        $("#loginForm").submit(checkLogin);
    }
);

function checkLogin()
{
    if(loggedIn)
        return;
    if( $("#username").val() && $("#password").val() ) {
        
        my_auth.login({ 'user': $("#username").val(), 
                        'pass': $("#password").val() });
        
        $("#message").text(msg['loggingin']);
    }
}

function logOut()
{
    loggedIn = false;
    my_paz.reset();
    
    $("#username").val('');
    $("#password").val('');
    $("#message").text( msg['login'] );
    $("#loginButton").text(lang['loginlink']);
    $("#loginForm").show();
    
    // ressel events - should be moved out
    $("#resmessage").text( msg['resselnonauth'] );    
    $("ul.dir").remove();
    resFilters.clearFilter();
    
    my_auth.callEvents('logOut');
    
    // fallback to a policy that does not require
    // any credentials
    my_auth.login();

    $("#loginDiv").hide();
}

/* handlers */
function my_oncheck (data)
{
    if ( data['auth-check']['status'] == 'success' ) {
        handle_policy( data['auth-check']['policy'] );
    } else {
        my_auth.login();
    }   
}

function my_onlogin (data)
{
    if ( data['auth-login']['status'] == 'success' ) {
        handle_policy( data['auth-login']['policy'] );
    } else {
        loginFailed();
    }
}

function handle_policy ( authPolicy )
{
    if ( 'ipaddr' in authPolicy 
        && authPolicy['ipaddr']['used'] == 'yes' )
        ipSuccess( authPolicy['ipaddr']['value'] );
    
    if ( 'username' in authPolicy && 'password' in authPolicy
        && authPolicy['username']['used'] == 'yes'
        && authPolicy['password']['used'] == 'yes' )
        loginSuccess( authPolicy['username']['value'] );
}

// function my_hsfailure()
// alert(msg['errservice']);

/* ip */
function ipSuccess (ip)
{
    ipAuth = true;

    my_paz.reset();
    
    $("#resmessage").text( msg['resselisauth'].replace('$', ip) );
    $("#targetSelection").empty();
    
    getTree();

    my_auth.callEvents('ipSuccess');
}

function ipFailed()
{
    alert(msg['erripauth']);
    my_auth.callEvents('ipFailed');
}

/* credentials */
function loginSuccess (login)
{
    loggedIn = true;
    ipAuth = false; //takes precedence

    my_paz.reset();

    $("#message").text( msg['loggedas'].replace('$', login) );
    $("#message").append(' [<a href="#" onclick="logOut()">'+msg['logout']+'</a>]');
    $("#loginForm").hide();
    $("#resmessage").text( msg['resselisauth'].replace('$', login) );
    $("#loginButton").text( msg['logout'] );
    $("#loginDiv").hide();

    getTree();

    my_auth.callEvents('loginSuccess');
}

function loginFailed()
{
    $("#message").text(msg['errlogin']);

    my_auth.callEvents('loginFailed');
}

function getTree ()
{
    var req = new pzHttpRequest('.');
    req.get(
        //'/masterkey-auth/pzproxy.php',
        {'command': 'tree', 'output' : 'xml' },
        function (data) {
            var targets = 
            $.parseJSON( Element_getTextContent( data.getElementsByTagName('targets')[0] ) );
            var categories =
            $.parseJSON( Element_getTextContent( data.getElementsByTagName('categories')[0] ) );
            var logo_uri = Element_getTextContent( data.getElementsByTagName('logo')[0] );

            targetInfo = targets;
            if (typeof ressel != "undefined") {
                ressel.fetchSelection ( categories );
            }
            changeLogo( logo_uri );
        }
    );
}

function changeLogo (uri)
{
    if (uri) {
        document.getElementById("logo").src = uri;
    } else {
        document.getElementById("logo").src = "gfx/logo.gif";
    }
}
