var ProfileEdit = function ( params )
{
    if (typeof params != 'object' )
        throw new Error ('Requires a hash with parameters!');

    this._form = params['userForm'];
    this._server = params['userDataWS'] || '.';
    this.password = '';
    //TODO get rid of globals
    //this.msg = params['messages'];
    this.populate();
}

ProfileEdit.prototype = 
{
    populate: function ()
    {
        var context = this;
        var request = new pzHttpRequest(this._server);
        request.get(
                {'command': 'fetch'},
                function (response) {
                    if (response.getElementsByTagName('status').length
                        && response.getElementsByTagName('status')[0].firstChild.nodeValue == 'OK' ) {
                        context.fillForm(response);
                    } else {
                        context.emptyForm();
                        throw new Error('Failure: user data cannot be retrieved.')
                        }
                }
        );
    },

    emptyForm: function ()
    {
        for (var i = 0; i < this._form.elements.length; i++) {
            var input = this._form.elements[i]; 
            if (input.type == 'text')
                input.value = '';
        }
    },

    fillForm: function (xmlDoc)
    {
        formAttrs = xmlDoc.getElementsByTagName('user')[0].attributes;

        for (var i = 0; i < formAttrs.length; i++) {
            if ( formAttrs[i].nodeName == 'pass' ) {
                this.password = formAttrs[i].firstChild.nodeValue;
                continue;
            }

            if( !this._form[formAttrs[i].nodeName] )
                continue;
            
            if ( formAttrs[i].hasChildNodes() ) {
                this._form[formAttrs[i].nodeName].value 
                    = formAttrs[i].firstChild.nodeValue;

                if ( formAttrs[i].nodeName == 'ourl_resolver' ) {
                    ourlResolver = formAttrs[i].firstChild.nodeValue;
                }
            }
        }
        this._form.oldpass.value = '';
        this._form.pass1.value = '';
        this._form.pass2.value = '';
    },

    changePass: function (userData, oldpass, pass1, pass2)
    {
        // when no pass entered simply return
        if (oldpass === '' 
            && pass1 === '' && pass2 === '')
            return true;

        if (oldpass === this.password
            && pass1 === pass2 ) {
            userData.setAttribute('enc_pass', pass1);
            return true;
        } else {
            alert(msg['errprofpass']);
            return false;
        }
    },

    sentForm: function ()
    {
        var udDoc = document.newXmlDoc('user');
        var userData = udDoc.documentElement;

        userData.setAttribute('user_name', this._form.name.value);
        userData.setAttribute('institution', this._form.institution.value);
        userData.setAttribute('email', this._form.email.value);
        userData.setAttribute('login', this._form.login.value);
        userData.setAttribute('ourl_resolver', this._form.ourl_resolver.value);

        if ( this.changePass(userData, 
                this._form.oldpass.value, 
                this._form.pass1.value, 
                this._form.pass2.value ) ) {

            var request = new pzHttpRequest(this._server);
            request.post(
                    {'command': 'save'},
                    udDoc,
                    function(response) {
                        if (response.getElementsByTagName('status').length
                            && response.getElementsByTagName('status')[0].firstChild.nodeValue == 'OK' ) {
                            alert(msg['profsave']);
                        } else {
                            alert(msg['errprofsave']);
                        }
                    }
                );
        }
        this._form.oldpass.value = '';
        this._form.pass1.value = '';
        this._form.pass2.value = '';
    }
}
